CMAKE_MINIMUM_REQUIRED( VERSION 3.1 )

ExternalProject_Add( CPPTEST
	URL ${CMAKE_SOURCE_DIR}/cpptest-2.0.0.tar.gz
	CMAKE_ARGS -DCMAKE_INSTALL_PREFIX:PATH=<INSTALL_DIR>
		-DCMAKE_C_COMPILER=${CMAKE_C_COMPILER}
		-DCMAKE_CXX_COMPILER=${CMAKE_CXX_COMPILER}
		-DCMAKE_CXX_FLAGS=${CMAKE_CXX_FLAGS}
		-DCMAKE_C_FLAGS=${CMAKE_C_FLAGS}
		-DCMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE}
	PATCH_COMMAND
		${CMAKE_COMMAND} -E copy_if_different
		"${CMAKE_CURRENT_SOURCE_DIR}/CppTest_CMakeLists.txt"
		"<SOURCE_DIR>/CMakeLists.txt"
		COMMAND
		${CMAKE_COMMAND} -E copy_if_different
		"${CMAKE_CURRENT_SOURCE_DIR}/CppTest_config.h"
		"<SOURCE_DIR>/src/config.h"
		COMMAND
		${CMAKE_COMMAND} -E copy_if_different
		"<SOURCE_DIR>/win/winconfig.h"
		"<SOURCE_DIR>/src/winconfig.h"
)
ExternalProject_Get_Property( CPPTEST INSTALL_DIR )
SET( CPPTEST_INSTALL_DIR ${INSTALL_DIR} )