# set Intel compiler flags
IF(CMAKE_CXX_COMPILER_ID STREQUAL "Intel")
  IF(WIN32)
    SET(CMAKE_CXX_FLAGS "/Qstd=c++0x")
  ELSE()
    SET(CMAKE_CXX_FLAGS "-std=c++0x")
  ENDIF()
ENDIF()

# set MS Visual Compiler flags
IF(CMAKE_CXX_COMPILER_ID STREQUAL "MSVC")
ENDIF()

 # set GNU Compiler Collection flags
IF(CMAKE_CXX_COMPILER_ID STREQUAL "GNU")
  EXECUTE_PROCESS(COMMAND ${CMAKE_CXX_COMPILER} -dumpversion OUTPUT_VARIABLE GCC_VERSION)
  IF(GCC_VERSION VERSION_GREATER 4.3 OR GCC_VERSION VERSION_EQUAL 4.3)
    IF(GCC_VERSION VERSION_GREATER 4.7 OR GCC_VERSION VERSION_EQUAL 4.7)
      SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11")
    ELSE()
      SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++0x")
    ENDIF()
  ELSE()
    MESSAGE(ERROR "GCC version ${GCC_VERSION} is too old.")
  ENDIF()
  IF(GCC_VERSION VERSION_LESS 4.9)
    SET( NOREGEXP TRUE )
  ENDIF()
ENDIF()

# set LLVM flags
IF(CMAKE_CXX_COMPILER_ID STREQUAL "Clang" OR CMAKE_CXX_COMPILER_ID STREQUAL "AppleClang")
  if (CMAKE_GENERATOR STREQUAL "Xcode")
    SET(CMAKE_XCODE_ATTRIBUTE_CLANG_CXX_LANGUAGE_STANDARD "c++11")
    SET(CMAKE_XCODE_ATTRIBUTE_CLANG_CXX_LIBRARY "libc++")
  else()
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11 -stdlib=libc++")
  ENDIF()
ENDIF()
