//
// This file is released under the terms of the NASA Open Source Agreement (NOSA)
// version 1.3 as detailed in the LICENSE file which accompanies this software.
//

// STEPStructureOptionsScreen.h: interface for controlling STEP export options.
//
//////////////////////////////////////////////////////////////////////

#ifndef STEPSTRUCTUREOPTIONSSCREEN_H
#define STEPSTRUCTUREOPTIONSSCREEN_H

#include "ScreenMgr.h"
#include "ScreenBase.h"
#include "Vehicle.h"
#include "GuiDevice.h"

class STEPStructureOptionsScreen : public BasicScreen
{
public:
    STEPStructureOptionsScreen( ScreenMgr* mgr );
    virtual ~STEPStructureOptionsScreen();

    void Show();
    bool Update();

    void CallBack( Fl_Widget *w );
    static void staticScreenCB( Fl_Widget *w, void* data )
    {
        ( ( STEPStructureOptionsScreen* )data )->CallBack( w );
    }
    virtual void CloseCallBack( Fl_Widget *w );
    virtual void GuiDeviceCallBack( GuiDevice* device );

    bool ShowSTEPOptionsScreen();

protected:

    GroupLayout m_GenLayout;

    Choice m_StructureChoice;
    SliderAdjRangeInput m_TolSlider;
    ToggleButton m_SplitSurfsToggle;
    //ToggleButton m_MergePointsToggle;
    ToggleButton m_ToCubicToggle;
    SliderAdjRangeInput m_ToCubicTolSlider;

    ToggleButton m_LabelIDToggle;
    ToggleButton m_LabelNameToggle;
    ToggleButton m_LabelSurfNoToggle;
    Choice m_LabelDelimChoice;

    int m_PrevStructureChoice;
    double m_PrevTol;
    bool m_PrevSplit;
    //bool m_PrevMerge;
    bool m_PrevCubic;
    double m_PrevToCubicTol;
    bool m_PrevLabelID;
    bool m_PrevLabelName;
    bool m_PrevLabelSurfNo;
    int m_PrevLabelDelim;

    TriggerButton m_OkButton;
    TriggerButton m_CancelButton;

    bool m_OkFlag;
};

#endif  // STEPSTRUCTUREOPTIONSSCREEN_H
