These are instructions for those who would like to build
libIGES and help test the current implementation. Various
MCAD packages have their own schemes for implementing IGES
models and each has its own quirks. For libIGES to become
a robust IGES preprocessor it must be tested against as
many IGES models generated by as many MCAD packages as
possible. The following instructions describe how to build
the current implementation and how to use the supplied
test programs 'readtest' and 'mergetest' to read and
write IGES files and how to help contribute to the
improvement of libIGES.

This library makes use of the SINTEF SISL library
(https://github.com/SINTEF-Geometry/SISL.git) which
is released under the GNU Affero General Public License V3.
As of 22 Mar 2015 SISL may be used in non-commercial
software such as libIGES or KiCad even though such
software may be used for commercial product development;
if in doubt about your licensing obligations and use,
contact the appropriate SINTEF representative for
clarification. If you intend to use libIGES within
any commercial cloud services you definitely must make
licensing arrangements with SINTEF.

I. Building libIGES and the test programs
    a. Dependencies
        + cmake
        + make
        + libboost (boost_filesystem  and boost_system)
        + C++ compiler (preferably gcc 4.9 or later)
        + SINTEF SISL library (https://github.com/SINTEF-Geometry/SISL.git)

    b. Building:
        i. SISL
            + clone source:
              git clone https://github.com/SINTEF-Geometry/SISL.git
            + change to SISL directory and patch CMakeLists.txt to
              produce a SHARED library - see git diff below:

                diff --git a/CMakeLists.txt b/CMakeLists.txt:
                index 47643a0..ed3b592 100644
                --- a/CMakeLists.txt
                +++ b/CMakeLists.txt
                @@ -17,7 +17,7 @@ INCLUDE_DIRECTORIES(
                # Make the sisl library

                FILE(GLOB sisl_SRCS src/*.c include/*.h)
                -ADD_LIBRARY(sisl ${sisl_SRCS})
                +ADD_LIBRARY(sisl SHARED ${sisl_SRCS})
                SET_PROPERTY(TARGET sisl
                PROPERTY FOLDER "sisl/Libs")

            + build SISL; from the SISL source directory:
              mkdir build && cd build
              cmake ..
              make

        ii. libIGES
            + change to the source directory:
                cd src
            + create a 'build' directory and change to that:
                mkdir build && cd build
            + configure with cmake; you will need to specify the SISL include
              directory and SISL library directory as in this example:
                cmake -DSISL_INCLUDE_DIR=/home/usr/SISL/include -DSISL_LIB_DIR=/home/usr/SISL/build ..
            + compile with make:
                make
            + if you have stripped the 'rpath' from the files, you must copy 'libsisl.so' to
              a directory where the dynamic linker/loader will find it.


II. Test program: readtest
    The program 'readtest' will read the file specified on
    the command line and write it back out to the file
    'test_out_read.igs'. If the program succeeds then the
    output file must contain all the data contained in the
    original file. Look out for messages about entities
    culled; ideally this should be '0' - if not then there
    may be a bug in the library or else the entity is not
    yet supported. Please post on the issue tracker and
    include the IGES file which failed to read and write
    correctly.  A second test is to load the output file
    into FreeCAD; it should display exactly as the original
    file if everything is fine.

    Example usage:
    ./readtest my_model.igs

III. Test program: mergetest
    The program 'mergetest' takes an input file which
    contains a list of IGES model files each with a
    list of position parameters. One instance of the
    model is created for every set of position parameters
    provided. Input files may be part files or assemblies;
    the output file will be an IGES assembly file named
    'test_out_merge.igs' which should respect the structure
    of all contained assemblies and subassemblies. The output
    may be rendered with FreeCAD; if it does not render
    correctly please post an issue and provide the input
    control file and IGES files used.

    Input control file format:
    unit: (optional) one of 'in' or 'mm'
    file: "model_filename.igs"
    orient: (optional) used to change the normal orientation of the part;
            this transform is applied to all instances of the part
            param 1: rotation (degrees)\n";
            param 2: x magnitude of rotation vector\n";
            param 3: y magnitude of rotation vector\n";
            param 4: z magnitude of rotation vector\n";
            param 5: x translation\n";
            param 6: y translation\n";
            param 7: z translation\n";
    pos: zRotation, flip (0/1), xOffset, yOffset, zOffset;
         this is applied to a single instance of the part
    [other 'pos:' lines to create more instances of the model]
    [more sets of 'file:' and 'pos:' lines]

    The position parameters:
    + zRotation: rotation of the component about its vertical axis
    + flip: 0: item will be positioned on the (imaginary) TOP surface
            1: item will be positioned on the BOTTOM surface (flipped
            180 degrees along the X axis)
    + xOffset, yOffset, zOffset: translation of the part. Note that
      X and Y offsets are absolute while the zOffset is negated when
      'flip' is 1.

    Input control file example:
    unit: mm
    file: "block-and_peg.IGS"
    pos: 0,0,0,0,0;
    file: "block_hole.IGS"
    pos: -45,0,0,0,15;
    file: "peg.IGS"
    pos: 0,0,15,15,1.6;
    file: "6371.igs"
    orient: 90,1,0,0,0,0,0;
    pos: 0,0,30,30,1.6;
    pos: 90,1,30,30,0;

    Example usage:
    ./mergetest my_assembly

    Note: IGES models may be in any of 3 orientations
    (vertical axis of the physical model along X, Y, or Z);
    this is due primarily to different users choosing different
    planes of reference when models are created. To compensate
    for a different orientation make use of the 'orient'
    parameters.
