/*
 * file: test_circle.cpp
 *
 * Copyright 2015, Dr. Cirilo Bernardo (cirilo.bernardo@gmail.com)
 *
 * Description:
 *  This program attempts to create a 3D compound curve in which
 *  a complete circular arc is represented by a single 9-point
 *  NURBS curve. If the result is generally accepted by MCADS,
 *  this may simplify the IGES models generated by the geom_pcb
 *  classes due to the compact form of the NURBS in comparison
 *  to the many-point Polynomial B-Spline currently used to
 *  represent circular arcs.
 *
 * This file is part of libIGES.
 *
 * libIGES is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * libIGES is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, If not, see
 * <http://www.gnu.org/licenses/> or write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/*
 * COMMENTS:
 * 1. OK - FreeCAD recognizes the arcs and by rotating the control points only a
 *    single NURBS curve is needed to represent any circular arc of any start/
 *    stop angle.
 */

#include <iostream>
#include <cmath>
#include <api/dll_iges.h>
#include <api/all_api_entities.h>

int main()
{
    DLL_IGES model;

    DLL_IGES_ENTITY_102 compound( model, true );

    DLL_IGES_ENTITY_126 nc( model, true );

    double SQHALF = sqrt( 0.5 );
    double cknots[] = { 0.0, 0.0, 0.0, 0.25, 0.25, 0.5, 0.5, 0.75, 0.75, 1.0, 1.0, 1.0 };
    double cpts[] = {   1.0, 0.0, 0.0, 1.0,
                        1.0, 1.0, 0.0, SQHALF,
                        0.0, 1.0, 0.0, 1,
                        -1.0, 1.0, 0.0, SQHALF,
                        -1.0, 0.0, 0.0, 1,
                        -1.0, -1.0, 0.0, SQHALF,
                        0.0, -1.0, 0.0, 1,
                        1.0, -1.0, 0.0, SQHALF,
                        1.0, 0.0, 0.0, 1
    };

    double cpts2[] = {   1.0, 0.0, -5.0, 1.0,
                         1.0, 1.0, -5.0, SQHALF,
                         0.0, 1.0, -5.0, 1,
                         -1.0, 1.0, -5.0, SQHALF,
                         -1.0, 0.0, -5.0, 1,
                         -1.0, -1.0, -5.0, SQHALF,
                         0.0, -1.0, -5.0, 1,
                         1.0, -1.0, -5.0, SQHALF,
                         1.0, 0.0, -5.0, 1
    };

    nc.SetNURBSData( 9, 3, cknots, cpts, true, 0.125, 1 );
    nc.NewEntity();
    nc.SetNURBSData( 9, 3, cknots, cpts2, true, 0.125, 1 );

    model.Write( "circle.igs", true );

    return 0;
}

using namespace std;
