#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.16';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 100 => 0x69 },
	'about' => { 440 => 'about' },
	'aboutcvterm' => { 432 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 432 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 432 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 432 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 432 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 107 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 446 => 'absPeakAudioFilePath' },
	'acceleration' => { 110 => 0x9404 },
	'accelerationtracking' => { 75 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 345 => 0x3 },
	'accelerometerx' => { 283 => 0x8d },
	'accelerometery' => { 283 => 0x8e },
	'accelerometerz' => { 283 => 0x8c },
	'accessoryserialnumber' => { 283 => 0x54 },
	'accessorytype' => { 283 => 0x53 },
	'acedemicfield' => { 436 => 'acedemicField' },
	'actionadvised' => { 118 => 0x2a },
	'activearea' => { 110 => 0xc68d },
	'actived-lighting' => { 201 => 0x22, 237 => 0x24 },
	'actived-lightingmode' => { 237 => 0x25 },
	'adaptervoltage' => { 124 => 0x407 },
	'addaspectratioinfo' => { 75 => 0x80e },
	'additionalmodelinformation' => { 432 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 75 => 0x80f, 76 => 0x11, 77 => 0x13, 80 => 0x14 },
	'address' => { 145 => 'Address' },
	'adjustmentmode' => { 352 => 0x15 },
	'adlbracketingstep' => { 219 => 0x883 },
	'adlbracketingtype' => { 219 => 0x884 },
	'adobe' => { 111 => 'Adobe' },
	'adultcontentwarning' => { 272 => 'AdultContentWarning', 439 => 'adultContentWarning' },
	'advancedfilter' => { 115 => 0x1201 },
	'advancedraw' => { 239 => 0x76a43203 },
	'advancedscenetype' => { 283 => 0x3d },
	'advisory' => { 444 => 'Advisory' },
	'ae_iso' => { 290 => 0x2, 291 => 0x4, 292 => 0x12 },
	'aeaperture' => { 290 => 0x1, 291 => 0x3, 292 => 0x11 },
	'aeaperturesteps' => { 290 => 0x8, 291 => 0xb },
	'aebautocancel' => { 75 => 0x104 },
	'aebbracketvalue' => { 69 => 0x11 },
	'aebracketingsteps' => { 218 => 0x174c, 219 => 0x87b, 227 => 0x1756 },
	'aebsequence' => { 75 => 0x105 },
	'aebsequenceautocancel' => { 73 => 0x9, 74 => 0x9, 76 => 0x8, 77 => 0x9, 80 => 0x9, 81 => 0x7 },
	'aebshotcount' => { 75 => 0x106 },
	'aebxv' => { 290 => 0x4, 291 => 0x6 },
	'aeerror' => { 291 => 0x8 },
	'aeexposuretime' => { 290 => 0x0, 291 => 0x2, 292 => 0x10 },
	'aelbutton' => { 167 => 0x45 },
	'aelexposureindicator' => { 167 => 0x51 },
	'aelock' => { 167 => 0x5b, 248 => '4.2', 257 => '4.2', 262 => 0x201, 317 => 0x48, 360 => 0x40, 361 => 0x40, 362 => [0x86,0x286] },
	'aelockbutton' => { 246 => '16.1', 248 => '4.1', 251 => '15.1', 252 => '16.1', 253 => '16.1', 255 => '30.1', 256 => '16.1', 257 => '4.1', 259 => '17.1', 260 => '17.1' },
	'aelockbuttonplusdials' => { 246 => '16.2', 255 => '32.1', 259 => '44.1' },
	'aelockformb-d80' => { 260 => '3.1' },
	'aemaxaperture' => { 290 => 0x9, 291 => 0x10, 292 => 0x1c },
	'aemaxaperture2' => { 290 => 0xa, 291 => 0x11, 292 => 0x1d },
	'aemeteringmode' => { 290 => 0xc },
	'aemeteringmode2' => { 290 => '13.1' },
	'aemeteringsegments' => { 170 => 0x628, 317 => 0x209 },
	'aemicroadjustment' => { 75 => 0x110 },
	'aeminaperture' => { 290 => 0xb, 291 => 0x12, 292 => 0x1e },
	'aeminexposuretime' => { 290 => 0x5, 291 => 0x13, 292 => 0x1f },
	'aeprogrammode' => { 290 => 0x6 },
	'aeprojectlink' => { 421 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 421 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 421 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 421 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 421 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 421 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 290 => 0xd },
	'aexv' => { 290 => 0x3, 291 => 0x5 },
	'af-cpriorityselection' => { 246 => '1.1', 247 => '1.1', 249 => '1.1', 250 => '1.1', 252 => '0.1', 253 => '0.1', 254 => '0.1', 255 => '1.1', 256 => '0.1', 259 => '1.1' },
	'af-onbutton' => { 249 => '70.1', 250 => '70.1' },
	'af-onformb-d10' => { 246 => '3.3', 255 => '3.2' },
	'af-onformb-d11' => { 256 => '2.2' },
	'af-onformb-d12' => { 259 => '50.1' },
	'af-spriorityselection' => { 246 => '1.2', 247 => '1.2', 249 => '1.4', 250 => '1.4', 254 => '0.2', 255 => '1.2', 256 => '0.2', 259 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 246 => '2.1', 247 => '2.1', 249 => '78.3', 250 => '78.3', 255 => '2.1', 259 => '2.1' },
	'afadjustment' => { 317 => 0x72, 326 => 0x267 },
	'afandmeteringbuttons' => { 75 => 0x701 },
	'afaperture' => { 197 => 0x5, 198 => 0x5 },
	'afareaheight' => { 176 => 0x1a },
	'afareaillumination' => { 167 => 0x4b, 257 => '15.3' },
	'afareamode' => { 163 => 0x33, 167 => 0xe, 175 => 0x0, 176 => 0x5, 283 => 0xf, 342 => 0x1205, 353 => [0xa,0x3a], 360 => 0x11, 361 => 0x10, 362 => 0x24, 372 => 0xb043, 394 => 0x17 },
	'afareamodesetting' => { 248 => '11.1', 251 => '0.1', 257 => '16.1', 260 => '2.1', 372 => 0x201c },
	'afareas' => { 262 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 75 => 0x51b },
	'afareawidth' => { 176 => 0x18 },
	'afareaxposition' => { 176 => 0x14, 342 => 0x1203 },
	'afareaxposition1' => { 342 => 0x1201 },
	'afareayposition' => { 176 => 0x16, 342 => 0x1204 },
	'afareayposition1' => { 342 => 0x1202 },
	'afassist' => { 73 => 0x5, 81 => 0x5, 167 => 0x48, 246 => '2.5', 248 => '0.2', 251 => '0.2', 252 => '1.1', 253 => '1.1', 254 => '1.3', 255 => '2.4', 256 => '1.3', 257 => '0.2', 259 => '2.4', 260 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 75 => 0x50e, 76 => 0x4, 77 => 0x5, 78 => 0x4, 79 => 0x4, 80 => 0x5 },
	'afassistlamp' => { 283 => 0x31 },
	'afbuttonpressed' => { 362 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 293 => 0x6 },
	'afduringliveview' => { 75 => 0x511 },
	'affinea' => { 415 => 'AffineA' },
	'affineb' => { 415 => 'AffineB' },
	'affinec' => { 415 => 'AffineC' },
	'affined' => { 415 => 'AffineD' },
	'affinetune' => { 177 => 0x0, 262 => 0x306 },
	'affinetuneadj' => { 177 => 0x2, 211 => 0x2d1, 212 => 0x2dc, 262 => 0x307 },
	'affinetuneindex' => { 177 => 0x1 },
	'affinex' => { 415 => 'AffineX' },
	'affiney' => { 415 => 'AffineY' },
	'afhold' => { 293 => 0x1fd },
	'afilluminator' => { 360 => 0x29, 372 => 0xb044 },
	'afimageheight' => { 176 => 0x12 },
	'afimagewidth' => { 176 => 0x10 },
	'afintegrationtime' => { 293 => 0x7 },
	'afmicroadj' => { 353 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 357 => 0x131 },
	'afmicroadjregisteredlenses' => { 357 => '305.1' },
	'afmicroadjustment' => { 75 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 357 => 0x130 },
	'afmode' => { 104 => 0x3009, 115 => 0x1022, 163 => 0x16, 352 => 0x5 },
	'afmoderestrictions' => { 247 => '50.3', 249 => '48.3', 250 => '48.3', 259 => '48.3' },
	'afonaelockbuttonswitch' => { 75 => 0x702 },
	'afonbutton' => { 246 => '3.1', 247 => '47.1' },
	'afpoint' => { 33 => 0x13, 103 => 0x18, 163 => 0x15, 175 => 0x1, 265 => 0x308, 352 => 0x1f, 353 => [0x37,0x7], 357 => 0x19, 358 => 0x18, 359 => [0x18,0x20] },
	'afpointactivationarea' => { 74 => 0x11, 80 => 0x11 },
	'afpointareaexpansion' => { 75 => 0x508 },
	'afpointatshutterrelease' => { 353 => [0x39,0x9] },
	'afpointautoselection' => { 75 => 0x50b },
	'afpointbrightness' => { 75 => 0x50d, 246 => '2.4', 247 => '46.5', 249 => '2.2', 250 => '2.2', 259 => '2.3' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 75 => 0x50c },
	'afpointillumination' => { 74 => 0xa, 246 => '2.3', 247 => '46.2', 249 => '47.2', 250 => '47.2', 254 => '1.2', 255 => '2.3', 256 => '1.2', 259 => '47.2', 260 => '2.4' },
	'afpointinfocus' => { 353 => [0x38,0x8] },
	'afpointmode' => { 298 => 0x3 },
	'afpointposition' => { 104 => 0x2021, 283 => 0x4d },
	'afpointregistration' => { 73 => 0x7 },
	'afpoints' => { 166 => 0x10 },
	'afpointselected' => { 167 => 0xd, 262 => 0x305, 317 => 0xe, 357 => 0x15, 358 => 0x14, 359 => [0x14,0x1c], 372 => 0x201e },
	'afpointselected2' => { 298 => 0x4 },
	'afpointselection' => { 74 => 0xb, 246 => '1.3', 247 => '1.3', 255 => '1.3', 259 => '1.3' },
	'afpointselectionmethod' => { 75 => 0x50f, 76 => 0xc, 77 => 0xd, 80 => 0xd },
	'afpointsetting' => { 360 => 0x12, 361 => 0x11 },
	'afpointsinfocus' => { 69 => 0xe, 175 => 0x2, 293 => 0xb, 294 => 0x4, 317 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 74 => 0xd },
	'afpointsselected' => { 294 => '4.1', 402 => 0x4 },
	'afpointsspecial' => { 294 => '4.2' },
	'afpointsunknown1' => { 293 => 0x0 },
	'afpointsunknown2' => { 293 => 0x2 },
	'afpointsused' => { 176 => 0x8, 353 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 293 => 0x4 },
	'afresponse' => { 201 => 0xad },
	'afresult' => { 267 => 0x1038 },
	'afsearch' => { 262 => 0x303 },
	'afsensoractive' => { 163 => 0x1 },
	'afstatus' => { 342 => 0x1200 },
	'afstatus_00_b4' => { 356 => 0x0 },
	'afstatus_01_c4' => { 356 => 0x2 },
	'afstatus_02_d4' => { 356 => 0x4 },
	'afstatus_03_e4' => { 356 => 0x6 },
	'afstatus_04_f4' => { 356 => 0x8 },
	'afstatus_05_g4' => { 356 => 0xa },
	'afstatus_06_h4' => { 356 => 0xc },
	'afstatus_07_b3' => { 356 => 0xe },
	'afstatus_08_c3' => { 356 => 0x10 },
	'afstatus_09_d3' => { 356 => 0x12 },
	'afstatus_10_e3' => { 356 => 0x14 },
	'afstatus_11_f3' => { 356 => 0x16 },
	'afstatus_12_g3' => { 356 => 0x18 },
	'afstatus_13_h3' => { 356 => 0x1a },
	'afstatus_14_b2' => { 356 => 0x1c },
	'afstatus_15_c2' => { 356 => 0x1e },
	'afstatus_16_d2' => { 356 => 0x20 },
	'afstatus_17_e2' => { 356 => 0x22 },
	'afstatus_18_f2' => { 356 => 0x24 },
	'afstatus_19_g2' => { 356 => 0x26 },
	'afstatus_20_h2' => { 356 => 0x28 },
	'afstatus_21_c1' => { 356 => 0x2a },
	'afstatus_22_d1' => { 356 => 0x2c },
	'afstatus_23_e1' => { 356 => 0x2e },
	'afstatus_24_f1' => { 356 => 0x30 },
	'afstatus_25_g1' => { 356 => 0x32 },
	'afstatus_26_a7_vertical' => { 356 => 0x34 },
	'afstatus_27_a6_vertical' => { 356 => 0x36 },
	'afstatus_28_a5_vertical' => { 356 => 0x38 },
	'afstatus_29_c7_vertical' => { 356 => 0x3a },
	'afstatus_30_c6_vertical' => { 356 => 0x3c },
	'afstatus_31_c5_vertical' => { 356 => 0x3e },
	'afstatus_32_e7_vertical' => { 356 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 356 => 0x42 },
	'afstatus_34_e5_vertical' => { 356 => 0x44 },
	'afstatus_35_g7_vertical' => { 356 => 0x46 },
	'afstatus_36_g6_vertical' => { 356 => 0x48 },
	'afstatus_37_g5_vertical' => { 356 => 0x4a },
	'afstatus_38_i7_vertical' => { 356 => 0x4c },
	'afstatus_39_i6_vertical' => { 356 => 0x4e },
	'afstatus_40_i5_vertical' => { 356 => 0x50 },
	'afstatus_41_a7' => { 356 => 0x52 },
	'afstatus_42_b7' => { 356 => 0x54 },
	'afstatus_43_c7' => { 356 => 0x56 },
	'afstatus_44_d7' => { 356 => 0x58 },
	'afstatus_45_e7' => { 356 => 0x5a },
	'afstatus_46_f7' => { 356 => 0x5c },
	'afstatus_47_g7' => { 356 => 0x5e },
	'afstatus_48_h7' => { 356 => 0x60 },
	'afstatus_49_i7' => { 356 => 0x62 },
	'afstatus_50_a6' => { 356 => 0x64 },
	'afstatus_51_b6' => { 356 => 0x66 },
	'afstatus_52_c6' => { 356 => 0x68 },
	'afstatus_53_d6' => { 356 => 0x6a },
	'afstatus_54_e6_center' => { 356 => 0x6c },
	'afstatus_55_f6' => { 356 => 0x6e },
	'afstatus_56_g6' => { 356 => 0x70 },
	'afstatus_57_h6' => { 356 => 0x72 },
	'afstatus_58_i6' => { 356 => 0x74 },
	'afstatus_59_a5' => { 356 => 0x76 },
	'afstatus_60_b5' => { 356 => 0x78 },
	'afstatus_61_c5' => { 356 => 0x7a },
	'afstatus_62_d5' => { 356 => 0x7c },
	'afstatus_63_e5' => { 356 => 0x7e },
	'afstatus_64_f5' => { 356 => 0x80 },
	'afstatus_65_g5' => { 356 => 0x82 },
	'afstatus_66_h5' => { 356 => 0x84 },
	'afstatus_67_i5' => { 356 => 0x86 },
	'afstatus_68_c11' => { 356 => 0x88 },
	'afstatus_69_d11' => { 356 => 0x8a },
	'afstatus_70_e11' => { 356 => 0x8c },
	'afstatus_71_f11' => { 356 => 0x8e },
	'afstatus_72_g11' => { 356 => 0x90 },
	'afstatus_73_b10' => { 356 => 0x92 },
	'afstatus_74_c10' => { 356 => 0x94 },
	'afstatus_75_d10' => { 356 => 0x96 },
	'afstatus_76_e10' => { 356 => 0x98 },
	'afstatus_77_f10' => { 356 => 0x9a },
	'afstatus_78_g10' => { 356 => 0x9c },
	'afstatus_79_h10' => { 356 => 0x9e },
	'afstatus_80_b9' => { 356 => 0xa0 },
	'afstatus_81_c9' => { 356 => 0xa2 },
	'afstatus_82_d9' => { 356 => 0xa4 },
	'afstatus_83_e9' => { 356 => 0xa6 },
	'afstatus_84_f9' => { 356 => 0xa8 },
	'afstatus_85_g9' => { 356 => 0xaa },
	'afstatus_86_h9' => { 356 => 0xac },
	'afstatus_87_b8' => { 356 => 0xae },
	'afstatus_88_c8' => { 356 => 0xb0 },
	'afstatus_89_d8' => { 356 => 0xb2 },
	'afstatus_90_e8' => { 356 => 0xb4 },
	'afstatus_91_f8' => { 356 => 0xb6 },
	'afstatus_92_g8' => { 356 => 0xb8 },
	'afstatus_93_h8' => { 356 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 356 => 0xbc },
	'afstatusactivesensor' => { 163 => 0x2, 353 => [0x4,0x3b], 357 => 0x1e, 358 => 0x1b, 359 => [0x1b,0x21] },
	'afstatusbottom' => { 163 => 0x8, 357 => 0x2a, 358 => 0x21, 359 => 0x21 },
	'afstatusbottom-left' => { 163 => 0x12, 358 => 0x2b, 359 => 0x2b },
	'afstatusbottom-right' => { 163 => 0x6, 358 => 0x1f, 359 => 0x1f },
	'afstatusbottomassist-left' => { 357 => 0x28 },
	'afstatusbottomassist-right' => { 357 => 0x2c },
	'afstatusbottomhorizontal' => { 354 => 0x10, 355 => 0x1c },
	'afstatusbottomvertical' => { 354 => 0x16, 355 => 0x26 },
	'afstatuscenter-10' => { 357 => 0x34 },
	'afstatuscenter-11' => { 357 => 0x36 },
	'afstatuscenter-12' => { 357 => 0x38 },
	'afstatuscenter-14' => { 357 => 0x3c },
	'afstatuscenter-7' => { 357 => 0x2e },
	'afstatuscenter-9' => { 357 => 0x32 },
	'afstatuscenter-horizontal' => { 357 => 0x30 },
	'afstatuscenter-vertical' => { 357 => 0x3a },
	'afstatuscenterf2-8' => { 357 => 0x4c },
	'afstatuscenterhorizontal' => { 163 => 0x2f, 354 => 0xc, 355 => 0x18, 358 => 0x2f, 359 => 0x2f },
	'afstatuscentervertical' => { 163 => 0xc, 354 => 0x14, 355 => 0x22, 358 => 0x25, 359 => 0x25 },
	'afstatusfarleft' => { 354 => 0x6, 357 => 0x26 },
	'afstatusfarlefthorizontal' => { 355 => 0x4 },
	'afstatusfarleftvertical' => { 355 => 0x12 },
	'afstatusfarright' => { 354 => 0x18, 357 => 0x44 },
	'afstatusfarrighthorizontal' => { 355 => 0x2c },
	'afstatusfarrightvertical' => { 355 => 0x34 },
	'afstatusleft' => { 163 => 0x2d, 354 => 0x2, 357 => 0x22, 358 => 0x2d, 359 => 0x2d },
	'afstatuslefthorizontal' => { 355 => 0x6 },
	'afstatusleftvertical' => { 355 => 0xe },
	'afstatuslower-left' => { 354 => 0x4, 357 => 0x24 },
	'afstatuslower-lefthorizontal' => { 355 => 0xa },
	'afstatuslower-leftvertical' => { 355 => 0x10 },
	'afstatuslower-middle' => { 354 => 0x22, 355 => 0x24 },
	'afstatuslower-right' => { 354 => 0x1e, 357 => 0x4a },
	'afstatuslower-righthorizontal' => { 355 => 0x32 },
	'afstatuslower-rightvertical' => { 355 => 0x3a },
	'afstatuslowerfarleft' => { 355 => 0x8 },
	'afstatuslowerfarright' => { 355 => 0x30 },
	'afstatusmiddlehorizontal' => { 163 => 0xa, 358 => 0x23, 359 => 0x23 },
	'afstatusnearleft' => { 354 => 0xe, 355 => 0x1a },
	'afstatusnearright' => { 354 => 0xa, 355 => 0x16 },
	'afstatusright' => { 163 => 0x31, 354 => 0x1c, 357 => 0x48, 358 => 0x31, 359 => 0x31 },
	'afstatusrighthorizontal' => { 355 => 0x2e },
	'afstatusrightvertical' => { 355 => 0x38 },
	'afstatustop' => { 163 => 0xe, 357 => 0x40, 358 => 0x27, 359 => 0x27 },
	'afstatustop-left' => { 163 => 0x10, 358 => 0x29, 359 => 0x29 },
	'afstatustop-right' => { 163 => 0x4, 358 => 0x1d, 359 => 0x1d },
	'afstatustopassist-left' => { 357 => 0x3e },
	'afstatustopassist-right' => { 357 => 0x42 },
	'afstatustophorizontal' => { 354 => 0x8, 355 => 0x14 },
	'afstatustopvertical' => { 354 => 0x12, 355 => 0x1e },
	'afstatusupper-left' => { 354 => 0x0, 357 => 0x20 },
	'afstatusupper-lefthorizontal' => { 355 => 0x2 },
	'afstatusupper-leftvertical' => { 355 => 0xc },
	'afstatusupper-middle' => { 354 => 0x20, 355 => 0x20 },
	'afstatusupper-right' => { 354 => 0x1a, 357 => 0x46 },
	'afstatusupper-righthorizontal' => { 355 => 0x2a },
	'afstatusupper-rightvertical' => { 355 => 0x36 },
	'afstatusupperfarleft' => { 355 => 0x0 },
	'afstatusupperfarright' => { 355 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 372 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 353 => 0x2 },
	'afwithshutter' => { 360 => 0x2a },
	'aggregateissuenumber' => { 436 => 'aggregateIssueNumber' },
	'aggregationtype' => { 436 => 'aggregationType' },
	'agreement' => { 439 => 'agreement' },
	'aiservocontinuousshooting' => { 74 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 75 => 0x519 },
	'aiservoimagepriority' => { 75 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 75 => 0x51a },
	'aiservotrackingmethod' => { 75 => 0x504 },
	'aiservotrackingsensitivity' => { 74 => 0x14, 75 => 0x502 },
	'album' => { 446 => 'album' },
	'alreadyapplied' => { 422 => 'AlreadyApplied' },
	'alternatetitle' => { 436 => 'alternateTitle' },
	'alternatetitlea-lang' => { 436 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 436 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 436 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 178 => 0x6 },
	'alttapename' => { 446 => 'altTapeName' },
	'alttimecode' => { 446 => 'altTimecode' },
	'alttimecodetimeformat' => { 446 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 446 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 446 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 110 => 0x9400, 338 => 0x14, 394 => 0x4 },
	'ambienttemperaturefahrenheit' => { 338 => 0x13 },
	'analogbalance' => { 110 => 0xc627 },
	'angleadj' => { 94 => 0x10003, 100 => 0x8b },
	'angleinforoll' => { 417 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 417 => 'AngleInfoYaw' },
	'anti-blur' => { 372 => 0xb04b },
	'antialiasstrength' => { 110 => 0xc632 },
	'aperturelock' => { 247 => '38.2', 249 => '38.2', 250 => '38.2', 259 => '38.2' },
	'aperturerange' => { 75 => 0x10d },
	'apertureringuse' => { 298 => '1.4' },
	'aperturesetting' => { 167 => 0x7, 360 => 0x30, 361 => 0x29, 362 => 0x1 },
	'aperturevalue' => { 84 => 0x2, 110 => 0x9202, 267 => 0x1002, 326 => 0x401, 426 => 'ApertureValue' },
	'applekeywords' => { 271 => 'AAPL:Keywords' },
	'applicationnotes' => { 110 => 0x2bc, 287 => 0x2bc },
	'applicationrecordversion' => { 118 => 0x0 },
	'applyshootingmeteringmode' => { 75 => 0x10e },
	'approved' => { 428 => 'Approved' },
	'approvedby' => { 428 => 'ApprovedBy' },
	'approximatefnumber' => { 279 => 0x313, 285 => 0x3406 },
	'approximatefocusdistance' => { 418 => 'ApproximateFocusDistance' },
	'appversion' => { 430 => 'AppVersion' },
	'aquahsl' => { 94 => 0x20913 },
	'armidentifier' => { 119 => 0x78 },
	'armversion' => { 119 => 0x7a },
	'artfilter' => { 262 => 0x529 },
	'artfiltereffect' => { 262 => 0x52f },
	'artist' => { 110 => 0x13b, 275 => 'Artist', 317 => 0x22e, 442 => 'Artist', 446 => 'artist' },
	'artmode' => { 104 => 0x301b },
	'artmodeparameters' => { 104 => 0x310b },
	'artworkcircadatecreated' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 432 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 432 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 266 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 266 => 0x1112, 317 => 0x80, 360 => 0x55, 361 => 0x55, 362 => 0xa },
	'assetid' => { 412 => 'AssetID' },
	'asshoticcprofile' => { 110 => 0xc68f },
	'asshotneutral' => { 110 => 0xc628 },
	'asshotpreprofilematrix' => { 110 => 0xc690 },
	'asshotprofilename' => { 110 => 0xc6f6 },
	'asshotwhitexy' => { 110 => 0xc629 },
	'assignbktbutton' => { 246 => '4.2', 247 => '16.1', 249 => '16.1', 250 => '16.1', 259 => '16.1' },
	'assignfuncbutton' => { 75 => 0x70b },
	'assignmb-d17af-onbutton' => { 250 => '79.1' },
	'assignmb-d17funcbutton' => { 250 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 250 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 249 => '75.1', 250 => '75.1' },
	'assignmoviefunc2button' => { 249 => '82.1', 250 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 249 => '75.2', 250 => '75.2' },
	'assignmovierecordbutton' => { 247 => '43.2', 259 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 249 => '45.1', 250 => '45.1' },
	'assignmoviesubselector' => { 249 => '74.1', 250 => '74.1' },
	'assignmoviesubselectorplusdials' => { 249 => '76.1', 250 => '76.1' },
	'assignremotefnbutton' => { 247 => '54.1', 259 => '51.1' },
	'assistbuttonfunction' => { 73 => 0xd },
	'attributionname' => { 419 => 'attributionName' },
	'attributionurl' => { 419 => 'attributionURL' },
	'audio' => { 283 => 0x20 },
	'audiobitrate' => { 60 => 0x6c, 432 => 'audioBitRate' },
	'audiobitratemode' => { 432 => 'audioBitRateMode' },
	'audiochannelcount' => { 432 => 'audioChannelCount' },
	'audiochannels' => { 60 => 0x70 },
	'audiochanneltype' => { 446 => 'audioChannelType' },
	'audiocompression' => { 139 => 'Compression' },
	'audiocompressor' => { 446 => 'audioCompressor' },
	'audiodata' => { 408 => 'Data' },
	'audioduration' => { 118 => 0x99 },
	'audiomimetype' => { 408 => 'Mime' },
	'audiomoddate' => { 446 => 'audioModDate' },
	'audiooutcue' => { 118 => 0x9a },
	'audiosamplerate' => { 60 => 0x6e, 446 => 'audioSampleRate' },
	'audiosampletype' => { 446 => 'audioSampleType' },
	'audiosamplingrate' => { 118 => 0x97 },
	'audiosamplingresolution' => { 118 => 0x98 },
	'audiotype' => { 118 => 0x96 },
	'author' => { 141 => 'Author', 271 => 'Author', 275 => 'Author', 333 => 'Author', 416 => 'author', 433 => 'Author', 444 => 'Author' },
	'authorsposition' => { 434 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 75 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 308 => '0.1' },
	'autobracket' => { 352 => 0x19 },
	'autobracketing' => { 115 => 0x1100, 317 => 0x18, 342 => 0x1007 },
	'autobracketingmode' => { 258 => '12.3' },
	'autobracketingset' => { 258 => '12.1' },
	'autobracketmodem' => { 246 => '21.2', 247 => '13.3', 249 => '13.2', 250 => '13.2', 255 => '26.2', 259 => '13.3' },
	'autobracketorder' => { 167 => 0x43, 246 => '21.3', 247 => '13.2', 249 => '13.1', 250 => '13.1', 255 => '26.3', 256 => '12.2', 257 => '2.2', 258 => '12.2', 259 => '13.2', 260 => '13.2' },
	'autobracketset' => { 246 => '21.1', 247 => '13.1', 251 => '11.1', 252 => '12.1', 253 => '12.1', 255 => '26.1', 256 => '12.1', 257 => '2.1', 259 => '13.1', 260 => '13.1' },
	'autobrightness' => { 422 => 'AutoBrightness' },
	'autocontrast' => { 422 => 'AutoContrast' },
	'autodistortioncontrol' => { 186 => 0x4 },
	'autodynamicrange' => { 115 => 0x140b },
	'autoexposure' => { 422 => 'AutoExposure' },
	'autoexposurebracketing' => { 69 => 0x10 },
	'autoflashisosensitivity' => { 249 => '38.5', 250 => '38.5' },
	'autofocus' => { 265 => 0x209 },
	'autofp' => { 257 => '7.3', 260 => '31.4' },
	'autoiso' => { 69 => 0x1, 104 => 0x3008, 248 => '1.1', 257 => '1.1' },
	'autoisomax' => { 248 => '1.2', 257 => '1.2' },
	'autoisominshutterspeed' => { 248 => '1.3', 257 => '1.3' },
	'autolateralca' => { 422 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 56 => 0x2, 75 => 0x204, 94 => 0x20500, 100 => 0x6f },
	'autolightingoptimizeron' => { 94 => '0x20500.0', 100 => 0x6e },
	'autoportraitframed' => { 372 => 0x2016 },
	'autoredeye' => { 239 => 0xfe28a44f },
	'autorotate' => { 69 => 0x1b },
	'autoshadows' => { 422 => 'AutoShadows' },
	'autowhiteversion' => { 422 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 201 => 0x82 },
	'avaperturesetting' => { 298 => 0x13 },
	'averageblacklevel' => { 40 => 0xe7, 42 => 0xfb, 43 => 0x114, 44 => 0x146 },
	'averagelv' => { 170 => 0x38 },
	'avsettingwithoutlens' => { 75 => 0x707 },
	'azimuth' => { 149 => 'Azimuth' },
	'babyage' => { 283 => [0x8010,0x33] },
	'babyname' => { 283 => 0x66 },
	'backgroundalpha' => { 441 => 'bgalpha' },
	'baseexposurecompensation' => { 298 => 0x15 },
	'baseiso' => { 69 => 0x2, 88 => 0x101c, 124 => 0x903, 285 => 0x312a, 400 => 0x6 },
	'baselineexposure' => { 110 => 0xc62a },
	'baselineexposureoffset' => { 110 => 0xc7a5 },
	'baselinenoise' => { 110 => 0xc62b },
	'baselinesharpness' => { 110 => 0xc62c },
	'baseurl' => { 444 => 'BaseURL' },
	'batterylevel' => { 360 => 0x51, 364 => 0xc, 365 => 0x4, 366 => 0x4, 401 => 0x7 },
	'batterylevelgrip1' => { 401 => 0x6 },
	'batterylevelgrip2' => { 401 => 0x8 },
	'batteryorder' => { 246 => '12.5', 255 => '13.2', 256 => '2.1', 259 => '3.1' },
	'batterystate' => { 167 => 0x60, 360 => 0x50, 366 => 0x14 },
	'batterytemperature' => { 364 => 0x1, 366 => 0x2, 401 => 0x5 },
	'batteryunknown' => { 364 => 0x2, 366 => 0x0 },
	'batteryvoltage' => { 124 => 0x408, 338 => 0x2a, 364 => 0x8 },
	'batteryvoltage1' => { 366 => 0x6 },
	'batteryvoltage2' => { 366 => 0x8 },
	'bayergreensplit' => { 110 => 0xc62d },
	'bayerpattern' => { 123 => 0xf902, 171 => 0x17 },
	'beatspliceparams' => { 446 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 446 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 446 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 446 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 446 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 446 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 246 => '13.1', 247 => '5.4', 248 => '0.1', 251 => '2.1', 252 => '3.1', 253 => '3.1', 255 => '10.1', 257 => '0.1', 259 => '5.5', 260 => '4.1' },
	'beeppitch' => { 256 => '3.1' },
	'beepvolume' => { 256 => '4.5' },
	'bestqualityscale' => { 110 => 0xc65c },
	'bestshotmode' => { 104 => 0x3007 },
	'bitdepth' => { 146 => 'BitDepth', 171 => 0x11, 208 => 0x41 },
	'bitspercomponent' => { 120 => 0x87 },
	'bitspersample' => { 110 => 0x102, 442 => 'BitsPerSample' },
	'blacklevel' => { 110 => 0xc61a, 201 => 0x3d, 267 => [0x401,0x1012], 326 => 0x21d },
	'blacklevel1' => { 287 => 0x8 },
	'blacklevel2' => { 266 => 0x600, 270 => 0x600, 287 => 0x9 },
	'blacklevel3' => { 287 => 0xa },
	'blacklevelblue' => { 287 => 0x1e },
	'blackleveldata' => { 326 => 0x223 },
	'blackleveldeltah' => { 110 => 0xc61b },
	'blackleveldeltav' => { 110 => 0xc61c },
	'blacklevelgreen' => { 287 => 0x1d },
	'blacklevelred' => { 287 => 0x1c },
	'blacklevelrepeatdim' => { 110 => 0xc619 },
	'blackpoint' => { 317 => 0x200 },
	'blacks2012' => { 422 => 'Blacks2012' },
	'bleachbypasstoning' => { 317 => 0x7f },
	'blockshotafresponse' => { 249 => '1.5', 250 => '1.5' },
	'blogtitle' => { 436 => 'blogTitle' },
	'blogurl' => { 436 => 'blogURL' },
	'bluebalance' => { 184 => 0x271, 267 => 0x1018, 287 => 0x12, 317 => 0x1b },
	'bluecurvelimits' => { 99 => 0x1fe },
	'bluecurvepoints' => { 98 => 0x79, 99 => 0x1d4 },
	'bluehsl' => { 94 => [0x20914,0x20915] },
	'bluehue' => { 422 => 'BlueHue' },
	'bluesaturation' => { 422 => 'BlueSaturation' },
	'blurcontrol' => { 317 => 0x82 },
	'blurwarning' => { 115 => 0x1300 },
	'bodybatteryadload' => { 296 => 0x3 },
	'bodybatteryadnoload' => { 296 => 0x2 },
	'bodybatterystate' => { 296 => '1.1' },
	'bodybatteryvoltage1' => { 296 => 0x2 },
	'bodybatteryvoltage2' => { 296 => 0x4 },
	'bodybatteryvoltage3' => { 296 => 0x6 },
	'bodybatteryvoltage4' => { 296 => 0x8 },
	'bodyfirmware' => { 343 => 0x0 },
	'bodyfirmwareversion' => { 263 => 0x104, 264 => 0x100, 267 => 0x104 },
	'bodyserialnumber' => { 343 => 0x10 },
	'bookedition' => { 436 => 'bookEdition' },
	'bracketmode' => { 51 => 0x3 },
	'bracketsequence' => { 104 => 0x301d },
	'bracketsettings' => { 283 => 0x45 },
	'bracketshotnumber' => { 51 => 0x5, 298 => 0x9, 371 => 0x2b },
	'bracketshotnumber2' => { 371 => 0x2d },
	'bracketstep' => { 164 => 0xe },
	'bracketvalue' => { 51 => 0x4 },
	'brightness' => { 110 => 0xfe53, 140 => 'Brightness', 160 => 'Brightness', 164 => 0x2c, 203 => 0x34, 204 => 0x39, 338 => 0x25, 360 => 0x22, 372 => 0x2007, 422 => 'Brightness' },
	'brightnessadj' => { 99 => 0x114, 232 => 0x0, 242 => 0x2d, 404 => 0x8018 },
	'brightnessvalue' => { 110 => 0x9203, 170 => [0x691,0x49c3], 267 => 0x1003, 376 => 0x1e, 379 => 0x1140, 380 => 0x1140, 381 => 0x111c, 382 => 0x1198, 383 => 0x1174, 384 => 0x102c, 385 => 0x224, 386 => 0x224, 387 => 0x219, 426 => 'BrightnessValue' },
	'bulbduration' => { 69 => 0x18 },
	'burstmode' => { 126 => 0xa, 283 => 0x2a },
	'burstmode2' => { 126 => 0x18 },
	'burstshot' => { 352 => 0x34 },
	'burstspeed' => { 283 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 75 => 0x70a },
	'bwfilter' => { 164 => 0x2a, 172 => 0x39 },
	'bwmode' => { 267 => 0x203 },
	'by-line' => { 118 => 0x50 },
	'by-linetitle' => { 118 => 0x55 },
	'bytecount' => { 436 => 'byteCount' },
	'calibration' => { 352 => [0x24,0x30] },
	'calibrationilluminant1' => { 110 => 0xc65a },
	'calibrationilluminant2' => { 110 => 0xc65b },
	'callforimage' => { 412 => 'CallForImage' },
	'cameraangle' => { 446 => 'cameraAngle' },
	'cameracalibration1' => { 110 => 0xc623 },
	'cameracalibration2' => { 110 => 0xc624 },
	'cameracalibrationsig' => { 110 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 41 => 0xba },
	'cameracolorcalibration02' => { 35 => 0x4, 41 => 0xbf },
	'cameracolorcalibration03' => { 35 => 0x8, 41 => 0xc4 },
	'cameracolorcalibration04' => { 35 => 0xc, 41 => 0xc9 },
	'cameracolorcalibration05' => { 35 => 0x10, 41 => 0xce },
	'cameracolorcalibration06' => { 35 => 0x14, 41 => 0xd3 },
	'cameracolorcalibration07' => { 35 => 0x18, 41 => 0xd8 },
	'cameracolorcalibration08' => { 35 => 0x1c, 41 => 0xdd },
	'cameracolorcalibration09' => { 35 => 0x20, 41 => 0xe2 },
	'cameracolorcalibration10' => { 35 => 0x24, 41 => 0xe7 },
	'cameracolorcalibration11' => { 35 => 0x28, 41 => 0xec },
	'cameracolorcalibration12' => { 35 => 0x2c, 41 => 0xf1 },
	'cameracolorcalibration13' => { 35 => 0x30, 41 => 0xf6 },
	'cameracolorcalibration14' => { 35 => 0x34, 41 => 0xfb },
	'cameracolorcalibration15' => { 35 => 0x38, 41 => 0x100 },
	'camerae-mountversion' => { 403 => 0xb },
	'cameraelevationangle' => { 110 => 0x9405 },
	'camerafilename' => { 412 => 'CameraFilename' },
	'cameraid' => { 267 => 0x209, 351 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 110 => 0xc7a1, 446 => 'cameraLabel' },
	'cameramakemodel' => { 412 => 'CameraMakeModel' },
	'cameramodel' => { 326 => 0x410, 446 => 'cameraModel' },
	'cameramodelid' => { 160 => 'CameraModelID' },
	'cameramove' => { 446 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 283 => 0x8f, 321 => 0x1, 326 => 0x100, 366 => [0x16,0x18], 391 => 0x28, 392 => 0x24, 393 => 0x29 },
	'cameraowner' => { 127 => 0xc353 },
	'cameraparameters' => { 267 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 106 => 0x9 },
	'cameraprofile' => { 422 => 'CameraProfile' },
	'cameraprofiledigest' => { 422 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 100 => 0xe1 },
	'camerarawcontrast' => { 100 => 0xe3 },
	'camerarawhighlightpoint' => { 100 => 0xe6 },
	'camerarawlinear' => { 100 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 100 => 0xe8 },
	'camerarawoutputshadowpoint' => { 100 => 0xe9 },
	'camerarawsaturation' => { 100 => 0xe2 },
	'camerarawshadowpoint' => { 100 => 0xe7 },
	'camerarawsharpness' => { 100 => 0xe5 },
	'cameraroll' => { 106 => 0xb },
	'cameraserialnumber' => { 110 => 0xc62f, 162 => 'CameraSerialNumber', 412 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 262 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 69 => 0xc, 124 => 0x406, 266 => 0x1306, 279 => 0x320, 285 => 0x3402, 317 => 0x47, 349 => 0x43, 395 => 0x5 },
	'cameratemperature4' => { 322 => 0x14 },
	'cameratemperature5' => { 322 => 0x16 },
	'cameratemperaturerangemax' => { 112 => 0x5 },
	'cameratemperaturerangemin' => { 112 => 0x6 },
	'cameratype' => { 69 => 0x1a, 267 => 0x207 },
	'cameratype2' => { 263 => 0x100 },
	'camerayaw' => { 106 => 0xa },
	'canondr4' => { 111 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 88 => 0x805 },
	'canonfilelength' => { 57 => 0xe },
	'canonfirmwareversion' => { 57 => 0x7, 88 => 0x80b },
	'canonflashinfo' => { 88 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 57 => 0x6, 88 => 0x815 },
	'canonmodelid' => { 57 => 0x10, 88 => 0x1834 },
	'canonvrd' => { 111 => 'CanonVRD' },
	'caption' => { 416 => 'caption' },
	'caption-abstract' => { 118 => 0x78 },
	'captionsauthornames' => { 425 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 425 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 434 => 'CaptionWriter' },
	'captureframerate' => { 104 => 0x4001 },
	'capturesoftware' => { 410 => 'CaptureSoftware' },
	'cardshutterlock' => { 167 => 0x49 },
	'casioimagesize' => { 104 => 0x9 },
	'catalogsets' => { 118 => 0xff, 407 => 'CatalogSets', 414 => 'CatalogSets' },
	'categories' => { 57 => 0x23, 416 => 'categories' },
	'category' => { 118 => 0xf, 261 => 0x30, 434 => 'Category' },
	'cbcrgain' => { 349 => 0xa036 },
	'cbcrgaindefault' => { 349 => 0xa035 },
	'cbcrmatrix' => { 349 => 0xa034 },
	'cbcrmatrixdefault' => { 349 => 0xa033 },
	'ccdboardversion' => { 279 => 0x331 },
	'ccdscanmode' => { 267 => 0x1039 },
	'ccdsensitivity' => { 229 => 0x6 },
	'ccdversion' => { 279 => 0x330 },
	'cellglobalid' => { 420 => 'cgi' },
	'celllength' => { 110 => 0x109 },
	'cellr' => { 420 => 'r' },
	'celltowerid' => { 420 => 'cellid' },
	'cellwidth' => { 110 => 0x108 },
	'centerafarea' => { 257 => '15.1' },
	'centerfocuspoint' => { 260 => '2.2' },
	'centerweightedareasize' => { 246 => '7.1', 247 => '8.1', 249 => '8.1', 250 => '8.1', 254 => '7.1', 255 => '5.1', 256 => '7.1', 257 => '6.3', 259 => '8.1', 260 => '8.1' },
	'certificate' => { 450 => 'Certificate' },
	'cfapattern' => { 110 => 0xa302, 426 => 'CFAPattern' },
	'cfapattern2' => { 110 => 0x828e },
	'cfapatterncolumns' => { 426 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 426 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 426 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 110 => 0x828d },
	'channel' => { 436 => 'channel' },
	'channela-lang' => { 436 => [\'channel','channelA-lang'] },
	'channelchannel' => { 436 => [\'channel','channelChannel'] },
	'channels' => { 139 => 'Channels' },
	'channelsubchannel1' => { 436 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 436 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 436 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 436 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 94 => 0x10101, 99 => 0x26a },
	'checkmark2' => { 100 => 0x8e },
	'childfontfiles' => { 451 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 246 => '10.3', 247 => '11.2' },
	'chromablurradius' => { 110 => 0xc631 },
	'chromaticaberration' => { 94 => 0x20703, 100 => 0x66, 349 => 0xa051 },
	'chromaticaberrationb' => { 422 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 94 => 0x20708, 100 => 0x6b },
	'chromaticaberrationcorr' => { 71 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 307 => 0x1 },
	'chromaticaberrationcorrparams' => { 110 => 0x7035, 399 => 0x66a, 400 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 94 => '0x20703.0', 100 => 0x62 },
	'chromaticaberrationr' => { 422 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 94 => 0x20707, 100 => 0x6a },
	'chromaticaberrationsetting' => { 72 => 0x6 },
	'chrominancenoisereduction' => { 94 => 0x20601, 100 => 0x5e, 352 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 100 => 0x60 },
	'circadatecreated' => { 432 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 422 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 422 => 'CircularGradientBasedCorrections' },
	'city' => { 118 => 0x5a, 145 => 'City', 283 => 0x6d, 434 => 'City' },
	'city2' => { 283 => 0x80 },
	'clarity' => { 204 => 0x35, 422 => 'Clarity' },
	'clarity2012' => { 422 => 'Clarity2012' },
	'claritycontrol' => { 317 => 0x96 },
	'classifystate' => { 118 => 0xe1 },
	'clearretouch' => { 283 => 0x7c },
	'clearretouchvalue' => { 283 => 0xa3 },
	'client' => { 446 => 'client' },
	'clientname' => { 428 => 'ClientName' },
	'clmodeshootingspeed' => { 246 => '10.2', 247 => '11.3', 249 => '11.2', 250 => '11.2', 255 => '11.2', 256 => '10.2', 259 => '11.2', 260 => '11.1' },
	'cmcontrast' => { 270 => 0x2022 },
	'cmexposurecompensation' => { 270 => 0x2000 },
	'cmhue' => { 270 => 0x2021 },
	'cmsaturation' => { 270 => 0x2020 },
	'cmsharpness' => { 270 => 0x2023 },
	'cmwhitebalance' => { 270 => 0x2001 },
	'cmwhitebalancecomp' => { 270 => 0x2002 },
	'cmwhitebalancegraypoint' => { 270 => 0x2010 },
	'codec' => { 153 => 'Codec' },
	'codedcharacterset' => { 119 => 0x5a },
	'collection' => { 275 => 'Collection' },
	'collectionname' => { 154 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 154 => 'Collections', 416 => 'collections' },
	'collectionuri' => { 154 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 435 => 'color' },
	'coloraberrationcontrol' => { 239 => 0xc89224b },
	'coloradjustment' => { 352 => 0x14 },
	'coloradjustmentmode' => { 351 => 0x210 },
	'coloranta' => { 451 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 451 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 451 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 451 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 451 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 451 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 451 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 451 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 451 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 451 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 451 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 451 => 'Colorants' },
	'colorantswatchname' => { 451 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 451 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 451 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 451 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 140 => 'ColorBalance' },
	'colorbalanceadj' => { 239 => 0x76a43202 },
	'colorbalanceblue' => { 164 => 0x1e },
	'colorbalancegreen' => { 164 => 0x1d },
	'colorbalancered' => { 164 => 0x1c },
	'colorbalanceversion' => { 185 => 0x0 },
	'colorblur' => { 100 => 0x65 },
	'colorbluron' => { 94 => 0x20704 },
	'colorbooster' => { 239 => 0x5f0e7d23 },
	'colorboostlevel' => { 233 => 0x1 },
	'colorboosttype' => { 233 => 0x0 },
	'colorclass' => { 328 => 0xde, 329 => 'ColorClass' },
	'colorcompensationfilter' => { 167 => [0x3a,0x5f], 169 => 0x111, 372 => 0xb022 },
	'colorcompensationfiltercustom' => { 360 => 0xd, 361 => 0xc },
	'colorcompensationfilterset' => { 360 => 0x8, 361 => 0x7, 362 => 0x18, 376 => 0xf },
	'colorcontrol' => { 267 => 0x102b },
	'colorcorrection' => { 404 => 0x8015 },
	'colorcreatoreffect' => { 262 => 0x532 },
	'colordataversion' => { 39 => 0x0, 40 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0 },
	'coloreffect' => { 283 => 0x28 },
	'colorfilter' => { 103 => 0x17, 104 => 0x3017, 164 => 0x29, 172 => [0x38,0x4d,0x4f], 324 => 0x17 },
	'colorgain' => { 208 => 0x51 },
	'colorhue' => { 94 => 0x20900, 201 => 0x8d },
	'colorimetricreference' => { 110 => 0xc6bf },
	'colorlabel' => { 425 => 'ColorLabel' },
	'colormatrix' => { 266 => 0x200, 267 => 0x1011, 349 => 0xa030 },
	'colormatrix1' => { 110 => 0xc621, 326 => 0x106 },
	'colormatrix2' => { 110 => 0xc622, 270 => 0x200, 326 => 0x226 },
	'colormatrixa' => { 317 => 0x203 },
	'colormatrixadobergb' => { 349 => 0xa032 },
	'colormatrixb' => { 317 => 0x204 },
	'colormatrixnumber' => { 267 => 0x1019 },
	'colormatrixsrgb' => { 349 => 0xa031 },
	'colormode' => { 104 => 0x3015, 115 => 0x1210, 126 => 0x66, 164 => 0x28, 167 => 0x16, 169 => 0x101, 170 => 0x36, 172 => 0x7, 201 => 0x3, 229 => 0x4, 283 => 0x32, 352 => 0x2c, 372 => 0xb029, 434 => 'ColorMode' },
	'colormoirereduction' => { 240 => 0x15 },
	'colormoirereductionmode' => { 240 => 0x5 },
	'colornoisereduction' => { 404 => 0x8029, 422 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 422 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 240 => 0x18 },
	'colornoisereductionsharpness' => { 240 => 0x1c },
	'colornoisereductionsmoothness' => { 422 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 114 => 0x2 },
	'colorprofile' => { 164 => 0x33 },
	'colorprofilesettings' => { 262 => 0x539 },
	'colorrepresentation' => { 120 => 0x3c },
	'colorsaturationadj' => { 94 => 0x20305 },
	'colorsequence' => { 120 => 0x41 },
	'colorspace' => { 45 => 0x3, 57 => 0xb4, 88 => 0x10b4, 110 => 0xa001, 146 => 'ColorSpace', 165 => 0x2f, 166 => 0x25, 167 => 0x17, 201 => 0x1e, 262 => 0x507, 317 => 0x37, 349 => 0xa011, 352 => 0xb, 360 => 0x1b, 361 => 0x83, 362 => 0xe, 376 => 0x6, 426 => 'ColorSpace' },
	'colortempasshot' => { 36 => 0x4, 37 => 0x1d, 38 => 0x26, 39 => 0x43, 42 => 0x43, 43 => 0x43, 44 => 0x43 },
	'colortempauto' => { 36 => 0x9, 37 => 0x22, 38 => 0x1c, 39 => 0x48, 42 => 0x48, 43 => 0x48, 44 => 0x48 },
	'colortempcloudy' => { 36 => 0x22, 37 => 0x31, 38 => 0x35, 39 => 0x5c, 42 => 0x75, 43 => 0x8e, 44 => 0x93, 317 => 0x55 },
	'colortempcustom' => { 39 => 0x84 },
	'colortempcustom1' => { 37 => 0x45 },
	'colortempcustom2' => { 37 => 0x4a },
	'colortempdaylight' => { 36 => 0x18, 37 => 0x27, 38 => 0x2b, 39 => 0x52, 42 => 0x6b, 43 => 0x84, 44 => 0x89, 317 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 57 => 0xae, 67 => 0x9, 88 => 0x10ae, 115 => 0x1005, 124 => 0x846, 140 => 'ColorTemperature', 165 => [0x6e,0x49], 166 => 0x3f, 167 => [0x39,0x5e], 169 => 0x10b, 172 => [0x3c,0x4c,0x4e], 279 => 0x321, 317 => 0x50, 342 => 0x1308, 372 => 0xb021, 422 => 'Temperature' },
	'colortemperatureadj' => { 404 => 0x8013 },
	'colortemperaturebg' => { 267 => 0x1013 },
	'colortemperaturecustom' => { 360 => 0xc, 361 => 0xb },
	'colortemperaturerg' => { 267 => 0x1014 },
	'colortemperatureset' => { 360 => 0x7, 361 => 0x6 },
	'colortemperaturesetting' => { 167 => 0x25, 362 => 0x17, 376 => 0xe },
	'colortempflash' => { 36 => 0x36, 37 => 0x40, 38 => 0x49, 39 => 0x70, 42 => 0x89, 43 => 0xa2, 44 => 0xa7, 317 => 0x5a },
	'colortempflashdata' => { 39 => 0x24a },
	'colortempfluorescent' => { 36 => 0x2c, 37 => 0x3b, 38 => 0x3f, 39 => 0x66, 42 => 0x7f, 43 => 0x98, 44 => 0x9d },
	'colortempfluorescentd' => { 317 => 0x57 },
	'colortempfluorescentn' => { 317 => 0x58 },
	'colortempfluorescentw' => { 317 => 0x59 },
	'colortempkelvin' => { 36 => 0x31, 38 => 0x44, 39 => 0x6b, 42 => 0x84, 43 => 0x9d, 44 => 0xa2, 283 => 0x44, 342 => 0x1307 },
	'colortempmeasured' => { 36 => 0xe, 39 => 0x4d, 42 => 0x4d, 43 => 0x4d, 44 => 0x4d },
	'colortemppc1' => { 38 => 0x94, 39 => 0x75 },
	'colortemppc2' => { 38 => 0x99, 39 => 0x7a },
	'colortemppc3' => { 38 => 0x9e, 39 => 0x7f },
	'colortempshade' => { 36 => 0x1d, 37 => 0x2c, 38 => 0x30, 39 => 0x57, 42 => 0x70, 43 => 0x89, 44 => 0x8e, 317 => 0x54 },
	'colortemptungsten' => { 36 => 0x27, 37 => 0x36, 38 => 0x3a, 39 => 0x61, 42 => 0x7a, 43 => 0x93, 44 => 0x98, 317 => 0x56 },
	'colortempunknown' => { 36 => 0x13, 38 => 0x21, 42 => 0x52, 43 => 0x52, 44 => 0x52 },
	'colortempunknown10' => { 36 => 0x63, 38 => 0x76, 42 => 0xa2, 43 => 0x7f, 44 => 0x7f },
	'colortempunknown11' => { 36 => 0x68, 38 => 0x7b, 42 => 0xa7, 43 => 0xa7, 44 => 0x84 },
	'colortempunknown12' => { 36 => 0x6d, 38 => 0x80, 42 => 0xac, 43 => 0xac, 44 => 0xac },
	'colortempunknown13' => { 36 => 0x72, 38 => 0x85, 42 => 0xb1, 43 => 0xb1, 44 => 0xb1 },
	'colortempunknown14' => { 38 => 0x8a, 42 => 0xb6, 43 => 0xb6, 44 => 0xb6 },
	'colortempunknown15' => { 38 => 0x8f, 42 => 0xbb, 43 => 0xbb, 44 => 0xbb },
	'colortempunknown16' => { 38 => 0xa3, 43 => 0xc0, 44 => 0xc0 },
	'colortempunknown17' => { 43 => 0xc5, 44 => 0xc5 },
	'colortempunknown18' => { 43 => 0xca, 44 => 0xca },
	'colortempunknown19' => { 43 => 0xcf, 44 => 0xcf },
	'colortempunknown2' => { 36 => 0x3b, 38 => 0x4e, 42 => 0x57, 43 => 0x57, 44 => 0x57 },
	'colortempunknown20' => { 43 => 0xd4, 44 => 0xd4 },
	'colortempunknown21' => { 44 => 0xd9 },
	'colortempunknown22' => { 44 => 0xde },
	'colortempunknown23' => { 44 => 0xe3 },
	'colortempunknown24' => { 44 => 0xe8 },
	'colortempunknown25' => { 44 => 0xed },
	'colortempunknown26' => { 44 => 0xf2 },
	'colortempunknown27' => { 44 => 0xf7 },
	'colortempunknown28' => { 44 => 0xfc },
	'colortempunknown29' => { 44 => 0x101 },
	'colortempunknown3' => { 36 => 0x40, 38 => 0x53, 42 => 0x5c, 43 => 0x5c, 44 => 0x5c },
	'colortempunknown30' => { 44 => 0x106 },
	'colortempunknown4' => { 36 => 0x45, 38 => 0x58, 42 => 0x61, 43 => 0x61, 44 => 0x61 },
	'colortempunknown5' => { 36 => 0x4a, 38 => 0x5d, 42 => 0x66, 43 => 0x66, 44 => 0x66 },
	'colortempunknown6' => { 36 => 0x4f, 38 => 0x62, 42 => 0x8e, 43 => 0x6b, 44 => 0x6b },
	'colortempunknown7' => { 36 => 0x54, 38 => 0x67, 42 => 0x93, 43 => 0x70, 44 => 0x70 },
	'colortempunknown8' => { 36 => 0x59, 38 => 0x6c, 42 => 0x98, 43 => 0x75, 44 => 0x75 },
	'colortempunknown9' => { 36 => 0x5e, 38 => 0x71, 42 => 0x9d, 43 => 0x7a, 44 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 45 => 0x2 },
	'colortoneadj' => { 94 => 0x20304, 99 => 0x11e },
	'colortoneauto' => { 64 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 63 => 0x6c, 64 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 63 => 0x3c, 64 => 0x3c },
	'colortonemonochrome' => { 63 => 0x84, 64 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 63 => 0x54, 64 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 63 => 0x24, 64 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 63 => 0xc, 64 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 63 => 0x9c, 64 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 63 => 0xb4, 64 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 63 => 0xcc, 64 => 0xe4 },
	'commanddials' => { 257 => '5.1' },
	'commanddialsaperturesetting' => { 246 => '17.3', 247 => '18.3', 249 => '18.3', 250 => '18.3', 255 => '33.3', 256 => '17.3', 259 => '18.3' },
	'commanddialschangemainsub' => { 246 => '17.2', 247 => '18.1', 249 => '18.1', 250 => '18.1', 255 => '33.2', 256 => '17.2', 259 => '18.1' },
	'commanddialsmenuandplayback' => { 246 => '17.4', 247 => '18.2', 249 => '18.2', 250 => '18.2', 255 => '33.4', 256 => '17.4', 259 => '18.2' },
	'commanddialsreverserotation' => { 246 => '17.1', 247 => '6.4', 249 => '6.2', 250 => '6.2', 251 => '16.2', 252 => '17.2', 255 => '33.1', 256 => '17.1', 259 => '6.2', 260 => '18.1' },
	'commanderchannel' => { 257 => '10.2', 258 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 257 => '13.1', 258 => '31.1' },
	'commandergroupa_ttlcomp' => { 260 => '32.1' },
	'commandergroupamanualoutput' => { 257 => '13.2', 258 => '28.2' },
	'commandergroupamode' => { 257 => '11.2', 258 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 257 => '14.1', 258 => '32.1' },
	'commandergroupb_ttlcomp' => { 260 => '33.1' },
	'commandergroupbmanualoutput' => { 257 => '14.2', 258 => '29.2' },
	'commandergroupbmode' => { 257 => '11.3', 258 => '29.1' },
	'commanderinternalflash' => { 257 => '11.1', 258 => '27.1' },
	'commanderinternalmanualoutput' => { 257 => '12.2', 258 => '27.2' },
	'commanderinternalttlchannel' => { 255 => '18.2' },
	'commanderinternalttlcomp' => { 257 => '12.1', 258 => '30.2', 260 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 255 => '20.1', 256 => '26.1' },
	'commanderinternalttlcompgroupa' => { 255 => '21.1', 256 => '27.1' },
	'commanderinternalttlcompgroupb' => { 255 => '22.1', 256 => '28.1' },
	'comment' => { 0 => 0x2, 111 => 'Comment', 141 => 'Comment', 275 => 'Comment' },
	'compass' => { 345 => 0x4 },
	'complianceprofile' => { 436 => 'complianceProfile' },
	'componentsconfiguration' => { 110 => 0x9101, 146 => 'Components', 426 => 'ComponentsConfiguration' },
	'componentversion' => { 88 => 0x80c },
	'composer' => { 446 => 'composer' },
	'composition' => { 412 => 'Composition' },
	'compositionadjust' => { 316 => '0.1' },
	'compositionadjustrotation' => { 316 => 0x7 },
	'compositionadjustx' => { 316 => 0x5 },
	'compositionadjusty' => { 316 => 0x6 },
	'compressedbitsperpixel' => { 110 => 0x9102, 426 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 169 => 0x40, 267 => 0x40 },
	'compression' => { 110 => 0x103, 442 => 'Compression' },
	'compressionfactor' => { 262 => 0x50d },
	'compressionratio' => { 146 => 'Compression', 267 => 0x1034 },
	'confidencelevel' => { 417 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 99 => 0x266, 328 => 0xd6 },
	'constrainedcropwidth' => { 99 => 0x262, 328 => 0xd5 },
	'contact' => { 118 => 0x76 },
	'contactinfo' => { 435 => 'contactInfo' },
	'containerformat' => { 432 => 'ContainerFormat' },
	'containerformatidentifier' => { 432 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 432 => [\'ContainerFormat','ContainerFormatName'] },
	'contentlocationcode' => { 118 => 0x1a },
	'contentlocationname' => { 118 => 0x1b },
	'contenttype' => { 436 => 'contentType' },
	'continuousbracketing' => { 167 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousshootingspeed' => { 75 => 0x610 },
	'continuousshotlimit' => { 75 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 103 => 0xc, 104 => [0x3012,0x20], 110 => [0xa408,0xfe54], 115 => [0x1004,0x1006], 140 => 'Contrast', 160 => 'Contrast', 164 => 0x20, 165 => 0x31, 166 => 0x27, 167 => 0x19, 172 => 0x2, 203 => 0x33, 204 => 0x37, 267 => 0x1029, 283 => 0x39, 285 => 0x300a, 317 => 0x20, 324 => 0xc, 338 => 0x24, 342 => 0x1012, 352 => 0xd, 360 => 0x1d, 361 => 0x1a, 372 => 0x2004, 422 => 'Contrast', 426 => 'Contrast' },
	'contrast2012' => { 422 => 'Contrast2012' },
	'contrastadj' => { 94 => 0x20303, 99 => 0x115, 242 => 0x2c, 404 => 0x8017 },
	'contrastauto' => { 64 => 0x90 },
	'contrastcurve' => { 201 => 0x8c },
	'contrastdetectaf' => { 176 => 0x4 },
	'contrastdetectafarea' => { 317 => 0x231 },
	'contrastdetectafinfocus' => { 176 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 63 => 0x60, 64 => 0x60 },
	'contrasthighlight' => { 317 => 0x6d },
	'contrasthighlightshadowadj' => { 317 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 63 => 0x30, 64 => 0x30 },
	'contrastmode' => { 283 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 63 => 0x78, 64 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 63 => 0x48, 64 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 63 => 0x18, 64 => 0x18 },
	'contrastsetting' => { 262 => 0x505, 270 => 0x1012, 362 => 0x10, 376 => 0x8 },
	'contrastshadow' => { 317 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 63 => 0x0, 64 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 63 => 0x90, 64 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 63 => 0xa8, 64 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 63 => 0xc0, 64 => 0xd8 },
	'contributedmedia' => { 446 => 'contributedMedia' },
	'contributedmediaduration' => { 446 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 446 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 446 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 446 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 446 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 446 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 446 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 446 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 446 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 446 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 423 => 'contributor', 432 => 'Contributor' },
	'contributoridentifier' => { 432 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 432 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 432 => [\'Contributor','ContributorRole'] },
	'contributors' => { 141 => 'Contributors' },
	'controldialset' => { 167 => 0x46 },
	'controlledvocabularyterm' => { 432 => 'CVterm' },
	'controllerboardversion' => { 279 => 0x332 },
	'controlmode' => { 69 => 0x12 },
	'conversionlens' => { 263 => 0x403, 283 => 0x35 },
	'converter' => { 110 => 0xfe4d, 229 => 0xb, 422 => 'Converter' },
	'converttograyscale' => { 422 => 'ConvertToGrayscale' },
	'cookingequipment' => { 438 => 'cookingEquipment' },
	'cookingmethod' => { 438 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 110 => 0x8298, 141 => 'Copyright', 275 => 'Copyright', 317 => 0x22f, 333 => 'Copyright', 433 => 'Copyright', 439 => 'copyright', 442 => 'Copyright', 446 => 'copyright' },
	'copyrightflag' => { 331 => 0x40a },
	'copyrightnotice' => { 118 => 0x74 },
	'copyrightowner' => { 272 => 'CopyrightOwner' },
	'copyrightownerid' => { 272 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 272 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 272 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 272 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 272 => 'CopyrightStatus' },
	'copyrightyear' => { 432 => 'CopyrightYear', 436 => 'copyrightYear' },
	'coringfilter' => { 266 => 0x310, 267 => 0x102d, 270 => 0x310 },
	'coringvalues' => { 266 => 0x311, 270 => 0x311 },
	'corporateentity' => { 436 => 'corporateEntity' },
	'country' => { 145 => 'Country', 283 => 0x69, 434 => 'Country' },
	'country-primarylocationcode' => { 118 => 0x64 },
	'country-primarylocationname' => { 118 => 0x65 },
	'countrycode' => { 200 => 0x5, 329 => 'CountryCode', 431 => 'CountryCode' },
	'course' => { 438 => 'course' },
	'coverage' => { 423 => 'coverage' },
	'coverdate' => { 436 => 'coverDate' },
	'coverdisplaydate' => { 436 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 317 => 0x28 },
	'crc32' => { 424 => 'crc32' },
	'createdate' => { 110 => 0x9004, 141 => 'CreateDate', 271 => 'CreationDate', 275 => 'create-date', 333 => 'CreationDate', 335 => 0x1, 444 => 'CreateDate' },
	'creationdate' => { 433 => 'CreationDate', 436 => 'creationDate' },
	'creationtime' => { 275 => 'Creation Time' },
	'creativestyle' => { 360 => 0x1a, 361 => 0x18, 371 => 0x41, 372 => 0xb020, 400 => 0x4a },
	'creativestylesetting' => { 362 => 0xf, 376 => 0x7 },
	'creativestylewaschanged' => { 404 => 0x8001 },
	'creator' => { 271 => 'Creator', 333 => 'Creator', 423 => 'creator', 432 => 'Creator', 433 => 'Creator' },
	'creatoraddress' => { 431 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 162 => 'CreatorAppId' },
	'creatorcity' => { 431 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 431 => 'CreatorContactInfo' },
	'creatorcountry' => { 431 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 432 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 432 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 162 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 431 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 431 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 432 => [\'Creator','CreatorRole'] },
	'creatortool' => { 444 => 'CreatorTool' },
	'creatorworkemail' => { 431 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 431 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 431 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 118 => 0x6e, 434 => 'Credit' },
	'creditline' => { 439 => 'creditLine' },
	'creditlinereq' => { 449 => 'CreditLineReq' },
	'creditlinerequired' => { 272 => 'CreditLineRequired' },
	'cropactive' => { 92 => 0x0, 99 => 0x244 },
	'cropangle' => { 422 => 'CropAngle' },
	'cropaspectratio' => { 94 => 0x30101, 99 => 0x260 },
	'cropaspectratiocustom' => { 94 => 0x30102 },
	'cropbottom' => { 114 => 0x9, 234 => 0x36, 287 => 0x31, 328 => 0xdc, 422 => 'CropBottom' },
	'cropbottommargin' => { 47 => 0x3 },
	'cropcircleactive' => { 100 => 0xd6 },
	'cropcircleradius' => { 100 => 0xd9 },
	'cropcirclex' => { 100 => 0xd7 },
	'cropcircley' => { 100 => 0xd8 },
	'cropconstraintowarp' => { 422 => 'CropConstrainToWarp' },
	'croph' => { 415 => 'CropH' },
	'cropheight' => { 92 => 0x6, 99 => 0x24c, 266 => 0x615, 270 => 0x615, 422 => 'CropHeight' },
	'crophispeed' => { 201 => 0x1b },
	'cropleft' => { 99 => 0x246, 114 => 0x6, 234 => 0x1e, 266 => 0x612, 270 => 0x612, 287 => 0x30, 328 => 0xd9, 422 => 'CropLeft' },
	'cropleftmargin' => { 47 => 0x0 },
	'cropmode35mm' => { 342 => 0x1018 },
	'croporiginalheight' => { 92 => 0xb },
	'croporiginalwidth' => { 92 => 0xa },
	'cropoutputheight' => { 234 => 0xce },
	'cropoutputheightinches' => { 234 => 0x96 },
	'cropoutputpixels' => { 234 => 0xd6 },
	'cropoutputresolution' => { 234 => 0xb6 },
	'cropoutputscale' => { 234 => 0xbe },
	'cropoutputwidth' => { 234 => 0xc6 },
	'cropoutputwidthinches' => { 234 => 0x8e },
	'croppedareaimageheightpixels' => { 410 => 'CroppedAreaImageHeightPixels', 411 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 410 => 'CroppedAreaImageWidthPixels', 411 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 410 => 'CroppedAreaLeftPixels', 411 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 410 => 'CroppedAreaTopPixels', 411 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 342 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 342 => 0x1603 },
	'cropright' => { 114 => 0x8, 234 => 0x2e, 287 => 0x32, 328 => 0xdb, 422 => 'CropRight' },
	'croprightmargin' => { 47 => 0x1 },
	'croprotatedoriginalheight' => { 92 => 0x2 },
	'croprotatedoriginalwidth' => { 92 => 0x1 },
	'croprotation' => { 92 => 0x8, 114 => 0xb },
	'cropscaledresolution' => { 234 => 0x9e },
	'cropsourceresolution' => { 234 => 0xae },
	'croptop' => { 99 => 0x248, 114 => 0x7, 234 => 0x26, 266 => 0x613, 270 => 0x613, 287 => 0x2f, 328 => 0xda, 422 => 'CropTop' },
	'croptopmargin' => { 47 => 0x2 },
	'cropunit' => { 422 => 'CropUnit' },
	'cropunits' => { 422 => 'CropUnits' },
	'cropw' => { 415 => 'CropW' },
	'cropwidth' => { 92 => 0x5, 99 => 0x24a, 266 => 0x614, 270 => 0x614, 422 => 'CropWidth' },
	'cropx' => { 92 => 0x3, 415 => 'CropX' },
	'cropy' => { 92 => 0x4, 415 => 'CropY' },
	'crossprocess' => { 317 => 0x7b },
	'crossprocessparams' => { 317 => 0x235 },
	'cuisine' => { 438 => 'cuisine' },
	'currenticcprofile' => { 110 => 0xc691 },
	'currentpreprofilematrix' => { 110 => 0xc692 },
	'currentversion' => { 404 => 0xd000 },
	'curve0x' => { 415 => 'Curve0x' },
	'curve0y' => { 415 => 'Curve0y' },
	'curve1x' => { 415 => 'Curve1x' },
	'curve1y' => { 415 => 'Curve1y' },
	'curve2x' => { 415 => 'Curve2x' },
	'curve2y' => { 415 => 'Curve2y' },
	'curve3x' => { 415 => 'Curve3x' },
	'curve3y' => { 415 => 'Curve3y' },
	'curve4x' => { 415 => 'Curve4x' },
	'curve4y' => { 415 => 'Curve4y' },
	'curves' => { 239 => 0x76a43201 },
	'custom1' => { 272 => 'Custom1' },
	'custom10' => { 272 => 'Custom10' },
	'custom2' => { 272 => 'Custom2' },
	'custom3' => { 272 => 'Custom3' },
	'custom4' => { 272 => 'Custom4' },
	'custom5' => { 272 => 'Custom5' },
	'custom6' => { 272 => 'Custom6' },
	'custom7' => { 272 => 'Custom7' },
	'custom8' => { 272 => 'Custom8' },
	'custom9' => { 272 => 'Custom9' },
	'customcolortone' => { 100 => 0x4c },
	'customcontrast' => { 100 => 0x4e },
	'customcontrols' => { 75 => 0x70c },
	'customdefaultunsharpfineness' => { 100 => 0xbe },
	'customdefaultunsharpstrength' => { 100 => 0xbc },
	'customdefaultunsharpthreshold' => { 100 => 0xc0 },
	'customlinear' => { 100 => 0x4f },
	'customoutputhighlightpoint' => { 100 => 0x53 },
	'customoutputshadowpoint' => { 100 => 0x54 },
	'custompicturestyle' => { 94 => 0x10021 },
	'custompicturestyledata' => { 94 => 0xf0500 },
	'custompicturestylefilename' => { 57 => 0x4010 },
	'customrawhighlight' => { 100 => 0x7c },
	'customrawhighlightpoint' => { 100 => 0x51 },
	'customrawshadow' => { 100 => 0x85 },
	'customrawshadowpoint' => { 100 => 0x52 },
	'customrendered' => { 110 => 0xa401, 426 => 'CustomRendered' },
	'customsaturation' => { 100 => 0x4d, 262 => 0x503 },
	'customsettingsalldefault' => { 246 => '0.2', 255 => '0.2' },
	'customsettingsbank' => { 246 => '0.1', 247 => '0.1', 249 => '0.1', 250 => '0.1', 255 => '0.1', 259 => '0.2' },
	'customsharpness' => { 100 => 0x50 },
	'customunsharpmaskfineness' => { 100 => 0xb8 },
	'customunsharpmaskstrength' => { 100 => 0xb6 },
	'customunsharpmaskthreshold' => { 100 => 0xba },
	'customwb_rblevels' => { 376 => 0x1a },
	'customwb_rgblevels' => { 361 => 0x8, 362 => 0x19 },
	'customwbbluelevel' => { 167 => 0x36 },
	'customwberror' => { 167 => 0x37 },
	'customwbgreenlevel' => { 167 => 0x35 },
	'customwbredlevel' => { 167 => 0x34 },
	'customwbsetting' => { 167 => 0x26 },
	'd-lightinghq' => { 239 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 235 => 0x2 },
	'd-lightinghqhighlight' => { 235 => 0x1 },
	'd-lightinghqselected' => { 239 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 235 => 0x0 },
	'd-lightinghs' => { 239 => 0xce5554aa },
	'd-lightinghsadjustment' => { 236 => 0x0 },
	'd-lightinghscolorboost' => { 236 => 0x1 },
	'd-rangeoptimizerhighlight' => { 404 => 0x8024 },
	'd-rangeoptimizermode' => { 404 => 0x8022 },
	'd-rangeoptimizershadow' => { 404 => 0x802d },
	'd-rangeoptimizervalue' => { 404 => 0x8023 },
	'd810meteringmode' => { 227 => 0x175e },
	'datacompressionmethod' => { 120 => 0x6e },
	'dataimprint' => { 164 => 0x34 },
	'dataonscreen' => { 432 => 'DataOnScreen' },
	'dataonscreenregion' => { 432 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 432 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 432 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 432 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 432 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 432 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 432 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 432 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 317 => 0x3d },
	'date' => { 317 => 0x6, 423 => 'date' },
	'dateacquired' => { 162 => 'DateAcquired' },
	'datecreated' => { 118 => 0x37, 434 => 'DateCreated' },
	'datedisplayformat' => { 231 => 0x3 },
	'dateidentified' => { 109 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 251 => '4.2' },
	'daterecieved' => { 436 => 'dateRecieved' },
	'datesent' => { 119 => 0x46 },
	'datestampmode' => { 57 => 0x1c },
	'datetime' => { 416 => 'datetime', 442 => 'DateTime' },
	'datetimedigitized' => { 426 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 91 => 0x0, 110 => 0x9003, 138 => 0x14, 141 => 'OriginalDate', 338 => 0xb, 426 => 'DateTimeOriginal' },
	'datetimestamp' => { 126 => 0x64 },
	'datetimeutc' => { 262 => 0x908 },
	'daylightsavings' => { 70 => 0x3, 231 => 0x2 },
	'dccontinent' => { 109 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 109 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 109 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 109 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 109 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 109 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 109 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 109 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 109 => 'Event' },
	'dcfootprintspatialfit' => { 109 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 109 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 109 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 109 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 109 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 109 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 109 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 109 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 109 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 109 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 109 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 109 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 109 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 109 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 109 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 109 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 109 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 109 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 109 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 109 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 109 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 109 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 109 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 109 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 109 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 109 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 109 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 109 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 109 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 109 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 109 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 109 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 109 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 109 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 109 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 109 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 109 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 149 => 'Declination' },
	'decposition' => { 164 => 0x32 },
	'defaultautogray' => { 422 => 'DefaultAutoGray' },
	'defaultautotone' => { 422 => 'DefaultAutoTone' },
	'defaultblackrender' => { 110 => 0xc7a6 },
	'defaultcroporigin' => { 110 => 0xc61f },
	'defaultcropsize' => { 110 => 0xc620 },
	'defaulteraseoption' => { 75 => 0x813 },
	'defaultscale' => { 110 => 0xc61e },
	'defaultsspecifictoiso' => { 422 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 422 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 110 => 0xc7b5 },
	'defringe' => { 422 => 'Defringe' },
	'defringegreenamount' => { 422 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 422 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 422 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 422 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 422 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 422 => 'DefringePurpleHueLo' },
	'dehaze' => { 422 => 'Dehaze' },
	'deletedimagecount' => { 201 => 0xa6, 209 => 0x6e },
	'deprecatedon' => { 419 => 'deprecatedOn' },
	'derivedfrom' => { 447 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 447 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 447 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 447 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 447 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 447 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 447 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 447 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 447 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 447 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 447 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 447 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 447 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 447 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 447 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 447 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 447 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 447 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 447 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 447 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 447 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 447 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 447 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 447 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 275 => 'Description', 423 => 'description', 444 => 'Description' },
	'destination' => { 119 => 0x5 },
	'destinationcity' => { 317 => 0x24, 323 => 0x3 },
	'destinationcitycode' => { 324 => 0x1001 },
	'destinationdst' => { 317 => 0x26, 323 => '0.3' },
	'developmentdynamicrange' => { 115 => 0x1403 },
	'device' => { 436 => 'device' },
	'devicesettingdescription' => { 426 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 426 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 426 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 426 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 349 => 0x2 },
	'dialdirectiontvav' => { 75 => 0x706 },
	'dietaryneeds' => { 438 => 'dietaryNeeds' },
	'diffractioncorrection' => { 307 => 0x3 },
	'digitalcreationdate' => { 118 => 0x3e },
	'digitalcreationtime' => { 118 => 0x3f },
	'digitaldeehighlightadj' => { 208 => 0x202 },
	'digitaldeeshadowadj' => { 208 => 0x200 },
	'digitaldeethreshold' => { 208 => 0x201 },
	'digitalfilter' => { 352 => 0x59 },
	'digitalfilter01' => { 304 => 0x5 },
	'digitalfilter02' => { 304 => 0x16 },
	'digitalfilter03' => { 304 => 0x27 },
	'digitalfilter04' => { 304 => 0x38 },
	'digitalfilter05' => { 304 => 0x49 },
	'digitalfilter06' => { 304 => 0x5a },
	'digitalfilter07' => { 304 => 0x6b },
	'digitalfilter08' => { 304 => 0x7c },
	'digitalfilter09' => { 304 => 0x8d },
	'digitalfilter10' => { 304 => 0x9e },
	'digitalfilter11' => { 304 => 0xaf },
	'digitalfilter12' => { 304 => 0xc0 },
	'digitalfilter13' => { 304 => 0xd1 },
	'digitalfilter14' => { 304 => 0xe2 },
	'digitalfilter15' => { 304 => 0xf3 },
	'digitalfilter16' => { 304 => 0x104 },
	'digitalfilter17' => { 304 => 0x115 },
	'digitalfilter18' => { 304 => 0x126 },
	'digitalfilter19' => { 304 => 0x137 },
	'digitalfilter20' => { 304 => 0x148 },
	'digitalgain' => { 67 => 0xb },
	'digitalgem' => { 193 => 0x0 },
	'digitalice' => { 208 => 0x100 },
	'digitalimageguid' => { 432 => 'DigImageGUID' },
	'digitalroc' => { 206 => 0x0 },
	'digitalsourcefiletype' => { 432 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 432 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 103 => 0xa, 115 => 0x1044, 126 => 0x68, 140 => 'DigitalZoom', 164 => 0xc, 201 => 0x86, 229 => 0xa, 267 => 0x204, 317 => 0x1e, 324 => 0xa, 351 => 0x204, 391 => 0x12, 392 => 0x12 },
	'digitalzoomon' => { 351 => 0x21b },
	'digitalzoomratio' => { 110 => 0xa404, 381 => 0x200, 383 => 0x21c, 426 => 'DigitalZoomRatio' },
	'director' => { 446 => 'director' },
	'directorphotography' => { 446 => 'directorPhotography' },
	'directory' => { 111 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 188 => 0x3 },
	'disclaimer' => { 275 => 'Disclaimer' },
	'discnumber' => { 446 => 'discNumber' },
	'dishtype' => { 438 => 'dishType' },
	'displayallafpoints' => { 75 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 332 => 0x2 },
	'displayedunitsy' => { 332 => 0x6 },
	'displayname' => { 435 => 'displayName' },
	'distance1' => { 126 => 0x28 },
	'distance2' => { 126 => 0x2c },
	'distance3' => { 126 => 0x30 },
	'distance4' => { 126 => 0x34 },
	'distortion' => { 349 => 0xa050 },
	'distortioncontrol' => { 209 => 0x10 },
	'distortioncorrection' => { 94 => 0x20705, 100 => 0x67, 262 => 0x50b, 286 => '7.1', 307 => 0x0, 399 => 0x601, 400 => 0x5b },
	'distortioncorrection2' => { 266 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 418 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 94 => '0x20705.0', 100 => 0x63 },
	'distortioncorrectionsetting' => { 372 => 0x2013 },
	'distortioncorrparams' => { 110 => 0x7037, 380 => 0x1a23, 383 => 0x1870, 385 => 0x189c, 386 => 0x18cc, 387 => 0x17d0, 399 => 0x6ca, 400 => 0x64 },
	'distortioncorrparamsnumber' => { 383 => 0x1899, 385 => 0x18c5, 386 => 0x18f5, 387 => 0x17f9 },
	'distortioncorrparamspresent' => { 383 => 0x1898, 385 => 0x18c4, 386 => 0x18f4, 387 => 0x17f8, 389 => 0x10b, 390 => 0x10b, 399 => 0x600, 400 => 0x5a },
	'distortioneffect' => { 94 => 0x20709 },
	'distortionn' => { 286 => 0xc },
	'distortionparam02' => { 286 => 0x2 },
	'distortionparam04' => { 286 => 0x4 },
	'distortionparam08' => { 286 => 0x8 },
	'distortionparam09' => { 286 => 0x9 },
	'distortionparam11' => { 286 => 0xb },
	'distortionscale' => { 286 => 0x5 },
	'distributor' => { 436 => 'distributor' },
	'distributorproductid' => { 435 => 'distributorProductID' },
	'dloon' => { 94 => '0x20706.0', 100 => 0xdc },
	'dlosetting' => { 94 => 0x20706, 100 => 0xdd },
	'dlosettingapplied' => { 93 => 0x4 },
	'dloshootingdistance' => { 100 => 0xde },
	'dloversion' => { 93 => 0x5 },
	'dmcomment' => { 446 => 'comment' },
	'dngadobedata' => { 110 => 0xc634 },
	'dngbackwardversion' => { 110 => 0xc613 },
	'dngignoresidecars' => { 422 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 110 => 0xc630 },
	'dngprivatedata' => { 110 => 0xc634 },
	'dngversion' => { 110 => 0xc612 },
	'document' => { 275 => 'Document' },
	'documentancestors' => { 434 => 'DocumentAncestors' },
	'documenthistory' => { 118 => 0xe7 },
	'documentid' => { 447 => 'DocumentID' },
	'documentname' => { 110 => 0x10d },
	'documentnotes' => { 118 => 0xe6 },
	'doi' => { 436 => 'doi' },
	'dopesheet' => { 432 => 'Dopesheet' },
	'dopesheetlink' => { 432 => 'DopesheetLink' },
	'dopesheetlinklink' => { 432 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 432 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'dpp' => { 416 => 'dpp' },
	'dr4cameramodel' => { 95 => 0x3 },
	'drivemode' => { 104 => 0x3103, 164 => 0x6, 167 => 0x1e, 170 => 0xe, 262 => 0x600, 317 => 0x34, 342 => 0x1002, 352 => 0x3, 360 => 0x4, 361 => 0x7e, 362 => 0x34 },
	'drivemode2' => { 167 => 0xa, 298 => 0x7, 371 => 0xe, 376 => 0x1 },
	'drivemodesetting' => { 362 => 0x4 },
	'dspfirmwareversion' => { 317 => 0x27 },
	'duration' => { 60 => 0x6a, 139 => 'Duration', 153 => 'Duration', 438 => 'duration', 446 => 'duration' },
	'durationscale' => { 446 => [\'duration','durationScale'] },
	'durationvalue' => { 446 => [\'duration','durationValue'] },
	'dustremovaldata' => { 57 => 0x97 },
	'dynamicafarea' => { 246 => '1.4', 255 => '1.4' },
	'dynamicareaafdisplay' => { 247 => '46.1', 249 => '47.1', 250 => '47.1', 259 => '47.1' },
	'dynamicrange' => { 115 => 0x1400 },
	'dynamicrangeexpansion' => { 317 => 0x69, 342 => 0x100e },
	'dynamicrangemax' => { 99 => 0x7c },
	'dynamicrangemin' => { 99 => 0x7a },
	'dynamicrangeoptimizer' => { 167 => 0x15, 372 => [0xb025,0xb04f], 379 => 0x1144, 380 => [0x1144,0x324], 381 => [0x1120,0x300], 382 => [0x119c,0x37c], 383 => [0x1178,0x328], 384 => [0x1030,0x50], 385 => [0x228,0x50], 386 => [0x228,0x50], 387 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 371 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 360 => 0x19, 361 => 0x17, 362 => 0xd, 371 => 0x79, 376 => 0x5 },
	'dynamicrangeoptimizermode' => { 170 => 0x15, 360 => 0x18, 361 => 0x16, 371 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 167 => 0x27, 362 => 0xc, 376 => 0x4 },
	'dynamicrangesetting' => { 115 => 0x1402 },
	'e-dialinprogram' => { 298 => '1.3' },
	'earliestageorloweststage' => { 109 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 109 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 109 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 109 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 109 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 260 => '6.1' },
	'easyexposurecompensation' => { 246 => '6.4', 247 => '6.5', 249 => '6.3', 250 => '6.3', 254 => '5.1', 255 => '4.4', 256 => '5.2', 259 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgenoisereduction' => { 240 => 0x4, 404 => 0x8028 },
	'edition' => { 436 => 'edition' },
	'editorialupdate' => { 118 => 0x8 },
	'editstatus' => { 118 => 0x7, 329 => 'EditStatus', 416 => 'EditStatus' },
	'editversionname' => { 239 => 0x3d136244 },
	'effectivelv' => { 317 => 0x2d },
	'effectivemaxaperture' => { 197 => 0x12, 198 => 0x13 },
	'eissn' => { 436 => 'eIssn' },
	'electronicfront-curtainshutter' => { 249 => '5.2', 250 => '5.2', 259 => '5.3' },
	'electronicfrontcurtainshutter' => { 372 => 0x201a },
	'elevation' => { 149 => 'Elevation' },
	'email' => { 141 => 'EMail' },
	'embargodate' => { 439 => 'embargoDate' },
	'embdencrightsexpr' => { 432 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 432 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 432 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 432 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 434 => 'EmbeddedXMPDigest' },
	'emissivity' => { 112 => 0x3 },
	'encryptionkey' => { 349 => 0xa020 },
	'endingpage' => { 436 => 'endingPage' },
	'enduser' => { 272 => 'EndUser' },
	'enduserid' => { 272 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 272 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 446 => 'engineer' },
	'enhancedarktones' => { 232 => 0x8 },
	'enhancement' => { 103 => 0x16, 104 => 0x3016 },
	'enhancer' => { 266 => 0x300 },
	'enhancervalues' => { 266 => 0x301 },
	'envelopenumber' => { 119 => 0x28 },
	'envelopepriority' => { 119 => 0x3c },
	'enveloperecordversion' => { 119 => 0x0 },
	'episode' => { 432 => 'Episode' },
	'episodeidentifier' => { 432 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 432 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 432 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 267 => 0x20c },
	'epsonimagewidth' => { 267 => 0x20b },
	'epsonsoftware' => { 267 => 0x20d },
	'equipmentinstitution' => { 406 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 406 => 'EquipmentManufacturer' },
	'equipmentversion' => { 263 => 0x0 },
	'ettlii' => { 75 => 0x304, 76 => 0xd, 77 => 0xe, 78 => 0x7, 79 => 0x7, 80 => 0xe },
	'event' => { 407 => 'Event', 414 => 'Event', 432 => 'Event', 436 => 'event' },
	'eventalias' => { 435 => 'eventAlias' },
	'eventday' => { 109 => [\'Event','EventDay'] },
	'eventearliestdate' => { 109 => [\'Event','EventEarliestDate'] },
	'eventend' => { 435 => 'eventEnd' },
	'eventenddayofyear' => { 109 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 109 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 109 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 109 => [\'Event','EventHabitat'] },
	'eventid' => { 109 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 109 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 109 => [\'Event','EventMonth'] },
	'eventnumber' => { 338 => 0x9 },
	'eventremarks' => { 109 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 109 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 109 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 435 => 'eventStart' },
	'eventstartdayofyear' => { 109 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 435 => 'eventSubtype' },
	'eventtime' => { 109 => [\'Event','EventEventTime'] },
	'eventtype' => { 435 => 'eventType' },
	'eventverbatimeventdate' => { 109 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 109 => [\'Event','EventYear'] },
	'evsteps' => { 298 => '1.2', 300 => 0x0 },
	'evstepsize' => { 251 => '5.1', 252 => '6.1', 253 => '6.1', 257 => '0.7' },
	'exclusivecoverage' => { 412 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 439 => 'exclusivityEndDate' },
	'excursiontolerance' => { 120 => 0x82 },
	'exif' => { 111 => 'EXIF' },
	'exifbyteorder' => { 111 => 'ExifByteOrder' },
	'exifcamerainfo' => { 118 => 0xe8 },
	'exifimageheight' => { 110 => 0xa003, 426 => 'PixelYDimension' },
	'exifimagewidth' => { 110 => 0xa002, 426 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 111 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 110 => 0x9000, 426 => 'ExifVersion' },
	'exitpupilposition' => { 197 => 0x4, 198 => 0x4 },
	'expirationdate' => { 118 => 0x25, 439 => 'expirationDate' },
	'expirationtime' => { 118 => 0x26 },
	'exposure' => { 110 => 0xfe51, 422 => 'Exposure' },
	'exposure2012' => { 422 => 'Exposure2012' },
	'exposureadj' => { 237 => 0x0 },
	'exposureadj2' => { 237 => 0x12 },
	'exposureadjust' => { 352 => 0xc },
	'exposurebracketingindicatorlast' => { 167 => 0x52 },
	'exposurebracketshotnumber' => { 170 => 0x2d, 371 => 0x2f },
	'exposurebracketstepsize' => { 298 => 0x8 },
	'exposurebracketvalue' => { 201 => 0x19 },
	'exposurecompensation' => { 69 => 0x6, 84 => 0x0, 110 => 0x9204, 126 => 0x24, 140 => 'ExposureComp', 160 => 'ExposureCompensation', 164 => 0xd, 165 => 0x53, 166 => 0x1e, 170 => 0x49c0, 267 => 0x1006, 317 => 0x16, 326 => 0x402, 349 => 0xa013, 352 => [0xc,0x35,0x4d], 379 => 0x114c, 380 => 0x114c, 381 => 0x1128, 383 => 0x1180, 384 => 0x1038, 385 => 0x230, 386 => 0x230, 387 => 0x223, 426 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 376 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 167 => 0x47, 170 => 0x2a },
	'exposurecompensationset' => { 360 => 0x3, 361 => 0x3, 362 => 0x3, 376 => 0x1e },
	'exposurecompensationsetting' => { 167 => 0x1 },
	'exposurecompstepsize' => { 246 => '6.3', 247 => '7.3', 249 => '7.3', 250 => '7.3', 255 => '4.3', 259 => '7.3' },
	'exposurecontrolstep' => { 254 => '6.1', 256 => '6.1' },
	'exposurecontrolstepsize' => { 246 => '6.2', 247 => '7.1', 249 => '7.1', 250 => '7.1', 255 => '4.2', 259 => '7.1', 260 => '7.1' },
	'exposurecount' => { 115 => 0x1032 },
	'exposuredelaymode' => { 246 => '10.1', 247 => '11.1', 249 => '11.1', 250 => '11.1', 251 => '9.1', 252 => '10.1', 253 => '10.1', 255 => '10.4', 256 => '10.1', 257 => '6.4', 259 => '11.1', 260 => '11.2' },
	'exposuredifference' => { 201 => 0xe },
	'exposureindex' => { 110 => 0xa215, 426 => 'ExposureIndex' },
	'exposureindicator' => { 167 => 0x50 },
	'exposurelevelincrements' => { 73 => 0x6, 74 => 0x6, 75 => 0x101, 76 => 0x5, 77 => 0x6, 78 => 0x5, 79 => 0x5, 80 => 0x6, 81 => 0x4, 360 => 0x58, 361 => 0x58 },
	'exposurelockused' => { 410 => 'ExposureLockUsed' },
	'exposuremode' => { 110 => 0xa402, 140 => 'ExposureMode', 164 => 0x1, 165 => 0xa, 166 => 0x0, 167 => 0x0, 170 => 0x34, 262 => 0x200, 281 => 0x40d, 352 => 0x8, 372 => 0xb041, 426 => 'ExposureMode' },
	'exposuremodeinmanual' => { 75 => 0x10b },
	'exposureprogram' => { 110 => 0x8822, 342 => 0x1001, 353 => [0x17e,0x43], 360 => 0x3c, 361 => 0x3c, 362 => 0x5, 366 => 0x14, 371 => 0x3f, 376 => 0x2, 379 => 0x1175, 380 => 0x1179, 381 => 0x1155, 382 => 0x11d1, 383 => 0x11ad, 384 => 0x1065, 385 => 0x25d, 386 => 0x25d, 387 => 0x24c, 396 => 0xb, 397 => 0xc, 398 => 0xb, 400 => 0x48, 426 => 'ExposureProgram' },
	'exposureshift' => { 262 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 69 => 0x16, 110 => 0x829a, 123 => 0xfd05, 126 => 0x20, 128 => 0xfa24, 130 => 0xf104, 133 => 0x12, 135 => 0x38, 138 => 0x10, 140 => 'ExposureTime', 164 => 0x9, 165 => 0x35, 166 => 0x48, 167 => 0x8, 170 => 0x49b8, 317 => 0x12, 349 => 0xa018, 352 => [0x32,0x4a], 360 => 0x0, 361 => 0x0, 376 => [0x21,0x23,0x27], 400 => 0x10, 426 => 'ExposureTime' },
	'exposuretime2' => { 352 => [0x33,0x4b] },
	'exposuretuning' => { 201 => 0x1c },
	'exposurevalue' => { 124 => 0x3 },
	'exposurewarning' => { 115 => 0x1302 },
	'exrauto' => { 115 => 0x1033 },
	'exrmode' => { 115 => 0x1034 },
	'extendedwbdetect' => { 262 => 0x902 },
	'extender' => { 263 => 0x301 },
	'extenderfirmwareversion' => { 263 => 0x304 },
	'extendermagnification' => { 142 => 'Magnification' },
	'extendermake' => { 142 => 'Make' },
	'extendermodel' => { 142 => 'Model', 263 => 0x303 },
	'extenderserialnumber' => { 142 => 'SerialNumber', 263 => 0x302 },
	'extenderstatus' => { 315 => 0x3 },
	'externalflash' => { 265 => 0x1201 },
	'externalflashae1' => { 267 => 0x101f },
	'externalflashae1_0' => { 267 => 0x101b },
	'externalflashae2' => { 267 => 0x1020 },
	'externalflashae2_0' => { 267 => 0x101c },
	'externalflashbounce' => { 265 => 0x1204, 267 => 0x1026, 305 => 0x1a },
	'externalflashcompensation' => { 191 => 0x1b },
	'externalflashexposurecomp' => { 201 => 0x17, 305 => 0x19 },
	'externalflashfirmware' => { 189 => 0x6, 190 => 0x6, 191 => 0x6, 192 => 0x6 },
	'externalflashflags' => { 189 => 0x8, 190 => 0x8, 191 => 0x8 },
	'externalflashguidenumber' => { 265 => 0x1203, 305 => '24.1' },
	'externalflashgvalue' => { 267 => 0x1025 },
	'externalflashmode' => { 267 => 0x1028, 305 => 0x2 },
	'externalflashreadystate' => { 192 => '9.1' },
	'externalflashstatus' => { 192 => '8.2' },
	'externalflashzoom' => { 265 => 0x1205, 267 => 0x1027 },
	'externalflashzoomoverride' => { 192 => '8.1' },
	'externalmetadatalink' => { 432 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 279 => 0x311, 285 => 0x3408 },
	'extrainfoversion' => { 364 => 0x1a },
	'eyestartaf' => { 167 => 0x40 },
	'face10position' => { 101 => 0x3f4, 102 => 0x1ec, 187 => 0x28, 302 => 0x12 },
	'face10size' => { 303 => 0x12 },
	'face11position' => { 187 => 0x2c, 302 => 0x14 },
	'face11size' => { 303 => 0x14 },
	'face12position' => { 187 => 0x30, 302 => 0x16 },
	'face12size' => { 303 => 0x16 },
	'face13position' => { 302 => 0x18 },
	'face13size' => { 303 => 0x18 },
	'face14position' => { 302 => 0x1a },
	'face14size' => { 303 => 0x1a },
	'face15position' => { 302 => 0x1c },
	'face15size' => { 303 => 0x1c },
	'face16position' => { 302 => 0x1e },
	'face16size' => { 303 => 0x1e },
	'face17position' => { 302 => 0x20 },
	'face17size' => { 303 => 0x20 },
	'face18position' => { 302 => 0x22 },
	'face18size' => { 303 => 0x22 },
	'face19position' => { 302 => 0x24 },
	'face19size' => { 303 => 0x24 },
	'face1position' => { 48 => 0x8, 101 => 0xd, 102 => 0x18, 187 => 0x4, 277 => 0x1, 302 => 0x0, 339 => 0xbc, 367 => 0x1, 368 => 0x0, 369 => 0x0, 370 => 0x5b },
	'face1size' => { 303 => 0x0 },
	'face20position' => { 302 => 0x26 },
	'face20size' => { 303 => 0x26 },
	'face21position' => { 302 => 0x28 },
	'face21size' => { 303 => 0x28 },
	'face22position' => { 302 => 0x2a },
	'face22size' => { 303 => 0x2a },
	'face23position' => { 302 => 0x2c },
	'face23size' => { 303 => 0x2c },
	'face24position' => { 302 => 0x2e },
	'face24size' => { 303 => 0x2e },
	'face25position' => { 302 => 0x30 },
	'face25size' => { 303 => 0x30 },
	'face26position' => { 302 => 0x32 },
	'face26size' => { 303 => 0x32 },
	'face27position' => { 302 => 0x34 },
	'face27size' => { 303 => 0x34 },
	'face28position' => { 302 => 0x36 },
	'face28size' => { 303 => 0x36 },
	'face29position' => { 302 => 0x38 },
	'face29size' => { 303 => 0x38 },
	'face2position' => { 48 => 0xa, 101 => 0x7c, 102 => 0x4c, 187 => 0x8, 277 => 0x5, 302 => 0x2, 339 => 0xc8, 367 => 0x6, 368 => 0x20, 369 => 0x25, 370 => 0x65 },
	'face2size' => { 303 => 0x2 },
	'face30position' => { 302 => 0x3a },
	'face30size' => { 303 => 0x3a },
	'face31position' => { 302 => 0x3c },
	'face31size' => { 303 => 0x3c },
	'face32position' => { 302 => 0x3e },
	'face32size' => { 303 => 0x3e },
	'face3position' => { 48 => 0xc, 101 => 0xeb, 102 => 0x80, 187 => 0xc, 277 => 0x9, 302 => 0x4, 339 => 0xd4, 367 => 0xb, 368 => 0x40, 369 => 0x4a, 370 => 0x6f },
	'face3size' => { 303 => 0x4 },
	'face4position' => { 48 => 0xe, 101 => 0x15a, 102 => 0xb4, 187 => 0x10, 277 => 0xd, 302 => 0x6, 339 => 0xe0, 367 => 0x10, 368 => 0x60, 369 => 0x6f, 370 => 0x79 },
	'face4size' => { 303 => 0x6 },
	'face5position' => { 48 => 0x10, 101 => 0x1c9, 102 => 0xe8, 187 => 0x14, 277 => 0x11, 302 => 0x8, 339 => 0xec, 367 => 0x15, 368 => 0x80, 369 => 0x94 },
	'face5size' => { 303 => 0x8 },
	'face6position' => { 48 => 0x12, 101 => 0x238, 102 => 0x11c, 187 => 0x18, 302 => 0xa, 339 => 0xf8, 367 => 0x1a, 368 => 0xa0, 369 => 0xb9 },
	'face6size' => { 303 => 0xa },
	'face7position' => { 48 => 0x14, 101 => 0x2a7, 102 => 0x150, 187 => 0x1c, 302 => 0xc, 339 => 0x104, 367 => 0x1f, 368 => 0xc0, 369 => 0xde },
	'face7size' => { 303 => 0xc },
	'face8position' => { 48 => 0x16, 101 => 0x316, 102 => 0x184, 187 => 0x20, 302 => 0xe, 339 => 0x110, 367 => 0x24, 368 => 0xe0, 369 => 0x103 },
	'face8size' => { 303 => 0xe },
	'face9position' => { 48 => 0x18, 101 => 0x385, 102 => 0x1b8, 187 => 0x24, 302 => 0x10 },
	'face9size' => { 303 => 0x10 },
	'facebalanceorigi' => { 415 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 415 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 415 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 415 => 'FaceBalanceWarmth' },
	'facedetect' => { 317 => 0x76, 349 => 0x100 },
	'facedetectarea' => { 266 => 0x1201 },
	'facedetectframecrop' => { 266 => 0x1207 },
	'facedetectframesize' => { 48 => 0x3, 101 => 0x1, 102 => 0x4, 187 => 0x1, 266 => 0x1203, 317 => 0x77, 339 => 0xb6 },
	'facedetection' => { 362 => 0x30, 376 => 0x19 },
	'faceelementpositions' => { 115 => 0x4203 },
	'faceelementtypes' => { 115 => 0x4201 },
	'faceid' => { 417 => 'FaceID' },
	'faceinfounknown' => { 104 => 0x2089 },
	'facename' => { 349 => 0x123 },
	'faceorientation' => { 102 => 0x8 },
	'faceposition' => { 301 => 0x2, 350 => 0x4 },
	'facepositions' => { 115 => 0x4103 },
	'facerecognition' => { 349 => 0x120 },
	'facesdetected' => { 48 => 0x2, 49 => 0x2, 50 => 0x3, 101 => 0x0, 102 => 0x2, 104 => 0x211c, 115 => 0x4100, 187 => 0x3, 266 => 0x1200, 283 => 0x3f, 301 => 0x0, 339 => 0xb5, 350 => 0x0, 367 => 0x0, 370 => 0x3, 378 => 0x30 },
	'facesrecognized' => { 278 => 0x0 },
	'facewidth' => { 49 => 0x1 },
	'faithfuloutputhighlightpoint' => { 100 => 0x38 },
	'faithfuloutputshadowpoint' => { 100 => 0x39 },
	'faithfulrawcolortone' => { 100 => 0x31 },
	'faithfulrawcontrast' => { 100 => 0x33 },
	'faithfulrawhighlight' => { 100 => 0x79 },
	'faithfulrawhighlightpoint' => { 100 => 0x36 },
	'faithfulrawlinear' => { 100 => 0x34 },
	'faithfulrawsaturation' => { 100 => 0x32 },
	'faithfulrawshadow' => { 100 => 0x82 },
	'faithfulrawshadowpoint' => { 100 => 0x37 },
	'faithfulrawsharpness' => { 100 => 0x35 },
	'faithfulunsharpmaskfineness' => { 100 => 0xac },
	'faithfulunsharpmaskstrength' => { 100 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 100 => 0xae },
	'feedidentifier' => { 432 => 'FeedIdentifier' },
	'femicroadjustment' => { 75 => 0x111 },
	'ffid' => { 424 => 'ffid' },
	'field' => { 435 => 'field' },
	'fieldcount' => { 267 => 0x103f },
	'filecreatedate' => { 111 => 'FileCreateDate' },
	'filedatarate' => { 446 => 'fileDataRate' },
	'fileformat' => { 86 => 0x0, 119 => 0x14, 352 => [0x22,0x26], 372 => 0xb000 },
	'filegroupid' => { 111 => 'FileGroupID' },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 284 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 111 => 'FileModifyDate' },
	'filename' => { 111 => 'FileName' },
	'filenameasdelivered' => { 272 => 'FileNameAsDelivered' },
	'filenumber' => { 51 => 0x1, 57 => 0x8, 88 => 0x1817, 105 => 'FileNumber', 188 => 0x4 },
	'filenumbermemory' => { 164 => 0x1a },
	'filenumbersequence' => { 246 => '12.2', 251 => '3.1', 252 => '4.1', 253 => '4.1', 255 => '11.1', 256 => '4.3', 260 => '5.2' },
	'filepermissions' => { 111 => 'FilePermissions' },
	'filesource' => { 110 => 0xa300, 115 => 0x8000, 426 => 'FileSource' },
	'fileuserid' => { 111 => 'FileUserID' },
	'fileversion' => { 119 => 0x16 },
	'fillflashautoreduction' => { 73 => 0xe, 74 => 0xe, 81 => 0xa },
	'filllight' => { 422 => 'FillLight' },
	'fillorder' => { 110 => 0x10a },
	'filmgraineffect' => { 262 => 0x538 },
	'filmmode' => { 115 => 0x1401, 281 => 0x412, 283 => 0x42 },
	'filmtype' => { 208 => 0x2 },
	'filtereffect' => { 51 => 0xe, 203 => 0x37, 204 => 0x3f },
	'filtereffectauto' => { 64 => 0xa0 },
	'filtereffectfaithful' => { 63 => 0x70, 64 => 0x70 },
	'filtereffectlandscape' => { 63 => 0x40, 64 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 63 => 0x88, 64 => 0x88 },
	'filtereffectneutral' => { 63 => 0x58, 64 => 0x58 },
	'filtereffectportrait' => { 63 => 0x28, 64 => 0x28 },
	'filtereffectstandard' => { 63 => 0x10, 64 => 0x10 },
	'filtereffectuserdef1' => { 63 => 0xa0, 64 => 0xb8 },
	'filtereffectuserdef2' => { 63 => 0xb8, 64 => 0xd0 },
	'filtereffectuserdef3' => { 63 => 0xd0, 64 => 0xe8 },
	'finderdisplayduringexposure' => { 74 => 0x1 },
	'finesharpness' => { 317 => 0x70 },
	'finetuneoptcenterweighted' => { 246 => '7.2', 247 => '9.1', 249 => '9.1', 250 => '9.1', 254 => '8.1', 259 => '9.1', 260 => '9.1' },
	'finetuneopthighlightweighted' => { 249 => '46.1', 250 => '46.1', 259 => '46.1' },
	'finetuneoptmatrixmetering' => { 246 => '8.1', 247 => '8.2', 249 => '8.2', 250 => '8.2', 254 => '7.2', 255 => '6.1', 259 => '8.2', 260 => '8.2' },
	'finetuneoptspotmetering' => { 246 => '8.2', 247 => '9.2', 249 => '9.2', 250 => '9.2', 254 => '8.2', 255 => '6.2', 259 => '9.2', 260 => '9.2' },
	'firmware' => { 267 => 0x405, 352 => [0x17,0x3b,0x57], 418 => 'Firmware' },
	'firmwaredate' => { 103 => 0x15, 104 => 0x2001, 338 => 0x4 },
	'firmwareid' => { 171 => 0x0 },
	'firmwarename' => { 349 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 57 => 0x1e, 340 => 0x0 },
	'firmwarerevision2' => { 340 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 124 => 0xce5, 138 => 0x57, 140 => 'FirmwareVersion', 283 => 0x2, 285 => 0x3109, 317 => 0x230, 342 => 0x2 },
	'firmwareversions' => { 326 => 0x301 },
	'firstphotodate' => { 410 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 272 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 118 => 0x16, 416 => 'FixtureIdentifier' },
	'flash' => { 105 => 'Flash', 110 => 0x9209, 165 => 0x1f, 166 => 0x15, 426 => 'Flash' },
	'flashaction' => { 360 => 0x3e, 361 => 0x3e, 372 => 0x2017, 376 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 360 => 0x4c, 361 => 0x4c, 376 => 0x77 },
	'flashactionexternal' => { 376 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 39 => 0x249 },
	'flashbias' => { 283 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 75 => 0x70e },
	'flashchargelevel' => { 267 => 0x1010 },
	'flashcolorfilter' => { 191 => 0x10 },
	'flashcommandermode' => { 189 => '9.1', 190 => '9.1', 191 => '9.1' },
	'flashcompensation' => { 189 => 0xa, 190 => 0xa, 191 => 0xa, 192 => 0xa, 418 => 'FlashCompensation' },
	'flashcontrol' => { 360 => 0x23, 361 => 0x1f, 362 => 0x21 },
	'flashcontrolbuilt-in' => { 255 => '16.1', 256 => '23.1', 258 => '23.1', 259 => '24.1' },
	'flashcontrolmode' => { 189 => '9.2', 190 => '9.2', 191 => '9.2', 262 => 0x404 },
	'flashcurtain' => { 283 => 0x48 },
	'flashdefault' => { 167 => 0x42 },
	'flashdevice' => { 267 => 0x1005 },
	'flashdistance' => { 104 => 0x2034 },
	'flashenergy' => { 110 => 0xa20b, 426 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 201 => 0x18 },
	'flashexposurecomp' => { 69 => 0xf, 115 => 0x1011, 143 => 'ExposureComp', 164 => 0x23, 169 => 0x104, 170 => 0x49c1, 201 => 0x12, 262 => 0x401, 267 => 0x1023, 317 => 0x4d, 342 => 0x100b, 352 => [0x3a,0x56], 372 => 0x104 },
	'flashexposurecomp2' => { 226 => 0x4d2 },
	'flashexposurecomp3' => { 191 => 0x1d },
	'flashexposurecomp4' => { 191 => 0x27 },
	'flashexposurecomparea' => { 247 => '38.4', 249 => '38.4', 250 => '38.4', 259 => '38.4' },
	'flashexposurecompset' => { 167 => 0x10, 290 => 0xe, 360 => 0x14, 361 => 0x12, 362 => 0x23, 376 => 0x1f },
	'flashexposurecompset2' => { 376 => [0x26,0x2c] },
	'flashexposureindicator' => { 167 => 0x54 },
	'flashexposureindicatorlast' => { 167 => 0x56 },
	'flashexposureindicatornext' => { 167 => 0x55 },
	'flashexposurelock' => { 51 => 0x19 },
	'flashfired' => { 126 => 0x5d, 143 => 'Fired', 164 => 0x14, 225 => '590.3', 283 => 0x8007, 426 => [\'Flash','FlashFired'] },
	'flashfiring' => { 75 => 0x306, 76 => 0x6, 77 => 0x7, 80 => 0x7 },
	'flashfirmwareversion' => { 263 => 0x1002 },
	'flashfocallength' => { 189 => 0xb, 190 => 0xc, 191 => 0xc, 192 => 0xc },
	'flashfunction' => { 170 => 0x31, 426 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 189 => 0xe, 190 => 0xf, 191 => 0xf, 192 => 0xf },
	'flashgroupacompensation' => { 189 => 0x11, 190 => 0x12, 191 => 0x13 },
	'flashgroupacontrolmode' => { 189 => 0xf, 190 => '16.1', 191 => '17.1' },
	'flashgroupaoutput' => { 189 => 0x11, 190 => 0x12, 191 => 0x13 },
	'flashgroupbcompensation' => { 189 => 0x12, 190 => 0x13, 191 => 0x14 },
	'flashgroupbcontrolmode' => { 189 => 0x10, 190 => '17.1', 191 => '18.1' },
	'flashgroupboutput' => { 189 => 0x12, 190 => 0x13, 191 => 0x14 },
	'flashgroupccompensation' => { 190 => 0x14, 191 => 0x15 },
	'flashgroupccontrolmode' => { 190 => '17.2', 191 => '18.2' },
	'flashgroupcoutput' => { 190 => 0x14, 191 => 0x15 },
	'flashguidenumber' => { 69 => 0xd, 85 => 0x0, 143 => 'GuideNumber' },
	'flashintensity' => { 103 => [0x19,0x5], 262 => 0x405 },
	'flashlevel' => { 248 => 0x9, 372 => 0xb048 },
	'flashmake' => { 143 => 'Make' },
	'flashmanufacturer' => { 162 => 'FlashManufacturer' },
	'flashmetering' => { 164 => 0x3f, 167 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 317 => 0x20a },
	'flashmode' => { 103 => 0x4, 126 => 0x5c, 143 => 'Mode', 164 => 0x2, 165 => 0x20, 166 => 0x16, 167 => 0xf, 201 => 0x87, 262 => 0x400, 267 => 0x1004, 317 => 0xc, 324 => 0x4, 341 => 0x20, 342 => 0x100a, 351 => 0x225, 360 => 0x13, 361 => 0x7f, 362 => 0x20, 376 => 0x10, 379 => 0x1138, 380 => 0x1138, 381 => 0x1114, 382 => 0x1190, 383 => 0x116c, 384 => 0x1024, 385 => 0x21c, 386 => 0x21c, 426 => [\'Flash','FlashMode'] },
	'flashmodel' => { 143 => 'Model', 162 => 'FlashModel', 263 => 0x1001 },
	'flashoptions' => { 298 => 0x2 },
	'flashoptions2' => { 298 => 0x10 },
	'flashoutput' => { 39 => 0x248, 69 => 0x21, 189 => 0xa, 190 => 0xa, 191 => 0xa },
	'flashpixversion' => { 110 => 0xa000, 426 => 'FlashpixVersion' },
	'flashredeyemode' => { 426 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 262 => 0x403 },
	'flashreturn' => { 426 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 143 => 'SerialNumber', 263 => 0x1003 },
	'flashsetting' => { 201 => 0x8 },
	'flashshutterspeed' => { 246 => '20.2', 247 => '23.2', 249 => '23.2', 250 => '23.2', 255 => '15.2', 256 => '22.2', 257 => '7.2', 258 => '22.2', 259 => '23.2', 260 => '23.1' },
	'flashsource' => { 189 => 0x4, 190 => 0x4, 191 => 0x4, 192 => 0x4 },
	'flashstatus' => { 305 => 0x0, 376 => [0x82,0x86], 389 => 0x31, 390 => 0x39 },
	'flashstatusbuilt-in' => { 362 => [0x87,0x287] },
	'flashstatusexternal' => { 362 => [0x88,0x288] },
	'flashsyncspeed' => { 246 => '20.1', 247 => '23.1', 249 => '23.1', 250 => '23.1', 255 => '15.1', 256 => '22.1', 258 => '22.1', 259 => '23.1' },
	'flashsyncspeedav' => { 73 => 0x3, 75 => 0x10f, 76 => 0x2, 77 => 0x3, 78 => 0x2, 79 => 0x2, 80 => 0x3, 81 => 0x6 },
	'flashthreshold' => { 85 => 0x1 },
	'flashtype' => { 143 => 'Type', 167 => 0x59, 201 => 0x9, 263 => 0x1000 },
	'flashwarning' => { 256 => '30.1', 257 => '7.1', 260 => '31.1', 283 => 0x62 },
	'flexiblespotposition' => { 372 => 0x201d },
	'flickerreduce' => { 351 => 0x218 },
	'flickerreduction' => { 219 => 0xe84 },
	'flickerreductionindicator' => { 219 => 0x5e2 },
	'flightpitchdegree' => { 107 => 'FlightPitchDegree' },
	'flightrolldegree' => { 107 => 'FlightRollDegree' },
	'flightyawdegree' => { 107 => 'FlightYawDegree' },
	'fliphorizontal' => { 239 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 69 => 0x15, 110 => 0x829d, 123 => 0xfd04, 126 => 0x1e, 128 => 0xfa23, 130 => 0xf103, 133 => 0x13, 135 => 0x3c, 138 => 0xc, 147 => 'FNumber', 164 => 0xa, 165 => 0x36, 166 => 0x47, 167 => 0x9, 170 => 0x49c7, 317 => 0x13, 349 => 0xa019, 352 => [0x31,0x49], 360 => 0x1, 361 => 0x1, 376 => [0x20,0x22,0x26], 426 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 53 => 0x1, 104 => 0x1d, 110 => 0x920a, 133 => 0x1d, 147 => 'FocalLength', 164 => 0x12, 197 => 0xa, 198 => 0xb, 317 => 0x1d, 326 => 0x403, 342 => 0x1500, 359 => 0xe, 383 => 0x1278, 384 => 0x1134, 385 => 0x32c, 386 => 0x32c, 387 => 0x30a, 426 => 'FocalLength' },
	'focallength2' => { 376 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 110 => 0xa405, 349 => 0xa01a, 426 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 359 => 0x10 },
	'focalplaneafpointarea' => { 388 => 0x2 },
	'focalplaneafpointlocation1' => { 388 => 0x6 },
	'focalplaneafpointlocation10' => { 388 => 0x2a },
	'focalplaneafpointlocation11' => { 388 => 0x2e },
	'focalplaneafpointlocation12' => { 388 => 0x32 },
	'focalplaneafpointlocation13' => { 388 => 0x36 },
	'focalplaneafpointlocation14' => { 388 => 0x3a },
	'focalplaneafpointlocation15' => { 388 => 0x3e },
	'focalplaneafpointlocation2' => { 388 => 0xa },
	'focalplaneafpointlocation3' => { 388 => 0xe },
	'focalplaneafpointlocation4' => { 388 => 0x12 },
	'focalplaneafpointlocation5' => { 388 => 0x16 },
	'focalplaneafpointlocation6' => { 388 => 0x1a },
	'focalplaneafpointlocation7' => { 388 => 0x1e },
	'focalplaneafpointlocation8' => { 388 => 0x22 },
	'focalplaneafpointlocation9' => { 388 => 0x26 },
	'focalplaneafpointsused' => { 388 => 0x1 },
	'focalplanediagonal' => { 263 => 0x103, 267 => 0x205 },
	'focalplaneresolutionunit' => { 110 => 0xa210, 426 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 110 => 0xa20e, 426 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 53 => 0x2 },
	'focalplanexunknown' => { 53 => 0x2 },
	'focalplaneyresolution' => { 110 => 0xa20f, 426 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 53 => 0x3 },
	'focalplaneyunknown' => { 53 => 0x3 },
	'focaltype' => { 9 => 0x2d, 53 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 229 => 0x8 },
	'focusarea' => { 164 => 0x31 },
	'focusareaselection' => { 257 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 75 => 0x515 },
	'focusdistance' => { 147 => 'FocusDistance', 164 => 0x13, 170 => 0x49bb, 197 => 0x9, 198 => 0xa, 265 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 51 => 0x15, 69 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 51 => 0x14, 69 => 0x13 },
	'focusholdbutton' => { 167 => 0x44 },
	'focusinfoversion' => { 265 => 0x0 },
	'focusingscreen' => { 74 => 0x0, 75 => 0x80b, 80 => 0x0 },
	'focuslocation' => { 372 => 0x2027 },
	'focuslocked' => { 163 => 0x14 },
	'focusmode' => { 33 => 0x7, 103 => 0x3, 104 => [0x3003,0xd], 115 => 0x1021, 126 => 0x38, 140 => 'FocusMode', 164 => 0x30, 166 => 0xe, 167 => 0xc, 201 => 0x7, 262 => 0x301, 267 => 0x100b, 283 => 0x7, 317 => 0xd, 324 => 0x3, 342 => 0x1006, 353 => [0xb,0x5], 359 => [0x15,0x1d], 360 => 0x4d, 361 => 0x4d, 372 => [0xb042,0xb04e,0x201b], 376 => 0x13, 394 => 0x16 },
	'focusmode2' => { 298 => '3.1', 376 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 248 => '10.1', 357 => 0x14, 358 => 0x15, 360 => 0x10, 361 => 0xf, 362 => 0x6 },
	'focusmodeswitch' => { 167 => 0x58, 360 => 0x2e },
	'focuspixel' => { 115 => 0x1023 },
	'focuspointwrap' => { 246 => '2.2', 247 => '2.2', 249 => '2.1', 250 => '2.1', 254 => '1.1', 255 => '2.2', 256 => '1.1', 259 => '2.2', 260 => '2.5' },
	'focusposition' => { 197 => 0x8, 198 => 0x8, 317 => 0x10, 371 => 0x9bb },
	'focusposition2' => { 376 => [0x29,0x2b,0x2f], 394 => 0x2d, 397 => 0x20 },
	'focusprocess' => { 262 => 0x302 },
	'focusrange' => { 33 => 0x12, 267 => 0x100a },
	'focusrangeindex' => { 308 => '3.1' },
	'focussetting' => { 352 => 0x6 },
	'focusstatus' => { 359 => 0x19, 360 => 0x53, 361 => 0x53 },
	'focusstepcount' => { 265 => 0x301, 267 => 0x100e },
	'focusstepinfinity' => { 265 => 0x303, 267 => 0x103b },
	'focusstepnear' => { 265 => 0x304, 267 => 0x103c },
	'focustrackinglockon' => { 246 => ['1.5','4.1'], 247 => '1.4', 254 => '0.4', 255 => '3.1', 256 => '0.4', 259 => '1.4' },
	'focuswarning' => { 115 => 0x1301 },
	'foldername' => { 164 => 0x27 },
	'foldernumber' => { 360 => 0x9a, 362 => [0x402,0x114,0x316] },
	'fontcomposite' => { 451 => [\'Fonts','FontsComposite'] },
	'fontface' => { 451 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 451 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 451 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 451 => [\'Fonts','FontsFontName'] },
	'fonts' => { 451 => 'Fonts' },
	'fonttype' => { 451 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 451 => [\'Fonts','FontsVersionString'] },
	'for' => { 333 => 'For' },
	'format' => { 423 => 'format', 444 => 'Format' },
	'forwardlock' => { 441 => 'forwardlock' },
	'forwardmatrix1' => { 110 => 0xc714 },
	'forwardmatrix2' => { 110 => 0xc715 },
	'framecount' => { 60 => [0x2,0x4] },
	'frameheight' => { 115 => 0x3822 },
	'framenum' => { 328 => 0xd7 },
	'framenumber' => { 115 => 0x8003, 170 => 0x3c, 317 => 0x29 },
	'framerate' => { 60 => [0x1,0x6], 110 => 0xc764, 115 => 0x3820 },
	'framewidth' => { 115 => 0x3821 },
	'framing' => { 435 => 'framing' },
	'freebytes' => { 88 => 0x1 },
	'freememorycardimages' => { 165 => [0x37,0x54], 166 => [0x2d,0x4a], 167 => 0x32 },
	'fujiflashmode' => { 115 => 0x1010 },
	'fullimagesize' => { 372 => 0xb02b },
	'fullpanoheightpixels' => { 410 => 'FullPanoHeightPixels', 411 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 410 => 'FullPanoWidthPixels', 411 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 342 => 0x100d },
	'fullsizeimage' => { 146 => 'data' },
	'fullsizeimagename' => { 146 => '1Name' },
	'fullsizeimagetype' => { 146 => '0Type' },
	'func1button' => { 249 => '14.1', 250 => '14.1' },
	'func1buttonplusdials' => { 249 => '42.1', 250 => '42.1' },
	'func2button' => { 249 => '80.1', 250 => '80.1' },
	'func2buttonplusdials' => { 249 => '81.1' },
	'func3button' => { 249 => '83.1' },
	'funcbutton' => { 246 => ['14.1','15.1'], 247 => '14.1', 255 => '28.1', 256 => '13.1', 259 => '14.1', 260 => '14.1' },
	'funcbuttonplusdials' => { 246 => ['14.2','15.2'], 247 => '14.2', 255 => '31.1', 259 => '42.1' },
	'functionbutton' => { 253 => '13.1', 257 => '5.2' },
	'gainbase' => { 266 => 0x610 },
	'gaincontrol' => { 110 => 0xa407, 426 => 'GainControl' },
	'gamma' => { 110 => 0xa500, 427 => 'Gamma' },
	'gammablackpoint' => { 96 => 0xc },
	'gammacolortone' => { 96 => 0x3 },
	'gammacompensatedvalue' => { 120 => 0x91 },
	'gammacontrast' => { 96 => 0x2 },
	'gammacurveoutputrange' => { 96 => 0xf },
	'gammahighlight' => { 96 => 0xa },
	'gammalinear' => { 94 => 0x20200 },
	'gammamidpoint' => { 96 => 0xe },
	'gammasaturation' => { 96 => 0x4 },
	'gammashadow' => { 96 => 0x9 },
	'gammasharpnessstrength' => { 96 => 0x8 },
	'gammaunsharpmaskfineness' => { 96 => 0x6 },
	'gammaunsharpmaskstrength' => { 96 => 0x5 },
	'gammaunsharpmaskthreshold' => { 96 => 0x7 },
	'gammawhitepoint' => { 96 => 0xd },
	'geimagesize' => { 115 => 0x1304 },
	'gemake' => { 116 => 0x300 },
	'gemodel' => { 116 => 0x207 },
	'genre' => { 432 => 'Genre', 436 => 'genre', 446 => 'genre' },
	'genrecvid' => { 432 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 432 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 432 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 432 => [\'Genre','GenreCvTermRefinedAbout'] },
	'geography' => { 437 => 'geography' },
	'geologicalcontext' => { 109 => 'GeologicalContext' },
	'geologicalcontextbed' => { 109 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 109 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 109 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 109 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 109 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 111 => 'Geosync' },
	'geotag' => { 111 => 'Geotag' },
	'geotiffasciiparams' => { 110 => 0x87b1 },
	'geotiffdirectory' => { 110 => 0x87af },
	'geotiffdoubleparams' => { 110 => 0x87b0 },
	'geotime' => { 111 => 'Geotime' },
	'giftftppriority' => { 412 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 107 => 'GimbalPitchDegree' },
	'gimbalrolldegree' => { 107 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 107 => 'GimbalYawDegree' },
	'globalaltitude' => { 331 => 0x419 },
	'globalangle' => { 331 => 0x40d },
	'good' => { 446 => 'good' },
	'googleplusuploadcode' => { 110 => 0x9009 },
	'gpsaltitude' => { 117 => 0x6, 144 => 'Altitude', 426 => 'GPSAltitude' },
	'gpsaltituderef' => { 117 => 0x5, 426 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 117 => 0x1c, 426 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 117 => 0x1d },
	'gpsdatetime' => { 144 => 'DateTime', 426 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 117 => 0x18, 144 => 'Bearing', 426 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 117 => 0x17, 426 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 117 => 0x1a, 144 => 'Distance', 426 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 117 => 0x19, 426 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 117 => 0x14, 426 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 117 => 0x13 },
	'gpsdestlongitude' => { 117 => 0x16, 426 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 117 => 0x15 },
	'gpsdifferential' => { 117 => 0x1e, 144 => 'Differential', 426 => 'GPSDifferential' },
	'gpsdop' => { 117 => 0xb, 426 => 'GPSDOP' },
	'gpshpositioningerror' => { 117 => 0x1f, 426 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 117 => 0x11, 426 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 117 => 0x10, 426 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 117 => 0x2, 144 => 'Latitude', 426 => 'GPSLatitude' },
	'gpslatituderef' => { 117 => 0x1 },
	'gpslongitude' => { 117 => 0x4, 144 => 'Longitude', 426 => 'GPSLongitude' },
	'gpslongituderef' => { 117 => 0x3 },
	'gpsmapdatum' => { 117 => 0x12, 144 => 'Datum', 426 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 117 => 0xa, 144 => 'MeasureMode', 426 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 117 => 0x1b, 426 => 'GPSProcessingMethod' },
	'gpssatellites' => { 117 => 0x8, 144 => 'Satellites', 426 => 'GPSSatellites' },
	'gpsspeed' => { 117 => 0xd, 144 => 'Speed', 426 => 'GPSSpeed' },
	'gpsspeedref' => { 117 => 0xc, 426 => 'GPSSpeedRef' },
	'gpsstatus' => { 117 => 0x9, 426 => 'GPSStatus' },
	'gpstimestamp' => { 117 => 0x7 },
	'gpstrack' => { 117 => 0xf, 144 => 'Heading', 426 => 'GPSTrack' },
	'gpstrackref' => { 117 => 0xe, 426 => 'GPSTrackRef' },
	'gpsversionid' => { 117 => 0x0, 426 => 'GPSVersionID' },
	'gradation' => { 262 => 0x50f },
	'gradientbasedcorractive' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 422 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 422 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 422 => 'GrainAmount' },
	'grainfrequency' => { 422 => 'GrainFrequency' },
	'grainsize' => { 422 => 'GrainSize' },
	'graymixeraqua' => { 422 => 'GrayMixerAqua' },
	'graymixerblue' => { 422 => 'GrayMixerBlue' },
	'graymixergreen' => { 422 => 'GrayMixerGreen' },
	'graymixermagenta' => { 422 => 'GrayMixerMagenta' },
	'graymixerorange' => { 422 => 'GrayMixerOrange' },
	'graymixerpurple' => { 422 => 'GrayMixerPurple' },
	'graymixerred' => { 422 => 'GrayMixerRed' },
	'graymixeryellow' => { 422 => 'GrayMixerYellow' },
	'graypoint' => { 404 => 0x8021 },
	'grayresponseunit' => { 110 => 0x122 },
	'greencurvelimits' => { 99 => 0x1c4 },
	'greencurvepoints' => { 98 => 0x53, 99 => 0x19a },
	'greenhsl' => { 94 => 0x20912 },
	'greenhue' => { 422 => 'GreenHue' },
	'greensaturation' => { 422 => 'GreenSaturation' },
	'griddisplay' => { 246 => '13.3', 247 => '4.3', 249 => '4.2', 250 => '4.2', 251 => '2.2', 255 => '10.5', 256 => '3.4', 257 => '6.1', 259 => '4.4', 260 => '4.2' },
	'gripbatteryadload' => { 296 => 0x5 },
	'gripbatteryadnoload' => { 296 => 0x4 },
	'gripbatterystate' => { 296 => '1.2' },
	'groupareaafillumination' => { 247 => '46.4', 250 => '47.4', 259 => '47.4' },
	'halftonehints' => { 110 => 0x141 },
	'hardlink' => { 111 => 'HardLink' },
	'hasalternative' => { 436 => 'hasAlternative' },
	'hascorrection' => { 436 => 'hasCorrection' },
	'hascorrectiona-lang' => { 436 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 436 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 436 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 422 => 'HasCrop' },
	'hasextendedxmp' => { 448 => 'HasExtendedXMP' },
	'hassettings' => { 422 => 'HasSettings' },
	'hastranslation' => { 436 => 'hasTranslation' },
	'hasvisibleoverprint' => { 451 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 451 => 'HasVisibleTransparency' },
	'hdr' => { 54 => 0x1, 194 => 0x4, 283 => 0x9e, 317 => 0x85, 372 => 0x200a },
	'hdreffect' => { 54 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 194 => 0x0 },
	'hdrlevel' => { 194 => 0x5, 362 => 0x2e, 376 => 0x17 },
	'hdrlevel2' => { 194 => 0x7 },
	'hdrsetting' => { 362 => 0x2d, 376 => 0x16, 379 => 0x1148, 380 => 0x1148, 381 => 0x1124, 382 => 0x11a0, 383 => 0x117c, 384 => 0x1034, 385 => 0x22c, 386 => 0x22c, 387 => 0x21f },
	'hdrsmoothing' => { 194 => 0x6 },
	'headline' => { 118 => 0x69, 432 => 'Headline', 434 => 'Headline' },
	'hierarchicalkeywords' => { 155 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 155 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 155 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 155 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 155 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 155 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 155 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 413 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 109 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 287 => 0x1a },
	'highisomultipliergreen' => { 287 => 0x19 },
	'highisomultiplierred' => { 287 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 56 => 0x5, 75 => 0x202, 115 => 0x100e, 201 => 0xb1, 317 => 0x71, 360 => 0x2c, 361 => 0x26, 362 => 0x26, 372 => 0x2009, 376 => 0x12, 400 => 0x42 },
	'highisonoisereduction2' => { 372 => 0xb050 },
	'highlight' => { 352 => 0xf },
	'highlightadj' => { 94 => 0x2030c },
	'highlightcolordistortreduct' => { 404 => 0x8026 },
	'highlightlinearitylimit' => { 349 => 0xa025 },
	'highlightprotection' => { 238 => 0x6 },
	'highlightrecovery' => { 422 => 'HighlightRecovery' },
	'highlights' => { 415 => 'Highlights' },
	'highlights2012' => { 422 => 'Highlights2012' },
	'highlighttone' => { 115 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 56 => 0x3, 75 => 0x203 },
	'highlowkeyadj' => { 317 => 0x6c },
	'highspeedsync' => { 167 => 0x5, 360 => 0x2, 361 => 0x2 },
	'histogramxml' => { 239 => 0x83a1a25 },
	'history' => { 434 => 'History', 447 => 'History' },
	'historyaction' => { 447 => [\'History','HistoryAction'] },
	'historychanged' => { 447 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 447 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 447 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 447 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 447 => [\'History','HistoryWhen'] },
	'hometowncity' => { 104 => 0x3006, 317 => 0x23, 323 => 0x2 },
	'hometowncitycode' => { 324 => 0x1000 },
	'hometowndst' => { 317 => 0x25, 323 => '0.2' },
	'hostcomputer' => { 110 => 0x13c },
	'hue' => { 172 => 0x3b, 204 => 0x3d, 317 => 0x67 },
	'hueadj' => { 242 => 0x2f, 404 => 0x8019 },
	'hueadjust' => { 342 => 0x1016 },
	'hueadjustment' => { 165 => 0x4a, 166 => 0x40, 201 => 0x92, 203 => 0x36 },
	'hueadjustmentaqua' => { 422 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 422 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 422 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 422 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 422 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 422 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 422 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 422 => 'HueAdjustmentYellow' },
	'huesetting' => { 270 => 0x1011 },
	'humidity' => { 110 => 0x9401 },
	'icc_profile' => { 111 => 'ICC_Profile' },
	'iccprofilename' => { 434 => 'ICCProfile' },
	'idccreativestyle' => { 404 => 0x8000 },
	'idcpreviewlength' => { 404 => 0x202 },
	'idcpreviewstart' => { 404 => 0x201 },
	'identification' => { 109 => 'Identification' },
	'identificationid' => { 109 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 109 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 109 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 109 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 109 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 109 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 423 => 'identifier', 444 => 'Identifier' },
	'illumination' => { 257 => '0.5' },
	'imageadjustment' => { 201 => 0x80, 229 => 0x5 },
	'imagealterationconstraints' => { 272 => 'ImageAlterationConstraints' },
	'imagearea' => { 213 => 0x10, 216 => 0x10 },
	'imageareaoffset' => { 317 => 0x38 },
	'imageauthentication' => { 201 => 0x20 },
	'imageboundary' => { 201 => 0x16 },
	'imagecount' => { 115 => 0x1438, 201 => 0xa5, 374 => 0x11b, 389 => 0x32, 390 => 0x3a },
	'imagecount2' => { 389 => 0x4c, 390 => 0x58 },
	'imagecount3' => { 389 => [0x1a0,0x1aa,0x1bd], 390 => [0x19f,0x1cb,0x1cd] },
	'imagecreator' => { 272 => 'ImageCreator' },
	'imagecreatorid' => { 272 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 272 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 272 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedata' => { 409 => 'Data' },
	'imagedatasize' => { 201 => 0xa2 },
	'imagedescription' => { 110 => 0x10e, 442 => 'ImageDescription' },
	'imageduplicationconstraints' => { 272 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 239 => 0xfe443a45 },
	'imageeditcount' => { 317 => 0x41 },
	'imageediting' => { 317 => 0x32 },
	'imageeffects' => { 342 => 0x1010 },
	'imagefileconstraints' => { 272 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 272 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 272 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 115 => 0x1436 },
	'imageheight' => { 110 => 0x101, 171 => 0xc, 326 => 0x10d, 442 => 'ImageLength' },
	'imagehistory' => { 110 => 0x9213, 425 => 'ImageHistory' },
	'imageidnumber' => { 279 => 0x340 },
	'imagemimetype' => { 409 => 'Mime' },
	'imagenumber' => { 110 => 0x9211, 140 => 'ImageNumber', 165 => 0xae, 166 => 0x5e, 326 => 0x113, 360 => 0x9b, 362 => [0x400,'276.1',0x314], 418 => 'ImageNumber' },
	'imagenumber2' => { 166 => 0x62 },
	'imageoptimization' => { 201 => 0xa9 },
	'imageorientation' => { 118 => 0x83 },
	'imageprocessing' => { 201 => 0x1a },
	'imageprocessingversion' => { 266 => 0x0 },
	'imagequality' => { 140 => 'ImageQuality', 215 => '723.2', 216 => '732.2', 225 => '708.1', 283 => 0x1 },
	'imagequality2' => { 262 => 0x603 },
	'imagerank' => { 412 => 'ImageRank' },
	'imageref' => { 430 => 'ImageRef' },
	'imagereview' => { 248 => '0.4', 257 => '0.4' },
	'imagereviewmonitorofftime' => { 247 => '21.1', 249 => '21.1', 250 => '21.1', 254 => '20.1', 259 => '21.1' },
	'imagereviewtime' => { 246 => '25.1', 248 => '2.1', 251 => '19.1', 252 => '20.1', 253 => '20.1', 255 => '9.2', 256 => '20.1', 260 => '21.2' },
	'imagesize' => { 146 => 'ImageSize' },
	'imagesizerestriction' => { 439 => 'imageSizeRestriction' },
	'imagesourcedata' => { 110 => 0x935c },
	'imagestabilization' => { 33 => 0x22, 104 => 0x3020, 115 => 0x1422, 140 => 'ImageStabilization', 165 => 0xbd, 166 => 0x71, 167 => 0x57, 168 => 0x0, 169 => [0x18,0x107,0x113], 170 => 0x49c2, 201 => 0xac, 262 => 0x604, 265 => 0x1600, 283 => 0x1a, 365 => 0x12, 366 => 0x11, 372 => 0xb026 },
	'imagestabilization2' => { 364 => 0xa },
	'imagestabilizationsetting' => { 170 => 0x14, 360 => 0x3d, 361 => 0x3d, 371 => 0x14 },
	'imagestyle' => { 360 => 0x2d, 361 => 0x27 },
	'imagesupplier' => { 272 => 'ImageSupplier' },
	'imagesupplierid' => { 272 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 272 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 272 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 112 => 0x1 },
	'imagetemperaturemin' => { 112 => 0x2 },
	'imagetone' => { 317 => 0x4f },
	'imagetype' => { 118 => 0x82, 272 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 57 => 0x28, 110 => 0xa420, 425 => 'ImageUniqueID', 426 => 'ImageUniqueID' },
	'imagewidth' => { 110 => 0x100, 171 => 0xe, 326 => 0x10c, 442 => 'ImageWidth' },
	'incrementaltemperature' => { 422 => 'IncrementalTemperature' },
	'incrementaltint' => { 422 => 'IncrementalTint' },
	'industry' => { 436 => 'industry', 437 => 'industry' },
	'infobuttonwhenshooting' => { 75 => 0x409 },
	'infraredilluminator' => { 338 => 0x28 },
	'ingredientexclusion' => { 438 => 'ingredientExclusion' },
	'ingredients' => { 447 => 'Ingredients' },
	'ingredientsalternatepaths' => { 447 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 447 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 447 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 447 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 447 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 447 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 447 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 447 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 447 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 447 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 447 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 447 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 447 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 447 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 447 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 447 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 447 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 447 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 447 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 447 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 447 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 447 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 447 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 75 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 410 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 410 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 410 => 'InitialViewHeadingDegrees', 411 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 410 => 'InitialViewPitchDegrees', 411 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 410 => 'InitialViewRollDegrees', 411 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 246 => '4.4' },
	'initialzoomsetting' => { 246 => '9.3', 255 => '27.3' },
	'inkset' => { 110 => 0x14c },
	'inputprofile' => { 124 => 0x1389 },
	'instanceid' => { 447 => 'InstanceID' },
	'instantplaybacksetup' => { 167 => 0x3e },
	'instantplaybacktime' => { 167 => 0x3d },
	'instructions' => { 434 => 'Instructions' },
	'instrument' => { 446 => 'instrument' },
	'intellectualgenre' => { 431 => 'IntellectualGenre' },
	'intelligentauto' => { 372 => 0xb052, 396 => 0xd, 397 => 0xe, 398 => 0xd },
	'intelligentcontrast' => { 46 => 0x4 },
	'intelligentd-range' => { 283 => 0x79 },
	'intelligentexposure' => { 283 => 0x5d },
	'intelligentresolution' => { 283 => 0x70 },
	'interchangecolorspace' => { 120 => 0x40 },
	'internalflash' => { 164 => 0x2b, 246 => '23.1', 248 => '8.1', 251 => '22.1', 253 => '23.1', 257 => '8.1', 260 => '24.1', 265 => 0x1208 },
	'internalflashae1' => { 267 => 0x1021 },
	'internalflashae1_0' => { 267 => 0x101d },
	'internalflashae2' => { 267 => 0x1022 },
	'internalflashae2_0' => { 267 => 0x101e },
	'internalflashmode' => { 305 => 0x1 },
	'internalflashstrength' => { 305 => 0x3 },
	'internalflashtable' => { 267 => 0x1024 },
	'internallensserialnumber' => { 349 => 0xa005 },
	'internalndfilter' => { 283 => 0x9d },
	'internalserialnumber' => { 57 => 0x96, 68 => 0x9, 115 => 0x10, 170 => 0x49dc, 261 => 0x18, 263 => 0x102, 283 => 0x25, 297 => 0x4, 342 => 0x5, 389 => [0x7c,0xf0], 390 => 0x88 },
	'interopindex' => { 110 => 0x1, 427 => 'InteroperabilityIndex' },
	'interopversion' => { 110 => 0x2 },
	'intervallength' => { 164 => 0x10 },
	'intervalmode' => { 164 => 0x26 },
	'intervalnumber' => { 164 => 0x11 },
	'intervalshooting' => { 317 => 0x92 },
	'introtime' => { 446 => 'introTime' },
	'introtimescale' => { 446 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 446 => [\'introTime','introTimeValue'] },
	'iptc' => { 111 => 'IPTC' },
	'iptc-naa' => { 110 => 0x83bb, 287 => 0x83bb },
	'iptcbitspersample' => { 120 => 0x56 },
	'iptcdigest' => { 331 => 0x425 },
	'iptcimageheight' => { 120 => 0x1e },
	'iptcimagerotation' => { 120 => 0x66 },
	'iptcimagewidth' => { 120 => 0x14 },
	'iptclastedited' => { 432 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 120 => 0xa },
	'iptcpixelheight' => { 120 => 0x32 },
	'iptcpixelwidth' => { 120 => 0x28 },
	'isalternativeof' => { 436 => 'isAlternativeOf' },
	'isbn' => { 436 => 'isbn' },
	'iscorrectionof' => { 436 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 100 => 0x3 },
	'ismergedhdr' => { 418 => 'IsMergedHDR' },
	'ismergedpanorama' => { 418 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 103 => 0x14, 104 => [0x3014,0x14], 110 => 0x8827, 123 => 0xfd06, 124 => 0x1784, 126 => 0x60, 128 => [0xfa2e,0xfa46], 129 => [0x27,0x28], 130 => 0xf105, 133 => 0x14, 135 => 0x4e, 138 => 0x34, 140 => 'ISO', 164 => 0x8, 170 => 0x49ba, 195 => 0x0, 201 => 0x2, 287 => 0x17, 317 => [0x8b,0x14], 324 => 0x14, 326 => 0x105, 349 => 0xa014, 371 => 0x6f, 376 => [0x1f,0x21,0x25], 426 => 'ISOSpeedRatings' },
	'iso2' => { 195 => 0x6, 210 => 0x265, 211 => 0x25c, 212 => 0x265, 213 => 0x221, 214 => 0x25d, 215 => 0x256, 216 => 0x25d, 220 => 0x2b5, 223 => 0x265, 228 => 0x2b5 },
	'isoauto' => { 298 => '14.4' },
	'isoautohilimit' => { 218 => 0x18eb, 219 => 0xe82, 227 => 0x185d },
	'isoautoparameters' => { 317 => 0x7a },
	'isoautoshuttertime' => { 218 => 0x18ea, 219 => 0xe81, 227 => 0x185c },
	'isodisplay' => { 249 => '4.1', 250 => '4.1', 251 => '2.3', 252 => '3.3', 253 => '3.3', 256 => '3.3', 259 => '4.3', 260 => '4.3' },
	'isoexpansion' => { 75 => 0x103, 76 => 0x7, 77 => 0x8, 80 => 0x8, 195 => 0x4 },
	'isoexpansion2' => { 195 => 0xa },
	'isofloor' => { 298 => 0x6 },
	'isoselection' => { 201 => 0xf },
	'isosensitivitystep' => { 254 => '6.2', 256 => '6.2' },
	'isosetting' => { 126 => 0x5e, 140 => 'ISOSetting', 164 => 0x24, 165 => 0x26, 166 => 0x1c, 167 => 0x13, 172 => 0x6, 201 => 0x13, 298 => '17.3', 341 => 0x27, 360 => 0x16, 361 => 0x14, 362 => 0x2, 371 => 0x6d },
	'isospeed' => { 110 => 0x8833, 427 => 'ISOSpeed' },
	'isospeedexpansion' => { 74 => 0x3 },
	'isospeedincrements' => { 75 => 0x102 },
	'isospeedlatitudeyyy' => { 110 => 0x8834, 427 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 110 => 0x8835, 427 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 75 => 0x103 },
	'isostepsize' => { 246 => '6.1', 247 => '7.2', 249 => '7.2', 250 => '7.2', 255 => '4.1', 259 => '7.2' },
	'isovalue' => { 267 => 0x1001 },
	'issn' => { 436 => 'issn' },
	'issueidentifier' => { 436 => 'issueIdentifier' },
	'issuename' => { 436 => 'issueName' },
	'issueteaser' => { 436 => 'issueTeaser' },
	'issuetype' => { 436 => 'issueType' },
	'istranslationof' => { 436 => 'isTranslationOf' },
	'jobid' => { 118 => 0xb8 },
	'jobname' => { 428 => 'JobName' },
	'jobref' => { 445 => 'JobRef' },
	'jobrefid' => { 445 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 445 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 445 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 428 => 'JobStatus' },
	'jpeghandling' => { 422 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 285 => 0x3034, 372 => 0xb047 },
	'jpegsize' => { 285 => 0x303a },
	'jpgcompression' => { 219 => 0x7d4 },
	'jpgfromraw' => { 88 => 0x2007, 105 => 'JpgFromRaw', 287 => 0x2e },
	'jpgfromrawlength' => { 110 => [0x117,0x202] },
	'jpgfromrawstart' => { 110 => [0x111,0x201] },
	'jpgrecordedpixels' => { 298 => '14.1' },
	'jurisdiction' => { 419 => 'jurisdiction' },
	'kelvinwb_01' => { 306 => 0x5 },
	'kelvinwb_02' => { 306 => 0x9 },
	'kelvinwb_03' => { 306 => 0xd },
	'kelvinwb_04' => { 306 => 0x11 },
	'kelvinwb_05' => { 306 => 0x15 },
	'kelvinwb_06' => { 306 => 0x19 },
	'kelvinwb_07' => { 306 => 0x1d },
	'kelvinwb_08' => { 306 => 0x21 },
	'kelvinwb_09' => { 306 => 0x25 },
	'kelvinwb_10' => { 306 => 0x29 },
	'kelvinwb_11' => { 306 => 0x2d },
	'kelvinwb_12' => { 306 => 0x31 },
	'kelvinwb_13' => { 306 => 0x35 },
	'kelvinwb_14' => { 306 => 0x39 },
	'kelvinwb_15' => { 306 => 0x3d },
	'kelvinwb_16' => { 306 => 0x41 },
	'kelvinwb_daylight' => { 306 => 0x1 },
	'key' => { 446 => 'key' },
	'keystonecompensation' => { 266 => 0x1900 },
	'keystonedirection' => { 266 => 0x1901 },
	'keystonevalue' => { 266 => 0x1906 },
	'keyword' => { 436 => 'keyword' },
	'keywordinfo' => { 155 => 'Keywords' },
	'keywords' => { 118 => 0x19, 141 => 'Keywords', 271 => 'Keywords', 333 => 'Keywords', 416 => 'keywords', 433 => 'Keywords', 444 => 'Keywords' },
	'killdate' => { 436 => 'killDate' },
	'killdatea-platform' => { 436 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 436 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 123 => 0xf908, 126 => 0xe, 128 => [0xfa1e,0xfa52], 134 => 0x70 },
	'kodakimagewidth' => { 123 => 0xf907, 126 => 0xc, 128 => [0xfa1d,0xfa51], 134 => 0x6c },
	'kodakinfotype' => { 123 => 0xfa00 },
	'kodaklook' => { 124 => 0xe4c },
	'kodaklookprofile' => { 124 => 0x138a },
	'kodakmaker' => { 134 => 0x8 },
	'kodakmodel' => { 126 => 0x0, 134 => 0x28 },
	'label' => { 275 => 'Label', 444 => 'Label' },
	'labelname1' => { 430 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 430 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 283 => 0x6f },
	'landscapeoutputhighlightpoint' => { 100 => 0x26 },
	'landscapeoutputshadowpoint' => { 100 => 0x27 },
	'landscaperawcolortone' => { 100 => 0x1f },
	'landscaperawcontrast' => { 100 => 0x21 },
	'landscaperawhighlight' => { 100 => 0x77 },
	'landscaperawhighlightpoint' => { 100 => 0x24 },
	'landscaperawlinear' => { 100 => 0x22 },
	'landscaperawsaturation' => { 100 => 0x20 },
	'landscaperawshadow' => { 100 => 0x80 },
	'landscaperawshadowpoint' => { 100 => 0x25 },
	'landscaperawsharpness' => { 100 => 0x23 },
	'landscapeunsharpmaskfineness' => { 100 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 100 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 100 => 0xa2 },
	'language' => { 423 => 'language' },
	'languageidentifier' => { 118 => 0x87 },
	'largestvalidinteriorrectheight' => { 410 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 410 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 410 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 410 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 164 => 0x1b },
	'lastkeywordiptc' => { 162 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 162 => 'LastKeywordXMP' },
	'lastphotodate' => { 410 => 'LastPhotoDate' },
	'lasturl' => { 447 => 'LastURL' },
	'lateralchromaticaberration' => { 372 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 418 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 109 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 109 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 109 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 109 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 109 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 308 => 0x2 },
	'lc10' => { 308 => 0xb },
	'lc11' => { 308 => 0xc },
	'lc12' => { 308 => 0xd },
	'lc14' => { 308 => 0xf },
	'lc15' => { 308 => 0x10 },
	'lc3' => { 308 => 0x4 },
	'lc4' => { 308 => 0x5 },
	'lc5' => { 308 => 0x6 },
	'lc6' => { 308 => 0x7 },
	'lc7' => { 308 => 0x8 },
	'lc8' => { 308 => 0x9 },
	'lcddisplayatpoweron' => { 75 => 0x811, 79 => 0xa },
	'lcddisplayreturntoshoot' => { 80 => 0x12 },
	'lcdillumination' => { 246 => '17.5', 247 => '5.2', 249 => '5.1', 250 => '5.1', 255 => '10.3', 256 => '4.2', 259 => '5.2', 260 => '5.4' },
	'lcdilluminationduringbulb' => { 75 => 0x408 },
	'lcdpanels' => { 74 => 0x8 },
	'lcheditor' => { 239 => 0x8ae85e },
	'legacyiptcdigest' => { 434 => 'LegacyIPTCDigest' },
	'legalcode' => { 419 => 'legalcode' },
	'lens' => { 110 => 0xfdea, 201 => 0x84, 418 => 'Lens' },
	'lensafstopbutton' => { 73 => 0x11, 74 => 0x13, 75 => 0x506, 76 => 0x10, 77 => 0x12, 80 => 0x13, 81 => 0x9 },
	'lensaperturerange' => { 352 => [0x30,0x48] },
	'lenscorrectionsettings' => { 425 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 418 => 'LensDistortInfo' },
	'lensdistortionparams' => { 267 => 0x206 },
	'lensdrivenoaf' => { 75 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 362 => 0x3f0, 403 => 0xd },
	'lensfirmware' => { 343 => 0x20, 349 => 0xa004 },
	'lensfirmwareversion' => { 263 => 0x204, 283 => 0x60, 362 => 0x3f4, 403 => 0x15 },
	'lensfocallength' => { 94 => 0xf0512, 308 => 0x9 },
	'lensfocalrange' => { 352 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 247 => '55.1', 249 => '52.1', 250 => '52.1', 259 => '52.1' },
	'lensformat' => { 383 => 0x1891, 385 => 0x18bd, 386 => 0x18ed, 387 => 0x17f1, 389 => 0x106, 390 => 0x106, 399 => 0x603, 400 => 0x5d },
	'lensfstops' => { 196 => 0x7, 197 => 0xc, 198 => 0xd, 201 => 0x8b, 308 => '0.3' },
	'lensid' => { 418 => 'LensID' },
	'lensidnumber' => { 196 => 0x6, 197 => 0xb, 198 => 0xc },
	'lensinfo' => { 110 => 0xa432, 314 => 0x2a, 418 => 'LensInfo', 427 => 'LensSpecification' },
	'lenskind' => { 308 => 0x1 },
	'lensmake' => { 110 => 0xa433, 147 => 'Make', 427 => 'LensMake' },
	'lensmanualdistortionamount' => { 422 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 162 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 352 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 57 => 0x95, 110 => 0xa434, 147 => 'Model', 162 => 'LensModel', 199 => 0x18a, 263 => 0x203, 281 => 0x303, 314 => 0xc, 326 => 0x412, 427 => 'LensModel' },
	'lensmount' => { 362 => 0x99, 383 => 0x1892, 385 => 0x18be, 386 => 0x18ee, 387 => 0x17f2, 389 => 0x105, 390 => 0x105, 399 => 0x604, 400 => 0x5e },
	'lensmount2' => { 403 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 422 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 422 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 422 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 422 => 'LensProfileEnable' },
	'lensprofilefilename' => { 422 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 422 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 422 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 422 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 422 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 422 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 422 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 422 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 422 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 422 => 'LensProfileName' },
	'lensprofilesetup' => { 422 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 422 => 'LensProfileVignettingScale' },
	'lensproperties' => { 263 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 55 => 0x0, 110 => 0xa435, 147 => 'SerialNumber', 263 => 0x202, 283 => 0x52, 343 => 0x30, 418 => 'LensSerialNumber', 427 => 'LensSerialNumber' },
	'lensshutterlock' => { 167 => 0x4a },
	'lensspec' => { 357 => 0x0, 358 => 0x0, 359 => 0x0, 372 => 0xb02a },
	'lensspecfeatures' => { 389 => [0x115,0x116], 390 => [0x116,0x21c,0x21e] },
	'lenstemperature' => { 267 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 169 => 0x10c, 170 => 0x49bd, 201 => 0x83, 263 => 0x201, 276 => 0x16, 279 => 0x310, 282 => 0x303, 283 => 0x51, 285 => 0x3405, 309 => 0x0, 310 => 0x0, 311 => 0x1, 312 => 0x1, 313 => 0x1, 315 => 0x0, 349 => 0xa003, 352 => 0x27, 372 => 0xb027, 383 => 0x1896, 385 => 0x18c2, 386 => 0x18f2, 387 => 0x17f6, 389 => 0x109, 390 => 0x109, 399 => 0x608, 400 => 0x62 },
	'lenstype2' => { 362 => 0x3f7, 383 => 0x1893, 385 => 0x18bf, 386 => 0x18ef, 387 => 0x17f3, 389 => 0x107, 390 => 0x107, 399 => 0x605, 400 => 0x60 },
	'lenstype3' => { 403 => 0x9 },
	'lenszoomposition' => { 396 => 0x19, 397 => 0x1e, 400 => [0x342,0x35a] },
	'levelindicator' => { 290 => 0x15 },
	'levelorientation' => { 316 => 0x0 },
	'license' => { 419 => 'license' },
	'licensee' => { 272 => 'Licensee' },
	'licenseeid' => { 272 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 272 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 272 => 'LicenseeImageNotes' },
	'licenseename' => { 272 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 272 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 272 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 272 => 'LicenseeTransactionID' },
	'licenseid' => { 272 => 'LicenseID' },
	'licensestartdate' => { 272 => 'LicenseStartDate' },
	'licensetransactiondate' => { 272 => 'LicenseTransactionDate' },
	'licensetype' => { 424 => 'licensetype' },
	'licensor' => { 272 => 'Licensor' },
	'licensorcity' => { 272 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 272 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 272 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 272 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 272 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 272 => 'LicensorImageID' },
	'licensorname' => { 272 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 272 => 'LicensorNotes' },
	'licensorpostalcode' => { 272 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 272 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 272 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 272 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 272 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 272 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 272 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 272 => 'LicensorTransactionID' },
	'licensorurl' => { 272 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 267 => 0x1009 },
	'lightingmode' => { 104 => 0x302a },
	'lightreading' => { 317 => 0x15 },
	'lightsource' => { 110 => 0x9208, 201 => 0x90, 270 => 0x1000, 426 => 'LightSource' },
	'lightsourcespecial' => { 351 => 0x21d },
	'lightswitch' => { 259 => '0.1', 260 => '0.1' },
	'lightvaluecenter' => { 267 => 0x103d },
	'lightvalueperiphery' => { 267 => 0x103e },
	'limitafareamodeselection' => { 247 => '51.1', 249 => '49.1', 250 => '49.1', 259 => '49.1' },
	'linearitylimitblue' => { 287 => 0x10 },
	'linearitylimitgreen' => { 287 => 0xf },
	'linearitylimitred' => { 287 => 0xe },
	'linearityuppermargin' => { 40 => [0x2ba,0x2d1,0x2d5], 42 => 0x1e5, 43 => [0x1fe,0x2de], 44 => [0x232,0x310] },
	'linearizationtable' => { 110 => 0xc618 },
	'linearresponselimit' => { 110 => 0xc62e },
	'link' => { 436 => 'link' },
	'linkaetoafpoint' => { 298 => '14.2' },
	'linkedencodedrightsexpr' => { 432 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 432 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 432 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 432 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 109 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 251 => '32.1', 260 => '34.1' },
	'liveviewafareamode' => { 256 => '34.1' },
	'liveviewafmethod' => { 376 => 0x20 },
	'liveviewafmode' => { 256 => '34.2' },
	'liveviewafsetting' => { 362 => 0x36 },
	'liveviewbuttonoptions' => { 247 => '50.2', 249 => '48.2', 250 => '48.2', 259 => '48.2' },
	'liveviewexposuresimulation' => { 75 => 0x810 },
	'liveviewfocusmode' => { 362 => [0x8b,0x28b] },
	'liveviewmetering' => { 362 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 247 => '21.2', 249 => '21.2', 250 => '21.2', 252 => '20.2', 253 => '20.2', 254 => '20.2', 256 => '20.2', 259 => '21.2' },
	'liveviewshooting' => { 51 => 0x13 },
	'localcaption' => { 118 => 0x79 },
	'localizedcameramodel' => { 110 => 0xc615 },
	'locallocationname' => { 349 => 0x30 },
	'location' => { 200 => 0x9, 283 => 0x67, 414 => 'Location', 431 => 'Location', 435 => 'location', 436 => 'location' },
	'locationareacode' => { 420 => 'lac' },
	'locationcreated' => { 432 => 'LocationCreated' },
	'locationcreatedcity' => { 432 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 432 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 432 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 432 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 432 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 432 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 432 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 432 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 432 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 432 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 432 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 432 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 200 => 0x0 },
	'locationname' => { 349 => 0x31 },
	'locationshown' => { 432 => 'LocationShown' },
	'locationshowncity' => { 432 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 432 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 432 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 432 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 432 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 432 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 432 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 432 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 432 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 432 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 432 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 432 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 75 => 0x709 },
	'logcomment' => { 446 => 'logComment' },
	'longexposurenoisereduction' => { 56 => 0x4, 75 => 0x201, 76 => 0x1, 77 => 0x2, 78 => 0x1, 79 => 0x1, 80 => 0x2, 81 => 0x1, 283 => 0x49, 360 => 0x2b, 361 => 0x25, 362 => 0x25, 372 => 0x2008, 376 => 0x11, 400 => 0x44 },
	'longexposurenoisereduction2' => { 51 => 0x8 },
	'loop' => { 446 => 'loop' },
	'lowestbiostratigraphiczone' => { 109 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 422 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 422 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 422 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 422 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 422 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 422 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 422 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 422 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 99 => 0x150 },
	'luminancecurvepoints' => { 99 => 0x126 },
	'luminancenoisereduction' => { 94 => 0x20600, 100 => 0x5f, 352 => 0x1b },
	'luminancenoisereductioncontrast' => { 422 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 422 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 100 => 0x6d },
	'luminancesmoothing' => { 422 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 75 => [0x40b,0x40c] },
	'lyrics' => { 446 => 'lyrics' },
	'm16cversion' => { 279 => 0x333 },
	'macatom' => { 421 => 'macAtom' },
	'macatomapplicationcode' => { 421 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 421 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 421 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 115 => 0x1020, 116 => 0x202, 267 => 0x202, 341 => 0x21, 351 => 0x202, 372 => 0xb040 },
	'macroled' => { 265 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 51 => 0x10 },
	'macromode' => { 33 => 0x1, 164 => 0xb, 262 => 0x300, 283 => 0x1c, 342 => 0x1009 },
	'magentahsl' => { 94 => 0x20917 },
	'magicfilter' => { 262 => 0x52c },
	'magnifiedview' => { 77 => 0x11, 79 => 0x9 },
	'maindialexposurecomp' => { 257 => '0.6' },
	'mainingredient' => { 438 => 'mainIngredient' },
	'make' => { 89 => 0x0, 106 => 0x1, 110 => 0x10f, 140 => 'Make', 275 => 'Make', 287 => 0x10f, 435 => 'make', 442 => 'Make' },
	'makernote' => { 426 => 'MakerNote' },
	'makernoteapple' => { 108 => 'MakN', 110 => 0x927c },
	'makernotecanon' => { 108 => 'MakN', 110 => 0x927c },
	'makernotecasio' => { 108 => 'MakN', 110 => 0x927c },
	'makernotecasio2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotedji' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteflir' => { 108 => 'MakN', 110 => 0x927c },
	'makernotefujifilm' => { 108 => 'MakN', 110 => 0x927c },
	'makernotege' => { 108 => 'MakN', 110 => 0x927c },
	'makernotege2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotehasselblad' => { 108 => 'MakN', 110 => 0x927c },
	'makernotehp' => { 108 => 'MakN', 110 => 0x927c },
	'makernotehp2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotehp4' => { 108 => 'MakN', 110 => 0x927c },
	'makernotehp6' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteisl' => { 108 => 'MakN', 110 => 0x927c },
	'makernotejvc' => { 108 => 'MakN', 110 => 0x927c },
	'makernotejvctext' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak10' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak11' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak1a' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak1b' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak3' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak4' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak5' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak6a' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak6b' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak7' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak8a' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak8b' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak8c' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodak9' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekodakunknown' => { 108 => 'MakN', 110 => 0x927c },
	'makernotekyocera' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica2' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica3' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica4' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica5' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica6' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica7' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica8' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteleica9' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteminolta' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteminolta2' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteminolta3' => { 108 => 'MakN', 110 => 0x927c },
	'makernotemotorola' => { 108 => 'MakN', 110 => 0x927c },
	'makernotenikon' => { 108 => 'MakN', 110 => 0x927c },
	'makernotenikon2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotenikon3' => { 108 => 'MakN', 110 => 0x927c },
	'makernotenintendo' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteoffset' => { 351 => 0xff },
	'makernoteolympus' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteolympus2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotepanasonic' => { 108 => 'MakN', 110 => 0x927c },
	'makernotepanasonic2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotepentax' => { 108 => 'MakN', 110 => 0x927c },
	'makernotepentax2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotepentax3' => { 108 => 'MakN', 110 => 0x927c },
	'makernotepentax4' => { 108 => 'MakN', 110 => 0x927c },
	'makernotepentax5' => { 108 => 'MakN', 110 => 0x927c },
	'makernotepentax6' => { 108 => 'MakN', 110 => 0x927c },
	'makernotephaseone' => { 108 => 'MakN', 110 => 0x927c },
	'makernotereconyx' => { 108 => 'MakN', 110 => 0x927c },
	'makernotericoh' => { 108 => 'MakN', 110 => 0x927c },
	'makernotericoh2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotericohtext' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesafety' => { 110 => 0xc635 },
	'makernotesamsung1a' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesamsung1b' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesamsung2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesanyo' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesanyoc4' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesanyopatch' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesigma' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesony' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesony2' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesony3' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesony4' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesony5' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesonyericsson' => { 108 => 'MakN', 110 => 0x927c },
	'makernotesonysrf' => { 108 => 'MakN', 110 => 0x927c },
	'makernotetype' => { 342 => 0x1 },
	'makernoteunknown' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteunknownbinary' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteunknowntext' => { 108 => 'MakN', 110 => 0x927c },
	'makernoteversion' => { 169 => 0x0, 201 => 0x1, 267 => 0x0, 283 => 0x8000, 346 => 0x0, 349 => 0x1, 352 => [0x1d,0x1f], 363 => 0x2000 },
	'managedfrom' => { 447 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 447 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 447 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 447 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 447 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 447 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 447 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 447 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 447 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 447 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 447 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 447 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 447 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 447 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 447 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 447 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 447 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 447 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 447 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 447 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 447 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 447 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 447 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 447 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 447 => 'Manager' },
	'managervariant' => { 447 => 'ManagerVariant' },
	'manageto' => { 447 => 'ManageTo' },
	'manageui' => { 447 => 'ManageUI' },
	'manifest' => { 447 => 'Manifest' },
	'manifestlinkform' => { 447 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 447 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 447 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 447 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 447 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 447 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 447 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 447 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 447 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 447 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 447 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 447 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 447 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 447 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 447 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 447 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 447 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 447 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 447 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 447 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 447 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 447 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 447 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 447 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 447 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 447 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 447 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 447 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 262 => 0x900, 283 => 0x86 },
	'manometerreading' => { 262 => 0x901 },
	'manualafpointselectpattern' => { 75 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 265 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 248 => '8.2', 251 => '22.2', 252 => '23.1', 253 => '23.2', 255 => '16.2', 256 => '23.2', 257 => '8.2', 258 => '23.2', 260 => '24.2', 342 => 0x100c },
	'manualflashstrength' => { 262 => 0x406 },
	'manualfocusdistance' => { 201 => 0x85, 267 => 0x100c, 351 => 0x223 },
	'manualtv' => { 74 => 0x5, 75 => 0x705 },
	'manufacturedate' => { 174 => 0x6705, 297 => 0x1 },
	'manufacturedate1' => { 344 => 0x4 },
	'manufacturedate2' => { 344 => 0x5 },
	'manufacturer' => { 435 => 'manufacturer' },
	'marked' => { 433 => 'Marked', 450 => 'Marked' },
	'markers' => { 446 => 'markers' },
	'markerscomment' => { 446 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 446 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 446 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 446 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 446 => [\'markers','markersCuePointType'] },
	'markersduration' => { 446 => [\'markers','markersDuration'] },
	'markerslocation' => { 446 => [\'markers','markersLocation'] },
	'markersname' => { 446 => [\'markers','markersName'] },
	'markersprobability' => { 446 => [\'markers','markersProbability'] },
	'markersspeaker' => { 446 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 446 => [\'markers','markersStartTime'] },
	'markerstarget' => { 446 => [\'markers','markersTarget'] },
	'markerstype' => { 446 => [\'markers','markersType'] },
	'maskedareas' => { 110 => 0xc68e },
	'masterdocumentid' => { 118 => 0xb9 },
	'mastergain' => { 208 => 0x50 },
	'matrixmetering' => { 247 => '50.1', 249 => '48.1', 250 => '48.1', 259 => '48.1' },
	'maxaperture' => { 33 => 0x1a, 130 => 0x6103, 147 => 'MaxAperture', 164 => 0x17, 170 => 0x49c5, 263 => 0x20a, 308 => '14.1', 389 => 0x0, 390 => 0x0 },
	'maxapertureatmaxfocal' => { 115 => 0x1407, 147 => 'MaxApertureAtMaxFocal', 196 => 0xb, 197 => 0x10, 198 => 0x11, 263 => 0x206 },
	'maxapertureatminfocal' => { 115 => 0x1406, 196 => 0xa, 197 => 0xf, 198 => 0x10, 263 => 0x205 },
	'maxaperturevalue' => { 110 => 0x9205, 326 => 0x414, 426 => 'MaxApertureValue' },
	'maxavailheight' => { 432 => 'MaxAvailHeight' },
	'maxavailwidth' => { 432 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 246 => 0xb, 247 => 0xc, 249 => '12.1', 250 => '12.1', 255 => 0xc, 256 => 0xb, 259 => '12.1' },
	'maxfaces' => { 266 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 115 => 0x1405, 147 => 'MaxFocalLength', 196 => 0x9, 197 => 0xe, 198 => 0xf, 263 => 0x208, 383 => 0x127c, 384 => 0x1138, 385 => 0x330, 386 => 0x330, 387 => 0x30e },
	'maximumdensityrange' => { 120 => 0x8c },
	'maxpagesize' => { 451 => 'MaxPageSize' },
	'maxpagesizeh' => { 451 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 451 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 451 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 110 => 0x119 },
	'maxstorage' => { 441 => 'maxstorage' },
	'mb-d10batteries' => { 246 => '12.6' },
	'mb-d10batterytype' => { 255 => '13.3' },
	'mb-d11batterytype' => { 256 => '2.3' },
	'mb-d12batterytype' => { 259 => '3.2' },
	'mb-d80batteries' => { 257 => '6.5' },
	'mb-d80batterytype' => { 260 => '3.2' },
	'mcuversion' => { 196 => 0xc, 197 => 0x11, 198 => 0x12 },
	'md5digest' => { 148 => 'zmd5' },
	'mditemfindercomment' => { 157 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 157 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 157 => 'MDItemFSLabel' },
	'meal' => { 438 => 'meal' },
	'measuredev' => { 27 => 0x9, 69 => 0x3, 88 => 0x1814, 140 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 69 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 170 => 0x690, 279 => 0x312, 285 => 0x3407 },
	'measuredrggb' => { 58 => 0x1 },
	'measuredrggbdata' => { 39 => 0x287 },
	'measurementaccuracy' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 109 => 'MeasurementOrFact' },
	'measurementremarks' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 109 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 272 => 'MediaConstraints' },
	'mediacreatedate' => { 334 => 0x1 },
	'mediaeventiddate' => { 412 => 'MediaEventIdDate' },
	'mediamodifydate' => { 334 => 0x2 },
	'mediasummarycode' => { 272 => 'MediaSummaryCode' },
	'memoaudioquality' => { 75 => 0x812 },
	'memorycardconfiguration' => { 366 => 0x16 },
	'memorycardnumber' => { 188 => 0x2 },
	'menubuttondisplayposition' => { 73 => 0xb, 76 => 0xa, 77 => 0xb, 80 => 0xb },
	'menubuttonreturn' => { 81 => 0xb },
	'menumonitorofftime' => { 246 => '26.1', 247 => '22.1', 249 => '22.1', 250 => '22.1', 254 => '21.1', 255 => '8.2', 256 => '21.1', 259 => '22.1', 260 => '22.1' },
	'metadatadate' => { 444 => 'MetadataDate' },
	'metadatamoddate' => { 446 => 'metadataModDate' },
	'metaversion' => { 378 => 0x34 },
	'meterinfo1row1' => { 373 => 0x0 },
	'meterinfo1row2' => { 373 => 0x6c },
	'meterinfo1row3' => { 373 => 0xd8 },
	'meterinfo1row4' => { 373 => 0x144 },
	'meterinfo1row5' => { 373 => 0x1b0 },
	'meterinfo1row6' => { 373 => 0x21c },
	'meterinfo1row7' => { 373 => 0x288 },
	'meterinfo2row1' => { 373 => 0x2f4 },
	'meterinfo2row2' => { 373 => 0x378 },
	'meterinfo2row3' => { 373 => 0x3fc },
	'meterinfo2row4' => { 373 => 0x480 },
	'meterinfo2row5' => { 373 => 0x504 },
	'meterinfo2row6' => { 373 => 0x588 },
	'meterinfo2row7' => { 373 => 0x60c },
	'meterinfo2row8' => { 373 => 0x690 },
	'meterinfo2row9' => { 373 => 0x714 },
	'metering' => { 248 => '6.1' },
	'meteringmode' => { 33 => 0x11, 110 => 0x9207, 126 => 0x1c, 164 => 0x7, 165 => 0x25, 167 => 0x12, 262 => 0x202, 317 => 0x17, 352 => 0x9, 360 => 0x15, 361 => 0x13, 362 => 0x7, 376 => 0x3, 379 => 0x1174, 380 => 0x1178, 381 => 0x1154, 382 => 0x11d0, 383 => 0x11ac, 384 => 0x1064, 385 => 0x25c, 386 => 0x25c, 387 => 0x24b, 426 => 'MeteringMode' },
	'meteringmode2' => { 298 => '2.1', 372 => 0x202c },
	'meteringmode3' => { 298 => '16.1' },
	'meteringoffscaleindicator' => { 167 => 0x53 },
	'meteringtime' => { 246 => '22.2', 248 => '3.2', 251 => '17.1', 252 => '18.1', 255 => '7.3', 256 => '18.1', 257 => '3.2', 260 => '19.1' },
	'mieversion' => { 148 => '0Vers' },
	'minaperture' => { 33 => 0x1b, 147 => 'MinAperture', 308 => '0.2', 389 => 0x1, 390 => 0x1 },
	'minaperturevalue' => { 326 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 115 => 0x1404, 147 => 'MinFocalLength', 196 => 0x8, 197 => 0xd, 198 => 0xe, 263 => 0x207, 383 => 0x127a, 384 => 0x1136, 385 => 0x32e, 386 => 0x32e, 387 => 0x30c },
	'minfocusdistance' => { 308 => 0x3 },
	'minoltadate' => { 164 => 0x15 },
	'minoltaimagesize' => { 164 => 0x4, 165 => 0xc, 166 => 0x2, 169 => 0x103 },
	'minoltamodelid' => { 164 => 0x25 },
	'minoltaquality' => { 164 => 0x5, 165 => 0xd, 166 => 0x3, 169 => [0x102,0x103] },
	'minoltatime' => { 164 => 0x16 },
	'minormodelagedisclosure' => { 272 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 110 => 0x118 },
	'mirrorlockup' => { 73 => 0xc, 74 => 0xc, 75 => 0x60f, 76 => 0xb, 77 => 0xc, 78 => 0x6, 79 => 0x6, 80 => 0xc, 81 => 0x3 },
	'mobilecountrycode' => { 420 => 'mcc' },
	'mobilenetworkcode' => { 420 => 'mnc' },
	'moddate' => { 275 => 'modify-date', 433 => 'ModDate' },
	'modedialposition' => { 366 => 0x14 },
	'model' => { 89 => 0x6, 110 => 0x110, 140 => 'Model', 275 => 'Model', 287 => 0x110, 317 => 0x23f, 352 => 0x84, 435 => 'model', 442 => 'Model' },
	'modelage' => { 432 => 'ModelAge' },
	'modelid' => { 261 => 0x0 },
	'modelingflash' => { 246 => '21.4', 247 => '31.1', 249 => '31.1', 250 => '31.1', 255 => '26.4', 256 => '30.2', 257 => '7.4', 258 => '30.1', 259 => '31.1', 260 => '31.3' },
	'modelreleaseid' => { 272 => 'ModelReleaseID' },
	'modelreleasestatus' => { 272 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 391 => 0x52, 392 => 0x46, 393 => 0x53 },
	'modelyear' => { 435 => 'modelYear' },
	'modificationdate' => { 436 => 'modificationDate' },
	'modifiedcolortemp' => { 59 => 0x9 },
	'modifieddigitalgain' => { 59 => 0xb },
	'modifiedparamflag' => { 52 => 0x1 },
	'modifiedpicturestyle' => { 59 => 0xa },
	'modifiedsaturation' => { 262 => 0x504 },
	'modifiedsensorbluelevel' => { 59 => 0x5 },
	'modifiedsensorredlevel' => { 59 => 0x4 },
	'modifiedsharpness' => { 59 => 0x2 },
	'modifiedsharpnessfreq' => { 59 => 0x3 },
	'modifiedtonecurve' => { 59 => 0x1 },
	'modifiedwhitebalance' => { 59 => 0x8 },
	'modifiedwhitebalanceblue' => { 59 => 0x7 },
	'modifiedwhitebalancered' => { 59 => 0x6 },
	'modifydate' => { 110 => 0x132, 141 => 'ModifyDate', 271 => 'ModDate', 273 => 'tIME', 333 => 'ModDate', 335 => 0x2, 444 => 'ModifyDate' },
	'moirefilter' => { 110 => 0xfe58, 422 => 'MoireFilter' },
	'monitordisplayoff' => { 167 => 0x4c },
	'monitorofftime' => { 246 => '18.2', 248 => '3.1', 257 => '3.1' },
	'monochromecolor' => { 262 => 0x53b },
	'monochromecontrast' => { 100 => 0x3c },
	'monochromefiltereffect' => { 94 => 0x20307, 100 => 0x3a, 317 => 0x73 },
	'monochromelinear' => { 100 => 0x3d },
	'monochromeoutputhighlightpoint' => { 100 => 0x41 },
	'monochromeoutputshadowpoint' => { 100 => 0x42 },
	'monochromeprofilesettings' => { 262 => 0x537 },
	'monochromerawhighlight' => { 100 => 0x7a },
	'monochromerawhighlightpoint' => { 100 => 0x3f },
	'monochromerawshadow' => { 100 => 0x83 },
	'monochromerawshadowpoint' => { 100 => 0x40 },
	'monochromesharpness' => { 100 => 0x3e },
	'monochrometoning' => { 317 => 0x74 },
	'monochrometoningeffect' => { 94 => 0x20306, 100 => 0x3b },
	'monochromeunsharpmaskfineness' => { 100 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 100 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 100 => 0xb4 },
	'monochromevignetting' => { 262 => 0x53a },
	'monthdaycreated' => { 126 => 0x12, 135 => 0xe },
	'moonphase' => { 338 => 0x12 },
	'morepermissions' => { 419 => 'morePermissions' },
	'motionsensitivity' => { 338 => 0x29 },
	'movieaelockbuttonassignment' => { 259 => '40.1' },
	'moviefunc1button' => { 249 => '41.1', 250 => '41.1' },
	'moviefunctionbutton' => { 247 => '41.1', 259 => '41.1' },
	'moviefunctionbuttonplusdials' => { 247 => '52.1' },
	'moviepreviewbutton' => { 247 => '41.2', 249 => '41.2', 250 => '41.2', 259 => '41.2' },
	'moviepreviewbuttonplusdials' => { 247 => '52.2' },
	'movieshutterbutton' => { 247 => '38.3', 249 => '38.3', 250 => '38.3', 259 => '38.3' },
	'moviesubselectorassignment' => { 247 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 247 => '53.1' },
	'multiburstimageheight' => { 372 => 0x1002 },
	'multiburstimagewidth' => { 372 => 0x1001 },
	'multiburstmode' => { 372 => 0x1000 },
	'multicontrollerwhilemetering' => { 75 => 0x517 },
	'multiexposure' => { 61 => 0x1 },
	'multiexposureautogain' => { 202 => 0x3 },
	'multiexposurecontrol' => { 61 => 0x2 },
	'multiexposuremode' => { 202 => 0x1 },
	'multiexposureshots' => { 61 => 0x3, 202 => 0x2 },
	'multiframenoisereduction' => { 362 => 0x35, 372 => 0x200b, 376 => 0x15 },
	'multiframenreffect' => { 372 => 0x2023 },
	'multifunctionlock' => { 75 => 0x70f },
	'multipleexposuremode' => { 266 => 0x101c },
	'multipleexposureset' => { 298 => '10.1' },
	'multisample' => { 208 => 0x40 },
	'multiselector' => { 246 => '9.4', 247 => '10.3', 249 => '10.3', 250 => '10.3', 255 => '27.4', 259 => '10.3' },
	'multiselectorliveview' => { 246 => '4.3', 249 => '37.1', 250 => '37.1', 259 => '37.1' },
	'multiselectorliveviewmode' => { 218 => 0x18c2 },
	'multiselectorplaybackmode' => { 246 => ['13.5','9.2'], 247 => '10.2', 250 => '10.2', 255 => '27.2', 259 => '10.2' },
	'multiselectorshootmode' => { 246 => '9.1', 247 => '10.1', 249 => '10.1', 250 => '10.1', 255 => '27.1', 259 => '10.1' },
	'mycolormode' => { 62 => 0x2 },
	'nationalcatalognumber' => { 436 => 'nationalCatalogNumber' },
	'nativedigest' => { 426 => 'NativeDigest', 442 => 'NativeDigest' },
	'ncdfileinfo' => { 124 => 0x414 },
	'ndfilter' => { 69 => 0x1c, 262 => 0x204, 342 => 0x1019 },
	'nefbitdepth' => { 201 => 0xe22 },
	'nefcompression' => { 201 => 0x93 },
	'neflinearizationtable' => { 201 => 0x96 },
	'negativecachelargepreviewsize' => { 422 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 422 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 422 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 317 => 0x88 },
	'neutraloutputhighlightpoint' => { 100 => 0x2f },
	'neutraloutputshadowpoint' => { 100 => 0x30 },
	'neutralrawcolortone' => { 100 => 0x28 },
	'neutralrawcontrast' => { 100 => 0x2a },
	'neutralrawhighlight' => { 100 => 0x78 },
	'neutralrawhighlightpoint' => { 100 => 0x2d },
	'neutralrawlinear' => { 100 => 0x2b },
	'neutralrawsaturation' => { 100 => 0x29 },
	'neutralrawshadow' => { 100 => 0x81 },
	'neutralrawshadowpoint' => { 100 => 0x2e },
	'neutralrawsharpness' => { 100 => 0x2c },
	'neutralunsharpmaskfineness' => { 100 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 100 => 0xa8 },
	'neutraunsharpmaskstrength' => { 100 => 0xa4 },
	'newrawimagedigest' => { 110 => 0xc7a7 },
	'newsphotoversion' => { 120 => 0x0 },
	'nickname' => { 444 => 'Nickname' },
	'nikoncapturedata' => { 201 => 0xe01 },
	'nikoncaptureeditversions' => { 201 => 0xe13 },
	'nikoncaptureoutput' => { 201 => 0xe1e },
	'nikoncaptureversion' => { 201 => 0xe09 },
	'nikoniccprofile' => { 201 => 0xe1d },
	'nikonimagesize' => { 215 => '723.1', 216 => '732.1', 225 => 0x2c4 },
	'noisefilter' => { 262 => 0x527 },
	'noiseprofile' => { 110 => 0xc761 },
	'noisereduction' => { 115 => 0x100b, 165 => 0xb0, 166 => 0x60, 167 => 0x3f, 201 => 0x95, 239 => 0x753dcbc0, 240 => 0x17, 262 => 0x50a, 267 => 0x103a, 283 => 0x2d, 317 => 0x49, 342 => 0x100f, 344 => 0x2a },
	'noisereduction2' => { 266 => 0x1010 },
	'noisereductionapplied' => { 110 => 0xc6f7 },
	'noisereductionintensity' => { 240 => 0x9 },
	'noisereductionmethod' => { 240 => 0x11 },
	'noisereductionmode' => { 404 => 0x801e },
	'noisereductionsharpness' => { 240 => 0xd },
	'noisereductionvalue' => { 404 => 0x8027 },
	'nomemorycard' => { 246 => '22.1', 247 => '4.2', 248 => '0.3', 251 => '2.4', 252 => '3.2', 253 => '3.2', 255 => '33.7', 256 => '3.2', 257 => '0.3', 259 => '4.2', 260 => '4.5' },
	'nominalmaxaperture' => { 308 => 0xa },
	'nominalminaperture' => { 308 => '10.1' },
	'normalwhitelevel' => { 40 => [0x2b8,0x2cf,0x2d3], 42 => 0x1e3, 43 => [0x1fc,0x2dc], 44 => [0x230,0x30e] },
	'notes' => { 405 => 'Notes', 416 => 'notes' },
	'npages' => { 451 => 'NPages' },
	'nrwdata' => { 201 => 0x14 },
	'nullrecord' => { 88 => 0x0 },
	'numafpoints' => { 294 => 0x2 },
	'number' => { 436 => 'number' },
	'numberofbeats' => { 446 => 'numberOfBeats' },
	'numberoffocuspoints' => { 249 => '1.2', 250 => '1.2', 253 => '0.2', 254 => '0.3', 256 => '0.3' },
	'numfaceelements' => { 115 => 0x4200 },
	'numfacepositions' => { 277 => 0x0 },
	'numindexentries' => { 120 => 0x54 },
	'numwbentries' => { 288 => 0x0, 289 => 0x0 },
	'object' => { 436 => 'object' },
	'objectattributereference' => { 118 => 0x4 },
	'objectcycle' => { 118 => 0x4b, 416 => 'ObjectCycle' },
	'objectdescription' => { 435 => 'objectDescription' },
	'objectdistance' => { 103 => 0x6, 104 => 0x2022 },
	'objectname' => { 118 => 0x5 },
	'objectpreviewdata' => { 118 => 0xca },
	'objectpreviewfileformat' => { 118 => 0xc8 },
	'objectpreviewfileversion' => { 118 => 0xc9 },
	'objectsubtype' => { 435 => 'objectSubtype' },
	'objecttype' => { 435 => 'objectType' },
	'objecttypereference' => { 118 => 0x3 },
	'occurrence' => { 109 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 109 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 109 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 109 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 109 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 109 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 109 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 109 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 109 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 109 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 109 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 109 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 109 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 109 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 109 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 109 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 109 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 109 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 109 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 109 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 109 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 109 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 109 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 109 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 426 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 426 => [\'OECF','OECFNames'] },
	'oecfrows' => { 426 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 426 => [\'OECF','OECFValues'] },
	'offsaledate' => { 436 => 'offSaleDate' },
	'offsaledatea-platform' => { 436 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 436 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 110 => 0xea1d },
	'offsettime' => { 110 => 0x9010 },
	'offsettimedigitized' => { 110 => 0x9012 },
	'offsettimeoriginal' => { 110 => 0x9011 },
	'okbutton' => { 256 => '15.1', 260 => '16.1' },
	'oldsubfiletype' => { 110 => 0xff },
	'olympusimageheight' => { 267 => 0x102f },
	'olympusimagewidth' => { 267 => 0x102e },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 267 => 0x302 },
	'onsaledate' => { 436 => 'onSaleDate' },
	'onsaledatea-platform' => { 436 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 436 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 436 => 'onSaleDay' },
	'onsaledaya-platform' => { 436 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 436 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 110 => 0xc740 },
	'opcodelist2' => { 110 => 0xc741 },
	'opcodelist3' => { 110 => 0xc74e },
	'opticalzoom' => { 128 => 0xfa3d, 130 => [0x6006,0xf006], 131 => 0x1000, 132 => 0xf, 135 => 0x1e, 147 => 'OpticalZoom' },
	'opticalzoomcode' => { 69 => 0xa },
	'opticalzoommode' => { 283 => 0x34 },
	'opticalzoomon' => { 351 => 0x219 },
	'optionenddate' => { 439 => 'optionEndDate' },
	'opto-electricconvfactor' => { 426 => 'OECF' },
	'orangehsl' => { 94 => 0x20911 },
	'ordernumber' => { 115 => 0x8002 },
	'organisationinimagecode' => { 432 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 432 => 'OrganisationInImageName' },
	'organization' => { 436 => 'organization' },
	'orientation' => { 110 => 0x112, 287 => 0x112, 435 => 'orientation', 442 => 'Orientation' },
	'orientation2' => { 376 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 75 => 0x516 },
	'originalbestqualitysize' => { 110 => 0xc792 },
	'originalcreatedatetime' => { 412 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 105 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 57 => 0x83 },
	'originaldefaultcropsize' => { 110 => 0xc793 },
	'originaldefaultfinalsize' => { 110 => 0xc791 },
	'originaldirectory' => { 281 => 0x408 },
	'originaldocumentid' => { 447 => 'OriginalDocumentID' },
	'originalfilename' => { 88 => 0x816, 124 => 0x3e9, 136 => 0x20, 281 => 0x407, 412 => 'OriginalFilename' },
	'originalimageheight' => { 71 => 0xc, 114 => 0x1 },
	'originalimagewidth' => { 71 => 0xb, 114 => 0x0 },
	'originalrawfiledata' => { 110 => 0xc68c },
	'originalrawfiledigest' => { 110 => 0xc71d },
	'originalrawfilename' => { 110 => 0xc68b },
	'originaltransmissionreference' => { 118 => 0x67 },
	'originatingprogram' => { 118 => 0x41, 416 => 'OriginatingProgram' },
	'originplatform' => { 436 => 'originPlatform' },
	'os' => { 424 => 'os' },
	'otherconditions' => { 272 => 'OtherConditions' },
	'otherconstraints' => { 272 => 'OtherConstraints' },
	'otherimage' => { 105 => 'OtherImage' },
	'otherimageinfo' => { 272 => 'OtherImageInfo' },
	'otherimagelength' => { 110 => 0x202 },
	'otherimagestart' => { 110 => 0x201 },
	'otherlicensedocuments' => { 272 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 272 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 272 => 'OtherLicenseRequirements' },
	'outcue' => { 446 => 'outCue' },
	'outcuescale' => { 446 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 446 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 179 => 0x3 },
	'outputimagewidth' => { 179 => 0x2 },
	'outputprofile' => { 124 => 0x138b },
	'outputresolution' => { 179 => 0x4 },
	'owner' => { 450 => 'Owner' },
	'ownerid' => { 118 => 0xbc },
	'ownername' => { 14 => 0x10f, 57 => 0x9, 88 => 0x810, 110 => [0xa430,0xfde8], 140 => 'OwnerName', 418 => 'OwnerName', 427 => 'CameraOwnerName' },
	'padding' => { 110 => 0xea1c },
	'pagecount' => { 436 => 'pageCount' },
	'pageimage' => { 444 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 444 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 444 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 444 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 444 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 444 => 'PageInfo' },
	'pagename' => { 110 => 0x11d },
	'pagenumber' => { 110 => 0x129 },
	'pageprogressiondirection' => { 436 => 'pageProgressionDirection' },
	'pagerange' => { 436 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 422 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 422 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 283 => 0x26 },
	'panasonicimageheight' => { 283 => 0x4c },
	'panasonicimagewidth' => { 283 => 0x4b },
	'panasonicrawversion' => { 287 => 0x1 },
	'panasonictitle' => { 110 => 0xc6d2 },
	'panasonictitle2' => { 110 => 0xc6d3 },
	'panoramaangle' => { 115 => 0x1153 },
	'panoramacropbottom' => { 377 => 0x7 },
	'panoramacropleft' => { 377 => 0x4 },
	'panoramacropright' => { 377 => 0x6 },
	'panoramacroptop' => { 377 => 0x5 },
	'panoramadirection' => { 65 => 0x5, 115 => 0x1154, 377 => 0x3 },
	'panoramaframeheight' => { 377 => 0x9 },
	'panoramaframenumber' => { 65 => 0x2 },
	'panoramaframewidth' => { 377 => 0x8 },
	'panoramafullheight' => { 377 => 0x2 },
	'panoramafullwidth' => { 377 => 0x1 },
	'panoramamode' => { 126 => 0x3c, 262 => 0x601 },
	'panoramasize3d' => { 362 => 0x38 },
	'panoramasourceheight' => { 377 => 0xb },
	'panoramasourcewidth' => { 377 => 0xa },
	'panoramicstitchcameramotion' => { 160 => 'PanoramicStitchCameraMotion', 161 => 0x1 },
	'panoramicstitchmaptype' => { 160 => 'PanoramicStitchMapType', 161 => 0x2 },
	'panoramicstitchphi0' => { 160 => 'PanoramicStitchPhi0', 161 => 0x5 },
	'panoramicstitchphi1' => { 160 => 'PanoramicStitchPhi1', 161 => 0x6 },
	'panoramicstitchtheta0' => { 160 => 'PanoramicStitchTheta0', 161 => 0x3 },
	'panoramicstitchtheta1' => { 160 => 'PanoramicStitchTheta1', 161 => 0x4 },
	'panoramicstitchversion' => { 161 => 0x0 },
	'pantry' => { 447 => 'Pantry' },
	'parallax' => { 115 => 0xb211, 261 => 0x28 },
	'parametricdarks' => { 422 => 'ParametricDarks' },
	'parametrichighlights' => { 422 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 422 => 'ParametricHighlightSplit' },
	'parametriclights' => { 422 => 'ParametricLights' },
	'parametricmidtonesplit' => { 422 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 422 => 'ParametricShadows' },
	'parametricshadowsplit' => { 422 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 412 => 'ParentMediaEventID' },
	'parentmeid' => { 412 => 'ParentMEID' },
	'parentreference1' => { 430 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 430 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 446 => 'partOfCompilation' },
	'patientbirthdate' => { 406 => 'PatientDOB' },
	'patientid' => { 406 => 'PatientID' },
	'patientname' => { 406 => 'PatientName' },
	'patientsex' => { 406 => 'PatientSex' },
	'pdfversion' => { 433 => 'PDFVersion' },
	'pentaximagesize' => { 317 => 0x9 },
	'pentaxmodelid' => { 297 => 0x0, 317 => 0x5 },
	'pentaxmodeltype' => { 317 => 0x1 },
	'pentaxversion' => { 317 => 0x0 },
	'people' => { 407 => 'People', 414 => 'People' },
	'perchannelblacklevel' => { 39 => 0xc4, 40 => [0x2b4,0x2cb,0x2cf], 41 => 0x108, 42 => 0x1df, 43 => [0x1f8,0x2d8], 44 => [0x22c,0x30a] },
	'peripheralillumcentralradius' => { 404 => 0x8030 },
	'peripheralillumcentralvalue' => { 404 => 0x8031 },
	'peripheralillumination' => { 94 => 0x20702, 100 => 0x68 },
	'peripheralilluminationcorr' => { 56 => 0x1, 307 => 0x2 },
	'peripheralilluminationon' => { 94 => '0x20702.0', 100 => 0x64 },
	'peripheralillumperiphvalue' => { 404 => 0x8032 },
	'peripherallighting' => { 71 => 0x2 },
	'peripherallightingsetting' => { 72 => 0x5 },
	'peripherallightingvalue' => { 71 => 0x6 },
	'permissions' => { 439 => 'permissions' },
	'permits' => { 419 => 'permits' },
	'person' => { 436 => 'person' },
	'personality' => { 412 => 'Personality' },
	'personheard' => { 432 => 'PersonHeard' },
	'personheardidentifier' => { 432 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 432 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 432 => 'PersonInImage' },
	'personinimagecharacteristic' => { 432 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 432 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 432 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 432 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 432 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 432 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 432 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 432 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 432 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 422 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 422 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 422 => 'PerspectiveRotate' },
	'perspectivescale' => { 422 => 'PerspectiveScale' },
	'perspectiveupright' => { 422 => 'PerspectiveUpright' },
	'perspectivevertical' => { 422 => 'PerspectiveVertical' },
	'perspectivex' => { 422 => 'PerspectiveX' },
	'perspectivey' => { 422 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 83 => 0x1 },
	'pf10retainprogramshift' => { 83 => 0xb },
	'pf13drivepriority' => { 83 => 0xe },
	'pf14disablefocussearch' => { 83 => 0xf },
	'pf15disableafassistbeam' => { 83 => 0x10 },
	'pf16autofocuspointshoot' => { 83 => 0x11 },
	'pf17disableafpointsel' => { 83 => 0x12 },
	'pf18enableautoafpointsel' => { 83 => 0x13 },
	'pf19continuousshootspeed' => { 83 => 0x14 },
	'pf19shootingspeedhigh' => { 82 => 0xa },
	'pf19shootingspeedlow' => { 82 => 0x9 },
	'pf1disableshootingmodes' => { 83 => 0x2 },
	'pf1value' => { 82 => 0x1 },
	'pf20limitcontinousshots' => { 83 => 0x15 },
	'pf20maxcontinousshots' => { 82 => 0xb },
	'pf21enablequietoperation' => { 83 => 0x16 },
	'pf23felocktime' => { 82 => 0xd },
	'pf23postreleasetime' => { 82 => 0xe },
	'pf23settimerlengths' => { 83 => 0x18 },
	'pf23shutterbuttontime' => { 82 => 0xc },
	'pf24lightlcdduringbulb' => { 83 => 0x19 },
	'pf25aemode' => { 82 => 0xf },
	'pf25afmode' => { 82 => 0x12 },
	'pf25afpointsel' => { 82 => 0x13 },
	'pf25colormatrix' => { 82 => 0x17 },
	'pf25defaultclearsettings' => { 83 => 0x1a },
	'pf25drivemode' => { 82 => 0x11 },
	'pf25imagesize' => { 82 => 0x14 },
	'pf25meteringmode' => { 82 => 0x10 },
	'pf25parameters' => { 82 => 0x16 },
	'pf25wbmode' => { 82 => 0x15 },
	'pf26shortenreleaselag' => { 83 => 0x1b },
	'pf27reversedialrotation' => { 83 => 0x1c },
	'pf27value' => { 82 => 0x18 },
	'pf28noquickdialexpcomp' => { 83 => 0x1d },
	'pf29quickdialswitchoff' => { 83 => 0x1e },
	'pf2disablemeteringmodes' => { 83 => 0x3 },
	'pf2value' => { 82 => 0x2 },
	'pf30enlargementmode' => { 83 => 0x1f },
	'pf31originaldecisiondata' => { 83 => 0x20 },
	'pf3manualexposuremetering' => { 83 => 0x4 },
	'pf3value' => { 82 => 0x3 },
	'pf4exposuretimelimits' => { 83 => 0x5 },
	'pf4exposuretimemax' => { 82 => 0x5 },
	'pf4exposuretimemin' => { 82 => 0x4 },
	'pf5aperturelimits' => { 83 => 0x6 },
	'pf5aperturemax' => { 82 => 0x7 },
	'pf5aperturemin' => { 82 => 0x6 },
	'pf6presetshootingmodes' => { 83 => 0x7 },
	'pf7bracketcontinuousshoot' => { 83 => 0x8 },
	'pf8bracketshots' => { 82 => 0x8 },
	'pf8setbracketshots' => { 83 => 0x9 },
	'pf9changebracketsequence' => { 83 => 0xa },
	'phasedetectaf' => { 176 => 0x6 },
	'phonenumber' => { 141 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 239 => 0xe9651831 },
	'photoeffects' => { 239 => 0xab5eca5e },
	'photoeffectsblue' => { 241 => 0x8 },
	'photoeffectsgreen' => { 241 => 0x6 },
	'photoeffectsred' => { 241 => 0x4 },
	'photoeffectstype' => { 241 => 0x0 },
	'photographicsensitivity' => { 427 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 246 => '17.6', 255 => '33.6' },
	'photometricinterpretation' => { 110 => 0x106, 442 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 219 => 0xe7d },
	'photoshootingmenubankimagearea' => { 219 => '3716.1' },
	'photoshopbgrthumbnail' => { 331 => 0x409 },
	'photoshopquality' => { 330 => 0x0 },
	'photoshopthumbnail' => { 331 => 0x40c },
	'photostyle' => { 283 => 0x89 },
	'picklabel' => { 425 => 'PickLabel' },
	'pictinfo' => { 351 => 0x208 },
	'picturecontrol' => { 239 => 0xe2173c47 },
	'picturecontrolactive' => { 242 => 0x0 },
	'picturecontroladjust' => { 203 => 0x30, 204 => 0x30 },
	'picturecontrolbase' => { 203 => 0x18, 204 => 0x18 },
	'picturecontroldata' => { 201 => [0xbd,0x23] },
	'picturecontrolmode' => { 242 => 0x13 },
	'picturecontrolname' => { 203 => 0x4, 204 => 0x4 },
	'picturecontrolquickadjust' => { 203 => 0x31, 204 => 0x31 },
	'pictureeffect' => { 372 => 0x200e },
	'pictureeffect2' => { 379 => 0x1163, 380 => 0x1167, 381 => 0x1143, 382 => 0x11bf, 383 => 0x119b, 384 => 0x1053, 385 => 0x24b, 386 => 0x24b, 387 => 0x23c, 400 => 0x46 },
	'picturefinish' => { 165 => 0x71 },
	'picturemode' => { 115 => 0x1031, 262 => 0x520, 317 => [0xb,0x33], 352 => 0x3d },
	'picturemode2' => { 298 => 0x0 },
	'picturemodebwfilter' => { 262 => 0x525 },
	'picturemodecontrast' => { 262 => 0x523 },
	'picturemodeeffect' => { 262 => 0x52d },
	'picturemodehue' => { 262 => 0x522 },
	'picturemodesaturation' => { 262 => 0x521 },
	'picturemodesharpness' => { 262 => 0x524 },
	'picturemodetone' => { 262 => 0x526 },
	'pictureprofile' => { 379 => [0x115e,0x115f], 380 => [0x1162,0x1163], 381 => [0x113e,0x113f], 382 => [0x11ba,0x11bb], 383 => [0x1196,0x1197], 384 => [0x104e,0x104f], 385 => [0x246,0x247], 386 => [0x246,0x247], 387 => [0x237,0x238] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 67 => 0xa, 94 => 0x20301, 100 => 0x2 },
	'picturewizard' => { 349 => 0x21 },
	'picturewizardcolor' => { 348 => 0x1 },
	'picturewizardcontrast' => { 348 => 0x4 },
	'picturewizardmode' => { 348 => 0x0 },
	'picturewizardsaturation' => { 348 => 0x2 },
	'picturewizardsharpness' => { 348 => 0x3 },
	'pipelineversion' => { 160 => 'PipelineVersion' },
	'pitch' => { 106 => 0x6, 247 => '4.1', 259 => '4.1' },
	'pitchangle' => { 218 => 0x350f, 227 => 0x36f8, 262 => 0x904, 283 => 0x91, 316 => 0x2, 347 => 0x1 },
	'pixelshiftresolution' => { 318 => 0x0 },
	'pixelsperunitx' => { 274 => 0x0 },
	'pixelsperunity' => { 274 => 0x4 },
	'pixelunits' => { 274 => 0x8 },
	'planarconfiguration' => { 110 => 0x11c, 442 => 'PlanarConfiguration' },
	'platenames' => { 451 => 'PlateNames' },
	'platform' => { 436 => 'platform' },
	'playbackmenustime' => { 251 => '20.1', 252 => '21.1', 253 => '21.1' },
	'playbackmonitorofftime' => { 246 => '25.2', 247 => '36.1', 249 => '36.1', 250 => '36.1', 254 => '35.1', 255 => '8.1', 256 => '35.1', 259 => '36.1', 260 => '21.1' },
	'playbackzoom' => { 247 => '37.1' },
	'playdisplay' => { 167 => 0x4e },
	'plusversion' => { 272 => 'Version' },
	'pmversion' => { 329 => 'PMVersion' },
	'pngwarning' => { 275 => 'Warning' },
	'poilevel' => { 200 => 0x8 },
	'portraitoutputhighlightpoint' => { 100 => 0x1d },
	'portraitoutputshadowpoint' => { 100 => 0x1e },
	'portraitrawcolortone' => { 100 => 0x16 },
	'portraitrawcontrast' => { 100 => 0x18 },
	'portraitrawhighlight' => { 100 => 0x76 },
	'portraitrawhighlightpoint' => { 100 => 0x1b },
	'portraitrawlinear' => { 100 => 0x19 },
	'portraitrawsaturation' => { 100 => 0x17 },
	'portraitrawshadow' => { 100 => 0x7f },
	'portraitrawshadowpoint' => { 100 => 0x1c },
	'portraitrawsharpness' => { 100 => 0x1a },
	'portraitrefiner' => { 104 => 0x302b },
	'portraitunsharpmaskfineness' => { 100 => 0x9a },
	'portraitunsharpmaskstrength' => { 100 => 0x98 },
	'portraitunsharpmaskthreshold' => { 100 => 0x9c },
	'poseheadingdegrees' => { 410 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 410 => 'PosePitchDegrees' },
	'poserolldegrees' => { 410 => 'PoseRollDegrees' },
	'positiondescriptor' => { 435 => 'positionDescriptor' },
	'postalcode' => { 145 => 'PostalCode' },
	'postcropvignetteamount' => { 422 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 422 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 422 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 422 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 422 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 422 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 370 => 0xb },
	'potentialface2position' => { 370 => 0x15 },
	'potentialface3position' => { 370 => 0x1f },
	'potentialface4position' => { 370 => 0x29 },
	'potentialface5position' => { 370 => 0x33 },
	'potentialface6position' => { 370 => 0x3d },
	'potentialface7position' => { 370 => 0x47 },
	'potentialface8position' => { 370 => 0x51 },
	'powersource' => { 296 => '0.1' },
	'poweruptime' => { 201 => 0xb6 },
	'precaptureframes' => { 267 => 0x300 },
	'predictor' => { 110 => 0x13d },
	'preflashreturnstrength' => { 216 => 0x28a },
	'prefs' => { 118 => 0xdd, 329 => 'Prefs' },
	'preservedfilename' => { 447 => 'PreservedFileName' },
	'presetwhitebalance' => { 167 => 0x24, 404 => 0x8002 },
	'presetwhitebalanceadj' => { 404 => 0x8014 },
	'pressure' => { 110 => 0x9402 },
	'previewapplicationname' => { 110 => 0xc716 },
	'previewapplicationversion' => { 110 => 0xc717 },
	'previewbutton' => { 246 => ['14.1','15.1'], 247 => '15.1', 249 => '15.1', 250 => '15.1', 255 => '29.1', 256 => '14.1', 259 => '15.1' },
	'previewbuttonplusdials' => { 246 => ['14.2','15.2'], 247 => '15.2', 249 => '43.1', 250 => '43.1', 255 => '31.2', 259 => '43.1' },
	'previewcolorspace' => { 110 => 0xc71a },
	'previewcropbottom' => { 328 => 0xef },
	'previewcropleft' => { 328 => 0xec },
	'previewcropright' => { 328 => 0xee },
	'previewcroptop' => { 328 => 0xed },
	'previewdate' => { 336 => 0x0 },
	'previewdatetime' => { 110 => 0xc71b },
	'previewimage' => { 104 => 0x2000, 105 => 'PreviewImage', 111 => 'PreviewImage', 113 => 0x4, 150 => 'data', 169 => 0x81, 267 => 0x280, 282 => 0x300, 372 => 0x2001 },
	'previewimageborders' => { 317 => 0x3e },
	'previewimageheight' => { 66 => 0x4, 128 => 0xfa58 },
	'previewimagelength' => { 66 => 0x2, 104 => 0x3, 110 => [0x117,0x202], 169 => 0x89, 205 => 0x202, 262 => 0x102, 267 => 0x1037, 317 => 0x3, 341 => 0x1e, 346 => 0x3, 352 => [0x1b,0x1d], 363 => 0x202 },
	'previewimagename' => { 150 => '1Name' },
	'previewimagesize' => { 104 => 0x2, 133 => 0x2, 150 => 'ImageSize', 317 => 0x2, 352 => [0x1c,0x1e], 372 => 0xb02c },
	'previewimagestart' => { 66 => 0x5, 104 => 0x4, 110 => [0x111,0x201], 169 => 0x88, 205 => 0x201, 262 => 0x101, 267 => 0x1036, 317 => 0x4, 341 => 0x1c, 346 => 0x2, 352 => [0x1a,0x1c], 363 => 0x201 },
	'previewimagetype' => { 150 => '0Type' },
	'previewimagevalid' => { 262 => 0x100, 267 => 0x1035 },
	'previewimagewidth' => { 66 => 0x3, 128 => 0xfa57 },
	'previewquality' => { 66 => 0x1 },
	'previewsettingsdigest' => { 110 => 0xc719 },
	'previewsettingsname' => { 110 => 0xc718 },
	'primaryafpoint' => { 176 => 0x7 },
	'primarychromaticities' => { 110 => 0x13f, 442 => 'PrimaryChromaticities' },
	'primaryftp' => { 412 => 'PrimaryFTP' },
	'primaryslot' => { 219 => 0xe7f },
	'printim' => { 110 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 167 => 0x1d, 360 => 0x28 },
	'privatertkinfo' => { 413 => 'privateRTKInfo' },
	'processingsoftware' => { 110 => 0xb },
	'processversion' => { 422 => 'ProcessVersion' },
	'producer' => { 271 => 'Producer', 433 => 'Producer' },
	'productcode' => { 436 => 'productCode' },
	'productid' => { 119 => 0x32, 435 => 'productID' },
	'productidtype' => { 435 => 'productIDType' },
	'productinimage' => { 432 => 'ProductInImage' },
	'productinimagedescription' => { 432 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 432 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 432 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 297 => 0x2 },
	'productorserviceconstraints' => { 272 => 'ProductOrServiceConstraints' },
	'profession' => { 436 => 'profession' },
	'profilecalibrationsig' => { 110 => 0xc6f4 },
	'profilecopyright' => { 110 => 0xc6fe },
	'profileembedpolicy' => { 110 => 0xc6fd },
	'profilehuesatmapdata1' => { 110 => 0xc6fa },
	'profilehuesatmapdata2' => { 110 => 0xc6fb },
	'profilehuesatmapdims' => { 110 => 0xc6f9 },
	'profilehuesatmapencoding' => { 110 => 0xc7a3 },
	'profilelooktabledata' => { 110 => 0xc726 },
	'profilelooktabledims' => { 110 => 0xc725 },
	'profilelooktableencoding' => { 110 => 0xc7a4 },
	'profilename' => { 110 => 0xc6f8 },
	'profiletonecurve' => { 110 => 0xc6fc },
	'programiso' => { 283 => 0x3c },
	'programline' => { 298 => '1.1' },
	'programmode' => { 172 => 0x5 },
	'programshift' => { 201 => 0xd },
	'programversion' => { 118 => 0x46 },
	'prohibits' => { 419 => 'prohibits' },
	'projectiontype' => { 410 => 'ProjectionType', 411 => 'ProjectionType' },
	'projectname' => { 446 => 'projectName' },
	'projectref' => { 446 => 'projectRef' },
	'projectrefpath' => { 446 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 446 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 272 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 272 => 'PropertyReleaseStatus' },
	'province-state' => { 118 => 0x5f },
	'publicationdate' => { 436 => 'publicationDate' },
	'publicationdatea-platform' => { 436 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 436 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 436 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 436 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 436 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 432 => 'PublicationEvent' },
	'publicationeventdate' => { 432 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 432 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 432 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 436 => 'publicationName' },
	'publisher' => { 423 => 'publisher' },
	'publishingfrequency' => { 436 => 'publishingFrequency' },
	'pulldown' => { 446 => 'pullDown' },
	'purplehsl' => { 94 => 0x20916 },
	'quality' => { 0 => 0x1, 33 => 0x3, 103 => 0x2, 104 => 0x3002, 115 => 0x1000, 126 => 0x9, 201 => 0x4, 229 => 0x3, 267 => 0x201, 279 => 0x300, 317 => 0x8, 324 => 0x2, 352 => 0x16, 360 => 0x56, 361 => 0x56, 362 => 0xb, 372 => 0x102 },
	'quality2' => { 379 => 0x1170, 380 => 0x1174, 381 => 0x1150, 383 => 0x11a8, 384 => 0x1060, 385 => 0x258, 386 => 0x258, 387 => 0x247, 391 => 0x29, 392 => 0x25, 393 => 0x2a },
	'qualitymode' => { 104 => 0x8 },
	'quantizationmethod' => { 120 => 0x78 },
	'quickadjust' => { 242 => 0x2a },
	'quickcontroldialinmeter' => { 75 => 0x703 },
	'quickfix' => { 239 => 0x416391c6 },
	'quickshot' => { 351 => 0x213 },
	'rangefinder' => { 251 => '4.1', 252 => '5.1', 253 => '5.1' },
	'rasterizedcaption' => { 118 => 0x7d },
	'rating' => { 110 => 0x4746, 115 => 0x1431, 328 => 0xdf, 372 => 0x2002, 416 => 'rating', 424 => 'rating', 432 => 'Rating', 436 => 'rating', 444 => 'Rating' },
	'ratingpercent' => { 110 => 0x4749, 162 => 'Rating' },
	'ratingratingregion' => { 432 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 432 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 432 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 432 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 432 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 432 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 432 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 432 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 432 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 432 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 432 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 432 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 432 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 432 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 432 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 432 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 432 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 432 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 73 => 0x8, 169 => 0x109, 298 => 0xd },
	'rawbrightnessadj' => { 94 => 0x20001, 99 => 0x38 },
	'rawcoloradj' => { 99 => 0x2e },
	'rawcropbottom' => { 328 => 0xd4 },
	'rawcropleft' => { 328 => 0xd1 },
	'rawcropright' => { 328 => 0xd3 },
	'rawcroptop' => { 328 => 0xd2 },
	'rawcustomsaturation' => { 99 => 0x30 },
	'rawcustomtone' => { 99 => 0x34 },
	'rawdata' => { 349 => 0xa048 },
	'rawdatabyteorder' => { 349 => 0x40 },
	'rawdatacfapattern' => { 349 => 0x50 },
	'rawdatauniqueid' => { 110 => 0xc65d },
	'rawdepth' => { 171 => 0x10 },
	'rawdevartfilter' => { 269 => 0x121 },
	'rawdevautogradation' => { 269 => 0x119 },
	'rawdevcolorspace' => { 268 => 0x108, 269 => 0x109 },
	'rawdevcontrastvalue' => { 268 => 0x106, 269 => 0x105 },
	'rawdeveditstatus' => { 268 => 0x10b },
	'rawdevelopmentprocess' => { 317 => 0x62 },
	'rawdevengine' => { 268 => 0x109, 269 => 0x10b },
	'rawdevexposurebiasvalue' => { 268 => 0x100, 269 => 0x100 },
	'rawdevgradation' => { 269 => 0x112 },
	'rawdevgraypoint' => { 268 => 0x103, 269 => 0x104 },
	'rawdevmemorycoloremphasis' => { 268 => 0x105, 269 => 0x108 },
	'rawdevnoisereduction' => { 268 => 0x10a, 269 => 0x10a },
	'rawdevpicturemode' => { 269 => 0x10c },
	'rawdevpm_bwfilter' => { 269 => 0x110 },
	'rawdevpmcontrast' => { 269 => 0x10e },
	'rawdevpmnoisefilter' => { 269 => 0x120 },
	'rawdevpmpicturetone' => { 269 => 0x111 },
	'rawdevpmsaturation' => { 269 => 0x10d },
	'rawdevpmsharpness' => { 269 => 0x10f },
	'rawdevsaturation3' => { 269 => 0x113 },
	'rawdevsaturationemphasis' => { 268 => 0x104, 269 => 0x107 },
	'rawdevsettings' => { 268 => 0x10c },
	'rawdevsharpnessvalue' => { 268 => 0x107, 269 => 0x106 },
	'rawdevversion' => { 268 => 0x0, 269 => 0x0 },
	'rawdevwbfineadjustment' => { 268 => 0x102, 269 => 0x103 },
	'rawdevwhitebalance' => { 269 => 0x101 },
	'rawdevwhitebalancevalue' => { 268 => 0x101, 269 => 0x102 },
	'rawfile' => { 110 => 0xfe4c },
	'rawfilename' => { 422 => 'RawFileName' },
	'rawfiletype' => { 372 => 0x2029 },
	'rawformat' => { 326 => 0x10e },
	'rawimagecenter' => { 201 => 0x99 },
	'rawimagedigest' => { 110 => 0xc71c },
	'rawimagesize' => { 317 => 0x39 },
	'rawinfoversion' => { 270 => 0x0 },
	'rawjpgheight' => { 90 => 0x4 },
	'rawjpgquality' => { 51 => 0x6, 90 => 0x1 },
	'rawjpgsize' => { 51 => 0x7, 90 => 0x2 },
	'rawjpgwidth' => { 90 => 0x3 },
	'rawmeasuredrggb' => { 38 => 0x26a, 40 => 0x280, 42 => 0x194, 43 => [0x1ad,0x26b] },
	'rawrppused' => { 416 => 'rawrppused' },
	'rawtopreviewgain' => { 110 => 0xc7a8 },
	'reardisplay' => { 246 => '12.3', 247 => '6.2' },
	'recipeendingpage' => { 438 => 'recipeEndingPage' },
	'recipepagerange' => { 438 => 'recipePageRange' },
	'recipesource' => { 438 => 'recipeSource' },
	'recipestartingpage' => { 438 => 'recipeStartingPage' },
	'recipetitle' => { 438 => 'recipeTitle' },
	'recognizedface1age' => { 278 => 0x20 },
	'recognizedface1name' => { 278 => 0x4 },
	'recognizedface1position' => { 278 => 0x18 },
	'recognizedface2age' => { 278 => 0x50 },
	'recognizedface2name' => { 278 => 0x34 },
	'recognizedface2position' => { 278 => 0x48 },
	'recognizedface3age' => { 278 => 0x80 },
	'recognizedface3name' => { 278 => 0x64 },
	'recognizedface3position' => { 278 => 0x78 },
	'recognizedfaceflags' => { 283 => 0x63 },
	'recommendedexposureindex' => { 110 => 0x8832, 427 => 'RecommendedExposureIndex' },
	'record' => { 109 => 'Record' },
	'recordbasisofrecord' => { 109 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 109 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 109 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 109 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 109 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 109 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 167 => 0x4d },
	'recorddynamicproperties' => { 109 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 88 => 0x1804 },
	'recordinformationwithheld' => { 109 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 342 => 0x1000 },
	'recordingmode' => { 103 => 0x1, 324 => 0x1 },
	'recordinstitutioncode' => { 109 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 109 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 104 => 0x3000 },
	'recordownerinstitutioncode' => { 109 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 351 => 0x217 },
	'redbalance' => { 184 => 0x270, 267 => 0x1017, 287 => 0x11, 317 => 0x1c },
	'redcurvelimits' => { 99 => 0x18a },
	'redcurvepoints' => { 98 => 0x2d, 99 => 0x160 },
	'redeyecorrection' => { 243 => 0x0 },
	'redeyeinfo' => { 422 => 'RedEyeInfo' },
	'redeyereduction' => { 167 => 0x41, 360 => 0x6a, 362 => 0x28 },
	'redhsl' => { 94 => 0x20910 },
	'redhue' => { 422 => 'RedHue' },
	'redsaturation' => { 422 => 'RedSaturation' },
	'reductionmatrix1' => { 110 => 0xc625 },
	'reductionmatrix2' => { 110 => 0xc626 },
	'reelname' => { 110 => 0xc789 },
	'reference1' => { 430 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 430 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 110 => 0x214, 442 => 'ReferenceBlackWhite' },
	'referencedate' => { 118 => 0x2f },
	'referencenumber' => { 118 => 0x32 },
	'references' => { 141 => 'References' },
	'referenceservice' => { 118 => 0x2d },
	'regionappliedtodimensions' => { 156 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 156 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 156 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 156 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 156 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 156 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 156 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 156 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 156 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 156 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 156 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 156 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 272 => 'RegionConstraints' },
	'regiondescription' => { 156 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 156 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 156 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 156 => 'Regions' },
	'regioninfodateregionsvalid' => { 159 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 159 => 'RegionInfo' },
	'regioninforegions' => { 159 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 156 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 156 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 159 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 159 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 159 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 159 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 159 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 156 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 156 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 156 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 432 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 432 => 'RegistryId' },
	'registryitemid' => { 432 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 432 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 139 => 'data' },
	'relatedaudiofilename' => { 139 => '1Name' },
	'relatedaudiofiletype' => { 139 => '0Type' },
	'relatedimagefileformat' => { 110 => 0x1000 },
	'relatedimageheight' => { 110 => 0x1002 },
	'relatedimagewidth' => { 110 => 0x1001 },
	'relatedresourceid' => { 109 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 110 => 0xa004, 426 => 'RelatedSoundFile' },
	'relatedvideofile' => { 153 => 'data' },
	'relatedvideofilename' => { 153 => '1Name' },
	'relatedvideofiletype' => { 153 => '0Type' },
	'relation' => { 423 => 'relation' },
	'relationshipaccordingto' => { 109 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 109 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 109 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 109 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 107 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 446 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 446 => 'relativeTimestamp' },
	'relativetimestampscale' => { 446 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 446 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 246 => '17.8', 247 => '18.5', 249 => '18.4', 250 => '18.4', 255 => '33.8', 256 => '17.6', 259 => '18.5' },
	'releasedate' => { 118 => 0x1e, 416 => 'ReleaseDate', 446 => 'releaseDate' },
	'releasemode' => { 104 => 0x3001, 218 => 0x184d, 372 => 0xb049 },
	'releasemode2' => { 379 => 0x112c, 380 => [0x112c,0x8], 381 => [0x1108,0x8], 382 => [0x1184,0x8], 383 => [0x1160,0x8], 384 => [0x4,0x1018], 385 => [0x4,0x210], 386 => [0x4,0x210], 387 => [0x4,0x208], 389 => [0x67,0x3f], 390 => [0x73,0x4b], 391 => 0x10, 392 => 0x10, 393 => 0x9, 400 => 0x34 },
	'releasemode3' => { 379 => 0x1128, 380 => 0x1128, 381 => 0x1104, 382 => 0x1180, 383 => 0x115c, 384 => 0x1014, 385 => 0x20c, 386 => 0x20c, 387 => 0x204 },
	'releaseready' => { 432 => 'ReleaseReady' },
	'releasesetting' => { 88 => 0x1016 },
	'releasetime' => { 118 => 0x23, 416 => 'ReleaseTime' },
	'remoteonduration' => { 248 => '3.4', 251 => '17.2', 252 => '18.2', 253 => '18.2', 254 => '18.2', 256 => '18.2', 257 => '4.3', 260 => '19.2' },
	'renditionclass' => { 447 => 'RenditionClass' },
	'renditionof' => { 447 => 'RenditionOf' },
	'renditionofalternatepaths' => { 447 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 447 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 447 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 447 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 447 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 447 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 447 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 447 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 447 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 447 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 447 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 447 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 447 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 447 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 447 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 447 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 447 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 447 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 447 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 447 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 447 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 447 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 447 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 447 => 'RenditionParams' },
	'repeatingflashcount' => { 189 => 0xd, 190 => 0xe, 191 => 0xe, 192 => 0xe, 255 => '17.2', 256 => '24.2', 257 => '9.2', 258 => '24.2', 260 => '25.2' },
	'repeatingflashcountbuilt-in' => { 226 => 0x4db },
	'repeatingflashcountexternal' => { 226 => 0x4c3 },
	'repeatingflashoutput' => { 255 => '17.1', 256 => '24.1', 257 => '9.1', 258 => '24.1', 260 => '25.1' },
	'repeatingflashoutputexternal' => { 226 => 0x4c0 },
	'repeatingflashrate' => { 189 => 0xc, 190 => 0xd, 191 => 0xd, 192 => 0xd, 255 => '18.1', 256 => '25.1', 257 => '10.1', 258 => '25.1', 260 => '26.1' },
	'repeatingflashratebuilt-in' => { 226 => 0x4da },
	'repeatingflashrateexternal' => { 226 => 0x4c2 },
	'requires' => { 419 => 'requires' },
	'resampleparams' => { 446 => 'resampleParams' },
	'resampleparamsquality' => { 446 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 351 => 0x21e },
	'resolution' => { 146 => 'Resolution' },
	'resolutionmode' => { 352 => 0x4 },
	'resolutionunit' => { 110 => 0x128, 121 => 0x2, 442 => 'ResolutionUnit' },
	'resourceid' => { 109 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 109 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 109 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 75 => 0x612 },
	'restrictions' => { 439 => 'restrictions' },
	'retouchareafeather' => { 422 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 422 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 422 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 422 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 422 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 422 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 422 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 422 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 422 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 422 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 422 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 422 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 422 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 422 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 422 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 422 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 422 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 422 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 422 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 422 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 422 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 422 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 422 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 422 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 422 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 422 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 422 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 422 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 422 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 422 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 422 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 422 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 422 => 'RetouchAreas' },
	'retouchareaseed' => { 422 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 422 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 422 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 422 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 201 => 0x9e },
	'retouchinfo' => { 422 => 'RetouchInfo' },
	'retouchnefprocessing' => { 207 => 0x5 },
	'retractlensonpoweroff' => { 75 => 0x814 },
	'reuse' => { 272 => 'Reuse' },
	'reuseallowed' => { 449 => 'ReuseAllowed' },
	'reuseprohibited' => { 439 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 253 => '5.2' },
	'reverseindicators' => { 246 => '12.1', 247 => '6.1', 249 => '6.1', 250 => '6.1', 251 => '4.3', 252 => '5.2', 253 => '5.4', 255 => '33.5', 256 => '5.1', 259 => '6.1', 260 => '6.2' },
	'reverseshutterspeedaperture' => { 253 => '5.3' },
	'revision' => { 424 => 'revision' },
	'rgbcurvelimits' => { 99 => 0x238 },
	'rgbcurvepoints' => { 98 => 0x7, 99 => 0x20e },
	'richtextcomment' => { 429 => 'RichTextComment' },
	'ricohdate' => { 341 => 0x6 },
	'ricohimageheight' => { 341 => 0x2 },
	'ricohimagewidth' => { 341 => 0x0 },
	'rightascension' => { 149 => 'RightAscension' },
	'rights' => { 423 => 'rights' },
	'rightsagent' => { 439 => 'rightsAgent' },
	'rightsowner' => { 439 => 'rightsOwner' },
	'roll' => { 106 => 0x8 },
	'rollangle' => { 218 => 0x350b, 227 => 0x36f4, 262 => 0x903, 283 => 0x90, 316 => 0x1, 347 => 0x2 },
	'romoperationmode' => { 88 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 87 => 0x3, 94 => 0x10002, 99 => 0x26e, 114 => 0x4, 149 => 'Rotation', 165 => [0x65,0x50], 166 => 0x46, 167 => 0x5a, 170 => 0x10, 218 => 0x3693, 219 => 0xca, 225 => '590.1', 227 => 0x38be, 239 => 0x76a43207, 283 => 0x30, 298 => '17.2', 328 => 0xd8, 360 => 0x3f, 361 => 0x3f, 371 => 0x10 },
	'routedto' => { 428 => 'RoutedTo' },
	'routing' => { 333 => 'Routing' },
	'routingdestinations' => { 412 => 'RoutingDestinations' },
	'routingexclusions' => { 412 => 'RoutingExclusions' },
	'routingnotes' => { 428 => 'RoutingNotes' },
	'rowsperstrip' => { 110 => 0x116 },
	'rpp' => { 416 => 'rpp' },
	'safetyshift' => { 75 => 0x108 },
	'safetyshiftinavortv' => { 73 => 0x10, 74 => 0x10, 76 => 0xf, 77 => 0x10, 80 => 0x10 },
	'sameexposurefornewaperture' => { 75 => 0x112 },
	'samplebits' => { 139 => 'SampleBits' },
	'samplepagerange' => { 436 => 'samplePageRange' },
	'samplerate' => { 139 => 'SampleRate' },
	'samplesperpixel' => { 110 => 0x115, 442 => 'SamplesPerPixel' },
	'samplestructure' => { 120 => 0x5a },
	'samsungmodelid' => { 349 => 0x3 },
	'sanyoquality' => { 351 => 0x201 },
	'sanyothumbnail' => { 351 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 45 => 0x1, 103 => 0xd, 104 => [0x3013,0x1f], 110 => [0xa409,0xfe55], 115 => 0x1003, 140 => 'Saturation', 164 => 0x1f, 165 => 0x32, 166 => 0x28, 167 => 0x1a, 172 => 0x1, 201 => [0x94,0xaa], 203 => 0x35, 204 => 0x3b, 283 => 0x40, 285 => 0x300d, 317 => 0x1f, 324 => 0xd, 338 => 0x27, 341 => 0x28, 342 => 0x1013, 352 => 0x10, 360 => 0x1e, 361 => 0x1b, 372 => 0x2005, 422 => 'Saturation', 426 => 'Saturation' },
	'saturationadj' => { 94 => 0x20901, 99 => 0x116, 238 => 0x1, 242 => 0x2e, 404 => 0x8016 },
	'saturationadjustmentaqua' => { 422 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 422 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 422 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 422 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 422 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 422 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 422 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 422 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 64 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 63 => 0x68, 64 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 63 => 0x38, 64 => 0x38 },
	'saturationmonochrome' => { 63 => 0x80, 64 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 63 => 0x50, 64 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 63 => 0x20, 64 => 0x20 },
	'saturationsetting' => { 270 => 0x1010, 362 => 0x11, 376 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 63 => 0x8, 64 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 63 => 0x98, 64 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 63 => 0xb0, 64 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 63 => 0xc8, 64 => 0xe0 },
	'saveid' => { 447 => 'SaveID' },
	'scaletype' => { 446 => 'scaleType' },
	'scanimageenhancer' => { 208 => 0x60 },
	'scanningdirection' => { 120 => 0x64 },
	'scene' => { 431 => 'Scene', 446 => 'scene' },
	'scenearea' => { 265 => 0x211, 267 => 0x1031 },
	'sceneassist' => { 201 => 0x9c },
	'scenecapturetype' => { 110 => 0xa406, 426 => 'SceneCaptureType' },
	'scenedetect' => { 265 => 0x210, 267 => 0x1030 },
	'scenedetectdata' => { 265 => 0x212, 267 => 0x1033 },
	'scenemode' => { 128 => 0xfa02, 169 => 0x100, 201 => 0x8f, 262 => 0x509, 267 => 0x403, 283 => 0x8001, 291 => 0xf, 372 => 0xb023 },
	'scenemodeused' => { 130 => [0x6002,0xf002] },
	'scenerecognition' => { 115 => 0x1425 },
	'sceneselect' => { 351 => 0x21f },
	'scenetype' => { 110 => 0xa301, 426 => 'SceneType' },
	'screentips' => { 246 => '12.7', 247 => '5.3', 255 => '13.1', 256 => '4.4', 259 => '5.4', 260 => '5.1' },
	'season' => { 432 => 'Season', 435 => 'season' },
	'seasonidentifier' => { 432 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 432 => [\'Season','SeasonName'] },
	'seasonnumber' => { 432 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 412 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 218 => 0x1d0, 227 => 0x1d0 },
	'section' => { 436 => 'section' },
	'securityclassification' => { 110 => 0x9212 },
	'selectableafpoint' => { 75 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 75 => 0x512 },
	'selftimer' => { 33 => 0x2, 283 => 0x2e, 351 => 0x214, 379 => 0x1134, 380 => 0x1134, 381 => 0x1110, 382 => 0x118c, 383 => 0x1168, 384 => 0x1020, 385 => 0x218, 386 => 0x218, 387 => 0x210 },
	'selftimer2' => { 69 => 0x1d },
	'selftimerinterval' => { 256 => '19.2' },
	'selftimermode' => { 110 => 0x882b },
	'selftimershotcount' => { 247 => '20.2', 249 => '20.3', 250 => '20.3', 251 => '18.2', 252 => '19.2', 253 => '19.2', 254 => '19.3', 256 => '19.3', 259 => '20.3', 260 => '20.2' },
	'selftimershotinterval' => { 247 => '20.3', 249 => '20.2', 250 => '20.2', 254 => '19.2', 259 => '20.2' },
	'selftimertime' => { 88 => 0x1806, 167 => 0x1f, 246 => '18.1', 247 => '20.1', 248 => '3.3', 249 => '20.1', 250 => '20.1', 251 => '18.1', 252 => '19.1', 253 => '19.1', 254 => '19.1', 255 => '7.2', 256 => '19.1', 257 => '3.3', 259 => '20.1', 260 => '20.1' },
	'sellingagency' => { 436 => 'sellingAgency' },
	'seminfo' => { 110 => 0x8546 },
	'sensingmethod' => { 110 => 0xa217, 426 => 'SensingMethod' },
	'sensitivityadjust' => { 317 => 0x40 },
	'sensitivitysteps' => { 298 => ['14.3','17.4'], 300 => 0x1 },
	'sensitivitytype' => { 110 => 0x8830, 427 => 'SensitivityType' },
	'sensor' => { 174 => 0x665e },
	'sensorareas' => { 349 => 0xa010 },
	'sensorbitdepth' => { 285 => 0x312d },
	'sensorbluelevel' => { 67 => 0x5 },
	'sensorcalibration' => { 266 => 0x805 },
	'sensorcleaning' => { 81 => 0xd },
	'sensorfullheight' => { 123 => 0xf904 },
	'sensorfullwidth' => { 123 => 0xf903 },
	'sensorheight' => { 123 => 0xf901, 128 => 0xfa21, 171 => 0x8, 285 => 0x312c, 326 => 0x109, 342 => 0x1602 },
	'sensorleftmargin' => { 326 => 0x10a },
	'sensorpixelsize' => { 201 => 0x9a },
	'sensorredlevel' => { 67 => 0x4 },
	'sensorserialnumber' => { 124 => 0x9ce },
	'sensorsize' => { 140 => 'SensorSize', 317 => 0x35 },
	'sensortemperature' => { 265 => 0x1500, 267 => 0x1007, 322 => 0xc, 326 => 0x210, 352 => [0x39,0x55] },
	'sensortemperature2' => { 322 => 0xe, 326 => 0x211 },
	'sensortopmargin' => { 326 => 0x10b },
	'sensorwidth' => { 123 => 0xf900, 128 => 0xfa20, 171 => 0xa, 285 => 0x312b, 326 => 0x108, 342 => 0x1601 },
	'sequence' => { 338 => 0x7 },
	'sequencefilenumber' => { 380 => 0x4, 381 => 0x4, 382 => 0x4, 383 => 0x4, 391 => 0xc, 392 => 0xc, 393 => 0x1a },
	'sequenceimagenumber' => { 380 => 0x0, 381 => 0x0, 382 => 0x0, 383 => 0x0, 391 => 0x8, 392 => 0x8, 393 => 0x12, 400 => 0x24 },
	'sequencelength' => { 391 => 0x22, 392 => 0x1e, 393 => [0x16,0x1e] },
	'sequencename' => { 435 => 'sequenceName' },
	'sequencenumber' => { 69 => 0x9, 104 => 0x301c, 115 => 0x1101, 126 => 0x1d, 226 => 0x51c, 283 => 0x2b, 362 => [0x10c,0x30c], 372 => 0xb04a, 435 => 'sequenceNumber' },
	'sequenceshotinterval' => { 351 => 0x224 },
	'sequencetotalnumber' => { 435 => 'sequenceTotalNumber' },
	'sequentialshot' => { 351 => 0x20e },
	'serialnumber' => { 57 => 0xc, 88 => 0x180b, 110 => [0xa431,0xfde9], 123 => 0xfa04, 125 => 0xfa00, 127 => 0xc354, 128 => 0xfa19, 137 => 0x0, 140 => 'SerialNumber', 201 => [0xa0,0x1d], 263 => 0x101, 267 => [0x404,0x101a], 279 => 0x303, 285 => 0x3103, 317 => 0x229, 326 => 0x102, 327 => 0x407, 338 => 0x15, 342 => 0x5, 352 => 0x2, 418 => 'SerialNumber', 427 => 'BodySerialNumber' },
	'serialnumberformat' => { 57 => 0x15, 88 => 0x183b },
	'series' => { 432 => 'Series' },
	'seriesdatetime' => { 406 => 'SeriesDateTime' },
	'seriesdescription' => { 406 => 'SeriesDescription' },
	'seriesidentifier' => { 432 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 406 => 'SeriesModality' },
	'seriesname' => { 432 => [\'Series','SeriesName'] },
	'seriesnumber' => { 406 => 'SeriesNumber', 436 => 'seriesNumber' },
	'seriestitle' => { 436 => 'seriesTitle' },
	'serviceidentifier' => { 119 => 0x1e },
	'servingsize' => { 438 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 78 => 0x0, 79 => 0x0 },
	'setbuttonwhenshooting' => { 73 => 0x1, 75 => 0x704, 81 => 0xc },
	'setfunctionwhenshooting' => { 76 => 0x0, 77 => 0x1, 80 => 0x1 },
	'setting' => { 435 => 'setting' },
	'shadingcompensation' => { 262 => 0x50c, 283 => 0x8a },
	'shadingcompensation2' => { 266 => 0x1012 },
	'shadow' => { 352 => 0xe },
	'shadowadj' => { 94 => 0x2030b },
	'shadowcorrection' => { 317 => 0x79 },
	'shadowprotection' => { 238 => 0x0 },
	'shadows' => { 110 => 0xfe52, 415 => 'Shadows', 422 => 'Shadows' },
	'shadows2012' => { 422 => 'Shadows2012' },
	'shadowscale' => { 110 => 0xc633 },
	'shadowtint' => { 422 => 'ShadowTint' },
	'shadowtone' => { 115 => 0x1040 },
	'shakereduction' => { 319 => 0x1, 320 => 0x1 },
	'sharpendetail' => { 422 => 'SharpenDetail' },
	'sharpenedgemasking' => { 422 => 'SharpenEdgeMasking' },
	'sharpening' => { 285 => 0x300b },
	'sharpeningadj' => { 242 => 0x2b },
	'sharpenradius' => { 422 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 67 => 0x2, 103 => 0xb, 104 => [0x3011,0x21], 110 => [0xa40a,0xfe56], 115 => 0x1001, 126 => 0x6b, 135 => 0x37, 140 => 'Sharpness', 164 => 0x21, 165 => 0x30, 166 => 0x26, 167 => 0x18, 172 => 0x3, 201 => 0x6, 203 => 0x32, 204 => 0x33, 267 => 0x100f, 283 => 0x41, 317 => 0x21, 324 => 0xb, 338 => 0x26, 341 => 0x22, 342 => [0x1003,0x1014], 352 => 0x11, 360 => 0x1c, 361 => 0x19, 372 => 0x2006, 400 => 0x52, 422 => 'Sharpness', 426 => 'Sharpness' },
	'sharpnessadj' => { 94 => 0x20310, 99 => 0x25a, 404 => 0x801a },
	'sharpnessadjon' => { 94 => '0x20310.0' },
	'sharpnessauto' => { 64 => 0x94 },
	'sharpnessfactor' => { 267 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 63 => 0x64, 64 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 67 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 63 => 0x34, 64 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 63 => 0x7c, 64 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 63 => 0x4c, 64 => 0x4c },
	'sharpnessovershoot' => { 404 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 63 => 0x1c, 64 => 0x1c },
	'sharpnesssetting' => { 262 => 0x506, 270 => 0x1013, 362 => 0x12, 376 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 63 => 0x4, 64 => 0x4 },
	'sharpnessstrength' => { 94 => 0x20311 },
	'sharpnessthreshold' => { 404 => 0x801d },
	'sharpnessundershoot' => { 404 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 63 => 0x94, 64 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 63 => 0xac, 64 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 63 => 0xc4, 64 => 0xdc },
	'shootid' => { 435 => 'shootID' },
	'shootingdistance' => { 94 => 0x20701 },
	'shootinginfodisplay' => { 246 => '13.2', 247 => '5.1', 255 => '10.2', 256 => '4.1', 259 => '5.1', 260 => '5.3' },
	'shootinginfomonitorofftime' => { 246 => '26.2', 247 => '22.2', 249 => '22.2', 250 => '22.2', 254 => '21.2', 255 => '9.1', 256 => '21.2', 259 => '22.2', 260 => '22.2' },
	'shootingmode' => { 140 => 'ShootingMode', 201 => 0x89, 283 => 0x1f },
	'shootingmodesetting' => { 248 => '5.1' },
	'shortdescription' => { 424 => 'shortdescription' },
	'shortdocumentid' => { 118 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 75 => 0x80d },
	'shotdate' => { 446 => 'shotDate' },
	'shotday' => { 446 => 'shotDay' },
	'shotlocation' => { 446 => 'shotLocation' },
	'shotname' => { 446 => 'shotName' },
	'shotnumber' => { 446 => 'shotNumber' },
	'shotnumbersincepowerup' => { 375 => 0x44e, 391 => 0x1a, 392 => 0x16, 393 => 0xa },
	'shotnumbersincepowerup2' => { 362 => 0x200 },
	'shotsize' => { 446 => 'shotSize' },
	'shownevent' => { 432 => 'EventExt' },
	'showneventidentifier' => { 432 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 432 => [\'EventExt','EventExtName'] },
	'shutter-aelock' => { 73 => 0x4, 75 => 0x701, 76 => 0x3, 77 => 0x4, 78 => 0x3, 79 => 0x3, 80 => 0x4, 81 => 0x2 },
	'shutteraelbutton' => { 74 => 0x4 },
	'shutterbuttonafonbutton' => { 75 => 0x701 },
	'shuttercount' => { 10 => 0x176, 51 => 0x1, 201 => 0xa7, 209 => [0x6a,0x157,0x24d], 210 => 0x286, 211 => 0x279, 212 => 0x284, 213 => 0x242, 214 => 0x280, 215 => 0x276, 216 => [0x27d,0x27f], 217 => 0x246, 220 => 0x2d6, 221 => 0x321, 222 => 0xbd8, 223 => 0x287, 224 => 0x320, 225 => 0x24a, 226 => 0x5fb, 228 => 0x2d5, 317 => 0x5d, 371 => 0x846, 374 => [0x125,0x14a] },
	'shuttercurtainsync' => { 73 => 0xf, 74 => 0xf, 75 => 0x305, 76 => 0xe, 77 => 0xf, 78 => 0x8, 79 => 0x8, 80 => 0xf, 81 => 0x8 },
	'shuttermode' => { 126 => 0x1b },
	'shutterreleasebuttonae-l' => { 246 => '17.7', 247 => '18.4', 249 => '78.4', 250 => '78.4', 251 => '16.1', 252 => '17.1', 253 => '17.1', 254 => '17.1', 255 => '7.1', 256 => '17.5', 259 => '18.4', 260 => '18.2' },
	'shutterreleasemethod' => { 88 => 0x1010 },
	'shutterreleasenocfcard' => { 73 => 0x2, 74 => 0x2, 81 => 0xf },
	'shutterreleasetiming' => { 88 => 0x1011 },
	'shutterreleasewithoutlens' => { 75 => 0x711 },
	'shutterspeedlock' => { 247 => '38.1', 249 => '38.1', 250 => '38.1', 259 => '38.1' },
	'shutterspeedrange' => { 75 => 0x10c },
	'shutterspeedsetting' => { 167 => 0x6, 360 => 0x2f, 361 => 0x28, 362 => 0x0 },
	'shutterspeedvalue' => { 84 => 0x1, 110 => 0x9201, 267 => 0x1000, 326 => 0x400, 426 => 'ShutterSpeedValue' },
	'shuttertype' => { 115 => 0x1050, 283 => 0x9f },
	'sidecarforextension' => { 434 => 'SidecarForExtension' },
	'similarityindex' => { 118 => 0xe4 },
	'singleframebracketing' => { 167 => 0x21 },
	'skilllevel' => { 438 => 'skillLevel' },
	'skintonecorrection' => { 317 => 0x95 },
	'slaveflashmeteringsegments' => { 317 => 0x20b },
	'slideshowname' => { 435 => 'slideshowName' },
	'slideshownumber' => { 435 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 435 => 'slideshowTotalNumber' },
	'slowshutter' => { 69 => 0x8 },
	'slowsync' => { 115 => 0x1030 },
	'smartalbumcolor' => { 349 => 0x20 },
	'smartrange' => { 349 => 0xa012 },
	'smileshutter' => { 362 => 0x31 },
	'smileshuttermode' => { 362 => 0x27 },
	'smoothness' => { 110 => 0xfe57, 422 => 'Smoothness' },
	'snapshot' => { 432 => 'SnapshotLink' },
	'snapshotformat' => { 432 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 432 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 432 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 432 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 432 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 416 => 'Snapshots' },
	'snapshotusedvideoframe' => { 432 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 432 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 432 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 432 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 432 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 372 => 0x200f },
	'software' => { 110 => 0x131, 141 => 'Software', 275 => 'Software', 326 => 0x203, 352 => 0x18, 442 => 'Software' },
	'softwareversion' => { 351 => 0x207 },
	'sonydatetime' => { 378 => 0x6, 380 => 0x1b6, 381 => 0x210, 382 => 0x1fe, 383 => 0x22c },
	'sonydatetime2' => { 389 => 0x51 },
	'sonyexposuretime' => { 389 => 0x3a, 390 => 0x46 },
	'sonyexposuretime2' => { 400 => 0xe },
	'sonyfnumber' => { 389 => 0x3c, 390 => 0x48, 400 => 0x14 },
	'sonyimageheight' => { 378 => 0x1a, 391 => 0x44, 392 => 0x3f, 393 => 0x47 },
	'sonyimageheightmax' => { 400 => 0x40 },
	'sonyimagesize' => { 167 => 0x3b, 360 => 0x54, 361 => 0x54, 362 => 0x9 },
	'sonyimagewidth' => { 378 => 0x1c },
	'sonyimagewidthmax' => { 400 => 0x3e },
	'sonyiso' => { 380 => 0x1218, 381 => 0x11f4, 382 => 0x1270, 383 => [0x1254,0x1258,0x1280], 384 => 0x113c, 385 => 0x344, 386 => 0x346, 387 => 0x320, 400 => 0x4 },
	'sonymaxaperturevalue' => { 400 => 0x16 },
	'sonymodelid' => { 372 => 0xb001 },
	'sonyquality' => { 167 => 0x3c },
	'sonytimeminsec' => { 390 => 0x61 },
	'source' => { 118 => 0x73, 275 => 'Source', 423 => 'source', 424 => 'source', 434 => 'Source' },
	'sourcecount' => { 411 => 'SourceCount' },
	'sourcedirectoryindex' => { 304 => 0x0 },
	'sourcefileindex' => { 304 => 0x2 },
	'sourcephotoscount' => { 410 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 426 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 426 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 426 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 426 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 426 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 446 => 'speakerPlacement' },
	'specialeffectlevel' => { 104 => 0x3030 },
	'specialeffectmode' => { 104 => 0x2076 },
	'specialeffectsetting' => { 104 => 0x3031 },
	'specialinstructions' => { 118 => 0x28 },
	'specialmode' => { 267 => 0x200, 351 => 0x200 },
	'specialoccasion' => { 438 => 'specialOccasion' },
	'spectralsensitivity' => { 110 => 0x8824, 426 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 40 => [0x2b9,0x2d0,0x2d4], 42 => 0x1e4, 43 => [0x1fd,0x2dd], 44 => [0x231,0x30f] },
	'speedx' => { 106 => 0x3 },
	'speedy' => { 106 => 0x4 },
	'speedz' => { 106 => 0x5 },
	'spherical' => { 411 => 'Spherical' },
	'splitcolumn' => { 326 => 0x222 },
	'splittoningbalance' => { 422 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 422 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 422 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 422 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 422 => 'SplitToningShadowSaturation' },
	'sport' => { 436 => 'sport' },
	'spotfocuspointx' => { 164 => 0x2d },
	'spotfocuspointy' => { 164 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 75 => 0x107 },
	'sractive' => { 298 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 319 => 0x3 },
	'srhalfpresstime' => { 319 => 0x2 },
	'srresult' => { 319 => 0x0, 320 => 0x0 },
	'stackedimage' => { 262 => 0x804 },
	'standardoutputhighlightpoint' => { 100 => 0x14 },
	'standardoutputsensitivity' => { 110 => 0x8831, 427 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 100 => 0x15 },
	'standardrawcolortone' => { 100 => 0xd },
	'standardrawcontrast' => { 100 => 0xf },
	'standardrawhighlight' => { 100 => 0x75 },
	'standardrawhighlightpoint' => { 100 => 0x12 },
	'standardrawlinear' => { 100 => 0x10 },
	'standardrawsaturation' => { 100 => 0xe },
	'standardrawshadow' => { 100 => 0x7e },
	'standardrawshadowpoint' => { 100 => 0x13 },
	'standardrawsharpness' => { 100 => 0x11 },
	'standardunsharpmaskfineness' => { 100 => 0x94 },
	'standardunsharpmaskstrength' => { 100 => 0x92 },
	'standardunsharpmaskthreshold' => { 100 => 0x96 },
	'standbytimer' => { 247 => '19.1', 249 => '19.1', 250 => '19.1', 253 => '18.1', 254 => '18.1', 259 => '19.1' },
	'startingpage' => { 436 => 'startingPage' },
	'startmovieshooting' => { 75 => 0x70d },
	'starttimecode' => { 446 => 'startTimecode' },
	'starttimecodetimeformat' => { 446 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 446 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 446 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 446 => 'startTimeSampleSize' },
	'starttimescale' => { 446 => 'startTimeScale' },
	'state' => { 145 => 'State', 283 => 0x6b, 434 => 'State' },
	'status' => { 407 => 'Status', 414 => 'Status' },
	'stereomode' => { 411 => 'StereoMode' },
	'stitched' => { 411 => 'Stitched' },
	'stitchingsoftware' => { 410 => 'StitchingSoftware', 411 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 379 => 0x113e, 380 => 0x113e, 381 => 0x111a, 382 => 0x1196, 383 => 0x1172, 384 => 0x102a, 385 => 0x222, 386 => 0x222, 387 => 0x217, 400 => 0xa },
	'storagemethod' => { 171 => 0x12 },
	'storebyorientation' => { 247 => '46.3', 249 => '47.3', 250 => '47.3', 259 => '47.3' },
	'storylineidentifier' => { 432 => 'StorylineIdentifier' },
	'straightenangle' => { 239 => 0x2fc08431 },
	'streamready' => { 432 => 'StreamReady' },
	'streamtype' => { 160 => 'StreamType' },
	'stretchmode' => { 446 => 'stretchMode' },
	'studydatetime' => { 406 => 'StudyDateTime' },
	'studydescription' => { 406 => 'StudyDescription' },
	'studyid' => { 406 => 'StudyID' },
	'studyphysician' => { 406 => 'StudyPhysician' },
	'styleperiod' => { 432 => 'StylePeriod' },
	'sub-location' => { 118 => 0x5c },
	'subfiledata' => { 148 => 'data' },
	'subfiledirectory' => { 148 => '1Directory' },
	'subfilemimetype' => { 148 => '2MIME' },
	'subfilename' => { 148 => '1Name' },
	'subfileresource' => { 148 => 'rsrc' },
	'subfiletype' => { 110 => 0xfe, 148 => '0Type' },
	'subject' => { 271 => 'Subject', 333 => 'Subject', 423 => 'subject', 433 => 'Subject', 447 => 'subject' },
	'subjectarea' => { 110 => 0x9214, 426 => 'SubjectArea' },
	'subjectcode' => { 431 => 'SubjectCode' },
	'subjectdistance' => { 110 => 0x9206, 126 => 0x3e, 426 => 'SubjectDistance' },
	'subjectdistancerange' => { 110 => 0xa40c, 426 => 'SubjectDistanceRange' },
	'subjectlocation' => { 110 => 0xa214, 426 => 'SubjectLocation' },
	'subjectmotion' => { 249 => '78.2', 250 => '78.2' },
	'subjectprogram' => { 164 => 0x22 },
	'subjectreference' => { 118 => 0xc },
	'sublabels4' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 430 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 430 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 105 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 105 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 105 => 'SubSecModifyDate' },
	'subsectime' => { 110 => 0x9290 },
	'subsectimedigitized' => { 110 => 0x9292 },
	'subsectimeoriginal' => { 110 => 0x9291 },
	'subsection1' => { 436 => 'subsection1' },
	'subsection2' => { 436 => 'subsection2' },
	'subsection3' => { 436 => 'subsection3' },
	'subsection4' => { 436 => 'subsection4' },
	'subselector' => { 247 => '49.1', 249 => '71.1', 250 => '71.1' },
	'subselectorassignment' => { 247 => '48.1' },
	'subselectorcenter' => { 249 => '72.1', 250 => '72.1' },
	'subselectorplusdials' => { 247 => '49.2', 249 => '73.1', 250 => '73.1' },
	'subtitle' => { 436 => 'subtitle' },
	'subversionfilename' => { 430 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 430 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 430 => 'SubVersions' },
	'superimposeddisplay' => { 73 => 0xa, 75 => 0x510, 76 => 0x9, 77 => 0xa, 80 => 0xa, 81 => 0xe },
	'supermacro' => { 57 => 0x1a },
	'supplementalcategories' => { 118 => 0x14, 434 => 'SupplementalCategories' },
	'supplementaltype' => { 120 => 0x37 },
	'supplementdisplayid' => { 436 => 'supplementDisplayID' },
	'supplementstartingpage' => { 436 => 'supplementStartingPage' },
	'supplementtitle' => { 436 => 'supplementTitle' },
	'supplychainsource' => { 432 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 432 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 432 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 298 => 0x14 },
	'swatchcoloranta' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 451 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 451 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 451 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 451 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 451 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 283 => 0x93, 362 => 0x33 },
	'sweeppanoramafieldofview' => { 283 => 0x94 },
	'sweeppanoramasize' => { 362 => 0x32 },
	'switchtoregisteredafpoint' => { 74 => 0x12, 75 => 0x50a },
	'syncreleasemode' => { 249 => '77.1', 250 => '77.1' },
	'system' => { 326 => 0x204 },
	'tagged' => { 328 => 0xdd, 329 => 'Tagged', 416 => 'tagged' },
	'tagslist' => { 425 => 'TagsList' },
	'tagstructure' => { 430 => 'TagStructure' },
	'takenumber' => { 446 => 'takeNumber' },
	'tapename' => { 446 => 'tapeName' },
	'targetaperture' => { 69 => 0x4 },
	'targetcompressionratio' => { 86 => 0x1 },
	'targetdistancesetting' => { 88 => 0x1807 },
	'targetexposuretime' => { 69 => 0x5 },
	'targetimagetype' => { 88 => 0x100a },
	'targetprinter' => { 110 => 0x151 },
	'taxon' => { 109 => 'Taxon' },
	'taxonacceptednameusage' => { 109 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 109 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 109 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 109 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 109 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 109 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 109 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 109 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 109 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 109 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 109 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 109 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 109 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 109 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 109 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 109 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 109 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 109 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 109 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 109 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 109 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 109 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 109 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 109 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 109 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 109 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 109 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 109 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 109 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 109 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 109 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 109 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 109 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 436 => 'teaser' },
	'teleconverter' => { 169 => 0x105, 372 => 0x105 },
	'tempo' => { 446 => 'tempo' },
	'temporalcoverage' => { 432 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 432 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 432 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 272 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 272 => 'TermsAndConditionsURL' },
	'testname' => { 111 => 'TestName' },
	'textencoding' => { 200 => 0x4 },
	'textlayername' => { 434 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 434 => 'TextLayers' },
	'textlayertext' => { 434 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 283 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 249 => '1.3', 250 => '1.3' },
	'three-dtrackingwatcharea' => { 249 => '78.1', 250 => '78.1' },
	'thresholding' => { 110 => 0x107 },
	'thumbnailfilename' => { 88 => 0x817 },
	'thumbnailformat' => { 444 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 128 => 0xfa55, 444 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 88 => 0x2008, 105 => 'ThumbnailImage', 113 => 0x3, 151 => 'data', 267 => 0x100, 444 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 151 => '1Name' },
	'thumbnailimagesize' => { 151 => 'ImageSize' },
	'thumbnailimagetype' => { 151 => '0Type' },
	'thumbnailimagevalidarea' => { 57 => 0x13 },
	'thumbnaillength' => { 110 => 0x202 },
	'thumbnailoffset' => { 110 => 0x201 },
	'thumbnails' => { 444 => 'Thumbnails' },
	'thumbnailwidth' => { 128 => 0xfa54, 444 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 436 => 'ticker' },
	'tiffhandling' => { 422 => 'TIFFHandling' },
	'tiffmeteringimage' => { 170 => 0x104c, 371 => 0x1110 },
	'tilelength' => { 110 => 0x143 },
	'tilewidth' => { 110 => 0x142 },
	'time' => { 124 => 0x401, 317 => 0x7 },
	'timecodes' => { 110 => 0xc763 },
	'timecreated' => { 118 => 0x3c, 126 => 0x14, 135 => 0x10, 329 => 'TimeCreated' },
	'timeperiod' => { 436 => 'timePeriod' },
	'timerfunctionbutton' => { 248 => '5.2', 251 => '12.1', 252 => '13.1' },
	'timerlength' => { 75 => 0x80c },
	'timerrecording' => { 283 => 0x96 },
	'timescaleparams' => { 446 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 446 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 446 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 446 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 119 => 0x50 },
	'timeshot' => { 412 => 'TimeShot' },
	'timesignature' => { 446 => 'timeSignature' },
	'timesincepoweron' => { 283 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 261 => 0x8, 275 => 'TimeStamp', 283 => 0xaf, 411 => 'Timestamp', 417 => 'Timestamp', 430 => 'TimeStamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 70 => 0x1, 231 => 0x0, 345 => 0xa },
	'timezonecity' => { 70 => 0x2 },
	'timezonecode' => { 91 => 0x1 },
	'timezoneinfo' => { 91 => 0x2 },
	'timezoneoffset' => { 110 => 0x882a },
	'tint' => { 422 => 'Tint' },
	'title' => { 141 => 'Title', 271 => 'Title', 275 => 'Title', 283 => 0x65, 333 => 'Title', 423 => 'title', 433 => 'Title', 444 => 'Title' },
	'tonecomp' => { 201 => 0x81 },
	'tonecurve' => { 67 => 0x1, 317 => 0x402, 422 => 'ToneCurve' },
	'tonecurveactive' => { 99 => 0x110 },
	'tonecurveadobergb' => { 349 => 0xa043 },
	'tonecurveadobergbdefault' => { 349 => 0xa041 },
	'tonecurveblue' => { 422 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 404 => 0x9003 },
	'tonecurvebluey' => { 404 => 0x9007 },
	'tonecurvebrightness' => { 94 => 0x20410 },
	'tonecurvebrightnessx' => { 404 => 0x9000 },
	'tonecurvebrightnessy' => { 404 => 0x9004 },
	'tonecurvecolorspace' => { 98 => 0x0 },
	'tonecurvecontrast' => { 94 => 0x20411 },
	'tonecurvefilename' => { 124 => 0x1391 },
	'tonecurvegreen' => { 422 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 404 => 0x9002 },
	'tonecurvegreeny' => { 404 => 0x9006 },
	'tonecurveinputrange' => { 98 => 0x3 },
	'tonecurveinterpolation' => { 99 => 0x159 },
	'tonecurvemode' => { 99 => 0x113 },
	'tonecurvename' => { 422 => 'ToneCurveName' },
	'tonecurvename2012' => { 422 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 94 => '0x20400.1' },
	'tonecurveoutputrange' => { 98 => 0x5 },
	'tonecurveproperty' => { 99 => 0x3c },
	'tonecurvepv2012' => { 422 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 422 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 422 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 422 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 422 => 'ToneCurveRed' },
	'tonecurveredx' => { 404 => 0x9001 },
	'tonecurveredy' => { 404 => 0x9005 },
	'tonecurves' => { 317 => 0x403 },
	'tonecurveshape' => { 98 => 0x1 },
	'tonecurvesrgb' => { 349 => 0xa042 },
	'tonecurvesrgbdefault' => { 349 => 0xa040 },
	'tonecurvex' => { 98 => 0xa },
	'tonecurvey' => { 98 => 0xb },
	'tonelevel' => { 262 => 0x52e },
	'tonemapstrength' => { 422 => 'ToneMapStrength' },
	'toningeffect' => { 51 => 0xf, 201 => 0xb3, 203 => 0x38, 204 => 0x40, 342 => 0x1015 },
	'toningeffectauto' => { 64 => 0xa4 },
	'toningeffectfaithful' => { 63 => 0x74, 64 => 0x74 },
	'toningeffectlandscape' => { 63 => 0x44, 64 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 63 => 0x8c, 64 => 0x8c },
	'toningeffectneutral' => { 63 => 0x5c, 64 => 0x5c },
	'toningeffectportrait' => { 63 => 0x2c, 64 => 0x2c },
	'toningeffectstandard' => { 63 => 0x14, 64 => 0x14 },
	'toningeffectuserdef1' => { 63 => 0xa4, 64 => 0xbc },
	'toningeffectuserdef2' => { 63 => 0xbc, 64 => 0xd4 },
	'toningeffectuserdef3' => { 63 => 0xd4, 64 => 0xec },
	'toningsaturation' => { 203 => 0x39, 204 => 0x41 },
	'totalzoom' => { 126 => 0x62 },
	'touchae' => { 283 => 0xab },
	'trackcreatedate' => { 337 => 0x1 },
	'trackmodifydate' => { 337 => 0x2 },
	'tracknumber' => { 446 => 'trackNumber' },
	'tracks' => { 446 => 'Tracks' },
	'tracksframerate' => { 446 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 446 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 446 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 446 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 446 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 446 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 446 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 446 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 446 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 446 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 446 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 446 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 446 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 446 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 446 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 446 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 446 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 148 => 'zmie' },
	'transcript' => { 432 => 'Transcript' },
	'transcriptlink' => { 432 => 'TranscriptLink' },
	'transcriptlinklink' => { 432 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 432 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 110 => 0x12d, 442 => 'TransferFunction' },
	'transform' => { 283 => [0x8012,0x59] },
	'transmissionreference' => { 434 => 'TransmissionReference' },
	'trapped' => { 271 => 'Trapped', 433 => 'Trapped' },
	'trashbuttonfunction' => { 75 => 0x710 },
	'travelday' => { 283 => 0x36 },
	'triggermode' => { 338 => 0x6 },
	'tstop' => { 110 => 0xc772 },
	'ttl_da_adown' => { 305 => 0x5 },
	'ttl_da_aup' => { 305 => 0x4 },
	'ttl_da_bdown' => { 305 => 0x7 },
	'ttl_da_bup' => { 305 => 0x6 },
	'tungstenawb' => { 295 => 0x1 },
	'tvexposuretimesetting' => { 298 => 0x12 },
	'type' => { 423 => 'type', 441 => 'type' },
	'typestatus' => { 109 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 110 => 0xc614 },
	'uniquedocumentid' => { 118 => 0xbb },
	'uniqueobjectname' => { 119 => 0x64 },
	'unknownblock' => { 317 => 0x405 },
	'unknownblock1' => { 266 => 0x635 },
	'unknownblock2' => { 266 => 0x636 },
	'unknownblock3' => { 266 => 0x1103 },
	'unknownblock4' => { 266 => 0x1104 },
	'unknowncontrast' => { 100 => 0x45 },
	'unknowndate' => { 326 => 0x212 },
	'unknownev' => { 124 => 0x1 },
	'unknownlinear' => { 100 => 0x46 },
	'unknownnumber' => { 88 => 0x180b },
	'unknownoutputhighlightpoint' => { 100 => 0x4a },
	'unknownoutputshadowpoint' => { 100 => 0x4b },
	'unknownrawhighlight' => { 100 => 0x7b },
	'unknownrawhighlightpoint' => { 100 => 0x48 },
	'unknownrawshadow' => { 100 => 0x84 },
	'unknownrawshadowpoint' => { 100 => 0x49 },
	'unknownsharpness' => { 100 => 0x47 },
	'unknowntemperature' => { 112 => 0x4 },
	'unsharp1color' => { 244 => 0x13 },
	'unsharp1halowidth' => { 244 => 0x19 },
	'unsharp1intensity' => { 244 => 0x17 },
	'unsharp1threshold' => { 244 => 0x1b },
	'unsharp2color' => { 244 => 0x2e },
	'unsharp2halowidth' => { 244 => 0x34 },
	'unsharp2intensity' => { 244 => 0x32 },
	'unsharp2threshold' => { 244 => 0x36 },
	'unsharp3color' => { 244 => 0x49 },
	'unsharp3halowidth' => { 244 => 0x4f },
	'unsharp3intensity' => { 244 => 0x4d },
	'unsharp3threshold' => { 244 => 0x51 },
	'unsharp4color' => { 244 => 0x64 },
	'unsharp4halowidth' => { 244 => 0x6a },
	'unsharp4intensity' => { 244 => 0x68 },
	'unsharp4threshold' => { 244 => 0x6c },
	'unsharpcount' => { 244 => 0x0 },
	'unsharpmask' => { 100 => 0x90, 239 => 0x76a43200 },
	'unsharpmaskfineness' => { 94 => 0x20309 },
	'unsharpmaskstrength' => { 94 => 0x20308 },
	'unsharpmaskthreshold' => { 94 => 0x2030a },
	'uprightcentermode' => { 422 => 'UprightCenterMode' },
	'uprightcenternormx' => { 422 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 422 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 422 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 422 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 422 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 422 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 422 => 'UprightPreview' },
	'uprighttransform_0' => { 422 => 'UprightTransform_0' },
	'uprighttransform_1' => { 422 => 'UprightTransform_1' },
	'uprighttransform_2' => { 422 => 'UprightTransform_2' },
	'uprighttransform_3' => { 422 => 'UprightTransform_3' },
	'uprighttransform_4' => { 422 => 'UprightTransform_4' },
	'uprighttransform_5' => { 422 => 'UprightTransform_5' },
	'uprighttransformcount' => { 422 => 'UprightTransformCount' },
	'uprightversion' => { 422 => 'UprightVersion' },
	'urgency' => { 118 => 0xa, 434 => 'Urgency' },
	'url' => { 141 => 'URL', 275 => 'URL', 331 => 0x40b, 436 => 'url' },
	'url_list' => { 331 => 0x41e },
	'urla-platform' => { 436 => [\'url','urlA-platform'] },
	'urlurl' => { 436 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 75 => 0x10a },
	'usableshootingmodes' => { 75 => 0x109 },
	'usage' => { 437 => 'usage' },
	'usageterms' => { 450 => 'UsageTerms' },
	'useguidelines' => { 419 => 'useGuidelines' },
	'usepanoramaviewer' => { 410 => 'UsePanoramaViewer' },
	'usercomment' => { 88 => 0x805, 110 => 0x9286, 426 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 63 => 0xd8, 64 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 63 => 0xda, 64 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 63 => 0xdc, 64 => 0xf4 },
	'userfields' => { 414 => 'UserFields' },
	'userlabel' => { 338 => 0x2b },
	'userprofile' => { 279 => 0x302, 285 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 74 => 0x7, 75 => 0x501 },
	'uspsnumber' => { 436 => 'uspsNumber' },
	'utmeasting' => { 152 => 'Easting' },
	'utmmapdatum' => { 152 => 'Datum' },
	'utmnorthing' => { 152 => 'Northing' },
	'utmzone' => { 152 => 'Zone' },
	'uv-irfiltercorrection' => { 279 => 0x325 },
	'validbits' => { 266 => 0x611, 267 => 0x102c },
	'validpixeldepth' => { 270 => 0x611 },
	'variablelowpassfilter' => { 372 => 0x2028 },
	'variousmodes' => { 126 => 0x26 },
	'variousmodes2' => { 126 => 0x3a },
	'variprogram' => { 201 => 0xab },
	'version' => { 115 => 0x0, 333 => 'Version', 422 => 'Version' },
	'versioncreatedate' => { 404 => 0xd100 },
	'versionid' => { 447 => 'VersionID' },
	'versionidentifier' => { 436 => 'versionIdentifier' },
	'versionmodifydate' => { 404 => 0xd101 },
	'versions' => { 447 => 'Versions' },
	'versionscomments' => { 447 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 447 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 447 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 447 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 447 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 447 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 447 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 447 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 447 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 447 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 447 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 246 => '3.2', 247 => '47.2', 249 => '79.1' },
	'verticalfuncbutton' => { 247 => '42.2', 249 => '67.1' },
	'verticalfuncbuttonplusdials' => { 247 => '43.1' },
	'verticalfuncplusdials' => { 249 => '68.1' },
	'verticalmultiselector' => { 247 => '42.1', 249 => '66.1', 250 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 75 => [0x510,0x51d] },
	'vibrance' => { 415 => 'Vibrance', 422 => 'Vibrance' },
	'vibrationreduction' => { 209 => [0x75,0x82,0x1ae], 217 => '586.1', 225 => '590.2', 230 => 0x4 },
	'videoalphamode' => { 446 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 446 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 446 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 446 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 432 => 'videoBitRate' },
	'videobitratemode' => { 432 => 'videoBitRateMode' },
	'videocodec' => { 60 => 0x74 },
	'videocolorspace' => { 446 => 'videoColorSpace' },
	'videocompressor' => { 446 => 'videoCompressor' },
	'videodisplayaspectratio' => { 432 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 432 => 'videoEncodingProfile' },
	'videofieldorder' => { 446 => 'videoFieldOrder' },
	'videoframerate' => { 446 => 'videoFrameRate' },
	'videoframesize' => { 446 => 'videoFrameSize' },
	'videoframesizeh' => { 446 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 446 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 446 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 446 => 'videoModDate' },
	'videopixelaspectratio' => { 446 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 446 => 'videoPixelDepth' },
	'videoquality' => { 104 => 0x4003 },
	'videoshottype' => { 432 => 'VideoShotType' },
	'videoshottypeidentifier' => { 432 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 432 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 432 => 'videoStreamsCount' },
	'viewfinder' => { 326 => 0x455 },
	'viewfinderdisplay' => { 246 => '12.4', 247 => '6.3' },
	'viewfinderwarning' => { 246 => '13.4', 256 => '3.5', 257 => '6.2', 260 => '4.4' },
	'viewfinderwarnings' => { 75 => 0x40a },
	'viewinfoduringexposure' => { 75 => 0x407 },
	'viewingmode' => { 362 => 0x2f, 376 => 0x18 },
	'viewingmode2' => { 362 => [0x85,0x285] },
	'viewpoint' => { 435 => 'viewpoint' },
	'vignetteamount' => { 422 => 'VignetteAmount' },
	'vignettecontrol' => { 201 => 0x2a, 239 => 0x76a43205 },
	'vignettecontrolintensity' => { 239 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 418 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 422 => 'VignetteMidpoint' },
	'vignetting' => { 342 => 0x1011, 349 => 0xa052 },
	'vignettingcorrection' => { 349 => 0xa053, 372 => 0x2011 },
	'vignettingcorrparams' => { 110 => 0x7032, 399 => 0x64a, 400 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 349 => 0xa054 },
	'visualcolor' => { 432 => 'VisualColour' },
	'visualtechnique' => { 435 => 'visualTechnique' },
	'voicememo' => { 351 => 0x216 },
	'volume' => { 436 => 'volume' },
	'vr_0x66' => { 209 => 0x66 },
	'vrdoffset' => { 57 => 0xd0 },
	'vrmode' => { 230 => 0x6 },
	'waterdepth' => { 110 => 0x9403 },
	'wb_bluelevel3500k' => { 170 => 0x19a },
	'wb_bluelevel6500k' => { 170 => 0x18a },
	'wb_bluelevelcustom' => { 170 => 0x18e },
	'wb_bluelevelscloudy' => { 170 => 0x106 },
	'wb_bluelevelsdaylight' => { 170 => 0xea },
	'wb_bluelevelsflash' => { 170 => 0x122 },
	'wb_bluelevelsfluorescent' => { 170 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 170 => 0x254 },
	'wb_bluelevelsshade' => { 170 => 0x176 },
	'wb_bluelevelstungsten' => { 170 => 0xce },
	'wb_gbrglevels' => { 170 => 0xae, 173 => 0x4 },
	'wb_glevel' => { 266 => 0x11f },
	'wb_glevel3000k' => { 266 => 0x113 },
	'wb_glevel3300k' => { 266 => 0x114 },
	'wb_glevel3600k' => { 266 => 0x115 },
	'wb_glevel3900k' => { 266 => 0x116 },
	'wb_glevel4000k' => { 266 => 0x117 },
	'wb_glevel4300k' => { 266 => 0x118 },
	'wb_glevel4500k' => { 266 => 0x119 },
	'wb_glevel4800k' => { 266 => 0x11a },
	'wb_glevel5300k' => { 266 => 0x11b },
	'wb_glevel6000k' => { 266 => 0x11c },
	'wb_glevel6600k' => { 266 => 0x11d },
	'wb_glevel7500k' => { 266 => 0x11e },
	'wb_grbglevels' => { 183 => 0x0 },
	'wb_rbgglevels' => { 180 => 0x0 },
	'wb_rblevels' => { 201 => 0xc, 266 => 0x100 },
	'wb_rblevels1' => { 288 => 0x2 },
	'wb_rblevels2' => { 288 => 0x5 },
	'wb_rblevels3' => { 288 => 0x8 },
	'wb_rblevels3000k' => { 266 => 0x102 },
	'wb_rblevels3300k' => { 266 => 0x103 },
	'wb_rblevels3500k' => { 170 => 0x430 },
	'wb_rblevels3600k' => { 266 => 0x104 },
	'wb_rblevels3900k' => { 266 => 0x105 },
	'wb_rblevels4' => { 288 => 0xb },
	'wb_rblevels4000k' => { 266 => 0x106 },
	'wb_rblevels4300k' => { 266 => 0x107 },
	'wb_rblevels4500k' => { 266 => 0x108 },
	'wb_rblevels4800k' => { 266 => 0x109 },
	'wb_rblevels5' => { 288 => 0xe },
	'wb_rblevels5300k' => { 266 => 0x10a },
	'wb_rblevels6' => { 288 => 0x11 },
	'wb_rblevels6000k' => { 266 => 0x10b },
	'wb_rblevels6500k' => { 170 => 0x420 },
	'wb_rblevels6600k' => { 266 => 0x10c },
	'wb_rblevels7' => { 288 => 0x14 },
	'wb_rblevels7500k' => { 266 => 0x10d },
	'wb_rblevelsauto' => { 270 => 0x110 },
	'wb_rblevelscloudy' => { 170 => 0x3f0, 172 => 0x10, 270 => 0x121 },
	'wb_rblevelscoolwhitef' => { 170 => 0x308, 172 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 270 => 0x132 },
	'wb_rblevelscustom' => { 170 => 0x424 },
	'wb_rblevelscwb1' => { 266 => 0x10e },
	'wb_rblevelscwb2' => { 266 => 0x10f },
	'wb_rblevelscwb3' => { 266 => 0x110 },
	'wb_rblevelscwb4' => { 266 => 0x111 },
	'wb_rblevelsdaylight' => { 170 => [0x3ec,0x528], 172 => 0xc },
	'wb_rblevelsdaylightf' => { 172 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 270 => 0x130 },
	'wb_rblevelsdaywhitef' => { 172 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 270 => 0x131 },
	'wb_rblevelseveningsunlight' => { 270 => 0x124 },
	'wb_rblevelsfineweather' => { 270 => 0x122 },
	'wb_rblevelsflash' => { 170 => [0x3f4,0x304], 172 => 0x18 },
	'wb_rblevelsshade' => { 170 => 0x418, 172 => 0x20, 270 => 0x120 },
	'wb_rblevelstungsten' => { 170 => 0x3e8, 172 => 0x8, 270 => 0x123 },
	'wb_rblevelsunknown' => { 172 => 0x1c },
	'wb_rblevelsused' => { 270 => 0x100 },
	'wb_rblevelswhitef' => { 172 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 270 => 0x133 },
	'wb_redlevel3500k' => { 170 => 0x198 },
	'wb_redlevel6500k' => { 170 => 0x188 },
	'wb_redlevelcustom' => { 170 => 0x18c },
	'wb_redlevelscloudy' => { 170 => 0xf8 },
	'wb_redlevelsdaylight' => { 170 => 0xdc },
	'wb_redlevelsflash' => { 170 => 0x114 },
	'wb_redlevelsfluorescent' => { 170 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 170 => 0x1be },
	'wb_redlevelsshade' => { 170 => 0x168 },
	'wb_redlevelstungsten' => { 170 => 0xc0 },
	'wb_rgbglevels' => { 182 => 0x0 },
	'wb_rgblevels' => { 170 => [0x546,0x96], 280 => 0xd, 281 => 0x413, 285 => 0x3036, 326 => 0x107, 379 => 0x117c, 380 => 0x1180, 381 => 0x115c, 382 => 0x11d8, 383 => 0x11b4, 384 => 0x106c, 385 => 0x264, 386 => 0x264, 387 => 0x252 },
	'wb_rgblevels1' => { 289 => 0x2 },
	'wb_rgblevels2' => { 289 => 0x6 },
	'wb_rgblevels3' => { 289 => 0xa },
	'wb_rgblevels4' => { 289 => 0xe },
	'wb_rgblevels5' => { 289 => 0x12 },
	'wb_rgblevels6' => { 289 => 0x16 },
	'wb_rgblevels7' => { 289 => 0x1a },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 173 => 0x4, 181 => 0x0 },
	'wb_rggblevelsasshot' => { 36 => 0x0, 37 => 0x19, 38 => 0x22, 39 => 0x3f, 42 => 0x3f, 43 => 0x3f, 44 => 0x3f },
	'wb_rggblevelsauto' => { 34 => 0x1, 36 => 0x5, 37 => 0x1e, 38 => 0x18, 39 => 0x44, 42 => 0x44, 43 => 0x44, 44 => 0x44, 349 => 0xa022 },
	'wb_rggblevelsblack' => { 349 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 36 => 0x1e, 37 => 0x2d, 38 => 0x31, 39 => 0x58, 42 => 0x71, 43 => 0x8a, 44 => 0x8f, 317 => 0x20f, 325 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 39 => 0x80 },
	'wb_rggblevelscustom1' => { 37 => 0x41 },
	'wb_rggblevelscustom2' => { 37 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 36 => 0x14, 37 => 0x23, 38 => 0x27, 39 => 0x4e, 42 => 0x67, 43 => 0x80, 44 => 0x85, 317 => 0x20d, 325 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 36 => 0x32, 37 => 0x3c, 38 => 0x45, 39 => 0x6c, 42 => 0x85, 43 => 0x9e, 44 => 0xa3, 317 => 0x214, 325 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 36 => 0x28, 37 => 0x37, 38 => 0x3b, 39 => 0x62, 42 => 0x7b, 43 => 0x94, 44 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 317 => 0x211, 325 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 325 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 317 => 0x212, 325 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 317 => 0x213, 325 => 0x38 },
	'wb_rggblevelsilluminator1' => { 349 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 349 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 36 => 0x2d, 38 => 0x40, 39 => 0x67, 42 => 0x80, 43 => 0x99, 44 => 0x9e },
	'wb_rggblevelsmeasured' => { 36 => 0xa, 39 => 0x49, 42 => 0x49, 43 => 0x49, 44 => 0x49 },
	'wb_rggblevelspc1' => { 38 => 0x90, 39 => 0x71 },
	'wb_rggblevelspc2' => { 38 => 0x95, 39 => 0x76 },
	'wb_rggblevelspc3' => { 38 => 0x9a, 39 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 36 => 0x19, 37 => 0x28, 38 => 0x2c, 39 => 0x53, 42 => 0x6c, 43 => 0x85, 44 => 0x8a, 317 => 0x20e, 325 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 36 => 0x23, 37 => 0x32, 38 => 0x36, 39 => 0x5d, 42 => 0x76, 43 => 0x8f, 44 => 0x94, 317 => 0x210, 325 => 0x1d },
	'wb_rggblevelsuncorrected' => { 349 => 0xa021 },
	'wb_rggblevelsunknown' => { 36 => 0xf, 38 => 0x1d, 42 => 0x4e, 43 => 0x4e, 44 => 0x4e, 325 => 0x53 },
	'wb_rggblevelsunknown10' => { 36 => 0x5f, 38 => 0x72, 42 => 0x9e, 43 => 0x7b, 44 => 0x7b },
	'wb_rggblevelsunknown11' => { 36 => 0x64, 38 => 0x77, 42 => 0xa3, 43 => 0xa3, 44 => 0x80 },
	'wb_rggblevelsunknown12' => { 36 => 0x69, 38 => 0x7c, 42 => 0xa8, 43 => 0xa8, 44 => 0xa8 },
	'wb_rggblevelsunknown13' => { 36 => 0x6e, 38 => 0x81, 42 => 0xad, 43 => 0xad, 44 => 0xad },
	'wb_rggblevelsunknown14' => { 38 => 0x86, 42 => 0xb2, 43 => 0xb2, 44 => 0xb2 },
	'wb_rggblevelsunknown15' => { 38 => 0x8b, 42 => 0xb7, 43 => 0xb7, 44 => 0xb7 },
	'wb_rggblevelsunknown16' => { 38 => 0x9f, 43 => 0xbc, 44 => 0xbc },
	'wb_rggblevelsunknown17' => { 43 => 0xc1, 44 => 0xc1 },
	'wb_rggblevelsunknown18' => { 43 => 0xc6, 44 => 0xc6 },
	'wb_rggblevelsunknown19' => { 43 => 0xcb, 44 => 0xcb },
	'wb_rggblevelsunknown2' => { 36 => 0x37, 38 => 0x4a, 42 => 0x53, 43 => 0x53, 44 => 0x53 },
	'wb_rggblevelsunknown20' => { 43 => 0xd0, 44 => 0xd0 },
	'wb_rggblevelsunknown21' => { 44 => 0xd5 },
	'wb_rggblevelsunknown22' => { 44 => 0xda },
	'wb_rggblevelsunknown23' => { 44 => 0xdf },
	'wb_rggblevelsunknown24' => { 44 => 0xe4 },
	'wb_rggblevelsunknown25' => { 44 => 0xe9 },
	'wb_rggblevelsunknown26' => { 44 => 0xee },
	'wb_rggblevelsunknown27' => { 44 => 0xf3 },
	'wb_rggblevelsunknown28' => { 44 => 0xf8 },
	'wb_rggblevelsunknown29' => { 44 => 0xfd },
	'wb_rggblevelsunknown3' => { 36 => 0x3c, 38 => 0x4f, 42 => 0x58, 43 => 0x58, 44 => 0x58 },
	'wb_rggblevelsunknown30' => { 44 => 0x102 },
	'wb_rggblevelsunknown4' => { 36 => 0x41, 38 => 0x54, 42 => 0x5d, 43 => 0x5d, 44 => 0x5d },
	'wb_rggblevelsunknown5' => { 36 => 0x46, 38 => 0x59, 42 => 0x62, 43 => 0x62, 44 => 0x62 },
	'wb_rggblevelsunknown6' => { 36 => 0x4b, 38 => 0x5e, 42 => 0x8a, 43 => 0x67, 44 => 0x67 },
	'wb_rggblevelsunknown7' => { 36 => 0x50, 38 => 0x63, 42 => 0x8f, 43 => 0x6c, 44 => 0x6c },
	'wb_rggblevelsunknown8' => { 36 => 0x55, 38 => 0x68, 42 => 0x94, 43 => 0x71, 44 => 0x71 },
	'wb_rggblevelsunknown9' => { 36 => 0x5a, 38 => 0x6d, 42 => 0x99, 43 => 0x76, 44 => 0x76 },
	'wb_rggblevelsuserselected' => { 325 => 0x5c },
	'wbadjblueamber' => { 94 => 0x20106 },
	'wbadjbluebalance' => { 245 => 0x8 },
	'wbadjcolortemp' => { 94 => 0x20102, 99 => 0x1a },
	'wbadjlighting' => { 245 => 0x14 },
	'wbadjmagentagreen' => { 94 => 0x20105 },
	'wbadjmode' => { 245 => 0x10 },
	'wbadjredbalance' => { 245 => 0x0 },
	'wbadjrggblevels' => { 94 => 0x20125, 99 => 0x6 },
	'wbadjtemperature' => { 245 => 0x18 },
	'wbadjtint' => { 245 => 0x25 },
	'wbbluelevel' => { 279 => 0x324, 283 => 0x8006, 287 => 0x26 },
	'wbbracketingsteps' => { 218 => 0x174d, 219 => 0x87c, 227 => 0x1757 },
	'wbbracketmode' => { 51 => 0x9 },
	'wbbracketshotnumber' => { 170 => 0x2b, 342 => 0x101a },
	'wbbracketvalueab' => { 51 => 0xc },
	'wbbracketvaluegm' => { 51 => 0xd },
	'wbfinetuneactive' => { 99 => 0x24 },
	'wbfinetunesaturation' => { 99 => 0x28 },
	'wbfinetunetone' => { 99 => 0x2c },
	'wbgreenlevel' => { 279 => 0x323, 283 => 0x8005, 287 => 0x25 },
	'wbmediaimagesizesetting' => { 75 => 0x708 },
	'wbmode' => { 172 => 0x4, 267 => 0x1015 },
	'wbredlevel' => { 279 => 0x322, 283 => 0x8004, 287 => 0x24 },
	'wbscale' => { 173 => 0x0 },
	'wbshiftab' => { 67 => 0xc, 283 => 0x46, 299 => 0x10 },
	'wbshiftab_gm' => { 372 => 0x2014 },
	'wbshiftab_gm_precise' => { 372 => 0x2026 },
	'wbshiftgm' => { 67 => 0xd, 283 => 0x47, 299 => 0x11 },
	'wbtype1' => { 288 => 0x1, 289 => 0x1 },
	'wbtype2' => { 288 => 0x4, 289 => 0x5 },
	'wbtype3' => { 288 => 0x7, 289 => 0x9 },
	'wbtype4' => { 288 => 0xa, 289 => 0xd },
	'wbtype5' => { 288 => 0xd, 289 => 0x11 },
	'wbtype6' => { 288 => 0x10, 289 => 0x15 },
	'wbtype7' => { 288 => 0x13, 289 => 0x19 },
	'webstatement' => { 450 => 'WebStatement' },
	'what' => { 422 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 67 => 0x8, 69 => 0x7, 103 => 0x7, 104 => [0x19,0x2012], 110 => [0xa403,0xfe4e], 115 => 0x1002, 124 => 0x3fc, 125 => 0xfa0d, 126 => 0x40, 164 => 0x3, 165 => 0xe, 166 => 0x4, 167 => 0xb, 169 => 0x115, 201 => 0x5, 229 => 0x7, 279 => 0x304, 283 => 0x3, 285 => 0x3033, 317 => 0x19, 324 => 0x7, 341 => 0x26, 342 => 0x1003, 352 => [0x3c,0x7,0x58], 360 => 0xf, 361 => 0xe, 372 => [0x115,0xb054], 422 => 'WhiteBalance', 426 => 'WhiteBalance' },
	'whitebalance0' => { 160 => 'WhiteBalance0' },
	'whitebalance1' => { 160 => 'WhiteBalance1' },
	'whitebalance2' => { 160 => 'WhiteBalance2', 262 => 0x500 },
	'whitebalanceadj' => { 94 => 0x20101, 99 => 0x18, 239 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 295 => 0x0 },
	'whitebalancebias' => { 104 => 0x2011, 267 => 0x304, 283 => 0x23 },
	'whitebalanceblue' => { 67 => 0x7 },
	'whitebalancebracket' => { 262 => 0x502, 267 => 0x303 },
	'whitebalancebracketing' => { 167 => 0x22, 170 => 0x2c, 371 => 0x2c },
	'whitebalancecomp' => { 270 => 0x1001 },
	'whitebalancefinetune' => { 115 => 0x100a, 167 => 0x38, 169 => 0x112, 201 => 0xb, 342 => 0x1004, 360 => 0x6, 361 => 0x5, 372 => 0x112 },
	'whitebalancemode' => { 317 => 0x1a },
	'whitebalancered' => { 67 => 0x6 },
	'whitebalanceset' => { 298 => 0xa },
	'whitebalancesetting' => { 167 => 0x23, 360 => 0x5, 361 => 0x4, 362 => 0x16, 376 => 0xd },
	'whitebalancesetup' => { 349 => 0x41 },
	'whitebalancetemperature' => { 262 => 0x501 },
	'whiteboard' => { 267 => 0x301 },
	'whitelevel' => { 110 => 0xc61d, 317 => 0x7e },
	'whitepoint' => { 110 => 0x13e, 317 => 0x201, 442 => 'WhitePoint' },
	'whites2012' => { 422 => 'Whites2012' },
	'wideadapter' => { 342 => 0x1017 },
	'widefocuszone' => { 164 => 0x2f },
	'widerange' => { 351 => 0x20f },
	'windowsatom' => { 421 => 'windowsAtom' },
	'windowsatomextension' => { 421 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 421 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 421 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 436 => 'wordCount' },
	'workcolorspace' => { 94 => 0x10200, 99 => 0x270 },
	'workflowtag' => { 432 => 'WorkflowTag' },
	'workflowtagcvid' => { 432 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 432 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 432 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 432 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 428 => 'WorkToDo' },
	'worldtimelocation' => { 283 => 0x3a, 317 => 0x22, 323 => '0.1' },
	'writer-editor' => { 118 => 0x7a },
	'x3filllight' => { 352 => 0x12 },
	'xattrquarantine' => { 158 => 'com.apple.quarantine' },
	'xml' => { 122 => 'xml ' },
	'xmp' => { 97 => 0xffff00f6, 111 => 'XMP' },
	'xmptoolkit' => { 443 => 'xmptk' },
	'xpauthor' => { 110 => 0x9c9d },
	'xpcomment' => { 110 => 0x9c9c },
	'xpkeywords' => { 110 => 0x9c9e },
	'xposition' => { 110 => 0x11e },
	'xpsubject' => { 110 => 0x9c9f },
	'xptitle' => { 110 => 0x9c9b },
	'xresolution' => { 110 => 0x11a, 121 => 0x3, 332 => 0x0, 442 => 'XResolution' },
	'xyresolution' => { 114 => 0x3 },
	'yaw' => { 106 => 0x7 },
	'yawangle' => { 218 => 0x3513, 227 => 0x36fc, 347 => 0x0 },
	'ycbcrcoefficients' => { 110 => 0x211, 442 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 110 => 0x213, 442 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 110 => 0x212, 442 => 'YCbCrSubSampling' },
	'yearcreated' => { 126 => 0x10, 135 => 0xc },
	'yield' => { 438 => 'yield' },
	'yposition' => { 110 => 0x11f },
	'yresolution' => { 110 => 0x11b, 121 => 0x5, 332 => 0x4, 442 => 'YResolution' },
	'zonematching' => { 169 => 0x10a, 172 => [0x3a,0x4a], 372 => 0xb024 },
	'zonematchingmode' => { 167 => 0x14 },
	'zonematchingon' => { 166 => 0x75 },
	'zonematchingvalue' => { 360 => 0x1f },
	'zoomedpreviewlength' => { 267 => 0xf05 },
	'zoomedpreviewsize' => { 267 => 0xf06 },
	'zoomedpreviewstart' => { 267 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 265 => 0x300, 267 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketinginfooffset' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaytime' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'int16u' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'listtype' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemimagedirection' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlatitude' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprofilename' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemversion' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelshiftinfo' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'poseyawdegrees' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrfinderinfo' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2017, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
