// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "TextComponent.pypp.hpp"

namespace bp = boost::python;

void register_TextComponent_class(){

    { //::CEGUI::TextComponent
        typedef bp::class_< CEGUI::TextComponent, bp::bases< CEGUI::FalagardComponentBase > > TextComponent_exposer_t;
        TextComponent_exposer_t TextComponent_exposer = TextComponent_exposer_t( "TextComponent", "*!\n\
        \n\
            Class that encapsulates information for a text component.\n\
        *\n", bp::init< >("*!\n\
        \n\
            Constructor\n\
        *\n") );
        bp::scope TextComponent_scope( TextComponent_exposer );
        TextComponent_exposer.def( bp::init< CEGUI::TextComponent const & >(( bp::arg("obj") ), "! Copy constructor\n") );
        { //::CEGUI::TextComponent::getFont
        
            typedef ::CEGUI::String const & ( ::CEGUI::TextComponent::*getFont_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getFont"
                , getFont_function_type( &::CEGUI::TextComponent::getFont )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Return the name of the font to be used when rendering this TextComponent.\n\
            \n\
                    @return\n\
                        String object containing the name of a font, or  if the window font is to be used.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::getFontPropertySource
        
            typedef ::CEGUI::String const & ( ::CEGUI::TextComponent::*getFontPropertySource_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getFontPropertySource"
                , getFontPropertySource_function_type( &::CEGUI::TextComponent::getFontPropertySource )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Return the name of the property that will be used to determine the font to use for\
                        rendering\n\
                        the text string for this TextComponent.\n\
            \n\
                    @return\n\
                        String object holding the name of a Propery.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::getHorizontalFormatting
        
            typedef ::CEGUI::HorizontalTextFormatting ( ::CEGUI::TextComponent::*getHorizontalFormatting_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getHorizontalFormatting"
                , getHorizontalFormatting_function_type( &::CEGUI::TextComponent::getHorizontalFormatting )
                , "*!\n\
                    \n\
                        Return the current horizontal formatting setting for this TextComponent.\n\
            \n\
                    @return\n\
                        One of the HorizontalTextFormatting enumerated values.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::getHorizontalTextExtent
        
            typedef float ( ::CEGUI::TextComponent::*getHorizontalTextExtent_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getHorizontalTextExtent"
                , getHorizontalTextExtent_function_type( &::CEGUI::TextComponent::getHorizontalTextExtent )
                , "! return the horizontal pixel extent of the formatted rendered string.\n" );
        
        }
        { //::CEGUI::TextComponent::getText
        
            typedef ::CEGUI::String const & ( ::CEGUI::TextComponent::*getText_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getText"
                , getText_function_type( &::CEGUI::TextComponent::getText )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Return the text object that will be rendered by this TextComponent.\n\
            \n\
                    @return\n\
                        String object containing the text that will be rendered.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::getTextPropertySource
        
            typedef ::CEGUI::String const & ( ::CEGUI::TextComponent::*getTextPropertySource_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getTextPropertySource"
                , getTextPropertySource_function_type( &::CEGUI::TextComponent::getTextPropertySource )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Return the name of the property that will be used to determine the text string to\
                        render\n\
                        for this TextComponent.\n\
            \n\
                    @return\n\
                        String object holding the name of a Propery.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::getTextVisual
        
            typedef ::CEGUI::String const & ( ::CEGUI::TextComponent::*getTextVisual_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getTextVisual"
                , getTextVisual_function_type( &::CEGUI::TextComponent::getTextVisual )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "! return text string with  e visual ordering of glyphs.\n" );
        
        }
        { //::CEGUI::TextComponent::getVerticalFormatting
        
            typedef ::CEGUI::VerticalTextFormatting ( ::CEGUI::TextComponent::*getVerticalFormatting_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getVerticalFormatting"
                , getVerticalFormatting_function_type( &::CEGUI::TextComponent::getVerticalFormatting )
                , "*!\n\
                    \n\
                        Return the current vertical formatting setting for this TextComponent.\n\
            \n\
                    @return\n\
                        One of the VerticalTextFormatting enumerated values.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::getVerticalTextExtent
        
            typedef float ( ::CEGUI::TextComponent::*getVerticalTextExtent_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "getVerticalTextExtent"
                , getVerticalTextExtent_function_type( &::CEGUI::TextComponent::getVerticalTextExtent )
                , "! return the vertical pixel extent of the formatted rendered string.\n" );
        
        }
        { //::CEGUI::TextComponent::isFontFetchedFromProperty
        
            typedef bool ( ::CEGUI::TextComponent::*isFontFetchedFromProperty_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "isFontFetchedFromProperty"
                , isFontFetchedFromProperty_function_type( &::CEGUI::TextComponent::isFontFetchedFromProperty )
                , "*!\n\
                    \n\
                        Return whether this TextComponent fetches it's font via a property on the target\
                        window.\n\
            \n\
                    @return\n\
                        - true if the font comes via a Propery.\n\
                        - false if the font is defined explicitly, or will come from the target window.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::isTextFetchedFromProperty
        
            typedef bool ( ::CEGUI::TextComponent::*isTextFetchedFromProperty_function_type )(  ) const;
            
            TextComponent_exposer.def( 
                "isTextFetchedFromProperty"
                , isTextFetchedFromProperty_function_type( &::CEGUI::TextComponent::isTextFetchedFromProperty )
                , "*!\n\
                    \n\
                        Return whether this TextComponent fetches it's text string via a property on the target\
                        window.\n\
            \n\
                    @return\n\
                        - true if the text string comes via a Propery.\n\
                        - false if the text string is defined explicitly, or will come from the target window.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::operator=
        
            typedef ::CEGUI::TextComponent & ( ::CEGUI::TextComponent::*assign_function_type )( ::CEGUI::TextComponent const & ) ;
            
            TextComponent_exposer.def( 
                "assign"
                , assign_function_type( &::CEGUI::TextComponent::operator= )
                , ( bp::arg("other") )
                , bp::return_self< >()
                , "! Assignment\n" );
        
        }
        { //::CEGUI::TextComponent::setFont
        
            typedef void ( ::CEGUI::TextComponent::*setFont_function_type )( ::CEGUI::String const & ) ;
            
            TextComponent_exposer.def( 
                "setFont"
                , setFont_function_type( &::CEGUI::TextComponent::setFont )
                , ( bp::arg("font") )
                , "*!\n\
                    \n\
                        Set the name of the font to be used when rendering this TextComponent.\n\
            \n\
                        Note that setting this to the empty string () will cause the font from the\n\
                        base window passed when rendering to be used instead.\n\
            \n\
                    @param font\n\
                        String containing name of a font\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::setFontPropertySource
        
            typedef void ( ::CEGUI::TextComponent::*setFontPropertySource_function_type )( ::CEGUI::String const & ) ;
            
            TextComponent_exposer.def( 
                "setFontPropertySource"
                , setFontPropertySource_function_type( &::CEGUI::TextComponent::setFontPropertySource )
                , ( bp::arg("property") )
                , "*!\n\
                    \n\
                        Set the name of the property that will be used to determine the font to use for\
                        rendering\n\
                        the text string of this TextComponent.\n\
            \n\
                    @param property\n\
                        String object holding the name of a Propery.  The property should access a valid font\
                        name.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::setHorizontalFormatting
        
            typedef void ( ::CEGUI::TextComponent::*setHorizontalFormatting_function_type )( ::CEGUI::HorizontalTextFormatting ) ;
            
            TextComponent_exposer.def( 
                "setHorizontalFormatting"
                , setHorizontalFormatting_function_type( &::CEGUI::TextComponent::setHorizontalFormatting )
                , ( bp::arg("fmt") )
                , "*!\n\
                    \n\
                        Set the horizontal formatting setting for this TextComponent.\n\
            \n\
                    @param fmt\n\
                        One of the HorizontalTextFormatting enumerated values.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::setText
        
            typedef void ( ::CEGUI::TextComponent::*setText_function_type )( ::CEGUI::String const & ) ;
            
            TextComponent_exposer.def( 
                "setText"
                , setText_function_type( &::CEGUI::TextComponent::setText )
                , ( bp::arg("text") )
                , "*!\n\
                    \n\
                        Set the text that will be rendered by this TextComponent.\n\
            \n\
                        Note that setting this to the empty string () will cause the text from the\n\
                        base window passed when rendering to be used instead.\n\
            \n\
                    @param text\n\
                        String containing text to render, or  to render text from window.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::setTextPropertySource
        
            typedef void ( ::CEGUI::TextComponent::*setTextPropertySource_function_type )( ::CEGUI::String const & ) ;
            
            TextComponent_exposer.def( 
                "setTextPropertySource"
                , setTextPropertySource_function_type( &::CEGUI::TextComponent::setTextPropertySource )
                , ( bp::arg("property") )
                , "*!\n\
                    \n\
                        Set the name of the property that will be used to determine the text string to render\n\
                        for this TextComponent.\n\
            \n\
                    @param property\n\
                        String object holding the name of a Propery.  The property can contain any text string\
                        to render.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::setVerticalFormatting
        
            typedef void ( ::CEGUI::TextComponent::*setVerticalFormatting_function_type )( ::CEGUI::VerticalTextFormatting ) ;
            
            TextComponent_exposer.def( 
                "setVerticalFormatting"
                , setVerticalFormatting_function_type( &::CEGUI::TextComponent::setVerticalFormatting )
                , ( bp::arg("fmt") )
                , "*!\n\
                    \n\
                        Set the vertical formatting setting for this TextComponent.\n\
            \n\
                    @param fmt\n\
                        One of the VerticalTextFormatting enumerated values.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::TextComponent::writeXMLToStream
        
            typedef void ( ::CEGUI::TextComponent::*writeXMLToStream_function_type )( ::CEGUI::XMLSerializer & ) const;
            
            TextComponent_exposer.def( 
                "writeXMLToStream"
                , writeXMLToStream_function_type( &::CEGUI::TextComponent::writeXMLToStream )
                , ( bp::arg("xml_stream") )
                , "*!\n\
                    \n\
                        Writes an xml representation of this TextComponent to  out_stream.\n\
            \n\
                    @param xml_stream\n\
                        Stream where xml data should be output.\n\
            \n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
    }

}
