/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.24
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/event.h>

        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxEvent_Clone, "Clone() -> Event\n"
"\n"
"Returns a copy of the event.");

extern "C" {static PyObject *meth_wxEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
             ::wxEvent*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_Event, sipName_Clone);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Clone();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxEvent,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_Clone, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_GetEventObject, "GetEventObject() -> Object\n"
"\n"
"Returns the object (usually a window) associated with the event, if\n"
"any.");

extern "C" {static PyObject *meth_wxEvent_GetEventObject(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_GetEventObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
             ::wxObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEventObject();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxObject,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_GetEventObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_GetEventType, "GetEventType() -> EventType\n"
"\n"
"Returns the identifier of the given event type, such as wxEVT_BUTTON.");

extern "C" {static PyObject *meth_wxEvent_GetEventType(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_GetEventType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
             ::wxEventType sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEventType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_GetEventType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_GetEventCategory, "GetEventCategory() -> EventCategory\n"
"\n"
"Returns a generic category for this event.");

extern "C" {static PyObject *meth_wxEvent_GetEventCategory(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_GetEventCategory(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
             ::wxEventCategory sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxEvent::GetEventCategory() : sipCpp->GetEventCategory());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxEventCategory);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_GetEventCategory, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_GetId, "GetId() -> int\n"
"\n"
"Returns the identifier associated with this event, such as a button\n"
"command id.");

extern "C" {static PyObject *meth_wxEvent_GetId(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_GetId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_GetId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_GetSkipped, "GetSkipped() -> bool\n"
"\n"
"Returns true if the event handler should be skipped, false otherwise.");

extern "C" {static PyObject *meth_wxEvent_GetSkipped(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_GetSkipped(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSkipped();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_GetSkipped, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_GetTimestamp, "GetTimestamp() -> long\n"
"\n"
"Gets the timestamp for the event.");

extern "C" {static PyObject *meth_wxEvent_GetTimestamp(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_GetTimestamp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTimestamp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_GetTimestamp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_IsCommandEvent, "IsCommandEvent() -> bool\n"
"\n"
"Returns true if the event is or is derived from wxCommandEvent else it\n"
"returns false.");

extern "C" {static PyObject *meth_wxEvent_IsCommandEvent(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_IsCommandEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsCommandEvent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_IsCommandEvent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_ResumePropagation, "ResumePropagation(propagationLevel)\n"
"\n"
"Sets the propagation level to the given value (for example returned\n"
"from an earlier call to wxEvent::StopPropagation).");

extern "C" {static PyObject *meth_wxEvent_ResumePropagation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvent_ResumePropagation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int propagationLevel;
         ::wxEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_propagationLevel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxEvent, &sipCpp, &propagationLevel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ResumePropagation(propagationLevel);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_ResumePropagation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_SetEventObject, "SetEventObject(object)\n"
"\n"
"Sets the originating object.");

extern "C" {static PyObject *meth_wxEvent_SetEventObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvent_SetEventObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxObject* object;
         ::wxEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_object,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxEvent, &sipCpp, sipType_wxObject, &object))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEventObject(object);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_SetEventObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_SetEventType, "SetEventType(type)\n"
"\n"
"Sets the event type.");

extern "C" {static PyObject *meth_wxEvent_SetEventType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvent_SetEventType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxEventType type;
         ::wxEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxEvent, &sipCpp, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEventType(type);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_SetEventType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_SetId, "SetId(id)\n"
"\n"
"Sets the identifier associated with this event, such as a button\n"
"command id.");

extern "C" {static PyObject *meth_wxEvent_SetId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvent_SetId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
         ::wxEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxEvent, &sipCpp, &id))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetId(id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_SetId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_SetTimestamp, "SetTimestamp(timeStamp=0)\n"
"\n"
"Sets the timestamp for the event.");

extern "C" {static PyObject *meth_wxEvent_SetTimestamp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvent_SetTimestamp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long timeStamp = 0;
         ::wxEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_timeStamp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|l", &sipSelf, sipType_wxEvent, &sipCpp, &timeStamp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTimestamp(timeStamp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_SetTimestamp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_ShouldPropagate, "ShouldPropagate() -> bool\n"
"\n"
"Test if this event should be propagated or not, i.e. if the\n"
"propagation level is currently greater than 0.");

extern "C" {static PyObject *meth_wxEvent_ShouldPropagate(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_ShouldPropagate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ShouldPropagate();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_ShouldPropagate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_Skip, "Skip(skip=True)\n"
"\n"
"This method can be used inside an event handler to control whether\n"
"further event handlers bound to this event will be called after the\n"
"current one returns.");

extern "C" {static PyObject *meth_wxEvent_Skip(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxEvent_Skip(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool skip = 1;
         ::wxEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_skip,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxEvent, &sipCpp, &skip))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Skip(skip);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_Skip, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxEvent_StopPropagation, "StopPropagation() -> int\n"
"\n"
"Stop the event from propagating to its parent window.");

extern "C" {static PyObject *meth_wxEvent_StopPropagation(PyObject *, PyObject *);}
static PyObject *meth_wxEvent_StopPropagation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->StopPropagation();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Event, sipName_StopPropagation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxEvent(void *, const sipTypeDef *);}
static void *cast_wxEvent(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxEvent *sipCpp = reinterpret_cast< ::wxEvent *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxEvent(void *, int);}
static void release_wxEvent(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxEvent(sipSimpleWrapper *);}
static void dealloc_wxEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxEvent(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxEvent[] = {{371, 255, 1}};


static PyMethodDef methods_wxEvent[] = {
    {SIP_MLNAME_CAST(sipName_Clone), meth_wxEvent_Clone, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_Clone)},
    {SIP_MLNAME_CAST(sipName_GetEventCategory), meth_wxEvent_GetEventCategory, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_GetEventCategory)},
    {SIP_MLNAME_CAST(sipName_GetEventObject), meth_wxEvent_GetEventObject, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_GetEventObject)},
    {SIP_MLNAME_CAST(sipName_GetEventType), meth_wxEvent_GetEventType, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_GetEventType)},
    {SIP_MLNAME_CAST(sipName_GetId), meth_wxEvent_GetId, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_GetId)},
    {SIP_MLNAME_CAST(sipName_GetSkipped), meth_wxEvent_GetSkipped, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_GetSkipped)},
    {SIP_MLNAME_CAST(sipName_GetTimestamp), meth_wxEvent_GetTimestamp, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_GetTimestamp)},
    {SIP_MLNAME_CAST(sipName_IsCommandEvent), meth_wxEvent_IsCommandEvent, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_IsCommandEvent)},
    {SIP_MLNAME_CAST(sipName_ResumePropagation), SIP_MLMETH_CAST(meth_wxEvent_ResumePropagation), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEvent_ResumePropagation)},
    {SIP_MLNAME_CAST(sipName_SetEventObject), SIP_MLMETH_CAST(meth_wxEvent_SetEventObject), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEvent_SetEventObject)},
    {SIP_MLNAME_CAST(sipName_SetEventType), SIP_MLMETH_CAST(meth_wxEvent_SetEventType), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEvent_SetEventType)},
    {SIP_MLNAME_CAST(sipName_SetId), SIP_MLMETH_CAST(meth_wxEvent_SetId), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEvent_SetId)},
    {SIP_MLNAME_CAST(sipName_SetTimestamp), SIP_MLMETH_CAST(meth_wxEvent_SetTimestamp), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEvent_SetTimestamp)},
    {SIP_MLNAME_CAST(sipName_ShouldPropagate), meth_wxEvent_ShouldPropagate, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_ShouldPropagate)},
    {SIP_MLNAME_CAST(sipName_Skip), SIP_MLMETH_CAST(meth_wxEvent_Skip), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxEvent_Skip)},
    {SIP_MLNAME_CAST(sipName_StopPropagation), meth_wxEvent_StopPropagation, METH_VARARGS, SIP_MLDOC_CAST(doc_wxEvent_StopPropagation)}
};

sipVariableDef variables_wxEvent[] = {
    {PropertyVariable, sipName_Timestamp, &methods_wxEvent[6], &methods_wxEvent[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Skipped, &methods_wxEvent[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Id, &methods_wxEvent[4], &methods_wxEvent[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_EventType, &methods_wxEvent[3], &methods_wxEvent[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_EventObject, &methods_wxEvent[2], &methods_wxEvent[9], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxEvent, "Event(id=0, eventType=wxEVT_NULL)\n"
"\n"
"An event is a structure holding information about an event passed to a\n"
"callback or member function.");


sipClassTypeDef sipTypeDef__core_wxEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxEvent,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Event,
        {0, 0, 1},
        16, methods_wxEvent,
        0, SIP_NULLPTR,
        5, variables_wxEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxEvent,
    -1,
    -1,
    supers_wxEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxEvent,
    cast_wxEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
