
// <ACEStransformID>urn:ampas:aces:transformId:v1.5:ACEScsc.Academy.SLog3_SGamut3Cine_to_ACES.a1.1.0</ACEStransformID>
// <ACESuserName>Sony S-Log3 S-Gamut3.Cine to ACES2065-1</ACESuserName>

//
// ACES Color Space Conversion - Sony S-Log3 S-Gamut3.Cine to ACES
//
// converts Sony S-Log3 S-Gamut3.Cine to
//          ACES2065-1 (AP0 w/ linear encoding)
//



import "ACESlib.Utilities_Color";


const float SGAMUT3_CINE_2_AP0_MAT[3][3] = 
                        calculate_rgb_to_rgb_matrix( SONY_SGAMUT3_CINE_PRI, 
                                                     AP0, 
                                                     CONE_RESP_MAT_CAT02);


float SLog3_to_lin( input varying float in)
{
    float out;
    if ( in >= 171.2102946929 / 1023.0 )
    {
        out = pow(10.0, (in * 1023.0 - 420.0) / 261.5) * (0.18 + 0.01) - 0.01;
    }
    else
    {
        out = (in * 1023.0 - 95.0) * 0.01125000 / (171.2102946929 - 95.0);
    }
    return out;
}



void main
(   
    input varying float rIn,
    input varying float gIn,
    input varying float bIn,
    input varying float aIn,
    output varying float rOut,
    output varying float gOut,
    output varying float bOut,
    output varying float aOut
)
{
    float lin_SGamut3Cine[3];
    lin_SGamut3Cine[0] = SLog3_to_lin( rIn);
    lin_SGamut3Cine[1] = SLog3_to_lin( gIn);
    lin_SGamut3Cine[2] = SLog3_to_lin( bIn);

    float ACES[3] = mult_f3_f33( lin_SGamut3Cine, SGAMUT3_CINE_2_AP0_MAT);
  
    rOut = ACES[0];
    gOut = ACES[1];
    bOut = ACES[2];
    aOut = aIn;
}