#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QProcess>
#include "objects.h"

namespace Ui
{
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    int versionId;
    QString version;
    QString fileFilter;
    QString lastFileDirectory;
    QList<Profile> profileList;

    bool justJoin;
    QStringList joinList;
    QStringList convertList;
    QStringList listToRemove;
    QString finalOutputFilename;
    QString ext;

    QProcess joinProcess;
    QProcess convertProcess;

    void loadSettings();
    void saveSettings();
    void showProfiles();
    void showError(QString text, QString info);

    void startProcess();
    void doConvert();
    void doJoin();

private slots:
    void on_actionAbout_triggered();
    void on_actionOnline_Help_triggered();
    void on_btnStart_clicked();
    void on_btnClear_clicked();
    void on_btnRemove_clicked();
    void on_btnAddFiles_clicked();
    void on_btnBrowse_clicked();
    void on_actionE_xit_triggered();
    void on_actionManage_profiles_triggered();
    void on_btnProfiles_clicked();
    void convertExec_finish(int);
    void joinExec_finish(int);

};

#endif // MAINWINDOW_H
