/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2019 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package control;

public class Room {

    public synchronized static void addFreak(Freak freak) {

        Freak[] newFreaks;
        if (Gate.freaks!=null) {
            newFreaks = new Freak[Gate.freaks.length + 1];
            System.arraycopy(Gate.freaks, 0, newFreaks, 0, Gate.freaks.length);
            newFreaks[Gate.freaks.length] = freak;
        } else {
            newFreaks = new Freak[1];
            newFreaks[0] = freak;
        }

        int flags = freak.controlFlags();

        Gate.callBeforeEnabled = growArray(Gate.callBeforeEnabled,((flags&Freak.CONTROL_CALL_BEFORE)!=0));
        Gate.callAfterEnabled = growArray(Gate.callAfterEnabled,((flags&Freak.CONTROL_CALL_AFTER)!=0));
        Gate.callStaticBeforeEnabled = growArray(Gate.callStaticBeforeEnabled,((flags&Freak.CONTROL_STATIC_CALL_BEFORE)!=0));
        Gate.callStaticAfterEnabled = growArray(Gate.callStaticAfterEnabled,((flags&Freak.CONTROL_STATIC_CALL_AFTER)!=0));
        Gate.throwEnabled = growArray(Gate.throwEnabled,((flags&Freak.CONTROL_THROW)!=0));
        Gate.catchEnabled = growArray(Gate.catchEnabled,((flags&Freak.CONTROL_CATCH)!=0));

        Gate.callBeforeEnabledAny = anyEnabled(Gate.callBeforeEnabled);
        Gate.callAfterEnabledAny = anyEnabled(Gate.callAfterEnabled);
        Gate.callStaticBeforeEnabledAny = anyEnabled(Gate.callStaticBeforeEnabled);
        Gate.callStaticAfterEnabledAny = anyEnabled(Gate.callStaticAfterEnabled);
        Gate.throwEnabledAny = anyEnabled(Gate.throwEnabled);
        Gate.catchEnabledAny = anyEnabled(Gate.catchEnabled);

        // last one
        Gate.freaks = newFreaks;
    }

    public synchronized static void disableAllFreaks() {
        Gate.callBeforeEnabledAny = false;
        Gate.callAfterEnabledAny = false;
        Gate.callStaticBeforeEnabledAny = false;
        Gate.callStaticAfterEnabledAny = false;
        Gate.throwEnabledAny = false;
        Gate.catchEnabledAny = false;
    }

    private static boolean[] growArray(boolean[] oldArray,boolean newValue) {
        boolean[] newArray;
        if (oldArray!=null) {
            newArray = new boolean[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = newValue;
        } else {
            newArray = new boolean[1];
            newArray[0] = newValue;
        }
        return newArray;
    }

    private static boolean anyEnabled(boolean[] array) {
        for (int i=0;i<array.length;i++) {
            if (array[i]==true) return true;
        }
        return false;
    }

    public static Class getCallerClass(int depth) {
        return callerContextInstance.callerClass(depth+4);
    }

    private static class CallerContext extends SecurityManager {
        public Class callerClass(int depth) {
            return getClassContext()[depth];
        }
    }

    private static CallerContext callerContextInstance = new CallerContext();

}
