/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.config.ConfigWriter;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.studio.apacheds.configuration.v2.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ConnectionServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.v2.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.v2.jobs.EntryBasedConfigurationPartition;
import org.apache.directory.studio.apacheds.configuration.v2.jobs.PartitionsDiffComputer;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.filesystem.PathEditorInput;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExecuteLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class ServerConfigurationEditorUtils {
    public static IEditorInput saveAs(IProgressMonitor monitor, Shell shell, IEditorInput input, ConfigWriter configWriter) throws Exception {
        boolean isIDE = CommonUIUtils.isIDEEnvironment();
        if (isIDE) {
            SaveAsDialog dialog = new SaveAsDialog(shell);
            String inputClassName = input.getClass().getName();
            if (input instanceof FileEditorInput) {
                dialog.setOriginalFile(((FileEditorInput)input).getFile());
            } else if (input instanceof IPathEditorInput) {
                dialog.setOriginalFile(ResourcesPlugin.getWorkspace().getRoot().getFile(((IPathEditorInput)input).getPath()));
            } else if (inputClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || inputClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
                dialog.setOriginalFile(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(input.getToolTipText())));
            } else {
                dialog.setOriginalName("config.ldif");
            }
            if (ServerConfigurationEditorUtils.openDialogInUIThread((Dialog)dialog) != 0) {
                return null;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(dialog.getResult());
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
            }
            FileEditorInput fei = new FileEditorInput(file);
            ServerConfigurationEditorUtils.saveConfiguration(fei, configWriter, monitor);
            return fei;
        }
        boolean canOverwrite = false;
        String path = null;
        while (!canOverwrite) {
            path = ServerConfigurationEditorUtils.openFileDialogInUIThread(shell);
            if (path == null) {
                return null;
            }
            File externalFile = new File(path);
            if (externalFile.exists()) {
                String question = NLS.bind((String)Messages.getString("ServerConfigurationEditorUtils.TheFileAlreadyExistsWantToReplace"), (Object)path);
                MessageDialog overwriteDialog = new MessageDialog(shell, Messages.getString("ServerConfigurationEditorUtils.Question"), null, question, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                int overwrite = ServerConfigurationEditorUtils.openDialogInUIThread((Dialog)overwriteDialog);
                switch (overwrite) {
                    case 0: {
                        canOverwrite = true;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                continue;
            }
            canOverwrite = true;
        }
        ServerConfigurationEditorUtils.saveConfiguration(path, configWriter);
        PathEditorInput newInput = new PathEditorInput((IPath)new Path(path));
        return newInput;
    }

    private static int openDialogInUIThread(final Dialog dialog) {
        class DialogResult {
            private int result;

            DialogResult() {
            }

            public int getResult() {
                return this.result;
            }

            public void setResult(int result) {
                this.result = result;
            }
        }
        final DialogResult result = new DialogResult();
        Display.getDefault().syncExec(new Runnable(){
            {
            }

            @Override
            public void run() {
                result.setResult(dialog.open());
            }
        });
        return result.getResult();
    }

    private static String openFileDialogInUIThread(final Shell shell) {
        class DialogResult {
            private String result;

            DialogResult() {
            }

            public String getResult() {
                return this.result;
            }

            public void setResult(String result) {
                this.result = result;
            }
        }
        final DialogResult result = new DialogResult();
        Display.getDefault().syncExec(new Runnable(){
            {
            }

            @Override
            public void run() {
                FileDialog dialog = new FileDialog(shell, 8192);
                result.setResult(dialog.open());
            }
        });
        return result.getResult();
    }

    public static void saveConfiguration(FileEditorInput input, ConfigWriter configWriter, IProgressMonitor monitor) throws Exception {
        input.getFile().setContents((InputStream)new ByteArrayInputStream(configWriter.writeToString().getBytes()), true, true, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfiguration(ConnectionServerConfigurationInput input, ConfigWriter configWriter, IProgressMonitor monitor) throws Exception {
        EntryBasedConfigurationPartition originalPartition = input.getOriginalPartition();
        SchemaManager schemaManager = ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager();
        EntryBasedConfigurationPartition newconfigurationPartition = new EntryBasedConfigurationPartition(schemaManager);
        newconfigurationPartition.initialize();
        List convertedLdifEntries = configWriter.getConvertedLdifEntries();
        for (LdifEntry ldifEntry : convertedLdifEntries) {
            newconfigurationPartition.addEntry((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
        }
        ConnectionEventRegistry.suspendEventFiringInCurrentThread();
        try {
            PartitionsDiffComputer partitionsDiffComputer = new PartitionsDiffComputer();
            partitionsDiffComputer.setOriginalPartition((Partition)originalPartition);
            partitionsDiffComputer.setDestinationPartition((Partition)newconfigurationPartition);
            List<LdifEntry> modificationsList = partitionsDiffComputer.computeModifications(new String[]{"*"});
            StringBuilder modificationsLdif = new StringBuilder();
            for (LdifEntry ldifEntry : modificationsList) {
                modificationsLdif.append(ldifEntry.toString());
            }
            IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(input.getConnection());
            StudioProgressMonitor studioProgressMonitor = new StudioProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            ExecuteLdifRunnable.executeLdif((IBrowserConnection)browserConnection, (String)modificationsLdif.toString(), (boolean)true, (boolean)true, (StudioProgressMonitor)studioProgressMonitor);
            if (studioProgressMonitor.errorsReported()) {
                throw new Exception(Messages.getString("ServerConfigurationEditorUtils.ChangesCouldNotBeSavedToConnection"));
            }
            input.setOriginalPartition(newconfigurationPartition);
        }
        finally {
            ConnectionEventRegistry.resumeEventFiringInCurrentThread();
        }
    }

    public static void saveConfiguration(File file, ConfigWriter configWriter) throws Exception {
        configWriter.writeToFile(file);
    }

    public static void saveConfiguration(String path, ConfigWriter configWriter) throws Exception {
        ServerConfigurationEditorUtils.saveConfiguration(new File(path), configWriter);
    }

    public static String checkNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String checkEmptyString(String s) {
        if ("".equals(s)) {
            return null;
        }
        return s;
    }
}

