/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.jobs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.AttributeUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.config.ConfigPartitionReader;
import org.apache.directory.server.config.ReadOnlyConfigurationPartition;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.studio.apacheds.configuration.v2.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ConnectionServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.v2.editor.NewServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.v2.jobs.EntryBasedConfigurationPartition;
import org.apache.directory.studio.apacheds.configuration.v2.jobs.Messages;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.io.StudioNamingEnumeration;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class LoadConfigurationRunnable
implements StudioRunnableWithProgress {
    private ServerConfigurationEditor editor;

    public LoadConfigurationRunnable(ServerConfigurationEditor editor) {
        this.editor = editor;
    }

    public String getErrorMessage() {
        return Messages.getString("LoadConfigurationRunnable.UnableToLoadConfiguration");
    }

    public Object[] getLockedObjects() {
        return new Object[0];
    }

    public String getName() {
        return Messages.getString("LoadConfigurationRunnable.LoadConfiguration");
    }

    public void run(StudioProgressMonitor monitor) {
        IEditorInput input = this.editor.getEditorInput();
        try {
            final ConfigBean configBean = this.getConfiguration(input, monitor);
            if (configBean != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LoadConfigurationRunnable.this.editor.configurationLoaded(configBean);
                    }
                });
            }
        }
        catch (Exception e) {
            monitor.reportError(e);
            final Exception exception = e;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LoadConfigurationRunnable.this.editor.configurationLoadFailed(exception);
                }
            });
        }
    }

    public ConfigBean getConfiguration(IEditorInput input, StudioProgressMonitor monitor) throws Exception {
        String inputClassName = input.getClass().getName();
        if (input instanceof NewServerConfigurationInput) {
            InputStream is = ApacheDS2ConfigurationPlugin.class.getResourceAsStream("config.ldif");
            return LoadConfigurationRunnable.readConfiguration(is);
        }
        if (input instanceof ConnectionServerConfigurationInput) {
            return this.readConfiguration((ConnectionServerConfigurationInput)input, monitor);
        }
        if (input instanceof FileEditorInput) {
            InputStream is = ((FileEditorInput)input).getFile().getContents();
            return LoadConfigurationRunnable.readConfiguration(is);
        }
        if (input instanceof IPathEditorInput) {
            FileInputStream is = new FileInputStream(new File(((IPathEditorInput)input).getPath().toOSString()));
            return LoadConfigurationRunnable.readConfiguration(is);
        }
        if (inputClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || inputClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
            FileInputStream is = new FileInputStream(new File(input.getToolTipText()));
            return LoadConfigurationRunnable.readConfiguration(is);
        }
        return null;
    }

    public static ConfigBean readConfiguration(InputStream is) throws Exception {
        if (is != null) {
            ReadOnlyConfigurationPartition configurationPartition = new ReadOnlyConfigurationPartition(is, ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager());
            configurationPartition.initialize();
            return LoadConfigurationRunnable.readConfiguration((AbstractBTreePartition)configurationPartition);
        }
        return null;
    }

    private static ConfigBean readConfiguration(AbstractBTreePartition partition) throws LdapException {
        if (partition != null) {
            ConfigPartitionReader cpReader = new ConfigPartitionReader(partition);
            return cpReader.readConfig();
        }
        return null;
    }

    private ConfigBean readConfiguration(ConnectionServerConfigurationInput input, StudioProgressMonitor monitor) throws Exception {
        if (input != null) {
            SchemaManager schemaManager = ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager();
            IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(input.getConnection());
            EntryBasedConfigurationPartition configurationPartition = new EntryBasedConfigurationPartition(schemaManager);
            configurationPartition.initialize();
            this.openConnection(input, monitor);
            SearchParameter configSearchParameter = new SearchParameter();
            configSearchParameter.setSearchBase(new Dn(new String[]{"ou=config"}));
            configSearchParameter.setFilter("(objectClass=*)");
            configSearchParameter.setScope(SearchScope.OBJECT);
            configSearchParameter.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
            DefaultEntry configEntry = null;
            StudioNamingEnumeration enumeration = SearchRunnable.search((IBrowserConnection)browserConnection, (SearchParameter)configSearchParameter, (StudioProgressMonitor)monitor);
            if (monitor.errorsReported()) {
                throw monitor.getException();
            }
            if (enumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)enumeration.next();
                configEntry = new DefaultEntry(schemaManager, AttributeUtils.toEntry((Attributes)searchResult.getAttributes(), (Dn)new Dn(new String[]{searchResult.getNameInNamespace()})));
            }
            enumeration.close();
            if (configEntry == null) {
                throw new LdapNoSuchObjectException(Messages.getString("LoadConfigurationRunnable.UnableToFindConfigBaseEntry"));
            }
            ArrayList<DefaultEntry> entries = new ArrayList<DefaultEntry>();
            entries.add(configEntry);
            while (!entries.isEmpty()) {
                Entry entry = (Entry)entries.remove(0);
                configurationPartition.addEntry(entry);
                SearchParameter searchParameter = new SearchParameter();
                searchParameter.setSearchBase(entry.getDn());
                searchParameter.setFilter("(objectClass=*)");
                searchParameter.setScope(SearchScope.ONELEVEL);
                searchParameter.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
                StudioNamingEnumeration childrenEnumeration = SearchRunnable.search((IBrowserConnection)browserConnection, (SearchParameter)searchParameter, (StudioProgressMonitor)monitor);
                if (monitor.errorsReported()) {
                    throw monitor.getException();
                }
                while (childrenEnumeration.hasMore()) {
                    SearchResult searchResult = (SearchResult)childrenEnumeration.next();
                    DefaultEntry childEntry = new DefaultEntry(schemaManager, AttributeUtils.toEntry((Attributes)searchResult.getAttributes(), (Dn)new Dn(new String[]{searchResult.getNameInNamespace()})));
                    entries.add(childEntry);
                }
                childrenEnumeration.close();
            }
            input.setOriginalPartition(configurationPartition);
            return LoadConfigurationRunnable.readConfiguration((AbstractBTreePartition)configurationPartition);
        }
        return null;
    }

    private void openConnection(ConnectionServerConfigurationInput input, StudioProgressMonitor monitor) {
        Connection connection = input.getConnection();
        if (connection != null && !connection.getConnectionWrapper().isConnected()) {
            connection.getConnectionWrapper().connect(monitor);
            if (connection.getConnectionWrapper().isConnected()) {
                connection.getConnectionWrapper().bind(monitor);
            }
            if (connection.getConnectionWrapper().isConnected()) {
                for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                    listener.connectionOpened(connection, monitor);
                }
                ConnectionEventRegistry.fireConnectionOpened((Connection)connection, (Object)input);
            }
        }
    }
}

