/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.studio.apacheds.configuration.v2.jobs.PartitionsDiffException;

public class PartitionsDiffComputer {
    private Partition originalPartition;
    private Partition destinationPartition;

    public PartitionsDiffComputer() {
    }

    public PartitionsDiffComputer(Partition originalPartition, Partition destinationPartition) {
        this.originalPartition = originalPartition;
        this.destinationPartition = destinationPartition;
    }

    public List<LdifEntry> computeModifications() throws Exception {
        return this.computeModifications(this.originalPartition.getSuffixDn(), new String[]{"*", "+"});
    }

    public List<LdifEntry> computeModifications(String[] attributeIds) throws Exception {
        return this.computeModifications(this.originalPartition.getSuffixDn(), attributeIds);
    }

    public List<LdifEntry> computeModifications(Dn baseDn, String[] attributeIds) throws Exception {
        this.checkPartitions();
        return this.comparePartitions(baseDn, attributeIds);
    }

    private void checkPartitions() throws PartitionsDiffException {
        if (this.originalPartition == null) {
            throw new PartitionsDiffException("The original partition must not be 'null'.");
        }
        if (!this.originalPartition.isInitialized()) {
            throw new PartitionsDiffException("The original partition must be intialized.");
        }
        if (this.originalPartition.getSuffixDn() == null) {
            throw new PartitionsDiffException("The original suffix is null.");
        }
        if (this.destinationPartition == null) {
            throw new PartitionsDiffException("The destination partition must not be 'null'.");
        }
        if (!this.destinationPartition.isInitialized()) {
            throw new PartitionsDiffException("The destination partition must be intialized.");
        }
        if (this.destinationPartition.getSuffixDn() == null) {
            throw new PartitionsDiffException("The destination suffix is null.");
        }
    }

    public List<LdifEntry> comparePartitions(Dn baseDn, String[] attributeIds) throws PartitionsDiffException {
        ArrayList<LdifEntry> modifications = new ArrayList<LdifEntry>();
        try {
            EntryFilteringCursor cursor;
            SearchOperationContext soc;
            Entry destinationEntry;
            Entry originalBaseEntry = this.originalPartition.lookup(new LookupOperationContext(null, baseDn, attributeIds));
            if (originalBaseEntry == null) {
                throw new PartitionsDiffException("Unable to find the base entry in the original partition.");
            }
            ArrayList<Entry> originalEntries = new ArrayList<Entry>();
            originalEntries.add(originalBaseEntry);
            while (originalEntries.size() > 0) {
                Entry originalEntry = (Entry)originalEntries.remove(0);
                LdifEntry modificationEntry = new LdifEntry();
                modificationEntry.setDn(originalEntry.getDn());
                destinationEntry = this.destinationPartition.lookup(new LookupOperationContext(null, originalEntry.getDn(), attributeIds));
                if (destinationEntry != null) {
                    modificationEntry.setChangeType(ChangeType.Modify);
                    this.compareEntries(originalEntry, destinationEntry, modificationEntry);
                } else {
                    modificationEntry.setChangeType(ChangeType.Delete);
                }
                ChangeType modificationEntryChangeType = modificationEntry.getChangeType();
                if (modificationEntryChangeType != ChangeType.None && (modificationEntryChangeType == ChangeType.Delete || modificationEntryChangeType == ChangeType.Modify && modificationEntry.getModifications().size() > 0)) {
                    modifications.add(modificationEntry);
                }
                soc = new SearchOperationContext(null, originalEntry.getDn(), SearchScope.ONELEVEL, FilterParser.parse((SchemaManager)this.originalPartition.getSchemaManager(), (String)"(objectClass=*)"), attributeIds);
                soc.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
                cursor = this.originalPartition.search(soc);
                while (cursor.next()) {
                    originalEntries.add(((ClonedServerEntry)cursor.get()).getClonedEntry());
                }
            }
            Collections.reverse(modifications);
            Entry destinationBaseEntry = this.destinationPartition.lookup(new LookupOperationContext(null, baseDn, attributeIds));
            if (destinationBaseEntry == null) {
                throw new PartitionsDiffException("Unable to find the base entry in the destination partition.");
            }
            ArrayList<Entry> destinationEntries = new ArrayList<Entry>();
            destinationEntries.add(originalBaseEntry);
            while (destinationEntries.size() > 0) {
                destinationEntry = (Entry)destinationEntries.remove(0);
                Entry originalEntry = this.originalPartition.lookup(new LookupOperationContext(null, destinationEntry.getDn(), attributeIds));
                if (originalEntry == null) {
                    LdifEntry modificationEntry = new LdifEntry();
                    modificationEntry.setDn(destinationEntry.getDn());
                    modificationEntry.setChangeType(ChangeType.Add);
                    for (Attribute attribute : destinationEntry) {
                        modificationEntry.addAttribute(attribute);
                    }
                    modifications.add(modificationEntry);
                }
                soc = new SearchOperationContext(null, destinationEntry.getDn(), SearchScope.ONELEVEL, FilterParser.parse((SchemaManager)this.originalPartition.getSchemaManager(), (String)"(objectClass=*)"), attributeIds);
                soc.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
                cursor = this.destinationPartition.search(soc);
                while (cursor.next()) {
                    destinationEntries.add(((ClonedServerEntry)cursor.get()).getClonedEntry());
                }
            }
        }
        catch (Exception e) {
            throw new PartitionsDiffException(e);
        }
        return modifications;
    }

    private void compareEntries(Entry originalEntry, Entry destinationEntry, LdifEntry modificationEntry) {
        ArrayList<AttributeType> evaluatedATs = new ArrayList<AttributeType>();
        for (Attribute originalAttribute : originalEntry) {
            AttributeType originalAttributeType = originalAttribute.getAttributeType();
            if (originalAttributeType.getUsage() != UsageEnum.USER_APPLICATIONS) continue;
            Attribute destinationAttribute = destinationEntry.get(originalAttributeType);
            if (destinationAttribute == null) {
                DefaultModification modification = new DefaultModification();
                modification.setOperation(ModificationOperation.REMOVE_ATTRIBUTE);
                modification.setAttribute((Attribute)new DefaultAttribute(originalAttribute.getAttributeType()));
                modificationEntry.addModification((Modification)modification);
            } else {
                this.compareAttributes(originalAttribute, destinationAttribute, modificationEntry);
            }
            evaluatedATs.add(originalAttributeType);
        }
        for (Attribute destinationAttribute : destinationEntry) {
            AttributeType destinationAttributeType = destinationAttribute.getAttributeType();
            if (destinationAttributeType.getUsage() != UsageEnum.USER_APPLICATIONS || evaluatedATs.contains(destinationAttributeType)) continue;
            DefaultModification modification = new DefaultModification();
            modification.setOperation(ModificationOperation.ADD_ATTRIBUTE);
            DefaultAttribute attribute = new DefaultAttribute(destinationAttributeType);
            modification.setAttribute((Attribute)attribute);
            for (Value value : destinationAttribute) {
                try {
                    attribute.add(new Value[]{value});
                }
                catch (LdapInvalidAttributeValueException liave) {}
            }
            modificationEntry.addModification((Modification)modification);
        }
    }

    private void compareAttributes(Attribute originalAttribute, Attribute destinationAttribute, LdifEntry modificationEntry) {
        DefaultAttribute attribute;
        DefaultModification modification;
        ArrayList<Value> evaluatedValues = new ArrayList<Value>();
        for (Value originalValue : originalAttribute) {
            if (!destinationAttribute.contains(new Value[]{originalValue})) {
                modification = new DefaultModification();
                modification.setOperation(ModificationOperation.REMOVE_ATTRIBUTE);
                attribute = new DefaultAttribute(originalAttribute.getAttributeType());
                modification.setAttribute((Attribute)attribute);
                try {
                    attribute.add(new Value[]{originalValue});
                }
                catch (LdapInvalidAttributeValueException liave) {
                    // empty catch block
                }
                modificationEntry.addModification((Modification)modification);
            }
            evaluatedValues.add(originalValue);
        }
        for (Value destinationValue : destinationAttribute) {
            if (evaluatedValues.contains(destinationValue)) continue;
            modification = new DefaultModification();
            modification.setOperation(ModificationOperation.ADD_ATTRIBUTE);
            attribute = new DefaultAttribute(originalAttribute.getAttributeType());
            modification.setAttribute((Attribute)attribute);
            try {
                attribute.add(new Value[]{destinationValue});
            }
            catch (LdapInvalidAttributeValueException liave) {
                // empty catch block
            }
            modificationEntry.addModification((Modification)modification);
        }
    }

    public Partition getOriginalPartition() {
        return this.originalPartition;
    }

    public void setOriginalPartition(Partition originalPartition) {
        this.originalPartition = originalPartition;
    }

    public Partition getDestinationPartition() {
        return this.destinationPartition;
    }

    public void setDestinationPartition(Partition destinationPartition) {
        this.destinationPartition = destinationPartition;
    }
}

