/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.reponse;

import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.dsmlv2.reponse.AbstractResultResponseDsml;
import org.apache.directory.api.dsmlv2.reponse.LdapResultDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.util.Strings;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;

public class ExtendedResponseDsml
extends AbstractResultResponseDsml<ExtendedResponse>
implements ExtendedResponse {
    private static final String EXTENDED_RESPONSE_TAG = "extendedResponse";
    private byte[] response;

    public ExtendedResponseDsml(LdapApiService codec) {
        super(codec, new ExtendedResponseImpl(""));
    }

    public ExtendedResponseDsml(LdapApiService codec, ExtendedResponse ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((ExtendedResponse)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        byte[] response;
        Object element = null;
        element = root != null ? root.addElement(EXTENDED_RESPONSE_TAG) : new DefaultElement(EXTENDED_RESPONSE_TAG);
        ExtendedResponse extendedResponse = (ExtendedResponse)this.getDecorated();
        LdapResultDsml ldapResultDsml = new LdapResultDsml(this.getCodecService(), ((ExtendedResponse)this.getDecorated()).getLdapResult(), (Message)this.getDecorated());
        ldapResultDsml.toDsml((Element)element);
        String responseName = extendedResponse.getResponseName();
        if (responseName != null) {
            element.addElement("responseName").addText(responseName);
        }
        if ((response = this.getResponseValue()) != null) {
            if (ParserUtils.needsBase64Encoding(response)) {
                Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                element.getDocument().getRootElement().add(xsdNamespace);
                element.getDocument().getRootElement().add(xsiNamespace);
                Element responseElement = element.addElement("response").addText(ParserUtils.base64Encode(response));
                responseElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
            } else {
                element.addElement("response").addText(Strings.utf8ToString((byte[])response));
            }
        }
        return element;
    }

    public void setResponseName(String oid) {
        ((ExtendedResponse)this.getDecorated()).setResponseName(oid);
    }

    public String getResponseName() {
        return ((ExtendedResponse)this.getDecorated()).getResponseName();
    }

    public void setResponseName(Oid responseName) {
        ((ExtendedResponse)this.getDecorated()).setResponseName(responseName.toString());
    }

    public byte[] getResponseValue() {
        return this.response;
    }

    public void setResponseValue(byte[] response) {
        this.response = response;
    }
}

