/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.cursor.AllEntriesCursor;
import org.apache.directory.server.xdbm.search.evaluator.SubstringEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstringCursor
extends AbstractIndexCursor<String> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_725, (Object[])new Object[0]);
    private final boolean hasIndex;
    private final Cursor<IndexEntry<String, String>> wrapped;
    private final SubstringEvaluator evaluator;
    private final IndexEntry<String, String> indexEntry = new IndexEntry();

    public SubstringCursor(Store store, SubstringEvaluator substringEvaluator) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating SubstringCursor {}", (Object)this);
        }
        this.evaluator = substringEvaluator;
        this.hasIndex = store.hasIndexOn(this.evaluator.getExpression().getAttributeType());
        this.wrapped = this.hasIndex ? store.getIndex(this.evaluator.getExpression().getAttributeType()).forwardCursor() : new AllEntriesCursor(store);
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        if (this.evaluator.getExpression().getInitial() != null && this.hasIndex) {
            IndexEntry indexEntry = new IndexEntry();
            indexEntry.setKey(this.evaluator.getExpression().getInitial());
            this.wrapped.before(indexEntry);
        } else {
            this.wrapped.beforeFirst();
        }
        this.clear();
    }

    private void clear() {
        this.setAvailable(false);
        this.indexEntry.setEntry(null);
        this.indexEntry.setId(null);
        this.indexEntry.setKey(null);
    }

    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.clear();
    }

    public boolean first() throws LdapException, CursorException, IOException {
        this.beforeFirst();
        return this.next();
    }

    private boolean evaluateCandidate(IndexEntry<String, String> indexEntry) throws LdapException {
        if (this.hasIndex) {
            String key = indexEntry.getKey();
            return this.evaluator.getPattern().matcher(key).matches();
        }
        return this.evaluator.evaluate(indexEntry);
    }

    public boolean last() throws LdapException, CursorException, IOException {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws LdapException, CursorException, IOException {
        while (this.wrapped.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry entry = (IndexEntry)this.wrapped.get();
            if (!this.evaluateCandidate(entry)) continue;
            this.setAvailable(true);
            this.indexEntry.setId((String)entry.getId());
            this.indexEntry.setKey((String)entry.getKey());
            this.indexEntry.setEntry(entry.getEntry());
            return true;
        }
        this.clear();
        return false;
    }

    public boolean next() throws LdapException, CursorException, IOException {
        while (this.wrapped.next()) {
            this.checkNotClosed("next()");
            IndexEntry entry = (IndexEntry)this.wrapped.get();
            if (!this.evaluateCandidate(entry)) continue;
            this.setAvailable(true);
            this.indexEntry.setId((String)entry.getId());
            this.indexEntry.setKey((String)entry.getKey());
            this.indexEntry.setEntry(entry.getEntry());
            return true;
        }
        this.clear();
        return false;
    }

    public IndexEntry<String, String> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (this.available()) {
            return this.indexEntry;
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing SubstringCursor {}", (Object)this);
        }
        super.close();
        this.wrapped.close();
        this.clear();
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing SubstringCursor {}", (Object)this);
        }
        super.close(cause);
        this.wrapped.close(cause);
        this.clear();
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("SubstringCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#index<").append(this.hasIndex).append("> :\n");
        sb.append(tabs + "  >>").append(this.evaluator).append('\n');
        sb.append(this.wrapped.toString(tabs + "    "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

