/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.model.LdifInvalidPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.lines.LdifLineBase;

public abstract class LdifContainer
implements Serializable {
    protected List parts;

    protected LdifContainer() {
    }

    protected LdifContainer(LdifPart part) {
        this.parts = new ArrayList(1);
        if (part == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(part);
    }

    public final int getOffset() {
        return ((LdifPart)this.parts.get(0)).getOffset();
    }

    public final int getLength() {
        LdifPart lastPart = this.getLastPart();
        return lastPart.getOffset() + lastPart.getLength() - this.getOffset();
    }

    public final void addInvalid(LdifInvalidPart invalid) {
        if (invalid == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(invalid);
    }

    public final LdifPart getLastPart() {
        return (LdifPart)this.parts.get(this.parts.size() - 1);
    }

    public final LdifPart[] getParts() {
        return this.parts.toArray(new LdifPart[this.parts.size()]);
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(":");
        sb.append(LdifParserConstants.LINE_SEPARATOR);
        LdifPart[] parts = this.getParts();
        for (int i = 0; i < parts.length; ++i) {
            sb.append("    ");
            sb.append(parts[i].toString());
            sb.append(LdifParserConstants.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public final String toRawString() {
        StringBuffer sb = new StringBuffer();
        LdifPart[] parts = this.getParts();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i].toRawString());
        }
        return sb.toString();
    }

    public final String toFormattedString(LdifFormatParameters formatParameters) {
        StringBuffer sb = new StringBuffer();
        LdifPart[] parts = this.getParts();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i].toFormattedString(formatParameters));
        }
        return sb.toString();
    }

    public abstract boolean isValid();

    protected boolean isAbstractValid() {
        if (this.parts.isEmpty()) {
            return false;
        }
        boolean containsLine = false;
        LdifPart[] parts = this.getParts();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] instanceof LdifInvalidPart) {
                return false;
            }
            if (!parts[i].isValid()) {
                return false;
            }
            if (!(parts[i] instanceof LdifLineBase)) continue;
            containsLine = true;
        }
        return containsLine;
    }

    public String getInvalidString() {
        if (this.parts.isEmpty()) {
            return "Empty Container";
        }
        LdifPart[] parts = this.getParts();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].isValid()) continue;
            return parts[i].getInvalidString();
        }
        return null;
    }

    public final void adjustOffset(int adjust) {
        for (LdifPart part : this.parts) {
            part.adjustOffset(adjust);
        }
    }
}

