/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.actions;

import org.apache.directory.studio.ldapservers.LdapServersPlugin;
import org.apache.directory.studio.ldapservers.LdapServersPluginConstants;
import org.apache.directory.studio.ldapservers.actions.Messages;
import org.apache.directory.studio.ldapservers.jobs.StartLdapServerRunnable;
import org.apache.directory.studio.ldapservers.jobs.StudioLdapServerJob;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapter;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterExtension;
import org.apache.directory.studio.ldapservers.views.ServersView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class StartAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public StartAction() {
        super(Messages.getString("StartAction.Start"));
        this.init();
    }

    public StartAction(ServersView view) {
        super(Messages.getString("StartAction.Start"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(LdapServersPluginConstants.CMD_START);
        this.setActionDefinitionId(LdapServersPluginConstants.CMD_START);
        this.setToolTipText(Messages.getString("StartAction.StartToolTip"));
        this.setImageDescriptor(LdapServersPlugin.getDefault().getImageDescriptor("resources/icons/start.gif"));
    }

    public void run() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty() && selection.size() == 1) {
            LdapServer server = (LdapServer)selection.getFirstElement();
            LdapServerAdapterExtension ldapServerAdapterExtension = server.getLdapServerAdapterExtension();
            if (ldapServerAdapterExtension != null && ldapServerAdapterExtension.getInstance() != null) {
                LdapServerAdapter ldapServerAdapter = ldapServerAdapterExtension.getInstance();
                try {
                    String[] portsAlreadyInUse = ldapServerAdapter.checkPortsBeforeServerStart(server);
                    if (portsAlreadyInUse == null || portsAlreadyInUse.length > 0) {
                        String title = null;
                        String message = null;
                        if (portsAlreadyInUse.length == 1) {
                            title = Messages.getString("StartAction.PortInUse");
                            message = NLS.bind((String)Messages.getString("StartAction.PortOfProtocolInUse"), (Object[])new String[]{portsAlreadyInUse[0]});
                        } else {
                            title = Messages.getString("StartAction.PortsInUse");
                            message = Messages.getString("StartAction.PortsOfProtocolsInUse");
                            for (String portAlreadyInUse : portsAlreadyInUse) {
                                message = message + "\n    - " + portAlreadyInUse;
                            }
                        }
                        message = message + "\n\n" + Messages.getString("StartAction.Continue");
                        MessageDialog dialog = new MessageDialog(this.view.getSite().getShell(), title, null, message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        if (dialog.open() == 1) {
                            return;
                        }
                    }
                    StudioLdapServerJob job = new StudioLdapServerJob(new StartLdapServerRunnable(server));
                    job.schedule();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)Messages.getString("StartAction.ErrorStartingServer"), (String)NLS.bind((String)(Messages.getString("StartAction.ServerCanNotBeStarted") + "\n" + Messages.getString("StartAction.Cause")), (Object)server.getName(), (Object)e.getMessage()));
                }
            } else {
                MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)Messages.getString("StartAction.NoLdapServerAdapter"), (String)NLS.bind((String)(Messages.getString("StartAction.ServerCanNotBeStarted") + "\n" + Messages.getString("StartAction.NoLdapServerAdapterCouldBeFound")), (Object)server.getName()));
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

