/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.model;

import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapter;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterExtension;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.apache.directory.studio.ldapservers.model.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class UnknownLdapServerAdapterExtension
extends LdapServerAdapterExtension {
    public UnknownLdapServerAdapterExtension() {
        this.setInstance(new LdapServerAdapter(){

            @Override
            public void add(LdapServer server, StudioProgressMonitor monitor) throws Exception {
                this.showWarningDialog();
            }

            @Override
            public void delete(LdapServer server, StudioProgressMonitor monitor) throws Exception {
            }

            @Override
            public void openConfiguration(LdapServer server, StudioProgressMonitor monitor) throws Exception {
                this.showWarningDialog();
            }

            @Override
            public void start(LdapServer server, StudioProgressMonitor monitor) throws Exception {
                this.showWarningDialog();
                server.setStatus(LdapServerStatus.STOPPED);
            }

            @Override
            public void stop(LdapServer server, StudioProgressMonitor monitor) throws Exception {
                this.showWarningDialog();
                server.setStatus(LdapServerStatus.STOPPED);
            }

            private void showWarningDialog() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommonUIUtils.openWarningDialog((String)Messages.getString("UnknownLdapServerAdapterExtension.ServerAdapterNotAvailable"), (String)NLS.bind((String)Messages.getString("UnknownLdapServerAdapterExtension.ServerCreatedWithServerAdapterNoLongerAvailable"), (Object[])new String[]{UnknownLdapServerAdapterExtension.this.getId(), UnknownLdapServerAdapterExtension.this.getName(), UnknownLdapServerAdapterExtension.this.getVendor(), UnknownLdapServerAdapterExtension.this.getVersion()}));
                    }
                });
            }

            @Override
            public String[] checkPortsBeforeServerStart(LdapServer server) {
                return new String[0];
            }
        });
    }
}

