/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.sourceeditor;

import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;

public class ACIFormattingStrategy
implements IFormattingStrategy {
    public static final String INDENT_STRING = "    ";
    public static final String NEWLINE = BrowserCoreConstants.LINE_SEPARATOR;
    private ISourceViewer sourceViewer;

    public ACIFormattingStrategy(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        String oldContent = this.sourceViewer.getDocument().get();
        String newContent = this.internFormat(oldContent);
        this.sourceViewer.getDocument().set(newContent);
        return null;
    }

    public void formatterStarts(String initialIndentation) {
    }

    public void formatterStops() {
    }

    private String internFormat(String content) {
        StringBuffer sb = new StringBuffer();
        boolean newLineStarted = true;
        boolean inQuotedString = false;
        boolean oneLineMode = false;
        int indent = 0;
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            int x;
            char c = content.charAt(i);
            if (c == '\"') {
                boolean bl = inQuotedString = !inQuotedString;
            }
            if (c == '{' && !inQuotedString) {
                oneLineMode = this.checkInOneLine(i, content);
                if (oneLineMode) {
                    sb.append(c);
                    newLineStarted = false;
                    continue;
                }
                if (!newLineStarted) {
                    sb.append(NEWLINE);
                    for (x = 0; x < indent; ++x) {
                        sb.append(INDENT_STRING);
                    }
                }
                sb.append(c);
                sb.append(NEWLINE);
                newLineStarted = true;
                ++indent;
                for (x = 0; x < indent; ++x) {
                    sb.append(INDENT_STRING);
                }
                continue;
            }
            if (c == '}' && !inQuotedString) {
                if (oneLineMode) {
                    sb.append(c);
                    newLineStarted = false;
                    oneLineMode = false;
                    continue;
                }
                --indent;
                if (newLineStarted) {
                    sb.delete(sb.length() - INDENT_STRING.length(), sb.length());
                } else {
                    sb.append(NEWLINE);
                    for (x = 0; x < indent; ++x) {
                        sb.append(INDENT_STRING);
                    }
                }
                sb.append(c);
                sb.append(NEWLINE);
                newLineStarted = true;
                for (x = 0; x < indent; ++x) {
                    sb.append(INDENT_STRING);
                }
                continue;
            }
            if (c == ',' && !inQuotedString) {
                if (oneLineMode) {
                    sb.append(c);
                    newLineStarted = false;
                    continue;
                }
                sb.append(c);
                sb.append(NEWLINE);
                newLineStarted = true;
                for (x = 0; x < indent; ++x) {
                    sb.append(INDENT_STRING);
                }
                continue;
            }
            if (Character.isWhitespace(c)) {
                char c1 = 'A';
                if (i + 1 < contentLength) {
                    c1 = content.charAt(i + 1);
                }
                if (newLineStarted || c == '\n' || c == '\r' || Character.isWhitespace(c1) || c1 == '\n' || c1 == '\r') continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
            newLineStarted = false;
        }
        return sb.toString();
    }

    private boolean checkInOneLine(int i, String content) {
        boolean inQuote = false;
        int commaCounter = 0;
        int contentLength = content.length();
        for (int k = i + 1; k < contentLength; ++k) {
            char c = content.charAt(k);
            if (c == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (c == '{' && !inQuote) {
                return false;
            }
            if (c == '}' && !inQuote) {
                return true;
            }
            if (c != ',' || inQuote || ++commaCounter <= 1) continue;
            return false;
        }
        return false;
    }
}

