/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionParameter;

public class Utils {
    private static final String DOT_DOT_DOT = "...";
    public static ResourceBundle oidDescriptions = null;
    public static ResourceBundle resultCodeDescriptions;

    public static String getOidDescription(String oid) {
        if (oidDescriptions != null) {
            try {
                return oidDescriptions.getString(oid);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getResultCodeDescription(int code) {
        if (resultCodeDescriptions != null) {
            try {
                return resultCodeDescriptions.getString("" + code);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String shorten(String label, int maxLength) {
        if (label == null) {
            return null;
        }
        if (maxLength < 3) {
            return DOT_DOT_DOT;
        }
        if (label.length() > maxLength) {
            label = label.substring(0, maxLength / 2) + DOT_DOT_DOT + label.substring(label.length() - maxLength / 2, label.length());
        }
        StringBuffer sb = new StringBuffer(maxLength + 3);
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (Character.isISOControl(c)) {
                sb.append('.');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getFilenameString(String s) {
        if (s == null) {
            return null;
        }
        byte[] b = Strings.getBytesUtf8((String)s);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String t;
            if (b[i] == 45 || b[i] == 95 || 48 <= b[i] && b[i] <= 57 || 65 <= b[i] && b[i] <= 90 || 97 <= b[i] && b[i] <= 122) {
                sb.append((char)b[i]);
                continue;
            }
            int x = b[i];
            if (x < 0) {
                x = 256 + x;
            }
            if ((t = Integer.toHexString(x)).length() == 1) {
                t = '0' + t;
            }
            sb.append(t);
        }
        return sb.toString();
    }

    public static LdapUrl getLdapURL(Connection connection, String searchBase, int scope, String filter, String[] attributes) {
        LdapUrl url = new LdapUrl();
        url.setScheme(connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS ? "ldaps://" : "ldap://");
        url.setHost(connection.getHost());
        url.setPort(connection.getPort());
        try {
            url.setDn(new Dn(new String[]{searchBase}));
        }
        catch (LdapInvalidDnException e) {
            // empty catch block
        }
        if (attributes != null) {
            url.setAttributes(Arrays.asList(attributes));
        }
        url.setScope(scope);
        url.setFilter(filter);
        return url;
    }

    public static String getSimpleNormalizedUrl(LdapUrl url) {
        return url.getScheme() + (url.getHost() != null ? Strings.toLowerCase((String)url.getHost()) : "") + ":" + url.getPort();
    }

    public static String getLdapSearchCommandLine(Connection connection, String searchBase, int scope, Connection.AliasDereferencingMethod aliasesDereferencingMethod, long sizeLimit, long timeLimit, String filter, String[] attributes) {
        StringBuilder cmdLine = new StringBuilder();
        cmdLine.append("ldapsearch");
        cmdLine.append(" -H ").append(connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS ? "ldaps://" : "ldap://").append(connection.getHost()).append(":").append(connection.getPort());
        if (connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS) {
            cmdLine.append(" -ZZ");
        }
        switch (connection.getAuthMethod()) {
            case SIMPLE: {
                cmdLine.append(" -x");
                cmdLine.append(" -D \"").append(connection.getBindPrincipal()).append("\"");
                cmdLine.append(" -W");
                break;
            }
            case SASL_CRAM_MD5: {
                cmdLine.append(" -U \"").append(connection.getBindPrincipal()).append("\"");
                cmdLine.append(" -Y \"CRAM-MD5\"");
                break;
            }
            case SASL_DIGEST_MD5: {
                cmdLine.append(" -U \"").append(connection.getBindPrincipal()).append("\"");
                cmdLine.append(" -Y \"DIGEST-MD5\"");
                break;
            }
            case SASL_GSSAPI: {
                cmdLine.append(" -Y \"GSSAPI\"");
            }
        }
        cmdLine.append(" -b \"").append(searchBase).append("\"");
        String scopeAsString = scope == 2 ? "sub" : (scope == 1 ? "one" : "base");
        cmdLine.append(" -s ").append(scopeAsString);
        if (aliasesDereferencingMethod != Connection.AliasDereferencingMethod.NEVER) {
            String aliasAsString = aliasesDereferencingMethod == Connection.AliasDereferencingMethod.ALWAYS ? "always" : (aliasesDereferencingMethod == Connection.AliasDereferencingMethod.FINDING ? "find" : (aliasesDereferencingMethod == Connection.AliasDereferencingMethod.SEARCH ? "search" : "never"));
            cmdLine.append(" -a ").append(aliasAsString);
        }
        if (sizeLimit > 0L) {
            cmdLine.append(" -z ").append(sizeLimit);
        }
        if (timeLimit > 0L) {
            cmdLine.append(" -l ").append(timeLimit);
        }
        cmdLine.append(" \"").append(filter).append("\"");
        if (attributes != null) {
            if (attributes.length == 0) {
                cmdLine.append(" \"1.1\"");
            }
            for (String attribute : attributes) {
                cmdLine.append(" \"").append(attribute).append("\"");
            }
        }
        return cmdLine.toString();
    }

    public static Dn getLdapDn(String dn) {
        if (dn == null) {
            return null;
        }
        try {
            return new Dn(new String[]{dn});
        }
        catch (LdapInvalidDnException e) {
            return null;
        }
    }

    static {
        try {
            oidDescriptions = ResourceBundle.getBundle("org.apache.directory.studio.connection.core.OIDDescriptions");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resultCodeDescriptions = null;
        try {
            resultCodeDescriptions = ResourceBundle.getBundle("org.apache.directory.studio.connection.core.ResultCodeDescriptions");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

