/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorInput;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class SearchResultEditorNavigationLocation
extends NavigationLocation {
    SearchResultEditorNavigationLocation(SearchResultEditor editor) {
        super((IEditorPart)editor);
    }

    public String getText() {
        ISearch search = this.getSearch();
        if (search != null) {
            String connectionName = search.getBrowserConnection().getConnection() != null ? " - " + search.getBrowserConnection().getConnection().getName() : "";
            return NLS.bind((String)Messages.getString("SearchResultEditorNavigationLocation.Search"), (Object[])new String[]{search.getName()}) + connectionName;
        }
        return super.getText();
    }

    public void saveState(IMemento memento) {
        ISearch search = this.getSearch();
        memento.putString("SEARCH", search.getName());
        memento.putString("CONNECTION", search.getBrowserConnection().getConnection().getId());
    }

    public void restoreState(IMemento memento) {
        IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(memento.getString("CONNECTION"));
        ISearch search = connection.getSearchManager().getSearch(memento.getString("SEARCH"));
        super.setInput((Object)new SearchResultEditorInput(search));
    }

    public void restoreLocation() {
        IEditorPart editorPart = this.getEditorPart();
        if (editorPart != null && editorPart instanceof SearchResultEditor) {
            SearchResultEditor searchResultEditor = (SearchResultEditor)editorPart;
            searchResultEditor.setInput((SearchResultEditorInput)this.getInput());
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != currentLocation.getClass()) {
            return false;
        }
        SearchResultEditorNavigationLocation location = (SearchResultEditorNavigationLocation)currentLocation;
        ISearch other = location.getSearch();
        ISearch search = this.getSearch();
        if (other == null && search == null) {
            return true;
        }
        if (other == null || search == null) {
            return false;
        }
        return search.equals(other);
    }

    public void update() {
    }

    private ISearch getSearch() {
        SearchResultEditorInput searchResultEditorInput;
        ISearch search;
        Object editorInput = this.getInput();
        if (editorInput != null && editorInput instanceof SearchResultEditorInput && (search = (searchResultEditorInput = (SearchResultEditorInput)editorInput).getSearch()) != null) {
            return search;
        }
        return null;
    }

    public String toString() {
        return "" + this.getSearch();
    }
}

