/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.connection;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class LinkWithEditorAction
extends Action {
    private ConnectionView connectionView;
    private IPartListener2 editorListener = new IPartListener2(){

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            LinkWithEditorAction.this.linkViewWithEditor(partRef.getPart(false));
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            LinkWithEditorAction.this.linkViewWithEditor(partRef.getPart(false));
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("browserLinkWithEditor".equals(event.getProperty())) {
                LinkWithEditorAction.this.run();
            }
        }
    };

    public LinkWithEditorAction(ConnectionView connectionView) {
        super(Messages.getString("LinkWithEditorAction.LinkWithEditor"), 2);
        super.setImageDescriptor(BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/link_with_editor.gif"));
        super.setEnabled(true);
        this.connectionView = connectionView;
        super.setChecked(BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("browserLinkWithEditor"));
        BrowserUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        if (this.isChecked()) {
            connectionView.getSite().getWorkbenchWindow().getPartService().addPartListener(this.editorListener);
        }
    }

    public void run() {
        this.setChecked(BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("browserLinkWithEditor"));
        if (this.isChecked()) {
            this.connectionView.getSite().getWorkbenchWindow().getPartService().addPartListener(this.editorListener);
            IEditorPart activeEditor = this.connectionView.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
            this.linkViewWithEditor((IWorkbenchPart)activeEditor);
        } else {
            this.connectionView.getSite().getWorkbenchWindow().getPartService().removePartListener(this.editorListener);
        }
    }

    private void linkViewWithEditor(IWorkbenchPart part) {
        if (part != null && this.connectionView != null && part.getSite().getWorkbenchWindow() == this.connectionView.getSite().getWorkbenchWindow()) {
            IStructuredSelection selection;
            Connection objectToSelect = null;
            if (part instanceof IEditorPart) {
                SearchResultEditorInput srei;
                ISearch search;
                IEditorPart editor = (IEditorPart)part;
                IEditorInput input = editor.getEditorInput();
                if (input != null && input instanceof EntryEditorInput) {
                    EntryEditorInput eei = (EntryEditorInput)input;
                    IEntry entry = eei.getResolvedEntry();
                    if (entry != null) {
                        objectToSelect = entry.getBrowserConnection().getConnection();
                    }
                } else if (input != null && input instanceof SearchResultEditorInput && (search = (srei = (SearchResultEditorInput)input).getSearch()) != null) {
                    objectToSelect = search.getBrowserConnection().getConnection();
                }
            }
            if (!(objectToSelect == null || (selection = (IStructuredSelection)this.connectionView.getMainWidget().getViewer().getSelection()).size() == 1 && selection.getFirstElement().equals(objectToSelect))) {
                this.connectionView.select(objectToSelect);
            }
        }
    }

    public void dispose() {
        if (this.editorListener != null) {
            this.connectionView.getSite().getWorkbenchWindow().getPartService().removePartListener(this.editorListener);
            BrowserUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.editorListener = null;
        }
        this.connectionView = null;
    }
}

