/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserCategory;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.ImportLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ImportLdifMainWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ImportLdifWizard
extends Wizard
implements IImportWizard {
    private ImportLdifMainWizardPage mainPage;
    private String ldifFilename;
    private IBrowserConnection importConnection;
    private boolean enableLogging;
    private String logFilename;
    private boolean updateIfEntryExists;
    private boolean continueOnError;

    public ImportLdifWizard() {
        this.setWindowTitle(Messages.getString("ImportLdifWizard.LDIFImport"));
    }

    public ImportLdifWizard(IBrowserConnection importConnection) {
        super.setWindowTitle(Messages.getString("ImportLdifWizard.LDIFImport"));
        this.importConnection = importConnection;
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_IMPORT_LDIF;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object o = selection.getFirstElement();
        this.importConnection = o instanceof IEntry ? ((IEntry)o).getBrowserConnection() : (o instanceof ISearchResult ? ((ISearchResult)o).getEntry().getBrowserConnection() : (o instanceof IBookmark ? ((IBookmark)o).getBrowserConnection() : (o instanceof IAttribute ? ((IAttribute)o).getEntry().getBrowserConnection() : (o instanceof IValue ? ((IValue)o).getAttribute().getEntry().getBrowserConnection() : (o instanceof IBrowserConnection ? (IBrowserConnection)o : (o instanceof Connection ? BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection((Connection)o) : (o instanceof BrowserCategory ? ((BrowserCategory)o).getParent() : null)))))));
    }

    public void addPages() {
        this.mainPage = new ImportLdifMainWizardPage(ImportLdifMainWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.mainPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_ldifimport_wizard");
    }

    public boolean performFinish() {
        this.mainPage.saveDialogSettings();
        if (this.ldifFilename != null && !"".equals(this.ldifFilename)) {
            File ldifFile = new File(this.ldifFilename);
            if (this.enableLogging) {
                File logFile = new File(this.logFilename);
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new ImportLdifRunnable(this.importConnection, ldifFile, logFile, this.updateIfEntryExists, this.continueOnError)}).execute();
            } else {
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new ImportLdifRunnable(this.importConnection, ldifFile, this.updateIfEntryExists, this.continueOnError)}).execute();
            }
            return true;
        }
        return false;
    }

    public IBrowserConnection getImportConnection() {
        return this.importConnection;
    }

    public void setImportConnection(IBrowserConnection importConnection) {
        this.importConnection = importConnection;
    }

    public void setLdifFilename(String ldifFilename) {
        this.ldifFilename = ldifFilename;
    }

    public void setUpdateIfEntryExists(boolean updateIfEntryExists) {
        this.updateIfEntryExists = updateIfEntryExists;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public void setEnableLogging(boolean b) {
        this.enableLogging = b;
    }
}

