/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.image;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.ValueEditorsConstants;
import org.apache.directory.studio.valueeditors.image.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ImageDialog
extends Dialog {
    private static final String SELECTED_TAB_DIALOGSETTINGS_KEY = ImageDialog.class.getName() + ".tab";
    private static final int MAX_WIDTH = 400;
    private static final int MAX_HEIGHT = 400;
    private static final int CURRENT_TAB = 0;
    private static final int NEW_TAB = 1;
    private byte[] currentImageRawData;
    private int requiredImageType;
    private byte[] newImageRawData;
    private byte[] newImageRawDataInRequiredFormat;
    private TabFolder tabFolder;
    private TabItem currentTab;
    private Composite currentImageContainer;
    private Image currentImage;
    private Label currentImageLabel;
    private Text currentImageTypeText;
    private Text currentImageWidthText;
    private Text currentImageHeightText;
    private Text currentImageSizeText;
    private Button currentImageSaveButton;
    private TabItem newTab;
    private Composite newImageContainer;
    private Image newImage;
    private Label newImageLabel;
    private Text newImageTypeText;
    private Text newImageWidthText;
    private Text newImageHeightText;
    private Text newImageSizeText;
    private Text newImageFilenameText;
    private Button newImageBrowseButton;
    private Button okButton;

    public ImageDialog(Shell parentShell, byte[] currentImageRawData, int requiredImageType) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.currentImageRawData = currentImageRawData;
        this.requiredImageType = requiredImageType;
        this.newImageRawDataInRequiredFormat = null;
    }

    public boolean close() {
        if (this.currentImage != null && !this.currentImage.isDisposed()) {
            this.currentImage.dispose();
        }
        if (this.newImage != null && !this.newImage.isDisposed()) {
            this.newImage.dispose();
        }
        ValueEditorsActivator.getDefault().getDialogSettings().put(SELECTED_TAB_DIALOGSETTINGS_KEY, this.tabFolder.getSelectionIndex());
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        block6: {
            if (buttonId == 0) {
                if (this.newImageRawData != null) {
                    try {
                        ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(this.newImageRawData));
                        if (imageData.type != this.requiredImageType) {
                            ImageLoader imageLoader = new ImageLoader();
                            imageLoader.data = new ImageData[]{imageData};
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            imageLoader.save((OutputStream)baos, this.requiredImageType);
                            this.newImageRawDataInRequiredFormat = baos.toByteArray();
                            break block6;
                        }
                        this.newImageRawDataInRequiredFormat = this.newImageRawData;
                    }
                    catch (SWTException swte) {
                        this.newImageRawDataInRequiredFormat = null;
                    }
                }
            } else {
                this.newImageRawDataInRequiredFormat = null;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ImageDialog.ImageEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/imageeditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        try {
            int tabIndex = ValueEditorsActivator.getDefault().getDialogSettings().getInt(SELECTED_TAB_DIALOGSETTINGS_KEY);
            this.tabFolder.setSelection(tabIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateTabFolder();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageDialog.this.updateTabFolder();
            }
        });
        if (this.currentImageRawData != null && this.currentImageRawData.length > 0) {
            this.currentTab = new TabItem(this.tabFolder, 0);
            this.currentTab.setText(Messages.getString("ImageDialog.CurrentImage"));
            this.currentImageContainer = this.createTabItemComposite();
            this.currentImageLabel = this.createImageLabel(this.currentImageContainer);
            Composite currentImageInfoContainer = this.createImageInfoContainer(this.currentImageContainer);
            this.currentImageTypeText = this.createImageInfo(currentImageInfoContainer, Messages.getString("ImageDialog.ImageType"));
            this.currentImageSizeText = this.createImageInfo(currentImageInfoContainer, Messages.getString("ImageDialog.ImageSize"));
            this.currentImageWidthText = this.createImageInfo(currentImageInfoContainer, Messages.getString("ImageDialog.ImageWidth"));
            this.currentImageHeightText = this.createImageInfo(currentImageInfoContainer, Messages.getString("ImageDialog.ImageHeight"));
            Composite currentImageSaveContainer = this.createImageInfoContainer(this.currentImageContainer);
            Label dummyLabel = BaseWidgetUtils.createLabel((Composite)currentImageSaveContainer, (String)"", (int)1);
            GridData gd = new GridData(768);
            dummyLabel.setLayoutData((Object)gd);
            this.currentImageSaveButton = this.createButton(currentImageSaveContainer, Messages.getString("ImageDialog.Save"));
            this.currentImageSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(ImageDialog.this.getShell(), 8192);
                    fileDialog.setText(Messages.getString("ImageDialog.SaveImage"));
                    fileDialog.setFilterExtensions(new String[]{"*.jpg"});
                    String returnedFileName = fileDialog.open();
                    if (returnedFileName != null) {
                        try {
                            File file = new File(returnedFileName);
                            FileOutputStream out = new FileOutputStream(file);
                            out.write(ImageDialog.this.currentImageRawData);
                            out.flush();
                            out.close();
                        }
                        catch (FileNotFoundException e) {
                            ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, ValueEditorsConstants.PLUGIN_ID, 4, Messages.getString("ImageDialog.CantWriteFile"), (Throwable)e));
                        }
                        catch (IOException e) {
                            ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, ValueEditorsConstants.PLUGIN_ID, 4, Messages.getString("ImageDialog.CantWriteFile"), (Throwable)e));
                        }
                    }
                }
            });
            this.currentTab.setControl((Control)this.currentImageContainer);
        }
        this.newTab = new TabItem(this.tabFolder, 0);
        this.newTab.setText(Messages.getString("ImageDialog.NewImage"));
        this.newImageContainer = this.createTabItemComposite();
        this.newImageLabel = this.createImageLabel(this.newImageContainer);
        Composite newImageInfoContainer = this.createImageInfoContainer(this.newImageContainer);
        this.newImageTypeText = this.createImageInfo(newImageInfoContainer, Messages.getString("ImageDialog.ImageType"));
        this.newImageSizeText = this.createImageInfo(newImageInfoContainer, Messages.getString("ImageDialog.ImageSize"));
        this.newImageWidthText = this.createImageInfo(newImageInfoContainer, Messages.getString("ImageDialog.ImageWidth"));
        this.newImageHeightText = this.createImageInfo(newImageInfoContainer, Messages.getString("ImageDialog.ImageHeight"));
        Composite newImageSelectContainer = this.createImageInfoContainer(this.newImageContainer);
        this.newImageFilenameText = new Text(newImageSelectContainer, 2052);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.newImageFilenameText.setLayoutData((Object)gd);
        this.newImageFilenameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImageDialog.this.updateNewImageGroup();
            }
        });
        this.newImageBrowseButton = this.createButton(newImageSelectContainer, Messages.getString("ImageDialog.Browse"));
        this.newImageBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(ImageDialog.this.getShell(), 4096);
                fileDialog.setText(Messages.getString("ImageDialog.SelectImage"));
                fileDialog.setFileName(new File(ImageDialog.this.newImageFilenameText.getText()).getName());
                fileDialog.setFilterPath(new File(ImageDialog.this.newImageFilenameText.getText()).getParent());
                String returnedFileName = fileDialog.open();
                if (returnedFileName != null) {
                    ImageDialog.this.newImageFilenameText.setText(returnedFileName);
                }
            }
        });
        this.newTab.setControl((Control)this.newImageContainer);
        ImageDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Composite createTabItemComposite() {
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        compositeLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        compositeLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        compositeLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    private Label createImageLabel(Composite parent) {
        Composite labelComposite = new Composite(parent, 2048);
        labelComposite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        labelComposite.setLayoutData((Object)gd);
        labelComposite.setBackground(this.getShell().getDisplay().getSystemColor(18));
        Label imageLabel = new Label(labelComposite, 0x1000000);
        gd = new GridData(0x1000000, 0x1000000, true, true);
        imageLabel.setLayoutData((Object)gd);
        return imageLabel;
    }

    private void updateCurrentImageGroup() {
        if (this.currentTab != null) {
            if (this.currentImage != null && !this.currentImage.isDisposed()) {
                this.currentImage.dispose();
                this.currentImage = null;
            }
            if (this.currentImageRawData != null && this.currentImageRawData.length > 0) {
                try {
                    ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(this.currentImageRawData));
                    this.currentImage = new Image((Device)this.getShell().getDisplay(), this.resizeImage(imageData));
                    this.currentImageLabel.setText("");
                    this.currentImageLabel.setImage(this.currentImage);
                    GridData currentImageLabelGridData = new GridData(0x1000000, 0x1000000, true, true);
                    currentImageLabelGridData.widthHint = this.currentImage.getBounds().width;
                    currentImageLabelGridData.heightHint = this.currentImage.getBounds().height;
                    this.currentImageLabel.setLayoutData((Object)currentImageLabelGridData);
                    this.currentImageTypeText.setText(ImageDialog.getImageType(imageData.type));
                    this.currentImageSizeText.setText(ImageDialog.getSizeString(this.currentImageRawData.length));
                    this.currentImageWidthText.setText(NLS.bind((String)Messages.getString("ImageDialog.Pixel"), (Object)imageData.width));
                    this.currentImageHeightText.setText(NLS.bind((String)Messages.getString("ImageDialog.Pixel"), (Object)imageData.height));
                }
                catch (SWTException swte) {
                    this.currentImageLabel.setImage(null);
                    this.currentImageLabel.setText(Messages.getString("ImageDialog.UnsupportedFormatSpaces"));
                    this.currentImageTypeText.setText(Messages.getString("ImageDialog.UnsupportedFormat"));
                    this.currentImageSizeText.setText(ImageDialog.getSizeString(this.currentImageRawData.length));
                    this.currentImageWidthText.setText("-");
                    this.currentImageHeightText.setText("-");
                }
            } else {
                this.currentImageLabel.setImage(null);
                this.currentImageLabel.setText(Messages.getString("ImageDialog.NoImageSpaces"));
                this.currentImageTypeText.setText(Messages.getString("ImageDialog.NoImage"));
                this.currentImageSizeText.setText("-");
                this.currentImageWidthText.setText("-");
                this.currentImageHeightText.setText("-");
            }
            this.currentImageSaveButton.setEnabled(this.currentImageRawData != null && this.currentImageRawData.length > 0);
        }
    }

    private void updateNewImageGroup() {
        if (this.newImage != null && !this.newImage.isDisposed()) {
            this.newImage.dispose();
            this.newImage = null;
        }
        if (!"".equals(this.newImageFilenameText.getText())) {
            try {
                int len;
                File file = new File(this.newImageFilenameText.getText());
                FileInputStream in = new FileInputStream(file);
                ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                this.newImageRawData = out.toByteArray();
                out.close();
                in.close();
            }
            catch (FileNotFoundException e) {
                this.newImageRawData = null;
                this.newImageLabel.setImage(null);
                this.newImageLabel.setText(Messages.getString("ImageDialog.ErrorFileNotFound"));
                this.newImageTypeText.setText("-");
                this.newImageSizeText.setText("-");
                this.newImageWidthText.setText("-");
                this.newImageHeightText.setText("-");
            }
            catch (IOException e) {
                this.newImageRawData = null;
                this.newImageLabel.setImage(null);
                this.newImageLabel.setText(NLS.bind((String)Messages.getString("ImageDialog.CantReadFile"), (Object[])new String[]{e.getMessage()}));
                this.newImageTypeText.setText("-");
                this.newImageSizeText.setText("-");
                this.newImageWidthText.setText("-");
                this.newImageHeightText.setText("-");
            }
        } else {
            this.newImageRawData = null;
            this.newImageLabel.setImage(null);
            this.newImageLabel.setText(Messages.getString("ImageDialog.NoImageSelected"));
            this.newImageTypeText.setText("-");
            this.newImageSizeText.setText("-");
            this.newImageWidthText.setText("-");
            this.newImageHeightText.setText("-");
        }
        if (this.newImageRawData != null && this.newImageRawData.length > 0) {
            try {
                ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(this.newImageRawData));
                this.newImage = new Image((Device)this.getShell().getDisplay(), this.resizeImage(imageData));
                this.newImageLabel.setImage(this.newImage);
                this.newImageTypeText.setText(ImageDialog.getImageType(imageData.type));
                if (imageData.type != this.requiredImageType) {
                    this.newImageTypeText.setText(this.newImageTypeText.getText() + NLS.bind((String)Messages.getString("ImageDialog.WillBeConverted"), (Object[])new String[]{ImageDialog.getImageType(this.requiredImageType)}));
                }
                this.newImageSizeText.setText(ImageDialog.getSizeString(this.newImageRawData.length));
                this.newImageWidthText.setText(NLS.bind((String)Messages.getString("ImageDialog.Pixel"), (Object)imageData.width));
                this.newImageHeightText.setText(NLS.bind((String)Messages.getString("ImageDialog.Pixel"), (Object)imageData.height));
            }
            catch (SWTException swte) {
                this.newImageLabel.setImage(null);
                this.newImageLabel.setText(Messages.getString("ImageDialog.UnsupportedFormatSpaces"));
                this.newImageTypeText.setText(Messages.getString("ImageDialog.UnsupportedFormat"));
                this.newImageSizeText.setText(ImageDialog.getSizeString(this.newImageRawData.length));
                this.newImageWidthText.setText("-");
                this.newImageHeightText.setText("-");
            }
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(this.newImage != null);
        }
        this.newImageLabel.getParent().layout();
        this.newImageTypeText.getParent().layout();
    }

    private void updateTabFolder() {
        if (this.currentImageSaveButton != null) {
            if (this.tabFolder.getSelectionIndex() == 0) {
                this.currentImageSaveButton.setFocus();
            }
            this.updateCurrentImageGroup();
        }
        if (this.newImageBrowseButton != null) {
            if (this.tabFolder.getSelectionIndex() == 1 || this.currentImageSaveButton == null) {
                this.newImageBrowseButton.setFocus();
            }
            this.updateNewImageGroup();
        }
    }

    private ImageData resizeImage(ImageData imageData) {
        double widthScaleFactor = 1.0;
        if (imageData.width > 400) {
            widthScaleFactor = 400.0 / (double)imageData.width;
        }
        double heightScaleFactor = 1.0;
        if (imageData.height > 400) {
            heightScaleFactor = 400.0 / (double)imageData.height;
        }
        double minScalefactor = Math.min(heightScaleFactor, widthScaleFactor);
        return this.resize(imageData, (int)((double)imageData.width * minScalefactor), (int)((double)imageData.height * minScalefactor));
    }

    private ImageData resize(ImageData imageData, int width, int height) {
        Image image = new Image((Device)Display.getDefault(), imageData);
        Image resizedImage = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)resizedImage);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        image.dispose();
        return resizedImage.getImageData();
    }

    private Composite createImageInfoContainer(Composite parent) {
        Composite imageInfoContainer = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        imageInfoContainer.setLayout((Layout)gl);
        imageInfoContainer.setLayoutData((Object)new GridData(768));
        return imageInfoContainer;
    }

    private Text createImageInfo(Composite parent, String label) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)label, (int)1);
        Text text = BaseWidgetUtils.createLabeledText((Composite)parent, (String)"", (int)1);
        return text;
    }

    private Button createButton(Composite parent, String label) {
        Button button = BaseWidgetUtils.createButton((Composite)parent, (String)label, (int)1);
        return button;
    }

    private static String getSizeString(int length) {
        if (length > 1000000) {
            return length / 1000000 + NLS.bind((String)Messages.getString("ImageDialog.MB"), (Object[])new Integer[]{length});
        }
        if (length > 1000) {
            return length / 1000 + NLS.bind((String)Messages.getString("ImageDialog.KB"), (Object[])new Integer[]{length});
        }
        return length + Messages.getString("ImageDialog.Bytes");
    }

    public static String getImageInfo(byte[] imageRawData) {
        String text;
        if (imageRawData == null) {
            return "NULL";
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(imageRawData);
            ImageData imageData = new ImageData((InputStream)bais);
            String typePrefix = ImageDialog.getImageType(imageData.type);
            if (!"".equals(typePrefix)) {
                typePrefix = typePrefix + "-";
            }
            text = NLS.bind((String)Messages.getString("ImageDialog.Image"), (Object[])new Object[]{typePrefix, imageData.width, imageData.height, imageRawData.length});
        }
        catch (SWTException swte) {
            text = NLS.bind((String)Messages.getString("ImageDialog.InvalidImage"), (Object[])new Object[]{imageRawData.length});
        }
        return text;
    }

    private static String getImageType(int swtCode) {
        String type = "";
        if (swtCode == 4) {
            type = "JPEG";
        } else if (swtCode == 2) {
            type = "GIF";
        } else if (swtCode == 5) {
            type = "PNG";
        } else if (swtCode == 0 || swtCode == 1) {
            type = "BMP";
        }
        return type;
    }

    public byte[] getNewImageRawData() {
        return this.newImageRawDataInRequiredFormat;
    }
}

