/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.search.Filter;
import org.apache.directory.api.util.Strings;

public class PresentFilter
extends Filter {
    private String attributeDescription;
    private byte[] attributeDescriptionBytes;

    public PresentFilter(int tlvId) {
        super(tlvId);
    }

    public PresentFilter() {
    }

    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(String attributeDescription) {
        this.attributeDescription = attributeDescription;
    }

    @Override
    public int computeLength() {
        this.attributeDescriptionBytes = Strings.getBytesUtf8((String)this.attributeDescription);
        return 1 + TLV.getNbBytes((int)this.attributeDescriptionBytes.length) + this.attributeDescriptionBytes.length;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        try {
            buffer.put((byte)-121);
            buffer.put(TLV.getBytes((int)this.attributeDescriptionBytes.length));
            buffer.put(this.attributeDescriptionBytes);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.attributeDescription).append("=*");
        return sb.toString();
    }
}

