/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v152;

import java.util.List;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.v152.InterceptorDetailsPage;
import org.apache.directory.studio.apacheds.configuration.editor.v152.dialogs.InterceptorDialog;
import org.apache.directory.studio.apacheds.configuration.model.v152.InterceptorEnum;
import org.apache.directory.studio.apacheds.configuration.model.v152.ServerConfigurationV152;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class InterceptorsMasterDetailsBlock
extends MasterDetailsBlock {
    private FormPage page;
    private ServerConfigurationV152 serverConfiguration;
    private List<InterceptorEnum> interceptors;
    private InterceptorDetailsPage detailsPage;
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    public InterceptorsMasterDetailsBlock(FormPage page) {
        this.page = page;
        this.serverConfiguration = (ServerConfigurationV152)((ServerConfigurationEditor)page.getEditor()).getServerConfiguration();
        this.interceptors = this.serverConfiguration.getInterceptors();
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 384);
        section.setText("All Interceptors");
        section.setDescription(" Set the Interceptors used in the server. Use the \"Up\" and \"Down\" buttons to change the order.");
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        Table table = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 4);
        gd.heightHint = 20;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ApacheDSConfigurationPlugin.getDefault().getImage("resources/icons/interceptor.gif");
            }

            public String getText(Object element) {
                if (element instanceof InterceptorEnum) {
                    return ((InterceptorEnum)((Object)element)).getName();
                }
                return super.getText(element);
            }
        });
        this.addButton = toolkit.createButton(client, "Add...", 8);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteButton = toolkit.createButton(client, "Delete", 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.upButton = toolkit.createButton(client, "Up", 8);
        this.upButton.setEnabled(false);
        this.upButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.downButton = toolkit.createButton(client, "Down", 8);
        this.downButton.setEnabled(false);
        this.downButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.initFromInput();
        this.addListeners();
    }

    private void initFromInput() {
        this.viewer.setInput(this.interceptors);
    }

    private void addListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InterceptorsMasterDetailsBlock.this.viewer.refresh();
                InterceptorsMasterDetailsBlock.this.deleteButton.setEnabled(!event.getSelection().isEmpty());
                InterceptorsMasterDetailsBlock.this.enableDisableUpDownButtons();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorDialog dialog = new InterceptorDialog(InterceptorsMasterDetailsBlock.this.interceptors);
                if (0 == dialog.open()) {
                    InterceptorEnum newInterceptor = dialog.getInterceptor();
                    InterceptorsMasterDetailsBlock.this.interceptors.add(newInterceptor);
                    InterceptorsMasterDetailsBlock.this.viewer.refresh();
                    InterceptorsMasterDetailsBlock.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newInterceptor));
                    InterceptorsMasterDetailsBlock.this.setEditorDirty();
                }
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)InterceptorsMasterDetailsBlock.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    InterceptorEnum interceptor = (InterceptorEnum)((Object)selection.getFirstElement());
                    InterceptorsMasterDetailsBlock.this.interceptors.remove((Object)interceptor);
                    InterceptorsMasterDetailsBlock.this.viewer.refresh();
                    InterceptorsMasterDetailsBlock.this.setEditorDirty();
                }
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)InterceptorsMasterDetailsBlock.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    InterceptorEnum interceptorBefore;
                    InterceptorEnum interceptor = (InterceptorEnum)((Object)selection.getFirstElement());
                    int index = InterceptorsMasterDetailsBlock.this.interceptors.indexOf((Object)interceptor);
                    if (index > 0 && (interceptorBefore = (InterceptorEnum)((Object)InterceptorsMasterDetailsBlock.this.interceptors.get(index - 1))) != null) {
                        InterceptorsMasterDetailsBlock.this.interceptors.set(index - 1, interceptor);
                        InterceptorsMasterDetailsBlock.this.interceptors.set(index, interceptorBefore);
                        InterceptorsMasterDetailsBlock.this.viewer.refresh();
                        InterceptorsMasterDetailsBlock.this.setEditorDirty();
                        InterceptorsMasterDetailsBlock.this.enableDisableUpDownButtons();
                    }
                }
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)InterceptorsMasterDetailsBlock.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    InterceptorEnum interceptorAfter;
                    InterceptorEnum interceptor = (InterceptorEnum)((Object)selection.getFirstElement());
                    int index = InterceptorsMasterDetailsBlock.this.interceptors.indexOf((Object)interceptor);
                    if (index < InterceptorsMasterDetailsBlock.this.interceptors.size() - 1 && (interceptorAfter = (InterceptorEnum)((Object)InterceptorsMasterDetailsBlock.this.interceptors.get(index + 1))) != null) {
                        InterceptorsMasterDetailsBlock.this.interceptors.set(index + 1, interceptor);
                        InterceptorsMasterDetailsBlock.this.interceptors.set(index, interceptorAfter);
                        InterceptorsMasterDetailsBlock.this.viewer.refresh();
                        InterceptorsMasterDetailsBlock.this.setEditorDirty();
                        InterceptorsMasterDetailsBlock.this.enableDisableUpDownButtons();
                    }
                }
            }
        });
    }

    private void enableDisableUpDownButtons() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        this.upButton.setEnabled(!selection.isEmpty());
        this.downButton.setEnabled(!selection.isEmpty());
        if (!selection.isEmpty()) {
            InterceptorEnum interceptor = (InterceptorEnum)((Object)selection.getFirstElement());
            this.upButton.setEnabled(this.interceptors.indexOf((Object)interceptor) != 0);
            this.downButton.setEnabled(this.interceptors.indexOf((Object)interceptor) != this.interceptors.size() - 1);
        }
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action horizontalAction = new Action("Horizontal layout", 8){

            public void run() {
                InterceptorsMasterDetailsBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        horizontalAction.setChecked(true);
        horizontalAction.setToolTipText("Horizontal Orientation");
        horizontalAction.setImageDescriptor(ApacheDSConfigurationPlugin.getDefault().getImageDescriptor("resources/icons/horizontal_orientation.gif"));
        Action verticalAction = new Action("Vertical Orientation", 8){

            public void run() {
                InterceptorsMasterDetailsBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        verticalAction.setChecked(false);
        verticalAction.setToolTipText("Vertical Orientation");
        verticalAction.setImageDescriptor(ApacheDSConfigurationPlugin.getDefault().getImageDescriptor("resources/icons/vertical_orientation.gif"));
        form.getToolBarManager().add((IAction)horizontalAction);
        form.getToolBarManager().add((IAction)verticalAction);
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPage = new InterceptorDetailsPage(this);
        detailsPart.registerPage(InterceptorEnum.class, (IDetailsPage)this.detailsPage);
    }

    public void setEditorDirty() {
        ((ServerConfigurationEditor)this.page.getEditor()).setDirty(true);
    }

    public void save() {
        this.detailsPage.commit(true);
        this.viewer.setInput(this.interceptors);
    }
}

