/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeChildrenRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.eclipse.jface.resource.ImageDescriptor;

public class FetchSubentriesAction
extends BrowserAction {
    public int getStyle() {
        return 2;
    }

    @Override
    public String getText() {
        return Messages.getString("FetchOperationalAttributesAction.FetchSubentries");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getCommandId() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        List<IEntry> entries = this.getEntries();
        return !entries.isEmpty() && !entries.iterator().next().getBrowserConnection().isFetchSubentries();
    }

    public boolean isChecked() {
        boolean checked = true;
        List<IEntry> entries = this.getEntries();
        if (entries.isEmpty()) {
            checked = false;
        } else {
            for (IEntry entry : entries) {
                if (entry.isFetchSubentries()) continue;
                checked = false;
            }
        }
        return checked;
    }

    @Override
    public void run() {
        IEntry[] entries = this.getEntries().toArray(new IEntry[0]);
        boolean init = !this.isChecked();
        for (IEntry entry : entries) {
            entry.setFetchSubentries(init);
        }
        new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new InitializeChildrenRunnable(true, entries)}).execute();
    }

    protected List<IEntry> getEntries() {
        ArrayList<IEntry> entriesList = new ArrayList<IEntry>();
        entriesList.addAll(Arrays.asList(this.getSelectedEntries()));
        return entriesList;
    }
}

