/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.common.dialogs.RenameEntryDialog;
import org.apache.directory.studio.ldapbrowser.common.dialogs.SimulateRenameDialogImpl;
import org.apache.directory.studio.ldapbrowser.core.jobs.RenameEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SimulateRenameDialog;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.impl.RootDSE;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;

public class RenameAction
extends BrowserAction {
    @Override
    public String getText() {
        IEntry[] entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IBookmark[] bookmarks = this.getBookmarks();
        if (entries.length == 1 && searches.length == 0 && bookmarks.length == 0) {
            return Messages.getString("RenameAction.RenameEntry");
        }
        if (searches.length == 1 && entries.length == 0 && bookmarks.length == 0) {
            return Messages.getString("RenameAction.RenameSearch");
        }
        if (bookmarks.length == 1 && entries.length == 0 && searches.length == 0) {
            return Messages.getString("RenameAction.RenameBookmark");
        }
        return Messages.getString("RenameAction.Rename");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.edit.rename";
    }

    @Override
    public void run() {
        IEntry[] entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IBookmark[] bookmarks = this.getBookmarks();
        if (entries.length == 1 && searches.length == 0 && bookmarks.length == 0) {
            this.renameEntry(entries[0]);
        } else if (searches.length == 1 && entries.length == 0 && bookmarks.length == 0) {
            this.renameSearch(searches[0]);
        } else if (bookmarks.length == 1 && entries.length == 0 && searches.length == 0) {
            this.renameBookmark(bookmarks[0]);
        }
    }

    @Override
    public boolean isEnabled() {
        try {
            IEntry[] entries = this.getEntries();
            ISearch[] searches = this.getSearches();
            IBookmark[] bookmarks = this.getBookmarks();
            return entries.length + searches.length + bookmarks.length == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected IEntry[] getEntries() {
        IEntry entry = null;
        if (this.getSelectedEntries().length == 1) {
            entry = this.getSelectedEntries()[0];
        } else if (this.getSelectedSearchResults().length == 1) {
            entry = this.getSelectedSearchResults()[0].getEntry();
        } else if (this.getSelectedValues().length == 1 && this.getSelectedValues()[0].isRdnPart()) {
            entry = this.getSelectedValues()[0].getAttribute().getEntry();
        }
        if (entry != null && !(entry instanceof RootDSE)) {
            return new IEntry[]{entry};
        }
        return new IEntry[0];
    }

    protected void renameEntry(IEntry entry) {
        Rdn newRdn;
        RenameEntryDialog renameDialog = new RenameEntryDialog(this.getShell(), entry);
        if (renameDialog.open() == 0 && (newRdn = renameDialog.getRdn()) != null && !newRdn.equals((Object)entry.getRdn())) {
            new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new RenameEntryRunnable(entry, newRdn, (SimulateRenameDialog)new SimulateRenameDialogImpl(this.getShell()))}).execute();
        }
    }

    protected ISearch[] getSearches() {
        if (this.getSelectedSearches().length == 1 && !(this.getSelectedSearches()[0] instanceof IQuickSearch)) {
            return this.getSelectedSearches();
        }
        return new ISearch[0];
    }

    protected void renameSearch(final ISearch search) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newName) {
                if (search.getName().equals(newName)) {
                    return null;
                }
                if (search.getBrowserConnection().getSearchManager().getSearch(newName) != null) {
                    return Messages.getString("RenameAction.ConnectionWithThisNameAlreadyExists");
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("RenameAction.RenameSearchDialog"), Messages.getString("RenameAction.RenameSearchNewName"), search.getName(), validator);
        dialog.open();
        String newName = dialog.getValue();
        if (newName != null) {
            search.setName(newName);
        }
    }

    protected IBookmark[] getBookmarks() {
        if (this.getSelectedBookmarks().length == 1) {
            return this.getSelectedBookmarks();
        }
        return new IBookmark[0];
    }

    protected void renameBookmark(final IBookmark bookmark) {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newName) {
                if (bookmark.getName().equals(newName)) {
                    return null;
                }
                if (bookmark.getBrowserConnection().getBookmarkManager().getBookmark(newName) != null) {
                    return Messages.getString("RenameAction.BookmarkWithThisNameAlreadyExists");
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("RenameAction.RenameBookmarkDialog"), Messages.getString("RenameAction.RenameBookmarkNewName"), bookmark.getName(), validator);
        dialog.open();
        String newName = dialog.getValue();
        if (newName != null) {
            bookmark.setName(newName);
        }
    }
}

