/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.filtereditor;

import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapAndFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterExtensibleComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterItemComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapNotFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapOrFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;

public class FilterFormattingStrategy
implements IFormattingStrategy {
    private LdapFilterParser parser;
    private ISourceViewer sourceViewer;

    public FilterFormattingStrategy(ISourceViewer sourceViewer, LdapFilterParser parser) {
        this.parser = parser;
        this.sourceViewer = sourceViewer;
    }

    public void formatterStarts(String initialIndentation) {
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        LdapFilter model = this.parser.getModel();
        if (model != null && model.isValid()) {
            this.sourceViewer.getDocument().set(this.getFormattedFilter(model, 0));
        }
        return null;
    }

    private String getFormattedFilter(LdapFilter filter, int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append("    ");
        }
        LdapFilterComponent fc = filter.getFilterComponent();
        if (fc instanceof LdapFilterItemComponent) {
            sb.append('(').append(((LdapFilterItemComponent)fc).toString()).append(')');
        } else if (fc instanceof LdapFilterExtensibleComponent) {
            sb.append('(').append(((LdapFilterExtensibleComponent)fc).toString()).append(')');
        } else if (fc instanceof LdapNotFilterComponent) {
            sb.append("(!");
            LdapNotFilterComponent lnfc = (LdapNotFilterComponent)fc;
            if (lnfc.getFilters().length > 0 && lnfc.getFilters()[0].getFilterComponent() instanceof LdapFilterItemComponent) {
                sb.append(this.getFormattedFilter(lnfc.getFilters()[0], 0));
            } else {
                sb.append('\n');
                sb.append(this.getFormattedFilter(lnfc.getFilters()[0], indent + 1));
                sb.append('\n');
                for (int i = 0; i < indent; ++i) {
                    sb.append("    ");
                }
            }
            sb.append(')');
        } else if (fc instanceof LdapAndFilterComponent) {
            int i;
            sb.append("(&");
            sb.append('\n');
            LdapFilter[] filters = ((LdapAndFilterComponent)fc).getFilters();
            for (i = 0; i < filters.length; ++i) {
                sb.append(this.getFormattedFilter(filters[i], indent + 1));
                sb.append('\n');
            }
            for (i = 0; i < indent; ++i) {
                sb.append("    ");
            }
            sb.append(')');
        } else if (fc instanceof LdapOrFilterComponent) {
            int i;
            sb.append("(|");
            sb.append('\n');
            LdapFilter[] filters = ((LdapOrFilterComponent)fc).getFilters();
            for (i = 0; i < filters.length; ++i) {
                sb.append(this.getFormattedFilter(filters[i], indent + 1));
                sb.append('\n');
            }
            for (i = 0; i < indent; ++i) {
                sb.append("    ");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public void formatterStops() {
    }
}

