/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets;

import java.util.Map;
import org.apache.directory.studio.ldapbrowser.common.widgets.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.OptionsInput;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.eclipse.core.runtime.Platform;

public class LineSeparatorInput
extends OptionsInput {
    public LineSeparatorInput(String initialRawValue, boolean asGroup) {
        super(Messages.getString("LineSeparatorInput.LineSeparator"), LineSeparatorInput.getDefaultDisplayValue(), LineSeparatorInput.getDefaultRawValue(), LineSeparatorInput.getOtherDisplayValues(), LineSeparatorInput.getOtherRawValues(), initialRawValue, asGroup, false);
    }

    private static String getDefaultDisplayValue() {
        Map lsMap = Platform.knownPlatformLineSeparators();
        for (String k : lsMap.keySet()) {
            String v = (String)lsMap.get(k);
            if (!v.equals(LineSeparatorInput.getDefaultRawValue())) continue;
            k = k + " (" + v.replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r") + ")";
            return k;
        }
        return LineSeparatorInput.getDefaultRawValue();
    }

    private static String getDefaultRawValue() {
        return BrowserCoreConstants.LINE_SEPARATOR;
    }

    private static String[] getOtherDisplayValues() {
        Map lsMap = Platform.knownPlatformLineSeparators();
        String[] displayValues = lsMap.keySet().toArray(new String[lsMap.size()]);
        for (int i = 0; i < displayValues.length; ++i) {
            displayValues[i] = displayValues[i] + " (" + ((String)lsMap.get(displayValues[i])).replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r") + ")";
        }
        return displayValues;
    }

    private static String[] getOtherRawValues() {
        Map lsMap = Platform.knownPlatformLineSeparators();
        String[] displayValues = lsMap.keySet().toArray(new String[lsMap.size()]);
        String[] rawValues = new String[displayValues.length];
        for (int i = 0; i < rawValues.length; ++i) {
            rawValues[i] = (String)lsMap.get(displayValues[i]);
        }
        return rawValues;
    }
}

