/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.core.events.AttributesInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ChildrenInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;

public class BrowserUniversalListener
implements ConnectionUpdateListener,
EntryUpdateListener,
SearchUpdateListener {
    protected BrowserWidget widget;
    protected TreeViewer viewer;
    private ITreeViewerListener treeViewerListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
            IEntry entry;
            if (event.getElement() instanceof IEntry && (entry = (IEntry)event.getElement()).isChildrenInitialized() && entry.hasMoreChildren() && entry.getChildrenCount() < entry.getBrowserConnection().getCountLimit()) {
                entry.setChildrenInitialized(false);
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }
    };
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (BrowserUniversalListener.this.viewer.getExpandedState(obj)) {
                    BrowserUniversalListener.this.viewer.collapseToLevel(obj, 1);
                } else if (((ITreeContentProvider)BrowserUniversalListener.this.viewer.getContentProvider()).hasChildren(obj)) {
                    BrowserUniversalListener.this.viewer.expandToLevel(obj, 1);
                }
            }
        }
    };

    public BrowserUniversalListener(BrowserWidget widget) {
        this.widget = widget;
        this.viewer = widget.getViewer();
        this.viewer.addTreeListener(this.treeViewerListener);
        this.viewer.addDoubleClickListener(this.doubleClickListener);
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionUIPlugin.getDefault().getEventRunner());
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        EventRegistry.addSearchUpdateListener((SearchUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.removeTreeListener(this.treeViewerListener);
            this.viewer.removeDoubleClickListener(this.doubleClickListener);
            ConnectionEventRegistry.removeConnectionUpdateListener((ConnectionUpdateListener)this);
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
            EventRegistry.removeSearchUpdateListener((SearchUpdateListener)this);
            this.viewer = null;
        }
    }

    public void connectionOpened(Connection connection) {
        this.viewer.refresh();
    }

    public void connectionClosed(Connection connection) {
        this.viewer.collapseAll();
    }

    public void connectionUpdated(Connection connection) {
        this.viewer.refresh();
    }

    public void connectionAdded(Connection connection) {
        this.viewer.refresh();
    }

    public void connectionRemoved(Connection connection) {
        this.viewer.refresh();
    }

    public void connectionFolderModified(ConnectionFolder connectionFolder) {
    }

    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
    }

    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
    }

    public void entryUpdated(EntryModificationEvent event) {
        if (event instanceof AttributesInitializedEvent && !(event.getModifiedEntry() instanceof IRootDSE)) {
            return;
        }
        if (event instanceof ChildrenInitializedEvent) {
            boolean expandedState = this.viewer.getExpandedState((Object)event.getModifiedEntry());
            this.viewer.collapseToLevel((Object)event.getModifiedEntry(), -1);
            if (expandedState) {
                this.viewer.expandToLevel((Object)event.getModifiedEntry(), 1);
            }
            this.viewer.refresh((Object)event.getModifiedEntry(), true);
        } else {
            this.viewer.refresh((Object)event.getModifiedEntry(), true);
        }
    }

    public void searchUpdated(SearchUpdateEvent searchUpdateEvent) {
        ISearch search = searchUpdateEvent.getSearch();
        if (search instanceof IQuickSearch && searchUpdateEvent.getDetail() == SearchUpdateEvent.EventDetail.SEARCH_REMOVED && this.widget.getQuickSearch() == search) {
            this.widget.setQuickSearch(null);
        }
        this.viewer.refresh();
        if (search instanceof IQuickSearch && searchUpdateEvent.getDetail() != SearchUpdateEvent.EventDetail.SEARCH_REMOVED) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)search), true);
            this.viewer.expandToLevel((Object)search, 1);
        }
    }
}

