/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class EntryEditorWidgetFilter
extends ViewerFilter {
    protected TreeViewer viewer;
    protected String quickFilterAttribute = "";
    protected String quickFilterValue = "";

    public void connect(TreeViewer viewer) {
        this.viewer = viewer;
        viewer.addFilter((ViewerFilter)this);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IValue value;
        if (element instanceof IAttribute) {
            IAttribute attribute = (IAttribute)element;
            boolean oneGoesThrough = false;
            IValue[] values = attribute.getValues();
            for (int i = 0; i < values.length; ++i) {
                if (!this.goesThroughQuickFilter(values[i])) continue;
                oneGoesThrough = true;
                break;
            }
            if (!oneGoesThrough) {
                return false;
            }
        } else if (element instanceof IValue && !this.goesThroughQuickFilter(value = (IValue)element)) {
            return false;
        }
        return true;
    }

    private boolean goesThroughQuickFilter(IValue value) {
        if (this.quickFilterAttribute != null && !"".equals(this.quickFilterAttribute) && value.getAttribute().getDescription().toUpperCase().indexOf(this.quickFilterAttribute.toUpperCase()) == -1) {
            return false;
        }
        if (this.quickFilterValue != null && !"".equals(this.quickFilterValue)) {
            if (value.isString() && value.getStringValue().toUpperCase().indexOf(this.quickFilterValue.toUpperCase()) == -1) {
                return false;
            }
            if (value.isBinary()) {
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        this.viewer = null;
    }

    public String getQuickFilterAttribute() {
        return this.quickFilterAttribute;
    }

    public void setQuickFilterAttribute(String quickFilterAttribute) {
        if (!this.quickFilterAttribute.equals(quickFilterAttribute)) {
            String oldValue = this.quickFilterAttribute;
            this.quickFilterAttribute = quickFilterAttribute;
            BrowserCommonActivator.getDefault().getPreferenceStore().firePropertyChangeEvent("QuickFilterAttributeChanged", (Object)oldValue, (Object)quickFilterAttribute);
        }
    }

    public String getQuickFilterValue() {
        return this.quickFilterValue;
    }

    public void setQuickFilterValue(String quickFilterValue) {
        if (!this.quickFilterValue.equals(quickFilterValue)) {
            String oldValue = this.quickFilterValue;
            this.quickFilterValue = quickFilterValue;
            BrowserCommonActivator.getDefault().getPreferenceStore().firePropertyChangeEvent("QuickFilterValueChanged", (Object)oldValue, (Object)this.quickFilterAttribute);
        }
    }
}

