/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.XMLSchemaFileImportException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.osgi.util.NLS;

public class XMLSchemaFileImporter {
    private static final String ALIAS_TAG = "alias";
    private static final String ALIASES_TAG = "aliases";
    private static final String ATTRIBUTE_TYPE_TAG = "attributetype";
    private static final String ATTRIBUTE_TYPES_TAG = "attributetypes";
    private static final String BOOLEAN_FALSE = "false";
    private static final String BOOLEAN_TRUE = "true";
    private static final String COLLECTIVE_TAG = "collective";
    private static final String DESCRIPTION_TAG = "description";
    private static final String EQUALITY_TAG = "equality";
    private static final String HUMAN_READABLE_TAG = "humanreadable";
    private static final String MANDATORY_TAG = "mandatory";
    private static final String MATCHING_RULE_TAG = "matchingrule";
    private static final String MATCHING_RULES_TAG = "matchingrules";
    private static final String NAME_TAG = "name";
    private static final String NO_USER_MODIFICATION_TAG = "nousermodification";
    private static final String OBJECT_CLASS_TAG = "objectclass";
    private static final String OBJECT_CLASSES_TAG = "objectclasses";
    private static final String OBSOLETE_TAG = "obsolete";
    private static final String OID_TAG = "oid";
    private static final String OPTIONAL_TAG = "optional";
    private static final String ORDERING_TAG = "ordering";
    private static final String SCHEMA_TAG = "schema";
    private static final String SCHEMAS_TAG = "schemas";
    private static final String SINGLE_VALUE_TAG = "singlevalue";
    private static final String SUBSTRING_TAG = "substring";
    private static final String SUPERIOR_TAG = "superior";
    private static final String SUPERIORS_TAG = "superiors";
    private static final String SYNTAX_LENGTH_TAG = "syntaxlength";
    private static final String SYNTAX_OID_TAG = "syntaxoid";
    private static final String SYNTAX_TAG = "syntax";
    private static final String SYNTAXES_TAG = "syntaxes";
    private static final String TYPE_TAG = "type";
    private static final String USAGE_TAG = "usage";

    public static Schema[] getSchemas(InputStream inputStream, String path) throws XMLSchemaFileImportException {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(inputStream);
        }
        catch (DocumentException e) {
            throw new XMLSchemaFileImportException(NLS.bind((String)Messages.getString("XMLSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}), (Exception)((Object)e));
        }
        Element rootElement = document.getRootElement();
        if (!rootElement.getName().equals(SCHEMAS_TAG)) {
            throw new XMLSchemaFileImportException(NLS.bind((String)Messages.getString("XMLSchemaFileImporter.NotValidSchema"), (Object[])new String[]{path}));
        }
        return XMLSchemaFileImporter.readSchemas(rootElement, path);
    }

    public static Schema getSchema(InputStream inputStream, String path) throws XMLSchemaFileImportException {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(inputStream);
        }
        catch (DocumentException e) {
            throw new XMLSchemaFileImportException(NLS.bind((String)Messages.getString("XMLSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}), (Exception)((Object)e));
        }
        Element rootElement = document.getRootElement();
        return XMLSchemaFileImporter.readSchema(rootElement, path);
    }

    public static Schema[] readSchemas(Element element, String path) throws XMLSchemaFileImportException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        if (!element.getName().equals(SCHEMAS_TAG)) {
            throw new XMLSchemaFileImportException(NLS.bind((String)Messages.getString("XMLSchemaFileImporter.NotValidSchema"), (Object[])new String[]{path}));
        }
        Iterator i = element.elementIterator(SCHEMA_TAG);
        while (i.hasNext()) {
            Element schemaElement = (Element)i.next();
            schemas.add(XMLSchemaFileImporter.readSchema(schemaElement, path));
        }
        return schemas.toArray(new Schema[0]);
    }

    public static Schema readSchema(Element element, String path) throws XMLSchemaFileImportException {
        Schema schema = new Schema(XMLSchemaFileImporter.getSchemaName(element, path));
        XMLSchemaFileImporter.readAttributeTypes(element, schema);
        XMLSchemaFileImporter.readObjectClasses(element, schema);
        XMLSchemaFileImporter.readMatchingRules(element, schema);
        XMLSchemaFileImporter.readSyntaxes(element, schema);
        return schema;
    }

    private static String getSchemaName(Element element, String path) throws XMLSchemaFileImportException {
        if (!element.getName().equals(SCHEMA_TAG)) {
            throw new XMLSchemaFileImportException(NLS.bind((String)Messages.getString("XMLSchemaFileImporter.NotValidSchema"), (Object[])new String[]{path}));
        }
        Attribute nameAttribute = element.attribute(NAME_TAG);
        if (nameAttribute != null && !nameAttribute.getValue().equals("")) {
            return nameAttribute.getValue();
        }
        return XMLSchemaFileImporter.getNameFromPath(path);
    }

    private static final String getNameFromPath(String path) {
        File file = new File(path);
        String fileName = file.getName();
        if (fileName.endsWith(".xml")) {
            String[] fileNameSplitted = fileName.split("\\.");
            return fileNameSplitted[0];
        }
        return fileName;
    }

    private static void readAttributeTypes(Element element, Schema schema) throws XMLSchemaFileImportException {
        Iterator i = element.elementIterator(ATTRIBUTE_TYPES_TAG);
        while (i.hasNext()) {
            Element attributesTypesElement = (Element)i.next();
            Iterator i2 = attributesTypesElement.elementIterator(ATTRIBUTE_TYPE_TAG);
            while (i2.hasNext()) {
                XMLSchemaFileImporter.readAttributeType((Element)i2.next(), schema);
            }
        }
    }

    private static void readAttributeType(Element element, Schema schema) throws XMLSchemaFileImportException {
        Element substringElement;
        Element orderingElement;
        Element equalityElement;
        Attribute noUserModificationAttribute;
        Attribute collectiveAttribute;
        Attribute singleValueAttribute;
        Attribute obsoleteAttribute;
        Element syntaxLengthElement;
        Element syntaxElement;
        Element usageElement;
        Element superiorElement;
        Element descriptionElement;
        MutableAttributeType at = null;
        Attribute oidAttribute = element.attribute(OID_TAG);
        if (oidAttribute == null || oidAttribute.getValue().equals("")) {
            throw new XMLSchemaFileImportException(Messages.getString("XMLSchemaFileImporter.NoOIDInAttribute"));
        }
        at = new MutableAttributeType(oidAttribute.getValue());
        at.setSchemaName(schema.getSchemaName());
        Element aliasesElement = element.element(ALIASES_TAG);
        if (aliasesElement != null) {
            ArrayList<String> aliases = new ArrayList<String>();
            Iterator i = aliasesElement.elementIterator(ALIAS_TAG);
            while (i.hasNext()) {
                Element aliasElement = (Element)i.next();
                aliases.add(aliasElement.getText());
            }
            if (aliases.size() >= 1) {
                at.setNames(aliases.toArray(new String[0]));
            }
        }
        if ((descriptionElement = element.element(DESCRIPTION_TAG)) != null && !descriptionElement.getText().equals("")) {
            at.setDescription(descriptionElement.getText());
        }
        if ((superiorElement = element.element(SUPERIOR_TAG)) != null && !superiorElement.getText().equals("")) {
            at.setSuperiorOid(superiorElement.getText());
        }
        if ((usageElement = element.element(USAGE_TAG)) != null && !usageElement.getText().equals("")) {
            try {
                at.setUsage(UsageEnum.valueOf((String)usageElement.getText()));
            }
            catch (IllegalArgumentException e) {
                throw new XMLSchemaFileImportException(Messages.getString("XMLSchemaFileImporter.UnceonvertableAttribute"), e);
            }
        }
        if ((syntaxElement = element.element(SYNTAX_TAG)) != null && !syntaxElement.getText().equals("")) {
            at.setSyntaxOid(syntaxElement.getText());
        }
        if ((syntaxLengthElement = element.element(SYNTAX_LENGTH_TAG)) != null && !syntaxLengthElement.getText().equals("")) {
            try {
                at.setSyntaxLength(Long.parseLong(syntaxLengthElement.getText()));
            }
            catch (NumberFormatException e) {
                throw new XMLSchemaFileImportException(Messages.getString("XMLSchemaFileImporter.UnconvertableInteger"), e);
            }
        }
        if ((obsoleteAttribute = element.attribute(OBSOLETE_TAG)) != null && !obsoleteAttribute.getValue().equals("")) {
            at.setObsolete(XMLSchemaFileImporter.readBoolean(obsoleteAttribute.getValue()));
        }
        if ((singleValueAttribute = element.attribute(SINGLE_VALUE_TAG)) != null && !singleValueAttribute.getValue().equals("")) {
            at.setSingleValued(XMLSchemaFileImporter.readBoolean(singleValueAttribute.getValue()));
        }
        if ((collectiveAttribute = element.attribute(COLLECTIVE_TAG)) != null && !collectiveAttribute.getValue().equals("")) {
            at.setCollective(XMLSchemaFileImporter.readBoolean(collectiveAttribute.getValue()));
        }
        if ((noUserModificationAttribute = element.attribute(NO_USER_MODIFICATION_TAG)) != null && !noUserModificationAttribute.getValue().equals("")) {
            at.setUserModifiable(!XMLSchemaFileImporter.readBoolean(noUserModificationAttribute.getValue()));
        }
        if ((equalityElement = element.element(EQUALITY_TAG)) != null && !equalityElement.getText().equals("")) {
            at.setEqualityOid(equalityElement.getText());
        }
        if ((orderingElement = element.element(ORDERING_TAG)) != null && !orderingElement.getText().equals("")) {
            at.setOrderingOid(orderingElement.getText());
        }
        if ((substringElement = element.element(SUBSTRING_TAG)) != null && !substringElement.getText().equals("")) {
            at.setSubstringOid(substringElement.getText());
        }
        schema.addAttributeType((AttributeType)at);
    }

    private static void readObjectClasses(Element element, Schema schema) throws XMLSchemaFileImportException {
        Iterator i = element.elementIterator(OBJECT_CLASSES_TAG);
        while (i.hasNext()) {
            Element objectClassesElement = (Element)i.next();
            Iterator i2 = objectClassesElement.elementIterator(OBJECT_CLASS_TAG);
            while (i2.hasNext()) {
                XMLSchemaFileImporter.readObjectClass((Element)i2.next(), schema);
            }
        }
    }

    private static void readObjectClass(Element element, Schema schema) throws XMLSchemaFileImportException {
        Element optionalElement;
        Element mandatoryElement;
        Attribute obsoleteAttribute;
        Element classTypeElement;
        Element superiorsElement;
        Element descriptionElement;
        MutableObjectClass oc = null;
        Attribute oidAttribute = element.attribute(OID_TAG);
        if (oidAttribute == null || oidAttribute.getValue().equals("")) {
            throw new XMLSchemaFileImportException(Messages.getString("XMLSchemaFileImporter.NoOIDInClass"));
        }
        oc = new MutableObjectClass(oidAttribute.getValue());
        oc.setSchemaName(schema.getSchemaName());
        Element aliasesElement = element.element(ALIASES_TAG);
        if (aliasesElement != null) {
            ArrayList<String> aliases = new ArrayList<String>();
            Iterator i = aliasesElement.elementIterator(ALIAS_TAG);
            while (i.hasNext()) {
                Element aliasElement = (Element)i.next();
                aliases.add(aliasElement.getText());
            }
            if (aliases.size() >= 1) {
                oc.setNames(aliases.toArray(new String[0]));
            }
        }
        if ((descriptionElement = element.element(DESCRIPTION_TAG)) != null && !descriptionElement.getText().equals("")) {
            oc.setDescription(descriptionElement.getText());
        }
        if ((superiorsElement = element.element(SUPERIORS_TAG)) != null) {
            ArrayList<String> superiors = new ArrayList<String>();
            Iterator i = superiorsElement.elementIterator(SUPERIOR_TAG);
            while (i.hasNext()) {
                Element superiorElement = (Element)i.next();
                superiors.add(superiorElement.getText());
            }
            if (superiors.size() >= 1) {
                oc.setSuperiorOids(superiors);
            }
        }
        if ((classTypeElement = element.element(TYPE_TAG)) != null && !classTypeElement.getText().equals("")) {
            try {
                oc.setType(ObjectClassTypeEnum.valueOf((String)classTypeElement.getText()));
            }
            catch (IllegalArgumentException e) {
                throw new XMLSchemaFileImportException(Messages.getString("XMLSchemaFileImporter.UnconvertableValue"), e);
            }
        }
        if ((obsoleteAttribute = element.attribute(OBSOLETE_TAG)) != null && !obsoleteAttribute.getValue().equals("")) {
            oc.setObsolete(XMLSchemaFileImporter.readBoolean(obsoleteAttribute.getValue()));
        }
        if ((mandatoryElement = element.element(MANDATORY_TAG)) != null) {
            ArrayList<String> mandatoryATs = new ArrayList<String>();
            Iterator i = mandatoryElement.elementIterator(ATTRIBUTE_TYPE_TAG);
            while (i.hasNext()) {
                Element attributeTypeElement = (Element)i.next();
                mandatoryATs.add(attributeTypeElement.getText());
            }
            if (mandatoryATs.size() >= 1) {
                oc.setMustAttributeTypeOids(mandatoryATs);
            }
        }
        if ((optionalElement = element.element(OPTIONAL_TAG)) != null) {
            ArrayList<String> optionalATs = new ArrayList<String>();
            Iterator i = optionalElement.elementIterator(ATTRIBUTE_TYPE_TAG);
            while (i.hasNext()) {
                Element attributeTypeElement = (Element)i.next();
                optionalATs.add(attributeTypeElement.getText());
            }
            if (optionalATs.size() >= 1) {
                oc.setMayAttributeTypeOids(optionalATs);
            }
        }
        schema.addObjectClass(oc);
    }

    private static void readMatchingRules(Element element, Schema schema) throws XMLSchemaFileImportException {
        Iterator i = element.elementIterator(MATCHING_RULES_TAG);
        while (i.hasNext()) {
            Element matchingRulesElement = (Element)i.next();
            Iterator i2 = matchingRulesElement.elementIterator(MATCHING_RULE_TAG);
            while (i2.hasNext()) {
                XMLSchemaFileImporter.readMatchingRule((Element)i2.next(), schema);
            }
        }
    }

    private static void readMatchingRule(Element element, Schema schema) throws XMLSchemaFileImportException {
        Element syntaxOidElement;
        Attribute obsoleteAttribute;
        Element descriptionElement;
        MutableMatchingRule mr = null;
        Attribute oidAttribute = element.attribute(OID_TAG);
        if (oidAttribute == null || oidAttribute.getValue().equals("")) {
            throw new XMLSchemaFileImportException(Messages.getString("XMLSchemaFileImporter.NoMatchingRuleForOID"));
        }
        mr = new MutableMatchingRule(oidAttribute.getValue());
        mr.setSchemaName(schema.getSchemaName());
        Element aliasesElement = element.element(ALIASES_TAG);
        if (aliasesElement != null) {
            ArrayList<String> aliases = new ArrayList<String>();
            Iterator i = aliasesElement.elementIterator(ALIAS_TAG);
            while (i.hasNext()) {
                Element aliasElement = (Element)i.next();
                aliases.add(aliasElement.getText());
            }
            if (aliases.size() >= 1) {
                mr.setNames(aliases.toArray(new String[0]));
            }
        }
        if ((descriptionElement = element.element(DESCRIPTION_TAG)) != null && !descriptionElement.getText().equals("")) {
            mr.setDescription(descriptionElement.getText());
        }
        if ((obsoleteAttribute = element.attribute(OBSOLETE_TAG)) != null && !obsoleteAttribute.getValue().equals("")) {
            mr.setObsolete(XMLSchemaFileImporter.readBoolean(obsoleteAttribute.getValue()));
        }
        if ((syntaxOidElement = element.element(SYNTAX_OID_TAG)) != null && !syntaxOidElement.getText().equals("")) {
            mr.setSyntaxOid(syntaxOidElement.getText());
        }
        schema.addMatchingRule((MatchingRule)mr);
    }

    private static void readSyntaxes(Element element, Schema schema) throws XMLSchemaFileImportException {
        Iterator i = element.elementIterator(SYNTAXES_TAG);
        while (i.hasNext()) {
            Element syntaxElement = (Element)i.next();
            Iterator i2 = syntaxElement.elementIterator(SYNTAX_TAG);
            while (i2.hasNext()) {
                XMLSchemaFileImporter.readSyntax((Element)i2.next(), schema);
            }
        }
    }

    private static void readSyntax(Element element, Schema schema) throws XMLSchemaFileImportException {
        Attribute humanReadibleAttribute;
        Attribute obsoleteAttribute;
        Element descriptionElement;
        LdapSyntax syntax = null;
        Attribute oidAttribute = element.attribute(OID_TAG);
        if (oidAttribute == null || oidAttribute.getValue().equals("")) {
            throw new XMLSchemaFileImportException(Messages.getString("XMLSchemaFileImporter.InvalidSyntaxForOID"));
        }
        syntax = new LdapSyntax(oidAttribute.getValue());
        syntax.setSchemaName(schema.getSchemaName());
        Element aliasesElement = element.element(ALIASES_TAG);
        if (aliasesElement != null) {
            ArrayList<String> aliases = new ArrayList<String>();
            Iterator i = aliasesElement.elementIterator(ALIAS_TAG);
            while (i.hasNext()) {
                Element aliasElement = (Element)i.next();
                aliases.add(aliasElement.getText());
            }
            if (aliases.size() >= 1) {
                syntax.setNames(aliases.toArray(new String[0]));
            }
        }
        if ((descriptionElement = element.element(DESCRIPTION_TAG)) != null && !descriptionElement.getText().equals("")) {
            syntax.setDescription(descriptionElement.getText());
        }
        if ((obsoleteAttribute = element.attribute(OBSOLETE_TAG)) != null && !obsoleteAttribute.getValue().equals("")) {
            syntax.setObsolete(XMLSchemaFileImporter.readBoolean(obsoleteAttribute.getValue()));
        }
        if ((humanReadibleAttribute = element.attribute(HUMAN_READABLE_TAG)) != null && !humanReadibleAttribute.getValue().equals("")) {
            syntax.setHumanReadable(XMLSchemaFileImporter.readBoolean(humanReadibleAttribute.getValue()));
        }
        schema.addSyntax(syntax);
    }

    private static boolean readBoolean(String value) throws XMLSchemaFileImportException {
        if (value.equals(BOOLEAN_TRUE)) {
            return true;
        }
        if (value.equals(BOOLEAN_FALSE)) {
            return false;
        }
        throw new XMLSchemaFileImportException(Messages.getString("XMLSchemaFileImporter.76"));
    }

    public static SchemaFileType getSchemaFileType(InputStream inputStream, String path) throws XMLSchemaFileImportException {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(inputStream);
        }
        catch (DocumentException e) {
            throw new XMLSchemaFileImportException(NLS.bind((String)Messages.getString("XMLSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}), (Exception)((Object)e));
        }
        Element rootElement = document.getRootElement();
        if (rootElement.getName().equals(SCHEMA_TAG)) {
            return SchemaFileType.SINGLE;
        }
        if (rootElement.getName().equals(SCHEMAS_TAG)) {
            return SchemaFileType.MULTIPLE;
        }
        throw new XMLSchemaFileImportException(NLS.bind((String)Messages.getString("XMLSchemaFileImporter.NotValidSchema"), (Object[])new String[]{path}));
    }

    public static enum SchemaFileType {
        SINGLE,
        MULTIPLE;

    }
}

