/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.hierarchy.HierarchyManager;
import org.apache.directory.studio.schemaeditor.view.wrappers.AbstractTreeNode;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class HierarchyViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        List<Object> children = new ArrayList();
        if (parentElement instanceof ObjectClass) {
            MutableObjectClass oc = (MutableObjectClass)parentElement;
            children = this.createTypeHierarchyObjectClass(oc);
        } else if (parentElement instanceof AttributeType) {
            AttributeType at = (AttributeType)parentElement;
            children = this.createTypeHierarchyAttributeType(at);
        } else if (parentElement instanceof TreeNode) {
            children = ((TreeNode)parentElement).getChildren();
        }
        return children.toArray();
    }

    private List<TreeNode> createTypeHierarchyObjectClass(MutableObjectClass oc) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        HierarchyManager hierarchyManager = new HierarchyManager();
        ObjectClassWrapper ocw = new ObjectClassWrapper((ObjectClass)oc);
        int mode = Activator.getDefault().getDialogSettings().getInt(PluginConstants.PREFS_HIERARCHY_VIEW_MODE);
        if (mode == 2) {
            this.createChildrenHierarchy(ocw, hierarchyManager.getChildren(oc), hierarchyManager);
            this.createParentHierarchy(hierarchyManager.getParents(oc), children, ocw, hierarchyManager);
        } else if (mode == 0) {
            this.createParentHierarchy(hierarchyManager.getParents(oc), children, ocw, hierarchyManager);
        } else if (mode == 1) {
            this.createChildrenHierarchy(ocw, hierarchyManager.getChildren(oc), hierarchyManager);
            children.add(ocw);
        }
        return children;
    }

    private void createParentHierarchy(List<Object> parents, List<TreeNode> children, ObjectClassWrapper ocw, HierarchyManager hierarchyManager) {
        if (parents != null) {
            for (Object parent : parents) {
                if (parent instanceof ObjectClass) {
                    MutableObjectClass parentOC = (MutableObjectClass)parent;
                    ObjectClassWrapper duplicatedOCW = (ObjectClassWrapper)this.duplicateTreeNode(ocw);
                    ObjectClassWrapper ocw2 = new ObjectClassWrapper((ObjectClass)parentOC);
                    duplicatedOCW.setParent(ocw2);
                    ocw2.addChild(duplicatedOCW);
                    this.createParentHierarchy(hierarchyManager.getParents(parentOC), children, ocw2, hierarchyManager);
                    continue;
                }
                children.add(ocw);
            }
        } else {
            children.add(ocw);
        }
    }

    public TreeNode duplicateTreeNode(TreeNode node) {
        if (node != null && node instanceof ObjectClassWrapper) {
            ObjectClassWrapper ocNode = (ObjectClassWrapper)node;
            ObjectClassWrapper duplicatedOCNode = new ObjectClassWrapper(ocNode.getObjectClass(), ocNode.getParent());
            for (TreeNode child : ocNode.getChildren()) {
                TreeNode duplicatedChild = this.duplicateTreeNode(child);
                if (duplicatedChild == null) continue;
                duplicatedOCNode.addChild(duplicatedChild);
            }
            return duplicatedOCNode;
        }
        return null;
    }

    private List<TreeNode> createTypeHierarchyAttributeType(AttributeType at) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        HierarchyManager hierarchyManager = new HierarchyManager();
        int mode = Activator.getDefault().getDialogSettings().getInt(PluginConstants.PREFS_HIERARCHY_VIEW_MODE);
        AttributeTypeWrapper atw = new AttributeTypeWrapper(at);
        if (mode == 2) {
            Object parent;
            this.createChildrenHierarchy(atw, hierarchyManager.getChildren(at), hierarchyManager);
            List<Object> parents = hierarchyManager.getParents(at);
            while (parents != null && parents.size() == 1 && (parent = parents.get(0)) instanceof AttributeType) {
                AttributeType parentAT = (AttributeType)parent;
                AttributeTypeWrapper atw2 = new AttributeTypeWrapper(parentAT);
                atw.setParent(atw2);
                atw2.addChild(atw);
                atw = atw2;
                parents = hierarchyManager.getParents(parentAT);
            }
            children.add(atw);
        } else if (mode == 0) {
            Object parent;
            List<Object> parents = hierarchyManager.getParents(at);
            while (parents != null && parents.size() == 1 && (parent = parents.get(0)) instanceof AttributeType) {
                AttributeType parentAT = (AttributeType)parent;
                AttributeTypeWrapper atw2 = new AttributeTypeWrapper(parentAT);
                atw.setParent(atw2);
                atw2.addChild(atw);
                atw = atw2;
                parents = hierarchyManager.getParents(parentAT);
            }
            children.add(atw);
        } else if (mode == 1) {
            this.createChildrenHierarchy(atw, hierarchyManager.getChildren(at), hierarchyManager);
            children.add(atw);
        }
        return children;
    }

    private void createChildrenHierarchy(TreeNode node, List<Object> children, HierarchyManager hierarchyManager) {
        if (children != null && children.size() > 0) {
            for (Object child : children) {
                AbstractTreeNode childNode = null;
                if (child instanceof AttributeType) {
                    AttributeType at = (AttributeType)child;
                    childNode = new AttributeTypeWrapper(at, node);
                    node.addChild(childNode);
                } else if (child instanceof ObjectClass) {
                    MutableObjectClass oc = (MutableObjectClass)child;
                    childNode = new ObjectClassWrapper((ObjectClass)oc, node);
                    node.addChild(childNode);
                }
                this.createChildrenHierarchy(childNode, hierarchyManager.getChildren(child), hierarchyManager);
            }
        }
    }

    public Object getParent(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof TreeNode;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

