/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.StudioPagedResultsControl;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.events.ChildrenInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeRootDSERunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.ContinuedSearchResultEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.apache.directory.studio.ldapbrowser.core.model.impl.SearchContinuation;
import org.eclipse.core.runtime.IAdaptable;

public class InitializeChildrenRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IEntry[] entries;
    private boolean purgeAllCaches;
    private StudioControl pagedSearchControl;

    public InitializeChildrenRunnable(boolean purgeAllCaches, IEntry ... entries) {
        this.entries = entries;
        this.purgeAllCaches = purgeAllCaches;
    }

    private InitializeChildrenRunnable(IEntry entry, StudioControl pagedSearchControl) {
        this.entries = new IEntry[]{entry};
        this.pagedSearchControl = pagedSearchControl;
    }

    public Connection[] getConnections() {
        Connection[] connections = new Connection[this.entries.length];
        for (int i = 0; i < connections.length; ++i) {
            connections[i] = this.entries[i].getBrowserConnection().getConnection();
        }
        return connections;
    }

    public String getName() {
        return BrowserCoreMessages.jobs__init_entries_title_subonly;
    }

    public Object[] getLockedObjects() {
        ArrayList<IEntry> l = new ArrayList<IEntry>();
        l.addAll(Arrays.asList(this.entries));
        return l.toArray();
    }

    public String getErrorMessage() {
        return this.entries.length == 1 ? BrowserCoreMessages.jobs__init_entries_error_1 : BrowserCoreMessages.jobs__init_entries_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", this.entries.length + 2);
        monitor.reportProgress(" ");
        for (IEntry entry : this.entries) {
            monitor.setTaskName(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_task, (Object[])new String[]{entry.getDn().getName()}));
            monitor.worked(1);
            IBrowserConnection browserConnection = entry.getBrowserConnection();
            if (browserConnection == null) continue;
            if (entry instanceof IRootDSE) {
                InitializeRootDSERunnable.loadRootDSE(browserConnection, monitor);
                continue;
            }
            if (this.pagedSearchControl == null && browserConnection.isPagedSearch()) {
                this.pagedSearchControl = new StudioPagedResultsControl(browserConnection.getPagedSearchSize(), null, false, browserConnection.isPagedSearchScrollMode());
            }
            this.initializeChildren(entry, monitor, this.pagedSearchControl);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        for (IEntry entry : this.entries) {
            if (entry.getBrowserConnection() == null || !entry.isChildrenInitialized()) continue;
            EventRegistry.fireEntryUpdated(new ChildrenInitializedEvent(entry), this);
        }
    }

    private void initializeChildren(IEntry parent, StudioProgressMonitor monitor, StudioControl pagedSearchControl) {
        monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_progress_sub, (Object[])new String[]{parent.getDn().getName()}));
        InitializeChildrenRunnable.clearCaches(parent, this.purgeAllCaches);
        ISearch search = InitializeChildrenRunnable.createSearch(parent, pagedSearchControl, false, false, false);
        InitializeChildrenRunnable.executeSearch(parent, search, monitor);
        ISearchResult[] srs = search.getSearchResults();
        SearchContinuation[] scs = search.getSearchContinuations();
        if (srs != null && srs.length > 0 || scs != null && scs.length > 0) {
            InitializeChildrenRunnable.clearCaches(parent, false);
            do {
                if (srs != null) {
                    for (IAdaptable iAdaptable : srs) {
                        parent.addChild(iAdaptable.getEntry());
                    }
                    srs = null;
                }
                if (scs != null) {
                    for (IAdaptable iAdaptable : scs) {
                        ContinuedSearchResultEntry entry = new ContinuedSearchResultEntry(parent.getBrowserConnection(), iAdaptable.getUrl().getDn());
                        entry.setUnresolved(iAdaptable.getUrl());
                        parent.addChild(entry);
                    }
                    scs = null;
                }
                StudioPagedResultsControl sprRequestControl = null;
                StudioPagedResultsControl sprResponseControl = null;
                for (StudioControl studioControl : search.getResponseControls()) {
                    if (!(studioControl instanceof StudioPagedResultsControl)) continue;
                    sprResponseControl = (StudioPagedResultsControl)studioControl;
                }
                for (StudioControl studioControl : search.getControls()) {
                    if (!(studioControl instanceof StudioPagedResultsControl)) continue;
                    sprRequestControl = (StudioPagedResultsControl)studioControl;
                }
                if (sprRequestControl == null || sprResponseControl == null) continue;
                if (sprRequestControl.isScrollMode()) {
                    if (sprRequestControl.getCookie() != null) {
                        InitializeChildrenRunnable topPageChildrenRunnable = new InitializeChildrenRunnable(parent, null);
                        parent.setTopPageChildrenRunnable(topPageChildrenRunnable);
                    }
                    if (sprResponseControl.getCookie() == null) continue;
                    StudioPagedResultsControl newSprc = new StudioPagedResultsControl(sprRequestControl.getSize(), sprResponseControl.getCookie(), sprRequestControl.isCritical(), sprRequestControl.isScrollMode());
                    InitializeChildrenRunnable initializeChildrenRunnable = new InitializeChildrenRunnable(parent, (StudioControl)newSprc);
                    parent.setNextPageChildrenRunnable(initializeChildrenRunnable);
                    continue;
                }
                if (sprResponseControl.getCookie() == null || search.getCountLimit() != 0 && search.getSearchResults().length >= search.getCountLimit()) continue;
                search.setSearchResults(new ISearchResult[0]);
                search.getResponseControls().clear();
                sprRequestControl.setCookie(sprResponseControl.getCookie());
                InitializeChildrenRunnable.executeSearch(parent, search, monitor);
                srs = search.getSearchResults();
                scs = search.getSearchContinuations();
            } while (srs != null && srs.length > 0);
        } else {
            parent.setHasChildrenHint(false);
        }
        ISearch subSearch = InitializeChildrenRunnable.createSearch(parent, null, true, false, false);
        if (parent.getBrowserConnection().isFetchSubentries() || parent.isFetchSubentries()) {
            this.executeSubSearch(parent, subSearch, monitor);
        }
        ISearch aliasOrReferralSearch = InitializeChildrenRunnable.createSearch(parent, null, false, parent.isFetchAliases(), parent.isFetchReferrals());
        if (parent.isFetchAliases() || parent.isFetchReferrals()) {
            this.executeSubSearch(parent, aliasOrReferralSearch, monitor);
        }
        parent.setHasMoreChildren(search.isCountLimitExceeded() || subSearch.isCountLimitExceeded() || aliasOrReferralSearch.isCountLimitExceeded() || monitor.isCanceled());
        parent.setChildrenInitialized(true);
    }

    private void executeSubSearch(IEntry parent, ISearch subSearch, StudioProgressMonitor monitor) {
        InitializeChildrenRunnable.executeSearch(parent, subSearch, monitor);
        ISearchResult[] subSrs = subSearch.getSearchResults();
        SearchContinuation[] subScs = subSearch.getSearchContinuations();
        if (subSrs != null && subSrs.length > 0) {
            for (ISearchResult iSearchResult : subSrs) {
                parent.addChild(iSearchResult.getEntry());
            }
            for (IAdaptable iAdaptable : subScs) {
                ContinuedSearchResultEntry entry = new ContinuedSearchResultEntry(parent.getBrowserConnection(), iAdaptable.getUrl().getDn());
                entry.setUnresolved(iAdaptable.getUrl());
                parent.addChild(entry);
            }
        }
    }

    private static void executeSearch(IEntry parent, ISearch search, StudioProgressMonitor monitor) {
        SearchRunnable.searchAndUpdateModel(parent.getBrowserConnection(), search, monitor);
        ISearchResult[] srs = search.getSearchResults();
        monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_progress_subcount, (Object[])new String[]{srs == null ? Integer.toString(0) : Integer.toString(srs.length), parent.getDn().getName()}));
    }

    private static ISearch createSearch(IEntry parent, StudioControl pagedSearchControl, boolean isSubentriesSearch, boolean isAliasSearch, boolean isReferralsSearch) {
        SearchScope scope = SearchScope.ONELEVEL;
        String filter = parent.getChildrenFilter();
        if (isSubentriesSearch) {
            filter = "(|(objectClass=subentry)(objectClass=ldapSubentry))";
        } else if (isAliasSearch && isReferralsSearch) {
            filter = "(|(objectClass=alias)(objectClass=referral))";
        } else if (isAliasSearch) {
            filter = "(objectClass=alias)";
        } else if (isReferralsSearch) {
            filter = "(objectClass=referral)";
        }
        Connection.AliasDereferencingMethod aliasesDereferencingMethod = parent.getBrowserConnection().getAliasesDereferencingMethod();
        if (parent.isAlias() || isAliasSearch) {
            aliasesDereferencingMethod = Connection.AliasDereferencingMethod.NEVER;
        }
        Connection.ReferralHandlingMethod referralsHandlingMethod = parent.getBrowserConnection().getReferralsHandlingMethod();
        Search search = new Search(null, parent.getBrowserConnection(), parent.getDn(), filter, ISearch.NO_ATTRIBUTES, scope, parent.getBrowserConnection().getCountLimit(), parent.getBrowserConnection().getTimeLimit(), aliasesDereferencingMethod, referralsHandlingMethod, BrowserCorePlugin.getDefault().getPluginPreferences().getBoolean("checkForChildren"), null);
        if (parent.isReferral() || isReferralsSearch || parent.getBrowserConnection().isManageDsaIT()) {
            search.getSearchParameter().getControls().add(StudioControl.MANAGEDSAIT_CONTROL);
        }
        if (isSubentriesSearch) {
            search.getSearchParameter().getControls().add(StudioControl.SUBENTRIES_CONTROL);
        }
        if (pagedSearchControl != null) {
            search.getSearchParameter().getControls().add(pagedSearchControl);
        }
        return search;
    }

    static void clearCaches(IEntry entry, boolean purgeAllCaches) {
        IEntry[] children = entry.getChildren();
        if (children != null) {
            for (IEntry child : children) {
                if (child == null) continue;
                entry.deleteChild(child);
                InitializeChildrenRunnable.clearCaches(child, purgeAllCaches);
            }
        }
        entry.setChildrenInitialized(false);
        entry.setTopPageChildrenRunnable(null);
        entry.setNextPageChildrenRunnable(null);
        if (purgeAllCaches) {
            entry.setAttributesInitialized(false);
            entry.setHasChildrenHint(true);
            entry.setHasMoreChildren(false);
        }
    }
}

