/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryMovedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.CopyEntriesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.DeleteEntriesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.RenameEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SimulateRenameDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveEntriesRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IBrowserConnection browserConnection;
    private IEntry[] oldEntries;
    private IEntry newParent;
    private IEntry[] newEntries;
    private Set<ISearch> searchesToUpdateSet = new HashSet<ISearch>();
    private SimulateRenameDialog dialog;

    public MoveEntriesRunnable(IEntry[] entries, IEntry newParent, SimulateRenameDialog dialog) {
        this.browserConnection = newParent.getBrowserConnection();
        this.oldEntries = entries;
        this.newParent = newParent;
        this.dialog = dialog;
        this.newEntries = new IEntry[this.oldEntries.length];
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return this.oldEntries.length == 1 ? BrowserCoreMessages.jobs__move_entry_name_1 : BrowserCoreMessages.jobs__move_entry_name_n;
    }

    public Object[] getLockedObjects() {
        ArrayList<IEntry> l = new ArrayList<IEntry>();
        l.add(this.newParent);
        l.addAll(Arrays.asList(this.oldEntries));
        return l.toArray();
    }

    public String getErrorMessage() {
        return this.oldEntries.length == 1 ? BrowserCoreMessages.jobs__move_entry_error_1 : BrowserCoreMessages.jobs__move_entry_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.bind((String)(this.oldEntries.length == 1 ? BrowserCoreMessages.jobs__move_entry_task_1 : BrowserCoreMessages.jobs__move_entry_task_n), (Object[])new String[0]), 3);
        monitor.reportProgress(" ");
        monitor.worked(1);
        StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
        int numAdd = 0;
        int numDel = 0;
        boolean isSimulatedRename = false;
        Dn parentDn = this.newParent.getDn();
        for (int i = 0; i < this.oldEntries.length; ++i) {
            IEntry newEntry;
            dummyMonitor.reset();
            IEntry oldEntry = this.oldEntries[i];
            Dn oldDn = oldEntry.getDn();
            Dn newDn = null;
            try {
                newDn = parentDn.add(oldDn.getRdn());
            }
            catch (LdapInvalidDnException lide) {
                newDn = Dn.EMPTY_DN;
            }
            RenameEntryRunnable.renameEntry(this.browserConnection, oldEntry, newDn, dummyMonitor);
            if (dummyMonitor.errorsReported()) {
                Exception exception;
                if (this.dialog != null && dummyMonitor.getException() instanceof ContextNotEmptyException) {
                    if (numAdd == 0) {
                        this.dialog.setEntryInfo(this.browserConnection, oldDn, newDn);
                        this.dialog.open();
                        isSimulatedRename = this.dialog.isSimulateRename();
                    }
                    if (isSimulatedRename) {
                        dummyMonitor.reset();
                        numAdd = CopyEntriesRunnable.copyEntry(oldEntry, this.newParent, null, 2, numAdd, null, dummyMonitor, monitor);
                        if (!dummyMonitor.errorsReported()) {
                            dummyMonitor.reset();
                            numDel = DeleteEntriesRunnable.optimisticDeleteEntryRecursive(this.browserConnection, oldDn, oldEntry.isReferral(), false, numDel, dummyMonitor, monitor);
                        }
                    } else {
                        exception = dummyMonitor.getException();
                        monitor.reportError(exception);
                    }
                } else {
                    exception = dummyMonitor.getException();
                    monitor.reportError(exception);
                }
            }
            if (dummyMonitor.errorsReported()) continue;
            this.browserConnection.uncacheEntryRecursive(oldEntry);
            oldEntry.getParententry().deleteChild(oldEntry);
            boolean hasMoreChildren = this.newParent.hasMoreChildren() || !this.newParent.isChildrenInitialized();
            ArrayList<StudioControl> controls = new ArrayList<StudioControl>();
            if (oldEntry.isReferral()) {
                controls.add(StudioControl.MANAGEDSAIT_CONTROL);
            }
            this.newEntries[i] = newEntry = ReadEntryRunnable.getEntry(this.browserConnection, newDn, controls, monitor);
            this.newParent.addChild(newEntry);
            this.newParent.setHasMoreChildren(hasMoreChildren);
            List<ISearch> searches = this.browserConnection.getSearchManager().getSearches();
            block3: for (ISearch search : searches) {
                ISearchResult[] searchResults;
                if (search.getSearchResults() == null) continue;
                for (ISearchResult result : searchResults = search.getSearchResults()) {
                    if (!oldEntry.equals(result.getEntry())) continue;
                    search.setSearchResults(null);
                    this.searchesToUpdateSet.add(search);
                    continue block3;
                }
            }
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        if (this.newEntries.length < 2) {
            for (int i = 0; i < this.newEntries.length; ++i) {
                if (this.oldEntries[i] == null || this.newEntries[i] == null) continue;
                EventRegistry.fireEntryUpdated(new EntryMovedEvent(this.oldEntries[i], this.newEntries[i]), this);
            }
        } else {
            for (IEntry oldEntry : this.oldEntries) {
                oldEntry.getParententry().setChildrenInitialized(false);
            }
            this.newParent.setChildrenInitialized(false);
            EventRegistry.fireEntryUpdated(new BulkModificationEvent(this.browserConnection), this);
        }
    }
}

