/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.AbstractEntry;

public class Entry
extends AbstractEntry {
    private static final long serialVersionUID = -4718107307581983276L;
    protected Rdn rdn;
    protected IEntry parent;

    protected Entry() {
    }

    public Entry(IEntry parent, Rdn rdn) {
        assert (parent != null);
        assert (rdn != null);
        assert (!"".equals(rdn.toString()));
        this.parent = parent;
        this.rdn = rdn;
    }

    @Override
    public Rdn getRdn() {
        return this.rdn;
    }

    @Override
    public Dn getDn() {
        try {
            Dn dn = this.parent.getDn().add(this.rdn);
            return dn;
        }
        catch (LdapInvalidDnException lide) {
            return null;
        }
    }

    @Override
    public IEntry getParententry() {
        return this.parent;
    }

    @Override
    public IBrowserConnection getBrowserConnection() {
        return this.getParententry().getBrowserConnection();
    }

    @Override
    protected void setRdn(Rdn newRdn) {
        this.rdn = newRdn;
    }

    @Override
    protected void setParent(IEntry newParent) {
        this.parent = newParent;
    }
}

