/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.apacheds.v157;

import org.apache.directory.studio.apacheds.configuration.model.v157.ServerConfigurationV157;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.PasswordsKeyStoreManager;
import org.apache.directory.studio.connection.ui.PasswordsKeyStoreManagerUtils;
import org.apache.directory.studio.ldapservers.actions.CreateConnectionActionHelper;
import org.apache.directory.studio.ldapservers.apacheds.v157.ApacheDS157LdapServerAdapter;
import org.apache.directory.studio.ldapservers.apacheds.v157.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.views.ServersView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CreateConnectionAction
implements IObjectActionDelegate {
    private static final String EXTENSION_ID = "org.apache.directory.server.1.5.7";
    private ServersView view;

    public void run(IAction action) {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty() && selection.size() == 1) {
            LdapServer server = (LdapServer)selection.getFirstElement();
            if (!EXTENSION_ID.equalsIgnoreCase(server.getLdapServerAdapterExtension().getId())) {
                String message = Messages.getString("CreateConnectionAction.UnableReadServerConfiguration") + "\n\n" + Messages.getString("CreateConnectionAction.NotA157Server");
                this.reportErrorReadingServerConfiguration(this.view, message);
                return;
            }
            ServerConfigurationV157 serverConfiguration = null;
            try {
                serverConfiguration = ApacheDS157LdapServerAdapter.getServerConfiguration(server);
            }
            catch (Exception e) {
                String message = Messages.getString("CreateConnectionAction.UnableReadServerConfiguration") + "\n\n" + Messages.getString("CreateConnectionAction.FollowingErrorOccurred") + e.getMessage();
                this.reportErrorReadingServerConfiguration(this.view, message);
                return;
            }
            if (serverConfiguration == null) {
                this.reportErrorReadingServerConfiguration(this.view, Messages.getString("CreateConnectionAction.UnableReadServerConfiguration"));
                return;
            }
            if (serverConfiguration.isEnableLdap() || serverConfiguration.isEnableLdaps()) {
                this.createConnection(server, serverConfiguration);
            } else {
                MessageDialog dialog = new MessageDialog(this.view.getSite().getShell(), Messages.getString("CreateConnectionAction.UnableCreateConnection"), null, Messages.getString("CreateConnectionAction.LDAPAndLDAPSDisabled"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        }
    }

    private void reportErrorReadingServerConfiguration(ServersView view, String message) {
        MessageDialog dialog = new MessageDialog(view.getSite().getShell(), Messages.getString("CreateConnectionAction.UnableReadServerConfiguration"), null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    private void createConnection(LdapServer server, ServerConfigurationV157 configuration) {
        ConnectionParameter connectionParameter = new ConnectionParameter();
        connectionParameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.SIMPLE);
        if (configuration.isEnableLdap()) {
            connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
            connectionParameter.setPort(configuration.getLdapPort());
        } else if (configuration.isEnableLdaps()) {
            connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
            connectionParameter.setPort(configuration.getLdapsPort());
        }
        if (PasswordsKeyStoreManagerUtils.isPasswordsKeystoreEnabled()) {
            PasswordsKeyStoreManager passwordsKeyStoreManager = ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager();
            if (passwordsKeyStoreManager.isLoaded()) {
                passwordsKeyStoreManager.storeConnectionPassword(connectionParameter.getId(), "secret");
            } else if (PasswordsKeyStoreManagerUtils.askUserToLoadKeystore()) {
                passwordsKeyStoreManager.storeConnectionPassword(connectionParameter.getId(), "secret");
            }
        } else {
            connectionParameter.setBindPassword("secret");
        }
        connectionParameter.setBindPrincipal("uid=admin,ou=system");
        connectionParameter.setHost("localhost");
        connectionParameter.setName(server.getName());
        connectionParameter.setNetworkProvider(ConnectionCorePlugin.getDefault().getDefaultNetworkProvider());
        CreateConnectionActionHelper.createLdapBrowserConnection((LdapServer)server, (Connection)new Connection(connectionParameter));
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof ServersView) {
            this.view = (ServersView)targetPart;
        }
    }
}

