/*
 * Pidgin Authorization Blocker
 * Copyright (C) 2011 Konrad Gräfe
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */

#include "authorization-blocker.h"

#include "deny_msg_blocker.h"

#include <debug.h>
#include <notify.h>
#include <gtk/gtk.h>
#include <gtkblist.h>
#include <minidialog.h>
#include <gtkutils.h>
#include <version.h>

static const char *deny1;
static const char *deny2;
static char reason[1024];

static void *(*notify_message_ori)(PurpleNotifyMsgType type, const char *title, const char *primary, const char *secondary);

static void *notify_message(PurpleNotifyMsgType type, const char *title, const char *primary, const char *secondary) {
	guint32 uid;
	const char *format;
	char *uid_s;
	GList *accounts, *cur;
	PurpleAccount *acc = NULL;
	gboolean found = FALSE;
	gchar *msg;
	GdkPixbuf *prpl_icon;
	GtkWidget *mini_dialog;

	if(!purple_prefs_get_bool(PLUGIN_PREFS_PREFIX "/block_deny_msg")) return notify_message_ori(type, title, primary, secondary);


	if(purple_utf8_strcasecmp(primary, deny1) == 0 || purple_utf8_strcasecmp(primary, deny2) == 0) {
		format = dgettext("pidgin", "The user %u has denied your request to add them to your buddy list for the following reason:\n%s");

		if(sscanf(secondary, format, &uid, reason) >= 1) {
			accounts = purple_accounts_get_all_active();
			uid_s = g_strdup_printf("%u", uid);

			for(cur = accounts; cur != NULL && found == FALSE; cur = cur->next) {
				acc = cur->data;
				if(purple_find_buddy(acc, uid_s) != NULL) {
					found = TRUE;
				}
			}

			free(uid_s);
			g_list_free(accounts);

			if(!found) {
				purple_debug_info(PLUGIN_STATIC_NAME, "Deny message from %u has been blocked!\n", uid);

				if(purple_prefs_get_bool(PLUGIN_PREFS_PREFIX "/show_blocked_requests")) {
					msg = g_strdup_printf(_("Blocked deny message from %u."), uid);

#if PURPLE_VERSION_CHECK(2,7,4)
					prpl_icon = pidgin_create_prpl_icon(acc, PIDGIN_PRPL_ICON_SMALL);
					mini_dialog = GTK_WIDGET(pidgin_mini_dialog_new_with_custom_icon(_("Authorization Blocker"), msg, prpl_icon));
#else
					mini_dialog = GTK_WIDGET(pidgin_mini_dialog_new(_("Authorization Blocker"), msg, ""));
#endif
					pidgin_mini_dialog_add_button(PIDGIN_MINI_DIALOG(mini_dialog), _("OK"), NULL, NULL);
					//pidgin_mini_dialog_add_button(PIDGIN_MINI_DIALOG(mini_dialog), _("Info"), show_user_info_cb, entry);
					pidgin_blist_add_alert(mini_dialog);

					g_free(msg);
				}
				return NULL;
			}
		}
	}

	return notify_message_ori(type, title, primary, secondary);
}

void deny_msg_blocker_init(void) {
	PurpleNotifyUiOps *ops;

	ops = purple_notify_get_ui_ops();
	if (ops == NULL) return;

	notify_message_ori = ops->notify_message;
	ops->notify_message = notify_message;

	deny1 = dgettext("pidgin", "ICQ authorization denied.");
	deny2 = dgettext("pidgin", "Authorization Denied");
}

void deny_msg_blocker_uninit(void) {
	PurpleNotifyUiOps *ops;

	ops = purple_notify_get_ui_ops();
	if (ops == NULL) return;

	ops->notify_message = notify_message_ori;
}

