.TH WMNOTIFY 1 "February 2004" "wmnotify" "User's Manual"

.SH NAME
wmnotify \- Dockable email notification program for single POP3 or IMAP4 account

.SH SYNOPSIS
.B wmnotify
[\fIOPTION\fR]...

.SH DESCRIPTION
\fBwmnotify\fR is a dockable application (DockApp) for the WindowMaker window
manager to periodically check a POP3 or IMAP4 email account for new messages.
If there are new messages in the mailbox, a simple animation is displayed
and an optional sound (or beep) is produced.

\fBwmnotify\fR now supports SSL encryption.

The interface is kept very simple. To manually check for new messages,
single-click on the mailbox image. To start your favorite email program, 
double-click on the mailbox image.

When you double-click on the mailbox image to start your email program,
the new messages animation is stopped, assuming that you will read your new
messages. If you don't, the wmnotify program will simply continue it's
periodic checking of your email account and will restart the new messages
animation after the usual delay if new messages are unread.

By default, the interval between checks is 5 minutes, and this can be changed
in the configuration file. You can also enable audio notification as well as
specify an optional audio sound file (WAV or AU). If audio notification is
enabled but no audio sound file is specified, a beep will be produced. There is
an option in the configuration file to adjust the volume of the sound file.

.SH "OPTIONS"
.TP
.BI "\-\^c " config-file
.B wmnotify
reads your mail account settings and preferences from the specified
configuration file. This option overrides the use of the default config file,
.IR "$HOME/.wmnotifyrc". Make sure that the alternate configuration file has
correct permissions (normally 0400) to protect your email account informations.

.TP
\fB\-d\fR
Display debugging messages.

.TP
.BI \-display " host" : display
Specifies the host and screen to be used by \fBwmnotify\fR. By default this
is obtained from the environment variable
.SB DISPLAY.

.TP
.BI \-geometry " geometry"
.RB ( *geometry )
Specifies the initial geometry of the window.

.TP
\fB\-h\fR
display usage and exit
.TP
\fB\-v\fR
output version information and exit

.SH "CONFIGURATION FILE"
.IR $HOME/.wmnotifyrc

The first time the program is run, it will check for the presence of the
configuration file in the user's home directory. If this file is not found,
wmnotify will automatically create a new one, and exit with a message telling the
user to set it's mail account settings and preferences in the new configuration file
before restarting wmnotify.

.TP
.BI "protocol " <protocol-name>
mail account protocol, POP3 or IMAP4.

.TP
.BI "imap_folder " <folder-name>
IMAP folder name (optional, default is INBOX).

.TP
.BI "use_ssl "  <value>
This option controls the SSL encryption enabling/disabling. The value may be
set to "0" to disable or to "1" to enable.

.TP
.BI "server " <server-name>
mail server name (or IP address).

.TP
.BI "port " <port-number>
mail server port number (optional, default value is 110).

.TP
.BI "username " <username>
mail account username.

.TP
.BI "password " <password>
mail account password.

.TP
.BI "mailcheckdelay " <delay-in-minutes>
Mail check interval, in minutes (optional, default value is 5).

.TP
.BI "mailclient " <program>
The program to start when double-clicking on the mailbox image (optional).

.TP
.BI "enablebeep " <value>
This option controls the audio notification enabling/disabling. If this option
is enabled and the "audiofile" option below contains a valid audio file, it
will be played whenever new message(s) are detected. If "audiofile" is
commented, the console beep will be used to produce the audio notification. The
value may be set to "0" to disable or to "1" to enable (optional, default value is 0, disabled).

.TP
.BI "audiofile " <path-to-audiofile>
Path and filename of the WAV or AU audio sound file to play when new message(s)
are detected (optional).

.TP
.BI "volume " <value>
Volume value, in percent, when playing an audio file (optional, default value is
100%). This volume value is relative to the values you have set in your sound
card mixer settings. If you find the audio notification sound to be too loud,
just reduce the volume value. On the other hand, if you want to increase the
audio notification sound amplitude, just increase the volume. If you increase
the volume value to 100% and you find that it is not sufficient, then you would
have to increase the volume using your favorite sound card mixer program
(ex: with alsamixer, increase the PCM or master value).

.SH CREDITS
\fBwmnotify\fR was written by Hugo Villeneuve <hugo@hugovil.com>, based on
the WMPop3 program by Scott Holden <scotth@thezone.net>.

.SH COPYRIGHT
\fBwmnotify\fR is free; anyone may redistribute it to anyone under the terms
stated in the GNU General Public License. A copy of the license is included in
the \fBwmnotify\fR distribution. You can also browse it online at
.I http://www.gnu.org/copyleft/gpl.html
