<!--

Thank your for contributing to ObsPy!

!! Please check that you select the **correct base branch** (details see below link) !!

Before submitting a PR, please review the pull request guidelines:
https://github.com/obspy/obspy/blob/master/CONTRIBUTING.md#submitting-a-pull-request

Also, please make sure you are following the ObsPy branching model:
https://github.com/obspy/obspy/wiki/ObsPy-Git-Branching-Model

-->

### What does this PR do?

*Please fill in*

### Why was it initiated?  Any relevant Issues?

*Please fill in*

### PR Checklist
- [ ] Correct base branch selected? `master` for new features, `maintenance_...` for bug fixes
- [ ] This PR is not directly related to an existing issue (which has no PR yet).
- [ ] If the PR is making changes to documentation, docs pages can be built automatically.
      Just add the "build_docs" tag to this PR.
- [ ] If all tests including network modules (e.g. `clients.fdsn`) should be tested for the PR,
      just add the "test_network" tag to this PR.
- [ ] All tests still pass.
- [ ] Any new features or fixed regressions are covered via new tests.
- [ ] Any new or changed features are fully documented.
- [ ] Significant changes have been added to `CHANGELOG.txt` .
- [ ] First time contributors have added your name to `CONTRIBUTORS.txt` .
- [ ] If the changes affect any plotting functions you have checked that the plots
      from all the CI builds look correct. Add the "upload_plots" tag so that plotting 
      outputs are attached as artifacts. 
- [ ] Add the "ready for review" tag when you are ready for the PR to be reviewed.
