/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import org.linkedin.util.reflect.ClassLoaderChain;
import org.linkedin.util.reflect.ObjectProxy;
import org.linkedin.util.reflect.ReflectUtils;

public class ObjectProxyBuilder {
    public static <T> T createProxy(InvocationHandler handler, Class<T> itface) {
        ObjectProxy proxy;
        if (handler instanceof ObjectProxy && !ReflectUtils.isSubClassOrInterfaceOf((proxy = (ObjectProxy)((Object)handler)).getProxiedObject().getClass(), itface)) {
            throw new IllegalArgumentException(proxy.getProxiedObject().getClass() + " does not extend " + itface);
        }
        return (T)Proxy.newProxyInstance(itface.getClassLoader(), new Class[]{itface}, handler);
    }

    public static Object createProxy(InvocationHandler handler, Class<?> ... itfaces) {
        if (handler instanceof ObjectProxy) {
            ObjectProxy proxy = (ObjectProxy)((Object)handler);
            Class<?> proxyClass = proxy.getProxiedObject().getClass();
            for (Class<?> itface : itfaces) {
                if (ReflectUtils.isSubClassOrInterfaceOf(proxyClass, itface)) continue;
                throw new IllegalArgumentException(proxyClass + " does not extend " + itface);
            }
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (Class<?> itface : itfaces) {
            classLoaders.add(itface.getClassLoader());
        }
        ClassLoader classLoader = ClassLoaderChain.createChain(classLoaders);
        return Proxy.newProxyInstance(classLoader, itfaces, handler);
    }

    public static Object createProxy(InvocationHandler handler, Collection<Class<?>> interfaces) {
        return ObjectProxyBuilder.createProxy(handler, interfaces.toArray(new Class[interfaces.size()]));
    }
}

