/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.stress.StressAction;
import org.apache.cassandra.stress.StressGraph;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.MultiResultLogger;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WindowsTimer;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class Stress {
    private static volatile boolean stopped = false;

    public static void main(String[] arguments) throws Exception {
        if (FBUtilities.isWindows) {
            WindowsTimer.startTimerPeriod((int)1);
        }
        int exitCode = Stress.run(arguments);
        if (FBUtilities.isWindows) {
            WindowsTimer.endTimerPeriod((int)1);
        }
        System.exit(exitCode);
    }

    private static int run(String[] arguments) {
        block16: {
            try {
                StressSettings settings;
                DatabaseDescriptor.clientInitialization();
                try {
                    settings = StressSettings.parse(arguments);
                    if (settings == null) {
                        return 0;
                    }
                }
                catch (IllegalArgumentException e) {
                    System.out.printf("%s%n", e.getMessage());
                    Stress.printHelpMessage();
                    return 1;
                }
                catch (Throwable e) {
                    Throwable rc = ExceptionUtils.getRootCause((Throwable)e);
                    if (rc instanceof FileNotFoundException) {
                        System.out.printf("File '%s' doesn't exist!%n", rc.getMessage());
                        Stress.printHelpMessage();
                        return 1;
                    }
                    throw e;
                }
                MultiResultLogger logout = settings.log.getOutput();
                if (!settings.log.noSettings) {
                    settings.printSettings(logout);
                }
                if (settings.graph.inGraphMode()) {
                    logout.addStream(new PrintStream(settings.graph.temporaryLogFile));
                }
                if (settings.sendToDaemon != null) {
                    BufferedReader inp;
                    ObjectOutputStream out;
                    Socket socket;
                    block15: {
                        socket = new Socket(settings.sendToDaemon, 2159);
                        out = new ObjectOutputStream(socket.getOutputStream());
                        inp = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        Runtime.getRuntime().addShutdownHook(new ShutDown(socket, out));
                        out.writeObject(settings);
                        try {
                            String line;
                            while (!socket.isClosed() && (line = inp.readLine()) != null) {
                                if (line.equals("END") || line.equals("FAILURE")) {
                                    out.writeInt(1);
                                    break;
                                }
                                logout.println(line);
                            }
                        }
                        catch (SocketException e) {
                            if (stopped) break block15;
                            e.printStackTrace();
                        }
                    }
                    out.close();
                    inp.close();
                    socket.close();
                    break block16;
                }
                StressAction stressAction = new StressAction(settings, logout);
                stressAction.run();
                logout.flush();
                if (settings.graph.inGraphMode()) {
                    new StressGraph(settings, arguments).generateGraph();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return 1;
            }
        }
        return 0;
    }

    public static void printHelpMessage() {
        StressSettings.printHelp();
    }

    private static class ShutDown
    extends Thread {
        private final Socket socket;
        private final ObjectOutputStream out;

        public ShutDown(Socket socket, ObjectOutputStream out) {
            this.out = out;
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                if (!this.socket.isClosed()) {
                    System.out.println("Control-C caught. Canceling running action and shutting down...");
                    this.out.writeInt(1);
                    this.out.close();
                    stopped = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

