/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.Legacy;
import org.apache.cassandra.stress.settings.SettingsColumn;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.SettingsCommandUser;
import org.apache.cassandra.stress.settings.SettingsErrors;
import org.apache.cassandra.stress.settings.SettingsGraph;
import org.apache.cassandra.stress.settings.SettingsInsert;
import org.apache.cassandra.stress.settings.SettingsLog;
import org.apache.cassandra.stress.settings.SettingsMisc;
import org.apache.cassandra.stress.settings.SettingsMode;
import org.apache.cassandra.stress.settings.SettingsNode;
import org.apache.cassandra.stress.settings.SettingsPopulation;
import org.apache.cassandra.stress.settings.SettingsPort;
import org.apache.cassandra.stress.settings.SettingsRate;
import org.apache.cassandra.stress.settings.SettingsSchema;
import org.apache.cassandra.stress.settings.SettingsTokenRange;
import org.apache.cassandra.stress.settings.SettingsTransport;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ResultLogger;
import org.apache.cassandra.transport.SimpleClient;

public class StressSettings
implements Serializable {
    public final SettingsCommand command;
    public final SettingsRate rate;
    public final SettingsPopulation generate;
    public final SettingsInsert insert;
    public final SettingsColumn columns;
    public final SettingsErrors errors;
    public final SettingsLog log;
    public final SettingsMode mode;
    public final SettingsNode node;
    public final SettingsSchema schema;
    public final SettingsTransport transport;
    public final SettingsPort port;
    public final String sendToDaemon;
    public final SettingsGraph graph;
    public final SettingsTokenRange tokenRange;
    private static volatile JavaDriverClient client;
    private static volatile int numFailures;
    private static int MAX_NUM_FAILURES;

    public StressSettings(SettingsCommand command, SettingsRate rate, SettingsPopulation generate, SettingsInsert insert, SettingsColumn columns, SettingsErrors errors, SettingsLog log, SettingsMode mode, SettingsNode node, SettingsSchema schema, SettingsTransport transport, SettingsPort port, String sendToDaemon, SettingsGraph graph, SettingsTokenRange tokenRange) {
        this.command = command;
        this.rate = rate;
        this.insert = insert;
        this.generate = generate;
        this.columns = columns;
        this.errors = errors;
        this.log = log;
        this.mode = mode;
        this.node = node;
        this.schema = schema;
        this.transport = transport;
        this.port = port;
        this.sendToDaemon = sendToDaemon;
        this.graph = graph;
        this.tokenRange = tokenRange;
    }

    public SimpleClient getSimpleNativeClient() {
        try {
            String currentNode = this.node.randomNode();
            SimpleClient client = new SimpleClient(currentNode, this.port.nativePort);
            client.connect(false);
            client.execute("USE \"" + this.schema.keyspace + "\";", ConsistencyLevel.ONE);
            return client;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public JavaDriverClient getJavaDriverClient() {
        return this.getJavaDriverClient(true);
    }

    public JavaDriverClient getJavaDriverClient(boolean setKeyspace) {
        if (setKeyspace) {
            return this.getJavaDriverClient(this.schema.keyspace);
        }
        return this.getJavaDriverClient(null);
    }

    public JavaDriverClient getJavaDriverClient(String keyspace) {
        if (client != null) {
            return client;
        }
        StressSettings stressSettings = this;
        synchronized (stressSettings) {
            if (numFailures >= MAX_NUM_FAILURES) {
                throw new RuntimeException("Failed to create client too many times");
            }
            try {
                String currentNode = this.node.randomNode();
                if (client != null) {
                    return client;
                }
                EncryptionOptions encOptions = this.transport.getEncryptionOptions();
                JavaDriverClient c = new JavaDriverClient(this, currentNode, this.port.nativePort, encOptions);
                c.connect(this.mode.compression());
                if (keyspace != null) {
                    c.execute("USE \"" + keyspace + "\";", ConsistencyLevel.ONE);
                }
                client = c;
                return client;
            }
            catch (Exception e) {
                ++numFailures;
                throw new RuntimeException(e);
            }
        }
    }

    public void maybeCreateKeyspaces() {
        if (this.command.type == Command.WRITE || this.command.type == Command.COUNTER_WRITE) {
            this.schema.createKeySpaces(this);
        } else if (this.command.type == Command.USER) {
            ((SettingsCommandUser)this.command).profiles.forEach((k, v) -> v.maybeCreateSchema(this));
        }
    }

    public static StressSettings parse(String[] args) {
        Map<String, String[]> clArgs = StressSettings.parseMap(args = StressSettings.repairParams(args));
        if (clArgs.containsKey("legacy")) {
            return Legacy.build(Arrays.copyOfRange(args, 1, args.length));
        }
        if (SettingsMisc.maybeDoSpecial(clArgs)) {
            return null;
        }
        return StressSettings.get(clArgs);
    }

    private static String[] repairParams(String[] args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(arg);
            first = false;
        }
        return sb.toString().replaceAll("\\s+([,=()])", "$1").replaceAll("([,=(])\\s+", "$1").split(" +");
    }

    public static StressSettings get(Map<String, String[]> clArgs) {
        SettingsCommand command = SettingsCommand.get(clArgs);
        if (command == null) {
            throw new IllegalArgumentException("No command specified");
        }
        String sendToDaemon = SettingsMisc.getSendToDaemon(clArgs);
        SettingsPort port = SettingsPort.get(clArgs);
        SettingsRate rate = SettingsRate.get(clArgs, command);
        SettingsPopulation generate = SettingsPopulation.get(clArgs, command);
        SettingsTokenRange tokenRange = SettingsTokenRange.get(clArgs);
        SettingsInsert insert = SettingsInsert.get(clArgs);
        SettingsColumn columns = SettingsColumn.get(clArgs);
        SettingsErrors errors = SettingsErrors.get(clArgs);
        SettingsLog log = SettingsLog.get(clArgs);
        SettingsMode mode = SettingsMode.get(clArgs);
        SettingsNode node = SettingsNode.get(clArgs);
        SettingsSchema schema = SettingsSchema.get(clArgs, command);
        SettingsTransport transport = SettingsTransport.get(clArgs);
        SettingsGraph graph = SettingsGraph.get(clArgs, command);
        if (!clArgs.isEmpty()) {
            StressSettings.printHelp();
            System.out.println("Error processing command line arguments. The following were ignored:");
            for (Map.Entry<String, String[]> e : clArgs.entrySet()) {
                System.out.print(e.getKey());
                for (String v : e.getValue()) {
                    System.out.print(" ");
                    System.out.print(v);
                }
                System.out.println();
            }
            System.exit(1);
        }
        return new StressSettings(command, rate, generate, insert, columns, errors, log, mode, node, schema, transport, port, sendToDaemon, graph, tokenRange);
    }

    private static Map<String, String[]> parseMap(String[] args) {
        if (args.length == 0) {
            System.out.println("No command provided");
            StressSettings.printHelp();
            System.exit(1);
        }
        LinkedHashMap<String, String[]> r = new LinkedHashMap<String, String[]>();
        String key = null;
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0 || args[i].startsWith("-")) {
                if (i > 0) {
                    StressSettings.putParam(key, params.toArray(new String[0]), r);
                }
                key = args[i].toLowerCase();
                params.clear();
                continue;
            }
            params.add(args[i]);
        }
        StressSettings.putParam(key, params.toArray(new String[0]), r);
        return r;
    }

    private static void putParam(String key, String[] args, Map<String, String[]> clArgs) {
        String[] prev = clArgs.put(key, args);
        if (prev != null) {
            throw new IllegalArgumentException(key + " is defined multiple times. Each option/command can be specified at most once.");
        }
    }

    public static void printHelp() {
        SettingsMisc.printHelp();
    }

    public void printSettings(ResultLogger out) {
        out.println("******************** Stress Settings ********************");
        out.println("Command:");
        this.command.printSettings(out);
        out.println("Rate:");
        this.rate.printSettings(out);
        out.println("Population:");
        this.generate.printSettings(out);
        out.println("Insert:");
        this.insert.printSettings(out);
        if (this.command.type != Command.USER) {
            out.println("Columns:");
            this.columns.printSettings(out);
        }
        out.println("Errors:");
        this.errors.printSettings(out);
        out.println("Log:");
        this.log.printSettings(out);
        out.println("Mode:");
        this.mode.printSettings(out);
        out.println("Node:");
        this.node.printSettings(out);
        out.println("Schema:");
        this.schema.printSettings(out);
        out.println("Transport:");
        this.transport.printSettings(out);
        out.println("Port:");
        this.port.printSettings(out);
        out.println("Send To Daemon:");
        out.printf("  " + (this.sendToDaemon != null ? this.sendToDaemon : "*not set*") + "%n", new Object[0]);
        out.println("Graph:");
        this.graph.printSettings(out);
        out.println("TokenRange:");
        this.tokenRange.printSettings(out);
        if (this.command.type == Command.USER) {
            out.println();
            out.println("******************** Profile(s) ********************");
            ((SettingsCommandUser)this.command).profiles.forEach((k, v) -> v.printSettings(out, this));
        }
        out.println();
    }

    public synchronized void disconnect() {
        if (client == null) {
            return;
        }
        client.disconnect();
        client = null;
    }

    static {
        MAX_NUM_FAILURES = 10;
    }
}

