.\" auto generated by yuck -*- nroff -*-
.TH DATETEST "1" "August 2021" "dateutils 0.4.9" "User Commands"
.SH NAME
datetest - Like test(1) but for dates.
.SH SYNOPSIS
.B datetest
[\fIOPTION\fR]... 
DATE/TIME1 \fIOP \fIDATE/TIME2
.SH DESCRIPTION
Like test(1) but for dates.

.PP

Recognized \fIOPTION\fRs:
.TP
.B   \fB-h\fR, \fB--help
Print help and exit
.TP
.B   \fB-V\fR, \fB--version
Print version and exit
.TP
.B   \fB-q\fR, \fB--quiet
Suppress message about date/time and duration
parser errors.
.TP
.B   \fB-i\fR, \fB--input-format\fR=\fISTRING\fR...
Input format, can be used multiple times.
Each date/time will be passed to the input
format parsers in the order they are given, if a
date/time can be read successfully with a given
input format specifier string, that value will
be used.
.TP
.B   \fB-b\fR, \fB--base\fR=\fIDT
For underspecified input use DT as a fallback to
fill in missing fields.  Also used for ambiguous
format specifiers to position their range on the
absolute time line.
Must be a date/time in ISO8601 format.
If omitted defaults to the current date/time.
.TP
.B       \fB--from-locale\fR=\fILOCALE
Interpret dates on stdin or the command line as
coming from the locale LOCALE, this would only
affect month and weekday names as input formats
have to be specified explicitly.
.TP
.B       \fB--from-zone\fR=\fIZONE
Interpret dates on stdin or the command line as
coming from the time zone ZONE.
.TP
.B   \fB-e\fR, \fB--backslash-escapes
Enable interpretation of backslash escapes in the
output and input format specifier strings.
.TP
.B       \fB--eq
DATE/TIME1 is the same as DATE/TIME2
.TP
.B       \fB--ne
DATE/TIME1 is not the same as DATE/TIME2
.TP
.B       \fB--gt
DATE/TIME1 is newer than DATE/TIME2
.TP
.B       \fB--lt
DATE/TIME1 is older than DATE/TIME2
.TP
.B       \fB--ge
DATE/TIME1 is newer than or equals DATE/TIME2
.TP
.B       \fB--le
DATE/TIME1 is older than or equals DATE/TIME2
.TP
.B       \fB--nt
DATE/TIME1 is newer than DATE/TIME2
.TP
.B       \fB--ot
DATE/TIME1 is older than DATE/TIME2
.TP
.B       \fB--cmp
compare DATE/TIME1 to DATE/TIME2, return with 0 if
equal, 1 if left argument was newer and 2 if
right argument was newer
.TP
.B       \fB--isvalid
Return success if dates specified conform to
input format.
.SH FORMAT SPECS
.PP
Format specs in dateutils are similar to posix' strftime().
.PP
However, due to a broader range of supported calendars dateutils must
employ different rules.
.PP
Date specs:
.nf
  %a  The abbreviated weekday name
  %A  The full weekday name
  %_a The weekday name shortened to a single character (MTWRFAS)
  %b  The abbreviated month name
  %B  The full month name
  %_b The month name shortened to a single character (FGHJKMNQUVXZ)
  %c  The count of the weekday within the month (range 00 to 05)
  %C  The count of the weekday within the year (range 00 to 53)
  %d  The day of the month, 2 digits (range 00 to 31)
  %D  The day of the year, 3 digits (range 000 to 366)
  %F  Equivalent to %Y-%m-%d (ymd's canonical format)
  %g  ISO week date year without the century (range 00 to 99)
  %G  ISO week date year including the century
  %j  Equivalent to %D
  %m  The month in the current calendar (range 00 to 19)
  %Q  The quarter of the year (range Q1 to Q4)
  %q  The number of the quarter (range 01 to 04)
  %s  The number of seconds since the Epoch.
  %u  The weekday as number (range 01 to 07, Sunday being 07)
  %U  The week count,  day of week is Sun (range 00 to 53)
  %V  The ISO week count,  day of week is Mon (range 01 to 53)
  %w  The weekday as number (range 00 to 06, Sunday being 00)
  %W  The week count,  day of week is Mon (range 00 to 53)
  %y  The year without a century (range 00 to 99)
  %Y  The year including the century
  %_y The year shortened to a single digit
  %Z  The zone offset in hours and minutes (HH:MM) with
      a preceding sign (+ for offsets east of UTC, - for offsets
      west of UTC)
.fi
.PP
.nf
  %Od The day as roman numerals
  %Om The month as roman numerals
  %Oy The two digit year as roman numerals
  %OY The year including the century as roman numerals
.fi
.PP
.nf
  %rs In time systems whose Epoch is different from the unix Epoch, this
      selects the number of seconds since then.
  %rY In calendars with years that don't coincide with the Gregorian
      years, this selects the calendar's year.
.fi
.PP
.nf
  %dth  The day of the month as an ordinal number, 1st, 2nd, 3rd, etc.
  %mth  The month of the year as an ordinal number, 1st, 2nd, 3rd, etc.
.fi
.PP
.nf
  %db The business day of the month (since last month's ultimo)
  %dB Number of business days until this month's ultimo
.fi
.PP
Time specs:
.nf
  %H  The hour of the day using a 24h clock, 2 digits (range 00 to 23)
  %I  The hour of the day using a 12h clock, 2 digits (range 01 to 12)
  %M  The minute (range 00 to 59)
  %N  The nanoseconds (range 000000000 to 999999999)
  %p  The string AM or PM, noon is PM and midnight is AM.
  %P  Like %p but in lowercase
  %S  The  (range 00 to 60, 60 is for leap seconds)
  %T  Equivalent to %H:%M:%S
.fi
.PP
General specs:
.nf
  %n  A newline character
  %t  A tab character
  %%  A literal % character
.fi
.PP
Modifiers:
.nf
  %O  Modifier to turn decimal numbers into Roman numerals
  %r  Modifier to turn units into real units
  %0  Modifier to turn on zero prefixes
  %SPC  Modifier to turn on space prefixes
  %-  Modifier to turn off prefixes altogether
  th  Suffix, read and print ordinal numbers
  b   Suffix, treat days as business days
.fi
.PP
By design dates before 1601-01-01 are not supported.
.PP
For conformity here is a list of calendar designators and their
corresponding format string:
.nf
  ymd     %Y-%m-%d
  ymcw    %Y-%m-%c-%w
  ywd     %rY-W%V-%u
  bizda   %Y-%m-%db
  lilian     n/a
  ldn        n/a
  julian     n/a
  jdn        n/a
  matlab     n/a
  mdn        n/a
.fi
.PP
These designators can be used as output format string, moreover,
@code{lilian}/@code{ldn} and @code{julian}/@code{jdn} can also be used
as input format string.

.SH EXAMPLES
.PP
.nf
  $ datetest 2012-03-01 --gt 2012-03-02 || echo "false"
  false
  $
.fi
.PP
.nf
  $ datetest 2012-03-01 --ot 2012-03-02 && echo "true"
  true
  $
.fi
.PP
.nf
  $ datetest 2012-03-01 --cmp 2012-03-02; echo $?
  2
  $
.fi
.PP
.nf
  $ datetest 2012-03-02 --cmp 2012-03-02; echo $?
  0
  $
.fi
.PP
.nf
  $ datetest 2012-03-02 --cmp 2012-03-01; echo $?
  1
  $
.fi
.PP
.nf
  $ datetest 12:00:04 --gt 11:22:33 && echo "true"
  true
  $
.fi
.PP
.nf
  $ datetest 12:00:04 --lt 11:22:33 || echo "false"
  false
  $
.fi
.PP
.nf
  $ datetest 12:00:04 --cmp 11:22:33; echo "$@{?@}"
  1
  $
.fi
.PP
.nf
  $ datetest --cmp 11:22:33 12:00:04; echo "$@{?@}"
  2
  $
.fi
.PP
.nf
  $ datetest --ne 2012-03-02T00:00:00 2012-03-02 || echo 'false'
  false
  $
.fi
.PP
.nf
  $ datetest 2012-03-02T09:00:00 --ot 2012-03-02T10:00:00 && echo "true"
  true
  $
.fi
.PP
.nf
  $ datetest 2012-03-02T07:00:00 --cmp 2012-03-02T09:30:00; echo "$@{?@}"
  2
  $
.fi
.PP
.nf
  $ datetest --cmp 2012-03-02T12:00:00 2012-03-02T09:30:00; echo "$@{?@}"
  1
  $
.fi
.PP
.nf
  $ datetest 2012-03-02T07:00:00 --cmp 09:30:00; echo "$@{?@}"
  3
  $
.fi
.PP

.SH AUTHOR
Written by Sebastian Freundt <freundt@fresse.org>
.PP
.SH REPORTING BUGS
Report bugs to: https://github.com/hroptatyr/dateutils/issues
.PP



.SH "SEE ALSO"
The full documentation for
.B datetest
is maintained as a Texinfo manual.  If the
.B info
and
.B datetest
programs are properly installed at your site, the command
.IP
.B info (dateutils)datetest
.PP
should give you access to the complete manual.
.\" yuck.m4man ends here
