<!--gterm notebook command=python-->
**GraphTerm Notebook Example (Markdown cell)**

```python
xmax = raw_input("x-max: ")
t = arange(0.0, float(xmax), 0.01)
plot(t, sin(2*pi*t))
title("Sine Plot")
```

```output




x-max: 2



Out[8]: [<matplotlib.lines.Line2D at 0x104867b50>]


```

![image][output-fig1-SineWave.py]

```output
Out[9]: <matplotlib.text.Text at 0x10485dc50>


KeyboardInterrupt
>>>  python -i $GTERM_DIR/bin/
gpylab.py $GTERM_DIR/notebooks
/SineWave.ipynb
  File "<stdin>", line 1
    python -i $GTERM_DIR/bin/g
pylab.py $GTERM_DIR/notebooks/
SineWave.ipynb
    ^
IndentationError: unexpected i
ndent
```

[output-fig1-SineWave.py]: data:image/png;base64,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
