#line 2 "lex.l"
/* This file is part of Mailfromd.
   Copyright (C) 2005-2020 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#line 25 "lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */

/* %if-c-only */
/* %if-not-reentrant */

/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 0
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */
    
/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* %endif */

/* %if-c++-only */
/* %endif */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* %not-for-header */

/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)
/* %ok-for-header */

/* %if-reentrant */
/* %endif */

/* %if-not-reentrant */

/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

/* %if-not-reentrant */
extern yy_size_t yyleng;
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
extern FILE *yyin, *yyout;
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
/* %if-c-only */
	FILE *yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

/* %if-not-reentrant */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;
/* %ok-for-header */

/* %endif */

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

/* %endif */

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* %% [1.0] yytext/yyin/yyout/yy_state_type/yylineno etc. def's & init go here */
/* Begin user sect3 */

#define FLEX_DEBUG

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

/* %% [1.5] DFA */

/* %if-c-only Standard (non-C++) definition */

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
#if defined(__GNUC__) && __GNUC__ >= 3
__attribute__((__noreturn__))
#endif
static void yy_fatal_error (yyconst char msg[]  );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
/* %% [2.0] code to fiddle yytext and yyleng for yymore() goes here \ */\
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
/* %% [3.0] code to copy yytext_ptr to yytext[] goes here, if %array \ */\
	(yy_c_buf_p) = yy_cp;

/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 152
#define YY_END_OF_BUFFER 153
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[986] =
    {   0,
        0,    0,    2,    2,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  153,  151,
      135,  136,  151,  151,   16,  151,  151,  143,  151,  151,
      151,  103,  103,  139,  137,  141,  105,  151,  145,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  144,  146,  135,
       16,    2,    4,    3,    2,    2,  152,  152,  117,  131,
      131,  152,  150,  133,  131,  131,  150,  152,  134,  152,
      150,  127,   20,   18,   19,   20,   17,  152,    8,  152,
      105,  105,  105,  135,   16,  135,  138,    0,  107,  109,

      109,   16,   15,   90,   94,   92,   95,    0,    0,    0,
        0,  106,    0,    1,  102,    0,  103,  147,  140,  137,
      142,  148,  105,   99,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,   34,  105,  105,
      105,   30,  105,  105,  105,  105,   29,  105,  105,  105,
      105,  105,  105,  105,  105,   33,   41,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  135,
        0,   16,   16,   16,   16,   16,   16,   16,    2,    3,
        3,    5,    2,    2,    2,    2,    0,  117,  118,  118,
       91,  130,   93,   96,    0,   88,   88,    0,  124,  116,

      124,  100,  124,    0,  133,  128,  132,    0,  134,  129,
        0,  127,   18,   17,    0,    8,    0,   83,  105,  105,
      135,    0,   16,  109,  115,  108,  115,  115,   92,   95,
        0,    0,    0,  149,  102,  101,    0,    0,    0,    0,
       99,  105,  105,  105,  105,  105,  105,  105,  105,  105,
       26,  105,   42,  105,  105,   78,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,   68,  105,   64,
      105,  105,  105,  105,  105,  105,    0,  105,   43,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  104,   46,
      105,  105,  105,  105,  105,   48,  105,  105,  105,    0,

        0,    0,    0,    0,    0,   16,   16,   16,   16,   16,
       16,   16,   16,    2,  116,   93,   96,    0,   88,   88,
        0,    0,  123,  122,  100,    0,    0,    7,  105,  105,
        0,  108,  114,  113,    0,    0,   97,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  101,    0,    0,    0,
        0,  125,    0,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,   54,
      105,  105,  105,  105,  105,  105,  105,   35,   49,   32,
       31,  105,   74,   52,  105,   62,  105,  105,    0,    0,
        0,   44,  105,   66,  105,   45,  105,  105,  105,  105,

      105,  105,  105,  105,  105,  105,  105,   40,  105,    0,
        0,    0,    0,    0,    0,   16,    6,   16,   16,   16,
       16,   16,    2,    0,   98,   88,   88,   88,   88,   88,
       88,   88,   88,    0,   89,    0,  121,  122,  120,   82,
       81,  112,  113,  111,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
       69,   67,   65,   47,   60,  105,   79,  105,  105,  105,
      105,  105,  105,  105,    0,    0,  105,  105,  105,  105,

      105,  105,  105,  105,  105,  105,  105,   61,   70,   63,
        0,    0,    0,    0,    0,   16,   16,   16,   16,   16,
       16,    2,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,    0,    0,    0,    0,    0,    0,
        0,    0,  122,  119,  113,  110,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  126,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,   21,  105,  105,
       28,  105,  105,   73,  105,   77,    0,    0,   59,  105,

       76,   22,  105,  105,   50,   75,   58,   53,  105,    0,
        0,    0,    0,    0,    0,   16,    9,   16,   16,   16,
       16,   16,    2,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  105,  105,   80,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,   55,   25,  105,
       36,    0,    0,    0,   57,  105,   27,   72,   51,    0,

       56,  105,    0,    9,    0,    0,    0,    0,    0,   16,
       16,   16,   10,   16,    2,   10,    0,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   84,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   80,  105,
      105,  105,  105,  105,  105,  105,  105,  105,   24,  105,
        0,    0,   71,   23,    0,    0,    0,   16,   12,   16,
       16,   88,   88,   85,   88,   88,   88,   88,   88,   88,

       88,   88,   88,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   84,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  105,  105,
      105,  105,  105,  105,   37,    0,    0,    0,   12,    0,
        0,   16,   16,   16,   11,   85,   88,   88,   88,   88,
       88,   88,   88,   88,   88,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   86,    0,    0,    0,    0,
        0,    0,    0,    0,  105,  105,  105,  105,  105,    0,

       38,    0,    0,    0,   11,   16,   14,   16,   88,   88,
       88,   88,   88,   88,    0,    0,   87,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  105,  105,    0,    0,
       14,    0,   16,   88,   88,   88,   88,   88,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   39,    0,   16,   88,   88,    0,    0,    0,    0,
        0,    0,    0,    0,   16,    0,    0,    0,   16,    0,
       16,   13,    0,   13,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    8,    9,   10,   11,   12,
        1,   13,    1,    1,   14,   15,   16,   17,   18,   18,
       18,   18,   18,   18,   18,   19,   19,    1,    1,   20,
       21,   22,    1,    1,   23,   23,   23,   23,   23,   23,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       24,   24,   24,   24,   24,   24,   24,   25,   24,   24,
        1,   26,    1,   27,   28,    1,   29,   30,   31,   32,

       33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
       43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
       53,   24,   54,   55,   56,   57,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst YY_CHAR yy_meta[58] =
    {   0,
        1,    1,    2,    1,    1,    1,    3,    4,    5,    1,
        6,    7,    8,    9,    1,    1,   10,   11,   11,    1,
        1,    1,   12,   13,   13,   14,    1,   13,   12,   12,
       12,   12,   12,   12,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   15,    1,   16,    1
    } ;

static yyconst flex_uint16_t yy_base[1045] =
    {   0,
        0,   56,   56,   63,   65,   69,   76,   78,   80,   89,
     2203, 2202,  115,    0, 2201,   59,   64,  171, 2203, 2207,
       92, 2207, 2181,  168, 2198,  172,  152, 2207, 2189, 2184,
     2185,  164,   92,   92, 2176,  164,    0,  174, 2207, 2168,
      170,  150,  166,  180,   59,  182,   73, 2152,  175,  165,
      187,  191, 2161,  188,  199, 2164, 2156, 2207, 2207,  239,
      245,    0, 2207,  238,  251,  240,  251, 2207, 2207,  254,
      243,  273,  278, 2182,  276,  247,  248,  290, 2207,  251,
     2187, 2207, 2207,  101, 2207, 2176,    0, 2185, 2207,  227,
      275, 2144,  280,  317,  329,  195, 2207,  329, 2207, 2207,

      293, 2183, 2207, 2207, 2207,  294,    0,    0, 2157, 2156,
     2172, 2207, 2167, 2207,  310,    0,  322,  332, 2207, 2207,
     2207, 2207,    0,  332,  335, 2150, 2148, 2142, 2146, 2142,
     2143, 2142,  305, 2132, 2133,  280, 2125, 2129, 2134,  307,
     2137,    0, 2127, 2121, 2123, 2123,    0, 2120, 2120, 2114,
     2129,  355, 2108, 2111, 2117,    0,    0, 2110,  328, 2126,
      336,  190,  159, 2118, 2113, 2107, 2099, 2107,  323,  361,
      384,  427,  374,  389,  369,  276,  299,  380,    0,  381,
      382, 2207,  397,  385,  407, 2113,  410, 2207, 2207, 2146,
     2207, 2207,  395,    0,    0,    0, 2120, 2119,  414,  424,

      426,  420,  433,  446, 2137, 2207, 2207,  448, 2207, 2207,
     2142, 2207,  459,    0, 2141, 2207,  466,    0, 2096, 2102,
      471,  475,  478, 2138,  457,  476,  481,  478,  499,    0,
     2084,  489, 2111, 2207,  474,    0,    0,  499,  539,  586,
      509, 2105,  439, 2100, 2099,  477,  259, 2087, 2101, 2100,
        0, 2103,    0, 2094, 2101,    0, 2096, 2097,  453, 2094,
     2097, 2092, 2093, 2090, 2079, 2087, 2087,    0, 2090,    0,
     2077, 2086, 2073, 2071, 2083, 2064,  597, 2064,    0, 2081,
     2063, 2078, 2073, 2067, 2073, 2065, 2055, 2054,    0,    0,
     2054, 2064, 2052, 2055, 2055,    0, 2049, 2054, 2055,  600,

      603, 2048, 2051, 2055, 2045,  595, 2087,  611,  606,  402,
      506,  492,  424, 2047, 2207,  609,    0, 2032,    0,  607,
     2031,  578, 2207,  641,  643,    0,  661, 2207, 2038, 2045,
      651, 2207, 2207,  663,    0, 2028, 2207, 2050,  619, 2045,
     2044,  648,  600, 2032, 2046,  658,    0, 2067,  668, 2074,
      671, 2207,    0, 2042, 2035, 2032, 2025, 2030, 2033, 2028,
     2037,  604, 2035, 2038, 2020, 2021, 2017, 2021, 2023,    0,
     2025, 2012, 2022, 2006, 2008, 2008, 2026,    0,    0,    0,
        0, 2006,    0,    0, 2007,    0, 2016, 2011,  699, 2008,
     2020,    0, 2015,    0, 2010,    0, 2009, 2014, 2015, 2006,

     1996, 2004, 1998, 2008, 2004, 1986, 1990,    0, 2002,  705,
      702, 1988, 2002, 1990, 2002, 2027, 2207,  529,  600,  673,
      633,  361, 1996, 1972, 2207, 1994,  663, 1989, 1988,  681,
      668, 1976, 1990, 1966, 2207,  709, 2207,  708,  719,    0,
        0, 2207,  721,  728, 1987, 1980, 1977, 1970, 1975, 1978,
     1973, 1982,  684, 1980, 1983, 1965, 1977,  686, 1972, 1971,
      723,  702, 1959, 1973,  759, 1994,  639, 1971, 1972, 1974,
     1968, 1957, 1956, 1949, 1958, 1965, 1951, 1946, 1946, 1944,
        0,    0,    0,    0,    0, 1949,    0, 1950, 1956, 1942,
     1956, 1938, 1952, 1951, 1942, 1934, 1935, 1937, 1948, 1930,

     1946, 1930, 1933, 1943, 1938, 1936, 1942,    0,    0,    0,
     1964, 1926, 1928, 1934, 1931,  752,  761,  459,  629,  766,
      417,  769, 1931, 1924, 1921, 1914, 1919, 1922, 1917, 1926,
      726, 1924, 1927, 1909,  739,  738,  740,  741,  747,  752,
      732,  746,  774, 2207,  783, 2207,  742, 1921, 1922, 1924,
     1918, 1907, 1906, 1899, 1908, 1915, 1901, 1896, 1896, 1908,
     1901, 1898, 1891, 1896, 1899, 1894, 1903,  762, 1901, 1904,
     1886, 1928,  802, 2207, 1884, 1901, 1880, 1899, 1898, 1879,
     1878, 1883, 1893, 1885, 1874, 1886, 1881,    0, 1868, 1868,
        0, 1883, 1878,    0, 1866,    0, 1883, 1880,  809, 1861,

        0,    0, 1876, 1875, 1860,    0,  810,    0, 1869, 1899,
      812, 1858, 1854,  797, 1861,  813, 2207,  814,  821,  613,
     1898,  693,  397,  782, 1867, 1868, 1870, 1864, 1853, 1852,
     1845, 1854, 1861, 1847, 1842, 1842,  751,  787,  786,  782,
      789,  794,  791,  802,  804,  803,  808,  793, 1842, 1859,
     1838, 1857, 1856, 1837, 1836, 1841, 1851, 1843, 1832, 1844,
     1839,  797, 1842, 1843, 1845, 1839, 1828, 1827, 1820, 1829,
     1836, 1822, 1817, 1817, 1835, 1825,    0, 1833, 1832, 1831,
     1825, 1822, 1828, 1812, 1822, 1810, 1819,    0,    0, 1818,
        0, 1802, 1813,  844, 2207, 1801,    0,    0,    0,  849,

     2207, 1807,  851, 2207,  859,  864, 1814, 1842, 1815, 1840,
      837, 1839, 2207,  869,  864, 2207, 1838, 1794, 1811, 1790,
     1809, 1808, 1789, 1788, 1793, 1803, 1795, 1784, 1796, 1791,
      831,  830,  824,  841,  843,  836,  838,  482,  835,  851,
      839,  837,  695, 1799, 1789, 2207, 1797, 1796, 1795, 1789,
     1786, 1792, 1776, 1786, 1774, 1770, 1787, 1766, 1785, 1784,
     1765, 1764, 1769, 1779, 1771, 1760, 1772, 1767,    0, 1760,
     1774, 1773, 1772, 1766, 1770, 1766, 1759, 1753,    0, 1747,
     1762, 1759,    0,    0, 1788, 1757,  886, 1786, 2207,  898,
     1785, 1759, 1749,    0, 1757, 1756, 1755, 1749, 1746, 1752,

     1736, 1746, 1734,  850,  856,  855,  861,  876,  852,  859,
      869,  881,  877,  868,  883,  882, 2207, 1733, 1747, 1746,
     1745, 1739, 1743, 1739, 1732, 1726, 1739, 1729, 1487, 1461,
     1460, 1459, 1445, 1442, 1443, 1427, 1413, 1401, 1396, 1406,
     1405, 1404, 1385, 1399,    0, 1387, 1375, 1418, 2207,  916,
     1417, 1403,  918, 1402, 2207,    0, 1360, 1374, 1360, 1264,
     1256, 1260, 1256, 1249, 1243,  894,  886, 1228,  899,  900,
      901,  897,   26,  903,  891,  904,  892, 1239, 1249, 1248,
     1247, 1228, 1245, 1216, 1212, 2207, 1211, 1201, 1195, 1170,
     1172, 1165, 1158, 1152, 1164, 1163, 1162, 1130, 1031, 1025,

     2207, 1054, 1008, 1043, 2207, 1038, 2207,  937,  232,  314,
      602,  659,  700,  913,  887,  902, 2207,  918,  921,  924,
      929,  926,  920,  927,  925,  935,  937,  938,  940,  941,
      928,  943,  944,  945,  929,  950,  956,  958,  940,  985,
     2207,  947,  987,  963,  964,  965,  966,  967,  954,  969,
      970,  971,  955,  972,  974,  975,  976,  977,  978,  979,
      980, 2207,  978, 1009,  985,  986,  987,  988,  989,  991,
      992,  993,  994,  990, 1027,  996, 1004, 1031, 1031, 1033,
     1034, 2207, 1035, 2207, 2207, 1060, 1076, 1092, 1108, 1124,
     1140, 1156, 1172, 1186, 1201, 1208, 1221, 1237, 1253, 1267,

     1278, 1293, 1309, 1325, 1341, 1348, 1361, 1377, 1384, 1027,
     1388, 1395, 1400, 1037, 1404, 1041, 1414, 1425, 1430, 1437,
     1043, 1449, 1456, 1463, 1470, 1473, 1480, 1493, 1509, 1525,
     1541, 1557, 1573, 1589, 1605, 1621, 1637, 1653, 1669, 1685,
     1701, 1717, 1733, 1749
    } ;

static yyconst flex_int16_t yy_def[1045] =
    {   0,
      985,    1,  986,  986,  987,  987,  988,  988,  989,  989,
      990,  990,  985,   13,  991,  991,    1,    1,  985,  985,
      985,  985,  985,  992,  993,  994,  985,  985,  995,  985,
      985,  985,  985,  985,  985,  985,  996,  985,  985,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  985,  985,  985,
      993,  997,  985,  998,  997,  997,  999,  985,  985, 1000,
     1001, 1002, 1003,  985, 1000, 1001, 1002, 1004,  985, 1002,
     1005,  985,  985,  985,  985,  985, 1006, 1007,  985, 1007,
      996,  996,  996,  985,  993,  985,  985,  992,  985,  985,

     1008,  993,  985,  985,  985,  985, 1009, 1010,  985,  985,
      995,  985,  985,  985,  985, 1011,  985, 1012,  985,  985,
      985,  985,  996,  985,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  985,
      985,  993,  993,  993,  993,  993,  993,  993,  997,  998,
      998,  985,  997,  997,  997,  997,  999,  985,  985,  985,
      985,  985,  985, 1013, 1014, 1015, 1015, 1016,  985,  985,

      985,  985, 1017, 1003,  985,  985,  985, 1004,  985,  985,
     1005,  985,  985, 1006, 1007,  985, 1007,  996,  996,  996,
      985,  985,  993,  985,  985,  985,  985, 1018,  985, 1009,
     1019,  985,  985,  985,  985, 1020, 1021, 1012,  985, 1012,
      985,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  985,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  985,

      985,  985,  985,  985,  985,  993, 1022,  993,  993,  993,
      993,  993,  993,  997,  985,  985, 1013, 1023, 1015, 1015,
     1024, 1024,  985,  985,  985, 1025, 1007,  985,  996,  996,
      985,  985,  985,  985, 1026, 1019,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985, 1020, 1027, 1012, 1028,
     1028,  985,  239,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  985,  985,
      985,  996,  996,  996,  996,  996,  996,  996,  996,  996,

      996,  996,  996,  996,  996,  996,  996,  996,  996,  985,
      985,  985,  985,  985,  985, 1022,  985, 1029,  993,  993,
      993,  993,  997, 1023,  985, 1015, 1015, 1015, 1015, 1015,
     1015, 1015, 1015, 1024,  985, 1024,  985,  985,  985,  996,
      996,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985, 1030, 1027,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  985,  985,  996,  996,  996,  996,

      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
     1031,  985,  985,  985,  985, 1029, 1032,  993,  993,  993,
      993,  997, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
     1015, 1015, 1015, 1015, 1024, 1024, 1024, 1024, 1024, 1024,
     1024, 1024,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985, 1030, 1030,  985,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  985,  985,  996,  996,

      996,  996,  996,  996,  996,  996,  996,  996,  996, 1031,
     1033,  985,  985,  985,  985, 1032,  985, 1032,  993,  993,
     1034,  993, 1035, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
     1015, 1015, 1015, 1015, 1015, 1015, 1024, 1024, 1024, 1024,
     1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  996,  996,  996,  996,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      996,  985,  985,  985,  985,  996,  996,  996,  996,  985,

      985,  996, 1033,  985, 1033,  985,  985, 1036,  985, 1037,
      993, 1034,  985,  993, 1035,  985, 1036, 1015, 1015, 1015,
     1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
     1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
     1024, 1024, 1024,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  996,  996,
      996,  996,  996,  996,  996,  996,  996,  996,  996,  996,
      985,  985,  996,  996, 1038,  985,  985, 1037,  985,  993,
     1039, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,

     1015, 1015, 1015, 1024, 1024, 1024, 1024, 1024, 1024, 1024,
     1024, 1024, 1024, 1024, 1024, 1024,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  996,  996,
      996,  996,  996,  996,  996,  985,  985, 1038,  985,  985,
     1040, 1041,  993, 1039,  985, 1015, 1015, 1015, 1015, 1015,
     1015, 1015, 1015, 1015, 1015, 1024, 1024, 1024, 1024, 1024,
     1024, 1024, 1024, 1024, 1024, 1024, 1024,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  996,  996,  996,  996,  996,  985,

      985, 1042,  985, 1040,  985, 1041,  985,  993, 1015, 1015,
     1015, 1015, 1015, 1015, 1024, 1024,  985, 1024, 1024, 1024,
     1024, 1024, 1024, 1024, 1024,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  996,  996,  985, 1042,
      985,  985,  993, 1015, 1015, 1015, 1015, 1015, 1024, 1024,
     1024, 1024, 1024, 1024,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  993, 1015, 1015, 1024, 1024, 1024, 1024,
     1024,  985,  985,  985,  993, 1024, 1024,  985, 1043, 1044,
     1043,  985, 1044,  985,    0,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,

      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985
    } ;

static yyconst flex_uint16_t yy_nxt[2265] =
    {   0,
       20,   21,   22,   21,   23,   24,   25,   26,   27,   28,
       29,   20,   20,   20,   30,   31,   32,   33,   33,   34,
       35,   36,   37,   37,   37,   38,   39,   40,   41,   42,
       43,   44,   45,   46,   37,   37,   47,   37,   37,   48,
       49,   50,   51,   52,   37,   53,   54,   55,   37,   56,
       57,   37,   37,   20,   58,   20,   59,   60,   63,   60,
      921,   89,   61,   90,   65,   63,   65,   68,   64,   66,
       69,   68,   70,   71,   69,   64,   70,   71,   74,   20,
       74,  435,   79,   75,   76,   75,   76,   70,   71,  139,
       72,   79,   91,   96,   72,   96,   70,   71,  140,   92,

      141,   77,  213,   77,  213,   80,  147,   93,  117,  117,
      117,  118,  119,  148,   80,   83,   84,   85,   84,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       86,   83,   83,   83,   83,   83,   83,   87,   87,   87,
       83,   83,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   83,   83,
       83,   83,   94,   99,   94,  100,  100,   95,  104,  109,
      115,  115,  130,  105,  121,  122,   20,  291,  116,  106,
      106,  124,  124,  101,  133,  131,   96,  153,   96,   91,

      126,  127,  132,  150,  292,  110,   92,  154,  134,  128,
      135,  129,  136,  155,   93,  116,  137,  151,  142,  158,
      162,  289,  138,  143,  144,  108,  152,  145,  156,  216,
      146,  165,  157,  217,  166,  163,  159,  290,  164,  160,
      170,  185,  170,  185,  167,  171,  172,  103,  172,  173,
      181,  192,  183,  182,  183,  985,  188,  184,  189,  189,
      191,  192,  174,  174,  201,  202,  202,  201,  202,  202,
      197,  193,  193,  944,  197,  200,  190,  175,  103,  186,
      205,  176,  191,  985,  177,  206,  206,  362,  178,  201,
      202,  202,  209,  193,  193,  226,  198,  210,  210,  203,

      198,  103,  203,  206,  363,  126,  127,  195,  158,  227,
      229,  229,  229,  261,  128,  210,  129,  311,  221,  262,
      221,  218,  220,  222,  203,  159,  235,  235,  160,  195,
      223,  103,  223,  173,   99,  312,  100,  100,  117,  117,
      117,  856,  237,  266,  228,  238,  174,  174,  241,  241,
      241,  257,  258,  267,  224,  298,  277,  240,  277,  299,
      282,  175,  170,  103,  170,  176,  242,  171,  243,  244,
      283,  103,  178,  285,  245,  246,  103,  306,  247,  286,
      287,  248,  103,  288,  249,  300,  185,  300,  185,  307,
      308,  103,  308,  985,  181,  521,  985,  182,  183,  716,

      183,  301,  301,  184,  103,  309,  309,  309,  185,  717,
      185,  316,  316,  316,  310,  188,  302,  189,  189,  103,
      303,  323,  323,  304,  186,  313,  103,  305,  172,  103,
      172,  323,  323,  323,  323,  190,  325,  325,  325,  323,
      323,  323,  324,  324,  174,  174,  186,  419,  205,  323,
      209,  323,  422,  206,  206,  210,  210,  622,  323,  175,
      213,  103,  213,  176,  333,  333,  177,  327,  328,  327,
      178,  206,  221,  210,  221,  355,  331,  222,  331,  223,
      103,  223,  333,  333,  333,  333,  333,  356,  333,  333,
      235,  235,  301,  301,  103,  174,  174,  334,  334,  372,

      373,  333,  349,  333,  619,  359,  333,  302,  103,  237,
      175,  303,  985,  360,  176,  229,  229,  229,  305,  361,
      338,  178,  339,  340,  240,  241,  241,  241,  341,  342,
      811,  103,  343,  421,  517,  344,  420,  435,  345,  350,
      351,  352,  351,  350,  350,  350,  350,  350,  350,  350,
      350,  350,  350,  350,  350,  353,  353,  353,  350,  350,
      350,  353,  353,  353,  350,  350,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  350,  350,  350,  350,  985,  103,  389,  985,

      389,  300,  103,  300,  410,  436,  410,  308,  103,  308,
      307,  985,  308,  103,  308,  103,  418,  301,  301,  411,
      411,  411,  309,  309,  309,  316,  316,  316,  453,  945,
      390,  103,  302,  435,  475,  103,  303,  391,  426,  304,
      427,  428,  518,  305,  711,  454,  429,  430,  437,  437,
      431,  476,  331,  432,  331,  446,  433,  438,  438,  325,
      325,  325,  327,  328,  327,  520,  437,  447,  301,  301,
      442,  442,  351,  352,  351,  103,  450,  620,  237,  443,
      443,  985,  575,  302,  451,  248,  946,  303,  442,  457,
      452,  458,  459,  240,  305,  103,  531,  460,  461,  524,

      389,  462,  389,  410,  463,  410,  410,  464,  410,  528,
      511,  525,  519,  532,  555,  437,  437,  529,  411,  411,
      411,  714,  561,  530,  543,  543,  544,  544,  442,  442,
      568,  556,  390,  437,  562,  546,  546,  545,  545,  391,
      535,  816,  536,  537,  544,  947,  442,  569,  538,  539,
      435,  565,  540,  546,  103,  541,  632,  517,  542,  566,
      573,  574,  573,  617,  435,  567,  618,  621,  103,  621,
      623,  637,  623,  633,  638,  642,  640,  641,  648,  647,
      645,  437,  437,  643,  731,  649,  639,  435,  344,  644,
      442,  442,  670,  435,  435,  435,  435,  646,  708,  437,

      708,  435,  435,  573,  574,  573,  435,  435,  442,  671,
      694,  700,  694,  700,  704,  617,  617,  705,  618,  618,
      695,  701,  710,  103,  710,  718,  732,  733,  432,  734,
      735,  736,  737,  738,  739,  741,  742,  435,  743,  103,
      756,  435,  435,  463,  435,  694,  435,  694,  435,  435,
      700,  740,  700,  704,  806,  695,  705,  435,  435,  435,
      701,  704,  805,  435,  705,  785,  716,  785,  807,  790,
      791,  103,  791,  812,  804,  808,  717,  541,  809,  435,
      810,  813,  814,  866,  815,  435,  435,  851,  868,  851,
      435,  435,  435,  435,  435,  646,  435,  870,  435,  852,

      103,  852,  867,  869,  871,  435,  435,  435,  872,  873,
      435,  435,  874,  875,  435,  876,  435,  902,  877,  902,
      103,  915,  916,  435,  435,  853,  915,  918,  919,  920,
      922,  435,  435,  923,  925,  924,  435,  435,  435,  103,
      948,  435,  917,  903,  949,  868,  435,  435,  868,  435,
      952,  950,  435,  868,  435,  435,  435,  435,  435,  435,
      908,  951,  955,  953,  746,  817,  954,  956,  746,  957,
      884,  958,  959,  435,  960,  435,  435,  961,  943,  435,
      435,  435,  435,  769,  435,  769,  962,  941,  963,  103,
      965,  794,  856,  966,  794,  967,  915,  968,  969,  971,

      970,  817,  817,  972,  829,  884,  973,  829,  974,  435,
      435,  103,  856,  856,  976,  868,  915,  964,  977,  868,
      884,  884,  978,  915,  435,  435,  435,  435,  979,  103,
      979,  915,  980,  982,  980,  984,  982,  984,  231,  231,
      907,  975,  435,  435,  435,  905,  435,  435,  318,  318,
      942,  435,  321,  321,  348,  348,  941,  939,  677,  435,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   73,   73,   73,   73,   73,   73,   73,   73,

       73,   73,   73,   73,   73,   73,   73,   73,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   98,  938,   98,   98,
       98,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   98,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  102,  102,  102,  107,  769,
      677,  937,  107,  936,  935,  934,  107,  107,  107,  829,

      107,  111,  933,  111,  111,  111,  111,  111,  111,  111,
      111,  111,  111,  111,  111,  111,  111,  123,  123,  123,
      123,  179,  932,  179,  179,  179,  179,  179,  829,  179,
      179,  179,  179,  179,  179,  179,  179,  180,  829,  180,
      180,  180,  180,  180,  180,  180,  180,  180,  180,  180,
      180,  180,  180,  187,  931,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  194,
      194,  886,  930,  929,  928,  927,  817,  194,  194,  194,
      926,  194,  196,  917,  914,  913,  912,  794,  911,  196,
      196,  910,  196,  199,  199,  199,  199,  199,  199,  199,

      199,  199,  199,  199,  199,  199,  199,  199,  199,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  208,  208,  208,  208,  208,
      208,  208,  208,  208,  208,  208,  208,  208,  208,  208,
      208,  211,  211,  211,  211,  211,  211,  211,  211,  211,
      211,  211,  211,  211,  211,  211,  211,  214,  214,  214,
      214,  215,  215,  215,  215,  215,  215,  215,  215,  215,
      215,  215,  215,  215,  215,  215,  215,  225,  225,  225,
      225,  225,  225,  225,  225,  225,  225,  794,  225,  225,
      225,  225,  225,  230,  230,  230,  230,  236,  236,  236,

      239,  794,  909,  239,  855,  907,  239,  239,  239,  317,
      317,  317,  317,  319,  319,  319,  319,  326,  326,  905,
      849,  901,  900,  326,  326,  326,  899,  326,  335,  335,
      898,  897,  896,  769,  335,  335,  335,  895,  335,  336,
      336,  336,  336,  894,  893,  336,  347,  347,  347,  416,
      416,  416,  416,  416,  416,  416,  416,  416,  416,  416,
      416,  416,  416,  416,  416,  424,  424,  424,  424,  892,
      891,  424,  434,  434,  434,  434,  890,  889,  434,  439,
      439,  439,  444,  444,  444,  466,  888,  887,  884,  466,
      466,  466,  466,  350,  350,  350,  350,  350,  350,  350,

      350,  350,  350,  350,  350,  350,  350,  350,  350,  516,
      516,  516,  516,  516,  516,  516,  516,  516,  516,  516,
      516,  516,  516,  516,  516,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  610,  886,  610,  610,  610,  610,  610,  610,  610,
      610,  610,  610,  610,  610,  610,  610,  616,  616,  616,
      616,  616,  616,  616,  616,  616,  616,  616,  616,  616,
      616,  616,  616,  703,  703,  703,  703,  703,  703,  703,
      703,  703,  703,  703,  703,  703,  703,  703,  703,  712,
      712,  712,  712,  712,  712,  712,  712,  712,  712,  712,

      712,  712,  712,  712,  712,  715,  715,  715,  715,  715,
      715,  715,  715,  715,  715,  715,  715,  715,  715,  715,
      715,  717,  717,  717,  717,  717,  717,  717,  717,  717,
      717,  717,  717,  717,  717,  717,  717,  788,  788,  788,
      788,  788,  788,  788,  788,  788,  788,  788,  788,  788,
      788,  788,  788,  848,  848,  848,  848,  848,  848,  848,
      848,  848,  848,  848,  848,  848,  848,  848,  848,  854,
      854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
      854,  854,  854,  854,  854,  904,  904,  904,  904,  904,
      904,  904,  904,  904,  904,  904,  904,  904,  904,  904,

      904,  906,  906,  906,  906,  906,  906,  906,  906,  906,
      906,  906,  906,  906,  906,  906,  906,  940,  940,  940,
      940,  940,  940,  940,  940,  940,  940,  940,  940,  940,
      940,  940,  940,  981,  981,  981,  981,  981,  981,  981,
      981,  981,  981,  981,  981,  981,  981,  981,  981,  983,
      983,  983,  983,  983,  983,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  983,  885,  884,  883,  882,  881,
      746,  880,  879,  746,  746,  878,  865,  864,  863,  862,
      861,  860,  859,  858,  856,  857,  856,  855,  789,  850,
      849,  847,  846,  845,  844,  843,  842,  677,  841,  840,

      677,  677,  839,  838,  837,  836,  835,  834,  833,  832,
      831,  830,  829,  828,  827,  569,  826,  825,  824,  823,
      822,  821,  820,  819,  817,  818,  817,  803,  802,  801,
      800,  799,  798,  797,  796,  795,  794,  793,  792,  532,
      716,  713,  789,  787,  716,  786,  784,  783,  782,  781,
      780,  779,  778,  777,  776,  775,  774,  773,  772,  771,
      769,  770,  769,  768,  767,  766,  765,  764,  763,  762,
      761,  760,  759,  758,  757,  755,  754,  753,  752,  751,
      750,  749,  748,  747,  746,  745,  744,  454,  730,  729,
      728,  727,  726,  725,  724,  723,  722,  721,  720,  719,

      713,  709,  707,  706,  611,  702,  699,  698,  697,  696,
      693,  692,  691,  690,  689,  688,  687,  686,  685,  684,
      683,  682,  681,  680,  679,  678,  677,  676,  675,  363,
      574,  674,  673,  672,  669,  668,  667,  666,  665,  664,
      663,  662,  661,  660,  659,  658,  657,  656,  655,  654,
      653,  652,  651,  650,  636,  635,  634,  631,  630,  629,
      628,  627,  626,  625,  624,  615,  614,  613,  612,  611,
      609,  608,  607,  606,  605,  604,  603,  602,  601,  600,
      599,  598,  597,  596,  595,  594,  593,  592,  591,  590,
      589,  588,  587,  586,  585,  584,  583,  582,  581,  580,

      579,  578,  577,  576,  465,  571,  570,  564,  563,  560,
      559,  558,  557,  554,  553,  552,  551,  550,  549,  548,
      547,  435,  534,  533,  527,  526,  523,  425,  522,  417,
      515,  514,  513,  512,  510,  509,  508,  507,  506,  505,
      504,  503,  502,  501,  500,  499,  498,  497,  496,  495,
      494,  493,  492,  491,  490,  489,  488,  487,  486,  485,
      484,  483,  482,  481,  480,  479,  478,  477,  474,  473,
      472,  471,  470,  469,  468,  467,  352,  465,  456,  455,
      449,  448,  445,  337,  441,  440,  435,  425,  423,  417,
      415,  414,  413,  412,  409,  408,  407,  406,  405,  404,

      403,  402,  401,  400,  399,  398,  397,  396,  395,  394,
      393,  392,  388,  387,  386,  385,  384,  383,  382,  381,
      380,  379,  378,  377,  376,  375,  374,  371,  370,  369,
      368,  367,  366,  365,  364,  358,  357,  354,  346,  337,
      332,  330,  329,  216,  212,  207,  322,  320,  315,  314,
      297,  296,  295,  294,  293,  284,  281,  280,  279,  278,
      276,  275,  274,  273,  272,  271,  270,  269,  268,  265,
      264,  263,  260,  259,  256,  255,  254,  253,  252,  251,
      250,  234,  112,  233,  232,  103,  219,  216,  114,  212,
      207,  169,  168,  161,  149,  125,  120,  114,  113,  112,

      103,   97,  985,   89,   82,   82,   19,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985
    } ;

static yyconst flex_int16_t yy_chk[2265] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    2,    3,    2,
      873,   16,    2,   16,    4,    4,    4,    5,    3,    4,
        5,    6,    5,    5,    6,    4,    6,    6,    7,   17,
        8,  873,    9,    7,    7,    8,    8,    9,    9,   45,
        5,   10,   17,   21,    6,   21,   10,   10,   45,   17,

       45,    7,   84,    8,   84,    9,   47,   17,   33,   33,
       33,   34,   34,   47,   10,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   18,   24,   18,   24,   24,   18,   26,   27,
       32,   32,   42,   26,   36,   36,   18,  163,   32,   26,
       26,   38,   38,   24,   43,   42,   96,   50,   96,   18,

       41,   41,   42,   49,  163,   27,   18,   50,   43,   41,
       44,   41,   44,   50,   18,   32,   44,   49,   46,   52,
       54,  162,   44,   46,   46,   26,   49,   46,   51,   90,
       46,   55,   51,   90,   55,   54,   52,  162,   54,   52,
       60,   66,   60,   66,   55,   60,   61,   61,   61,   61,
       64,   71,   65,   64,   65,   76,   67,   65,   67,   67,
       70,   70,   61,   61,   77,   77,   77,   80,   80,   80,
       71,   70,   70,  909,   76,   72,   67,   61,  176,   66,
       73,   61,   75,   75,   61,   73,   73,  247,   61,   72,
       72,   72,   78,   75,   75,  101,   71,   78,   78,   77,

       76,  177,   80,   73,  247,   91,   91,   70,   93,  101,
      106,  106,  106,  136,   91,   78,   91,  176,   94,  136,
       94,   91,   93,   94,   72,   93,  115,  115,   93,   75,
       95,   95,   95,   95,   98,  177,   98,   98,  117,  117,
      117,  910,  118,  140,  101,  118,   95,   95,  124,  124,
      124,  133,  133,  140,   98,  169,  152,  118,  152,  169,
      159,   95,  170,  422,  170,   95,  125,  170,  125,  125,
      159,  175,   95,  161,  125,  125,  173,  173,  125,  161,
      161,  125,  178,  161,  125,  171,  184,  171,  184,  173,
      174,  174,  174,  180,  181,  422,  180,  181,  183,  623,

      183,  171,  171,  183,  310,  174,  174,  174,  185,  623,
      185,  193,  193,  193,  175,  187,  171,  187,  187,  521,
      171,  199,  199,  171,  184,  178,  313,  171,  172,  172,
      172,  200,  200,  201,  201,  187,  202,  202,  202,  199,
      203,  203,  201,  201,  172,  172,  185,  310,  204,  200,
      208,  201,  313,  204,  204,  208,  208,  521,  203,  172,
      213,  518,  213,  172,  225,  225,  172,  217,  217,  217,
      172,  204,  221,  208,  221,  243,  222,  221,  222,  223,
      223,  223,  225,  226,  226,  228,  228,  243,  227,  227,
      235,  235,  222,  222,  312,  223,  223,  227,  227,  259,

      259,  226,  238,  228,  518,  246,  227,  222,  311,  238,
      223,  222,  238,  246,  223,  229,  229,  229,  222,  246,
      232,  223,  232,  232,  238,  241,  241,  241,  232,  232,
      738,  418,  232,  312,  418,  232,  311,  738,  232,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  240,  306,  277,  240,

      277,  300,  419,  300,  301,  322,  301,  309,  309,  309,
      306,  240,  308,  308,  308,  620,  308,  300,  300,  301,
      301,  301,  309,  309,  309,  316,  316,  316,  343,  911,
      277,  519,  300,  322,  362,  421,  300,  277,  320,  300,
      320,  320,  419,  300,  620,  343,  320,  320,  324,  324,
      320,  362,  331,  320,  331,  339,  320,  324,  324,  325,
      325,  325,  327,  327,  327,  421,  324,  339,  331,  331,
      334,  334,  351,  351,  351,  420,  342,  519,  349,  334,
      334,  349,  467,  331,  342,  467,  912,  331,  334,  346,
      342,  346,  346,  349,  331,  622,  431,  346,  346,  427,

      389,  346,  389,  411,  346,  411,  410,  346,  410,  430,
      410,  427,  420,  431,  453,  438,  438,  430,  411,  411,
      411,  622,  458,  430,  438,  438,  439,  439,  443,  443,
      462,  453,  389,  438,  458,  444,  444,  443,  443,  389,
      436,  743,  436,  436,  439,  913,  443,  462,  436,  436,
      743,  461,  436,  444,  516,  436,  531,  516,  436,  461,
      465,  465,  465,  517,  436,  461,  517,  520,  520,  520,
      522,  535,  522,  531,  536,  539,  537,  538,  542,  541,
      540,  543,  543,  539,  637,  547,  536,  541,  547,  539,
      545,  545,  568,  536,  535,  537,  538,  540,  614,  543,

      614,  542,  539,  573,  573,  573,  637,  540,  545,  568,
      599,  607,  599,  607,  611,  616,  618,  611,  616,  618,
      599,  607,  619,  619,  619,  624,  638,  639,  624,  640,
      641,  642,  643,  644,  645,  646,  647,  640,  648,  711,
      662,  639,  638,  662,  641,  694,  643,  694,  648,  642,
      700,  645,  700,  703,  733,  694,  703,  644,  646,  645,
      700,  705,  732,  647,  705,  706,  715,  706,  734,  711,
      714,  714,  714,  739,  731,  735,  715,  731,  736,  733,
      737,  740,  741,  805,  742,  732,  731,  787,  807,  787,
      739,  736,  742,  737,  741,  804,  734,  809,  735,  790,

      790,  790,  806,  808,  810,  804,  740,  809,  811,  812,
      806,  805,  813,  814,  810,  815,  807,  850,  816,  850,
      853,  866,  867,  814,  811,  790,  869,  870,  871,  872,
      874,  808,  813,  875,  877,  876,  812,  816,  815,  908,
      914,  867,  915,  850,  916,  918,  875,  877,  919,  866,
      923,  920,  872,  922,  869,  870,  871,  916,  874,  876,
      853,  921,  926,  924,  927,  928,  925,  929,  930,  931,
      932,  933,  934,  918,  935,  923,  919,  936,  908,  920,
      925,  922,  924,  937,  921,  938,  939,  940,  942,  943,
      944,  945,  946,  947,  948,  949,  950,  951,  952,  954,

      953,  955,  956,  957,  958,  959,  960,  961,  963,  949,
      953,  964,  965,  966,  967,  968,  969,  943,  970,  971,
      972,  973,  974,  976,  950,  951,  952,  954,  975,  975,
      975,  977,  978,  979,  978,  980,  981,  983, 1010, 1010,
      906,  964,  967,  968,  969,  904,  970,  971, 1014, 1014,
      903,  976, 1016, 1016, 1021, 1021,  902,  900,  899,  977,
      986,  986,  986,  986,  986,  986,  986,  986,  986,  986,
      986,  986,  986,  986,  986,  986,  987,  987,  987,  987,
      987,  987,  987,  987,  987,  987,  987,  987,  987,  987,
      987,  987,  988,  988,  988,  988,  988,  988,  988,  988,

      988,  988,  988,  988,  988,  988,  988,  988,  989,  989,
      989,  989,  989,  989,  989,  989,  989,  989,  989,  989,
      989,  989,  989,  989,  990,  990,  990,  990,  990,  990,
      990,  990,  990,  990,  990,  990,  990,  990,  990,  990,
      991,  991,  991,  991,  991,  991,  991,  991,  991,  991,
      991,  991,  991,  991,  991,  991,  992,  898,  992,  992,
      992,  992,  992,  992,  992,  992,  992,  992,  992,  992,
      992,  992,  993,  993,  993,  993,  993,  993,  993,  993,
      993,  993,  993,  993,  993,  993,  993,  993,  994,  897,
      896,  895,  994,  894,  893,  892,  994,  994,  994,  891,

      994,  995,  890,  995,  995,  995,  995,  995,  995,  995,
      995,  995,  995,  995,  995,  995,  995,  996,  996,  996,
      996,  997,  889,  997,  997,  997,  997,  997,  888,  997,
      997,  997,  997,  997,  997,  997,  997,  998,  887,  998,
      998,  998,  998,  998,  998,  998,  998,  998,  998,  998,
      998,  998,  998,  999,  885,  999,  999,  999,  999,  999,
      999,  999,  999,  999,  999,  999,  999,  999,  999, 1000,
     1000,  884,  883,  882,  881,  880,  879, 1000, 1000, 1000,
      878, 1000, 1001,  868,  865,  864,  863,  862,  861, 1001,
     1001,  860, 1001, 1002, 1002, 1002, 1002, 1002, 1002, 1002,

     1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1004, 1004, 1004, 1004, 1004,
     1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
     1004, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
     1005, 1005, 1005, 1005, 1005, 1005, 1005, 1006, 1006, 1006,
     1006, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
     1007, 1007, 1007, 1007, 1007, 1007, 1007, 1008, 1008, 1008,
     1008, 1008, 1008, 1008, 1008, 1008, 1008,  859, 1008, 1008,
     1008, 1008, 1008, 1009, 1009, 1009, 1009, 1011, 1011, 1011,

     1012,  858,  857, 1012,  854,  852, 1012, 1012, 1012, 1013,
     1013, 1013, 1013, 1015, 1015, 1015, 1015, 1017, 1017,  851,
      848,  847,  846, 1017, 1017, 1017,  844, 1017, 1018, 1018,
      843,  842,  841,  840, 1018, 1018, 1018,  839, 1018, 1019,
     1019, 1019, 1019,  838,  837, 1019, 1020, 1020, 1020, 1022,
     1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
     1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023, 1023,  836,
      835, 1023, 1024, 1024, 1024, 1024,  834,  833, 1024, 1025,
     1025, 1025, 1026, 1026, 1026, 1027,  832,  831,  830, 1027,
     1027, 1027, 1027, 1028, 1028, 1028, 1028, 1028, 1028, 1028,

     1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028, 1029,
     1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,
     1029, 1029, 1029, 1029, 1029, 1030, 1030, 1030, 1030, 1030,
     1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030,
     1030, 1031,  829, 1031, 1031, 1031, 1031, 1031, 1031, 1031,
     1031, 1031, 1031, 1031, 1031, 1031, 1031, 1032, 1032, 1032,
     1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032,
     1032, 1032, 1032, 1033, 1033, 1033, 1033, 1033, 1033, 1033,
     1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1034,
     1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034, 1034,

     1034, 1034, 1034, 1034, 1034, 1035, 1035, 1035, 1035, 1035,
     1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035, 1035,
     1035, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036,
     1036, 1036, 1036, 1036, 1036, 1036, 1036, 1037, 1037, 1037,
     1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037,
     1037, 1037, 1037, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
     1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 1039,
     1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039,
     1039, 1039, 1039, 1039, 1039, 1040, 1040, 1040, 1040, 1040,
     1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040,

     1040, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041,
     1041, 1041, 1041, 1041, 1041, 1041, 1041, 1042, 1042, 1042,
     1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042,
     1042, 1042, 1042, 1043, 1043, 1043, 1043, 1043, 1043, 1043,
     1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 1044,
     1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044,
     1044, 1044, 1044, 1044, 1044,  828,  827,  826,  825,  824,
      823,  822,  821,  820,  819,  818,  803,  802,  801,  800,
      799,  798,  797,  796,  795,  793,  792,  791,  788,  786,
      785,  782,  781,  780,  778,  777,  776,  775,  774,  773,

      772,  771,  770,  768,  767,  766,  765,  764,  763,  762,
      761,  760,  759,  758,  757,  756,  755,  754,  753,  752,
      751,  750,  749,  748,  747,  745,  744,  730,  729,  728,
      727,  726,  725,  724,  723,  722,  721,  720,  719,  718,
      717,  712,  710,  709,  708,  707,  702,  696,  693,  692,
      690,  687,  686,  685,  684,  683,  682,  681,  680,  679,
      678,  676,  675,  674,  673,  672,  671,  670,  669,  668,
      667,  666,  665,  664,  663,  661,  660,  659,  658,  657,
      656,  655,  654,  653,  652,  651,  650,  649,  636,  635,
      634,  633,  632,  631,  630,  629,  628,  627,  626,  625,

      621,  615,  613,  612,  610,  609,  605,  604,  603,  600,
      598,  597,  595,  593,  592,  590,  589,  587,  586,  585,
      584,  583,  582,  581,  580,  579,  578,  577,  576,  575,
      572,  571,  570,  569,  567,  566,  565,  564,  563,  562,
      561,  560,  559,  558,  557,  556,  555,  554,  553,  552,
      551,  550,  549,  548,  534,  533,  532,  530,  529,  528,
      527,  526,  525,  524,  523,  515,  514,  513,  512,  511,
      507,  506,  505,  504,  503,  502,  501,  500,  499,  498,
      497,  496,  495,  494,  493,  492,  491,  490,  489,  488,
      486,  480,  479,  478,  477,  476,  475,  474,  473,  472,

      471,  470,  469,  468,  466,  464,  463,  460,  459,  457,
      456,  455,  454,  452,  451,  450,  449,  448,  447,  446,
      445,  434,  433,  432,  429,  428,  426,  424,  423,  416,
      415,  414,  413,  412,  409,  407,  406,  405,  404,  403,
      402,  401,  400,  399,  398,  397,  395,  393,  391,  390,
      388,  387,  385,  382,  377,  376,  375,  374,  373,  372,
      371,  369,  368,  367,  366,  365,  364,  363,  361,  360,
      359,  358,  357,  356,  355,  354,  350,  348,  345,  344,
      341,  340,  338,  336,  330,  329,  321,  318,  314,  307,
      305,  304,  303,  302,  299,  298,  297,  295,  294,  293,

      292,  291,  288,  287,  286,  285,  284,  283,  282,  281,
      280,  278,  276,  275,  274,  273,  272,  271,  269,  267,
      266,  265,  264,  263,  262,  261,  260,  258,  257,  255,
      254,  252,  250,  249,  248,  245,  244,  242,  233,  231,
      224,  220,  219,  215,  211,  205,  198,  197,  190,  186,
      168,  167,  166,  165,  164,  160,  158,  155,  154,  153,
      151,  150,  149,  148,  146,  145,  144,  143,  141,  139,
      138,  137,  135,  134,  132,  131,  130,  129,  128,  127,
      126,  113,  111,  110,  109,  102,   92,   88,   86,   81,
       74,   57,   56,   53,   48,   40,   35,   31,   30,   29,

       25,   23,   19,   15,   12,   11,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  985,  985
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 1;

static yyconst flex_int16_t yy_rule_linenum[152] =
    {   0,
      487,  488,  489,  490,  491,  493,  498,  499,  501,  517,
      522,  527,  531,  534,  538,  539,  541,  544,  545,  546,
      550,  551,  552,  553,  554,  555,  556,  557,  558,  559,
      560,  561,  562,  563,  564,  565,  566,  567,  568,  569,
      570,  571,  572,  573,  574,  575,  576,  577,  578,  579,
      580,  581,  582,  583,  584,  585,  586,  587,  588,  589,
      590,  591,  592,  593,  594,  595,  596,  597,  598,  599,
      600,  601,  602,  603,  604,  605,  606,  642,  643,  645,
      646,  647,  648,  650,  653,  656,  659,  662,  666,  671,
      674,  677,  680,  683,  685,  697,  709,  711,  715,  718,

      722,  723,  724,  726,  727,  764,  765,  766,  768,  770,
      775,  780,  785,  790,  795,  799,  800,  805,  810,  815,
      818,  823,  826,  831,  836,  837,  877,  899,  908,  913,
      918,  921,  942,  962,  978,  979,  980,  981,  982,  983,
      984,  985,  986,  987,  988,  989,  990,  991,  992,  993,
      995
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lex.l"

#line 26 "lex.l"
#include <sys/types.h>	
#include <sys/stat.h>
#include "mailfromd.h"
#include <mailutils/yyloc.h>
#include "gram.h"
#include "prog.h"
#include "srvcfg.h"

static mu_linetrack_t trk;

static struct mu_locus_point start_locus; /* Location when the last state switch
					    occurred */
static mu_opool_t string_pool;   /* Opool for constructing string values */
static char *multiline_delimiter; /* End of here-document delimiter */ 
static size_t multiline_delimiter_len; /* Length of multiline_delimiter_len */
static int multiline_unescape;         /* Unescape here-document contents */
static int (*char_to_strip)(char);     /* Strip matching characters of each
					  here-document line */
struct mu_locus_range const *
get_locus(void)
{
	return &yylloc;
}

static int
is_tab(char c)
{
	return c == '\t';
}
 
static int
is_space(char c)
{
	return c == '\t' || c == ' ';
}

static unsigned char
c_unescape(unsigned char inc)
{
	int outc = mu_wordsplit_c_unquote_char(inc);
        return outc ? outc : inc;
}

static void
switch_origin(struct mu_locus_point *pt)
{
	mu_linetrack_origin(trk, pt);
	mu_locus_point_deinit(pt);
}

#define line_begin string_begin
#define line_add string_add
#define line_add_char string_add_char
static void line_finish(void);
static void string(const char *str, size_t len);
static int isemptystr(char *text);
static int builtin_const(const char *s, size_t len);


/* Input context flags */
#define INCTX_MODULE     0x1  /* current input is a MFL module */
#define INCTX_HADINPUT   0x2  /* some statements has already been processed */
#define INCTX_IGNORE_BYE 0x4  /* ignore eventual `bye' statement, because
                                 this is an #included module */

/* Input context stack */
struct inctx {                     /* input context structure */
	struct inctx *parent;      /* parent context */
	struct mu_locus_range locus;/* locus where the context was pushed */
	mu_linetrack_t trk;
	struct input_file_ident id;/* file id structure to prevent recursion */
	FILE *file;                /* saved yyin */ 
	pid_t pp_pid;              /* preprocessor pid, if used */
	int inctx_flags;           /* input context flags */ 
	YY_BUFFER_STATE buf;       /* lex buffer state */
};

struct inctx *inctx_tos;           /* stack of input contexts */

/* Current input context: */
static pid_t pp_pid;               /* preprocessor pid */
static struct input_file_ident input_file_id;
static int inctx_flags;            /* input context flags */

/* If not 0, emit_token keeps a token that yylex must return on the
   next call. See YY_USER_ACTION below. */
static int emit_token;

/* Find on stack an input context that matches the given file id.
   Return pointer to the context. */
struct inctx *
inctx_locate(struct input_file_ident *id)
{
	struct inctx *ctx;

	for (ctx = inctx_tos; ctx; ctx = ctx->parent)
		if (ctx->id.device == id->device
		    && ctx->id.i_node == id->i_node)
			break;
	return ctx;
}
	
/* Push input context */	
static void
inctx_push()
{
	struct inctx *ctx = mu_alloc(sizeof(*ctx));

	mu_locus_range_init(&ctx->locus);
	mu_locus_range_copy(&ctx->locus, &yylloc);
	ctx->trk = trk;
	ctx->id = input_file_id;
	ctx->file = yyin;
	ctx->pp_pid = pp_pid;
	ctx->inctx_flags = inctx_flags;
	ctx->buf = YY_CURRENT_BUFFER;
	ctx->parent = inctx_tos;
	inctx_tos = ctx;
}

/* Pop input context from the top of the stack into the current
   input context. Return 1 if there are no more contexts left. */
int
inctx_pop()
{
	struct inctx *ctx = inctx_tos;
	
	if (!ctx)
		return 1;

	inctx_tos = ctx->parent;
	
	mu_locus_range_deinit(&ctx->locus);
	trk = ctx->trk;
	yyin = ctx->file; 
	input_file_id = ctx->id;
	inctx_flags = ctx->inctx_flags;
	yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer(ctx->buf);
	pp_pid = ctx->pp_pid;
	free(ctx);
	return 0;
}

/* Setup the scanner for input from the file NAME. Return 0 on success,
   and an appropriate EX_ code on error. See lex_new_source below. */
static int
lex_new_source_0(const char *name)
{
	if (!yyin)
		mu_locus_range_init (&yylloc);
	if (ext_pp) {
		yyin = pp_extrn_start(name, &pp_pid);
		if (!yyin) {
			parse_error(_("unable to start external "
				      "preprocessor `%s': %s"),
				     ext_pp,
				     mu_strerror(errno));
			return EX_OSFILE;
		}
	} else {
		yyin = fopen(name, "r");
		if (!yyin) {
			parse_error(_("cannot open %s: %s"), name,
				    mu_strerror(errno));
			return EX_NOINPUT;
		}
	}
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
	MU_ASSERT(mu_linetrack_create(&trk, name, 2));
	mu_locus_point_set_file(&yylloc.beg, name);
	yylloc.beg.mu_line = 1;
	yylloc.beg.mu_col = 1;
	mu_locus_point_copy(&yylloc.end, &yylloc.beg);
	mu_stream_ioctl(mu_strerr, MU_IOCTL_LOGSTREAM,
			MU_IOCTL_LOGSTREAM_SET_LOCUS_RANGE, &yylloc);
	return EX_OK;
}

/* Save the current input context on stack and set up the scanner for
   input from the file NAME. Return 0 on success,
   and an appropriate EX_ code on error. */
int
lex_new_source(const char *name, int flag)
{
	int rc;
	struct stat st;
	struct input_file_ident id;
	struct inctx *pctx;
	
	if (stat(name, &st)) {
		parse_error(_("cannot open `%s': %s"),
			    name, mu_strerror(errno));
		return EX_NOINPUT;
	} else if (!S_ISREG(st.st_mode)) {
		parse_error(_("`%s' is not a regular file"), name);
		return EX_NOINPUT;
	}
	
	id.device = st.st_dev;
	id.i_node = st.st_ino;
	
	pctx = inctx_locate(&id);
	if (pctx) {
		parse_error(_("recursive inclusion"));
		if (pctx->parent)
			parse_error_locus(&pctx->parent->locus,
					  _("`%s' already included here"),
					  name);
		else
			parse_error(_("`%s' already included at top level"),
				    name);
		return 1;
	}
	
	if (flag == LEX_ONCE && source_lookup(&id))
		return 0;

	if (yyin)
		inctx_push();
	rc = lex_new_source_0(name);
	if (rc)
		inctx_pop();
	else {
		input_file_id = id;
		if (flag == LEX_MODULE) {
			inctx_flags = INCTX_MODULE;
			emit_token = T_MODBEG;
		} else
			inctx_flags = 0;
	}
	return rc;
}


/* Return constant or variable token corresponding to the current
   value of yylval.literal->text. */
static int
variable_or_const()
{
	struct variable *vptr;
	const struct constant *cptr;

	cptr = constant_lookup(yylval.literal->text);
	if (cptr) {
		const struct value *value_ptr = &cptr->value;
		switch (value_ptr->type) {
		case dtype_number:
			yylval.number = value_ptr->v.number;
			return T_NUMBER;

		case dtype_string:
			yylval.literal = value_ptr->v.literal;
			return T_STRING;
			
		default:
			abort();
		}
	}

	vptr = variable_lookup(yylval.literal->text);
	if (!vptr) {
		parse_error(_("variable %s is not defined"),
			    yylval.literal->text);
		return T_BOGUS;
	}
	add_xref(vptr, &yylloc);
	yylval.var = vptr;
	return T_VARIABLE;
}
	
/* Saved lexer state before entering COMMENT */
static int save_state;
/* Same as BEGIN, but also saves the current locus. It is then used
   to report unclosed constructs at the end of file. */
#define BEGIN_X(s)							\
	do {								\
		BEGIN(s);						\
		mu_locus_point_copy (&start_locus, &yylloc.beg);	\
	} while(0)

/* If emit_token is not 0, push back current input and return the value
   of emit_token. Clear emit_token before returning. */
#define YY_USER_ACTION							\
	if (emit_token) {						\
		int tok = emit_token;					\
		emit_token = 0;						\
		if (yy_flex_debug)					\
			fprintf(stderr, "--emitting %d (module %s)\n",	\
				tok,top_module->name);			\
		mu_linetrack_retreat(trk, yyleng);			\
		yyless(0);						\
		return tok;						\
  	} else {							\
	        mu_linetrack_advance(trk, &yylloc, yytext, yyleng);	\
	        mu_stream_ioctl(mu_strerr, MU_IOCTL_LOGSTREAM,		\
			        MU_IOCTL_LOGSTREAM_SET_LOCUS_RANGE, &yylloc);\
   	}

/* Read next input chunk. */
#define YY_INPUT(buf,result,max_size)					\
	if (yyin == NULL)						\
		result = YY_NULL;					\
	else if (((result = fread(buf, 1, max_size, yyin)) == 0)	\
		 && ferror(yyin))					\
		YY_FATAL_ERROR("input in flex scanner failed");

/* Redeclare main entry point. Actual yylex is defined in the code section
   below. */
#define YY_DECL static int lexscan(void)


/* String composer */
static struct mu_locus_point string_beg;
static NODE *string_head, *string_tail;

static void
compose_add_node(NODE *node)
{
	if (string_tail)
		string_tail->next = node;
	else
		string_head = node;
	string_tail = node;
}

static void
compose_start(int state)
{
	if (string_head) {
		parse_error("INTERNAL ERROR: previous composition has not "
			    "finished when a new one started");
		abort();
	}
	mu_locus_point_copy(&string_beg, &yylloc.beg);
	BEGIN_X(state);
}

static int
compose_finish()
{
	if (string_tail != string_head) {
		while (string_head->next) {
			NODE *cat = alloc_node(node_type_concat,
					       &string_head->locus);
			NODE *next = string_head->next;
			cat->next = next->next;
			cat->v.concat.arg[0] = cast_to(dtype_string,
						       string_head);
			cat->v.concat.arg[1] = cast_to(dtype_string, next);
			string_head->next = next->next = NULL;
			string_head = cat;
		}
	}
	yylval.node = string_head;
	mu_locus_point_copy(&yylloc.beg, &string_beg);
	mu_locus_point_deinit(&string_beg);
	string_head = string_tail = NULL;
	return T_COMPOSE;
}

static void
compose_add_literal(struct literal *lit)
{
	NODE *node = alloc_node(node_type_string, &yylloc);
	node->v.literal = lit;
	compose_add_node(node);
	if (yy_flex_debug)
		fprintf(stderr, "--add literal: '%s'\n", lit->text);
}

static void
compose_add_string(const char *text, size_t length)
{
	compose_add_literal(string_alloc(text, length));
}

static void
compose_add_number(long num)
{
	NODE *node = alloc_node(node_type_number, &yylloc);
	node->v.number = num;
	compose_add_node(node);
}

void
compose_add_builtin_const(const char *s, size_t len)
{
	const char *sval;
	long nval;
	
	switch (builtin_const_value(s, len, &sval, &nval)) {
	case dtype_number:
		compose_add_number(nval);
		break;

	case dtype_string:
		compose_add_string(sval, strlen(sval));
		break;

	default:
		abort();
	}
}

void
compose_add_variable_or_const(int what)
{
	switch (what) {
	case T_NUMBER:
		compose_add_number(yylval.number);
		break;

	case T_STRING:
		compose_add_literal(yylval.literal);
		break;

	case T_VARIABLE:
		compose_add_node(create_node_variable(yylval.var, &yylloc));
	}
}

/* Exclusive states:

   SHELLMAGIC     Initial shell-magic boilerplate (#!... !#)
   COMMENT        Within a C-style comment;
   XIDENT         Expected identifier;
   STR            Processing a complex string;
   ML             Within a multi-line aggregator.  The line being built
                  requires stripping leading whitespace (if requested).
   CML            Continuation within a multi-line aggregator.  The line
                  being built does not require stripping leading whitespace.
   QML            Quoted multi-line aggregator.  No variable substitution and
                  unquoting is needed.

   Inclusive states:
   
   ONBLOCK	  Lexical tie-in after an `on' keyword.  In ONBLOCK state
                  the strigns `as', `host', `from', and `poll' are
		  recognized as keywords.  The string `for' also acquires
		  special meaning.
*/


#line 1875 "lex.c"

#define INITIAL 0
#define COMMENT 1
#define STR 2
#define ML 3
#define CML 4
#define QML 5
#define XIDENT 6
#define SHELLMAGIC 7
#define ONBLOCK 8

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */
/* %if-c-only */

static int yy_init_globals (void );

/* %endif */
/* %if-reentrant */
/* %endif */
/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

yy_size_t yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

/* %if-bison-bridge */
/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

/* %not-for-header */

#ifndef YY_NO_UNPUT
    
#endif
/* %ok-for-header */

/* %endif */

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */

/* %ok-for-header */

/* %not-for-header */

/* %tables-yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int yylex (void);

#define YY_DECL int yylex (void)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/* %not-for-header */

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
/* %if-c-only */
			yyin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! yyout )
/* %if-c-only */
			yyout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
/* %% [7.0] user's declarations go here */
#line 485 "lex.l"

         /* C-style comments */
#line 2172 "lex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] yymore()-related code goes here */
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 986 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 2207 );

yy_find_action:
/* %% [10.0] code to find the action number goes here */
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for yylineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( yy_flex_debug )
			{
			if ( yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( yy_act < 152 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)yy_rule_linenum[yy_act], yytext );
			else if ( yy_act == 152 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         yytext );
			else if ( yy_act == 153 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 487 "lex.l"
{ save_state = YYSTATE;  BEGIN_X(COMMENT); }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 488 "lex.l"
/* eat anything that's not a '*' */
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 489 "lex.l"
/* eat up '*'s not followed by '/'s */
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 490 "lex.l"
;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 491 "lex.l"
BEGIN(save_state);
	YY_BREAK
/* Shell magic sequence */
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 493 "lex.l"
{
	if (yylloc.beg.mu_line == 1) {
		BEGIN_X(SHELLMAGIC);
	}
      }
	YY_BREAK
case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 498 "lex.l"
{ BEGIN(INITIAL); }
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 499 "lex.l"
;
	YY_BREAK
/* Configuration directives */
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 501 "lex.l"
{
	struct mu_locus_point pt;
	if (parse_line_cpp(yytext, &pt) == 0)
		switch_origin(&pt);
}
	YY_BREAK
/* Normally, everything within a comment should be ignored, so
	   the exclusive condition for the rule below is an error.
	   Unfortunately, GNU m4 in versions up to 1.4.9 outputs line
	   synchronisation directives in comments, which makes any decent
	   compiler lost trace of which input line it is on.  To avoid
	   this, mfd handles #line directives even within a C-comment
	   block.

	   This bug was fixed in m4 version 1.4.10.  I prefer to keep
	   this kludge until I am pretty sure there are no 1.4.9 around.
	*/
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 517 "lex.l"
{
	struct mu_locus_point pt;
	if (parse_line(yytext, &pt) == 0)
		switch_origin(&pt);
}
	YY_BREAK
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 522 "lex.l"
{
	mu_linetrack_retreat(trk, 1);
	yyless(yyleng-1);
	parse_pragma(yytext);
}
	YY_BREAK
case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
#line 527 "lex.l"
{
         yytext[yyleng-1] = 0; /* Kill trailing newline */
         parse_error("%s", yytext);
}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 531 "lex.l"
{
	parse_include(yytext, 1);
}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 534 "lex.l"
{
	parse_include(yytext, 0);
}
	YY_BREAK
/* End-of-line comments */
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 538 "lex.l"
;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 539 "lex.l"
/* end-of-file comment */;
	YY_BREAK
/* expected identified (after 'require' or initial 'from') */
case 17:
YY_RULE_SETUP
#line 541 "lex.l"
{ BEGIN(INITIAL);
	          string(yytext, yyleng);
		  return T_IDENTIFIER; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 544 "lex.l"
;
	YY_BREAK
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 545 "lex.l"
;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 546 "lex.l"
{ BEGIN(INITIAL);
	 mu_linetrack_retreat(trk, yyleng);
                  yyless(0); }
	YY_BREAK
/* Reserved words */
case 21:
YY_RULE_SETUP
#line 550 "lex.l"
return T_ACCEPT;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 551 "lex.l"
return T_REJECT;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 552 "lex.l"
return T_TEMPFAIL;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 553 "lex.l"
return T_CONTINUE;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 554 "lex.l"
return T_DISCARD;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 555 "lex.l"
return T_ADD;
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 556 "lex.l"
return T_REPLACE;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 557 "lex.l"
return T_DELETE;
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 558 "lex.l"
return T_IF;
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 559 "lex.l"
return T_FI;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 560 "lex.l"
return T_ELSE;
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 561 "lex.l"
return T_ELIF;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 562 "lex.l"
return T_ON;
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 563 "lex.l"
return T_DO;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 564 "lex.l"
return T_DONE;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 565 "lex.l"
return T_MATCHES;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 566 "lex.l"
return T_FNMATCHES;
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 567 "lex.l"
return T_MXMATCHES;
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 568 "lex.l"
return T_MXFNMATCHES;
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 569 "lex.l"
return T_WHEN;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 570 "lex.l"
return T_OR;
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 571 "lex.l"
return T_AND;
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 572 "lex.l"
return T_NOT;
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 573 "lex.l"
return T_NEXT;
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 574 "lex.l"
return T_PROG;
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 575 "lex.l"
return T_SET;
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 576 "lex.l"
return T_CATCH;
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 577 "lex.l"
return T_TRY;
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 578 "lex.l"
return T_ECHO;
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 579 "lex.l"
return T_RETURN;
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 580 "lex.l"
return T_RETURNS;
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 581 "lex.l"
return T_FUNC;
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 582 "lex.l"
return T_SWITCH;
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 583 "lex.l"
return T_CASE;
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 584 "lex.l"
return T_DEFAULT;
	YY_BREAK
case 56:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 6;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 585 "lex.l"
{ yylval.type = dtype_string; return T_TYPECAST; }
	YY_BREAK
case 57:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 6;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 586 "lex.l"
{ yylval.type = dtype_number; return T_TYPECAST; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 587 "lex.l"
{ yylval.type = dtype_string; return T_TYPE; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 588 "lex.l"
{ yylval.type = dtype_number; return T_TYPE; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 589 "lex.l"
return T_CONST;
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 590 "lex.l"
return T_THROW;
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 591 "lex.l"
return T_LOOP;
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 592 "lex.l"
return T_WHILE;
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 593 "lex.l"
return T_FOR;
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 594 "lex.l"
return T_BREAK;
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 595 "lex.l"
return T_PASS;
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 596 "lex.l"
return T_BEGIN;
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 597 "lex.l"
return T_END;
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 598 "lex.l"
return T_ALIAS;
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 599 "lex.l"
return T_VAPTR;
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 600 "lex.l"
return T_PRECIOUS;
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 601 "lex.l"
return T_REQUIRE;
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 602 "lex.l"
return T_IMPORT;
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 603 "lex.l"
return T_FROM;
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 604 "lex.l"
return T_STATIC;
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 605 "lex.l"
return T_PUBLIC;
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 606 "lex.l"
{  if (inctx_tos && inctx_flags == 0) {
                int c;
		int flen;
		const char *fname = strrchr(yylloc.beg.mu_file, '/');

		if (fname)
			fname++;
		else
			fname = yylloc.beg.mu_file;
		flen = strlen(fname);
		
		if (flen > 3 && strcmp(fname + flen - 3, ".mf") == 0)
			flen -= 3;
		parse_warning_locus(&inctx_tos->locus,
				    _("including a module file is unreliable and may cause subtle errors"));
		/* TRANSLATORS: Do not translate `require %*.*s' */
		parse_warning_locus(&inctx_tos->locus,
				    _("use `require %*.*s' instead"),
				    flen, flen, fname);
		inctx_flags |= INCTX_IGNORE_BYE;
		mu_locus_point_copy(&start_locus, &yylloc.beg);
		while ((c = input()) != '.') {
		    if (c == 0) {
  		        mu_diag_at_locus_point(MU_DIAG_ERROR, &start_locus,
					       "%s",
					       _("unexpected end of file"));
		     	return 0;
		    } else {
			char ch = c;
			mu_linetrack_advance(trk, &yylloc, &ch, 1);
		    }
		}
	     } else if (inctx_flags & INCTX_HADINPUT) 
		     parse_error(_("misplaced `module'"));
	    return T_MODULE;
          }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 642 "lex.l"
return T_BYE;
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 643 "lex.l"
return T_DCLEX;
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 645 "lex.l"
{ return builtin_const(yytext, yyleng); } 
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 646 "lex.l"
return T_POLL;
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 647 "lex.l"
return T_HOST;
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 648 "lex.l"
return T_AS;
	YY_BREAK
/* Variables */
case 84:
YY_RULE_SETUP
#line 650 "lex.l"
{
	return builtin_const(yytext + 1, yyleng - 1);
}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 653 "lex.l"
{
	compose_add_builtin_const(yytext + 1, yyleng - 1);
}	
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 656 "lex.l"
{
	return builtin_const(yytext + 2, yyleng - 3);
}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 659 "lex.l"
{
	compose_add_builtin_const(yytext + 2, yyleng - 3);
}
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 662 "lex.l"
{
	string(yytext + 1, yyleng - 1);
	compose_add_variable_or_const(variable_or_const());
}
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 666 "lex.l"
{
	string(yytext + 2, yyleng - 3);
	compose_add_variable_or_const(variable_or_const());
}
	YY_BREAK
/* Positional arguments */
case 90:
YY_RULE_SETUP
#line 671 "lex.l"
{
	return T_ARGCOUNT;
}
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 674 "lex.l"
{
	compose_add_node(create_node_argcount(&yylloc));
}
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 677 "lex.l"
{
	yylval.number = strtol(yytext + 1, NULL, 0);
	return T_ARG; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 680 "lex.l"
{
	compose_add_node(create_node_arg(strtol(yytext + 1, NULL, 0), &yylloc));
}
	YY_BREAK
case 94:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 683 "lex.l"
{ return T_ARGX; }
	YY_BREAK
/* Sendmail variables */
case 95:
YY_RULE_SETUP
#line 685 "lex.l"
{
	        if (yyleng == 2)
	           string(yytext + 1, 1);
                else {
                   line_begin();
                   line_add("{", 1);
                   line_add(yytext + 1, yyleng - 1);
                   line_add("}", 1);
                   line_finish();
                }
                return T_SYMBOL;
              }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 697 "lex.l"
{
	        if (yyleng == 2)
	           string(yytext + 1, 1);
                else {
                   line_begin();
                   line_add("{", 1);
                   line_add(yytext + 1, yyleng - 1);
                   line_add("}", 1);
                   line_finish();
                }
		compose_add_node(create_node_symbol(yylval.literal, &yylloc));
              }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 709 "lex.l"
{
	string(yytext+1, yyleng - 1); return T_SYMBOL; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 711 "lex.l"
{
	string(yytext+1, yyleng - 1);
	compose_add_node(create_node_symbol(yylval.literal, &yylloc)); }
	YY_BREAK
/* Back-references */
case 99:
YY_RULE_SETUP
#line 715 "lex.l"
{
	 yylval.number = strtoul(yytext+1, NULL, 0);
	 return T_BACKREF; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 718 "lex.l"
{
	compose_add_node(create_node_backref(strtoul(yytext+1, NULL, 10),
					     &yylloc)); }
	YY_BREAK
/* Numeric strings */
case 101:
YY_RULE_SETUP
#line 722 "lex.l"
{ yylval.number = strtoul(yytext, NULL, 16); return T_NUMBER; };
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 723 "lex.l"
{ yylval.number = strtoul(yytext, NULL, 8); return T_NUMBER; };
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 724 "lex.l"
{ yylval.number = strtoul(yytext, NULL, 10); return T_NUMBER; };
	YY_BREAK
/* Identifiers */
case 104:
YY_RULE_SETUP
#line 726 "lex.l"
return T_SED;
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 727 "lex.l"
{
	const struct constant *cptr;

	cptr = constant_lookup(yytext);
	if (cptr) {
		const struct value *value_ptr = &cptr->value;
		switch (value_ptr->type) {
		case dtype_number:
			yylval.number = value_ptr->v.number;
			return T_NUMBER;

		case dtype_string:
			yylval.literal = value_ptr->v.literal;
			return T_STRING;
			
		default:
			abort();
		}
	}
	
	if (yylval.builtin = builtin_lookup(yytext))
		return T_BUILTIN;
	else if (yylval.function = function_lookup(yytext))
		return T_FUNCTION;
	else {
                struct variable *vptr;
		string(yytext, yyleng);
                vptr = variable_lookup(yylval.literal->text);
	        if (!vptr) {
			return T_IDENTIFIER;
		}
		add_xref(vptr, &yylloc);
		yylval.var = vptr;
		return T_VARIABLE;
	}
}
	YY_BREAK
/* Strings */
case 106:
YY_RULE_SETUP
#line 764 "lex.l"
{ string(yytext+1, yyleng-2); return T_STRING; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 765 "lex.l"
{ string(yytext+1, yyleng-2); return T_STRING; }
	YY_BREAK
case 108:
/* rule 108 can match eol */
YY_RULE_SETUP
#line 766 "lex.l"
{ compose_start(STR);
                        compose_add_string(yytext + 1, yyleng - 3); }
	YY_BREAK
case 109:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 768 "lex.l"
{ compose_start(STR);
                        compose_add_string(yytext+1, yyleng-1); }
	YY_BREAK
case 110:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 5;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 770 "lex.l"
{
         compose_start(STR);
         line_add_char(strtoul(yytext + 3, NULL, 16));
         compose_add_literal(string_finish());
}
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 775 "lex.l"
{
         compose_start(STR);
         line_add_char(strtoul(yytext + 3, NULL, 16));
}
	YY_BREAK
case 112:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 780 "lex.l"
{
         compose_start(STR);
         line_add_char(strtoul(yytext + 3, NULL, 8));
         compose_add_literal(string_finish());
}
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 785 "lex.l"
{
         compose_start(STR);  
         line_add_char(strtoul(yytext + 3, NULL, 8));
}
	YY_BREAK
case 114:
/* rule 114 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 3);
(yy_c_buf_p) = yy_cp = yy_bp + 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 790 "lex.l"
{
         compose_start(STR);
         line_add_char(c_unescape(yytext[2]));
         compose_add_literal(string_finish());
}
	YY_BREAK
case 115:
/* rule 115 can match eol */
YY_RULE_SETUP
#line 795 "lex.l"
{
         compose_start(STR);
         line_add_char(c_unescape(yytext[2]));
}
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 799 "lex.l"
{ line_add(yytext, yyleng - 2); }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 800 "lex.l"
{ BEGIN(INITIAL);
                        if (yyleng > 1)
                          line_add(yytext, yyleng - 1);
                        compose_add_literal(string_finish());
                        return compose_finish(); }
	YY_BREAK
case 118:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 805 "lex.l"
{
                       line_add(yytext, yyleng);
                       compose_add_literal(string_finish());
                       line_begin();
                 }
	YY_BREAK
case 119:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 4;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 810 "lex.l"
{
         line_add_char(strtoul(yytext + 2, NULL, 16));
         compose_add_literal(string_finish());       
         line_begin();
}
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 815 "lex.l"
{
         line_add_char(strtoul(yytext + 2, NULL, 16));
}
	YY_BREAK
case 121:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 818 "lex.l"
{
         line_add_char(strtoul(yytext + 2, NULL, 8));
         compose_add_literal(string_finish());
         line_begin();
}
	YY_BREAK
case 122:
YY_RULE_SETUP
#line 823 "lex.l"
{
         line_add_char(strtoul(yytext + 2, NULL, 8));
}
	YY_BREAK
case 123:
/* rule 123 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 2);
(yy_c_buf_p) = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 826 "lex.l"
{
         line_add_char(c_unescape(yytext[1]));
         compose_add_literal(string_finish());
         line_begin();
}
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 831 "lex.l"
{
         line_add_char(c_unescape(yytext[1]));
}
	YY_BREAK
/* Multi-line strings */
case 125:
/* rule 125 can match eol */
#line 837 "lex.l"
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 837 "lex.l"
{
        char *p;

        char_to_strip = NULL;
        multiline_unescape = 1;

        line_begin();
        p = yytext + 2;
        if (*p == '-') {
            ++p;
            if (*p == ' ') {
                ++p;
                char_to_strip = is_space;
            } else
                char_to_strip = is_tab;
        }
        
        if (*p == '\\') {
            p++;
            multiline_unescape = 0;
        }
        if (*p == '\'') {
            char *q;
 
            p++;
            multiline_unescape = 0;
            q = strchr(p, '\'');
            multiline_delimiter_len = q - p;
        } else
            multiline_delimiter_len = strcspn(p, " \t");

        multiline_delimiter = mu_alloc(multiline_delimiter_len + 1);
        memcpy(multiline_delimiter, p, multiline_delimiter_len);
        multiline_delimiter[multiline_delimiter_len] = 0;
        if (multiline_unescape)
            compose_start(ML);
        else
            compose_start(QML);
}
	YY_BREAK
/* Quoted multilines */
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 877 "lex.l"
{
        char *p;

        p = yytext;
        if (char_to_strip)
               for (; char_to_strip (*p); p++)
                      ;

        if (strlen(p) >= multiline_delimiter_len
            && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
            && isemptystr(p + multiline_delimiter_len)) {
	       free (multiline_delimiter);
	       multiline_delimiter = NULL;
               multiline_delimiter_len = 0;
	       BEGIN(INITIAL);
               compose_add_literal(string_finish());
               return compose_finish();
        }
        line_add(p, strlen(p));
}
	YY_BREAK
/* Unquoted multilines */
case 128:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 899 "lex.l"
{
        char *p = yytext;
        if (char_to_strip)
               for (; char_to_strip (*p); p++)
                      ;
        line_add(p, strlen(p));
        compose_add_literal(string_finish());
        BEGIN_X(CML);
}
	YY_BREAK
case 129:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 908 "lex.l"
{
        line_add(yytext, yyleng);
        compose_add_literal(string_finish());
        line_begin();
}
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 913 "lex.l"
{
        line_add(yytext, 1);
        compose_add_literal(string_finish());
        line_begin();
}
	YY_BREAK
case 131:
YY_RULE_SETUP
#line 918 "lex.l"
{
        line_add(yytext, yyleng);
}
	YY_BREAK
case 132:
/* rule 132 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_cp - 1);
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 921 "lex.l"
{
        char *p;

        p = yytext;
        if (char_to_strip)
               for (; char_to_strip (*p); p++)
                      ;

        if (strlen(p) >= multiline_delimiter_len
            && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
            && isemptystr(p + multiline_delimiter_len)) {
	       free (multiline_delimiter);
	       multiline_delimiter = NULL;
               multiline_delimiter_len = 0;
	       BEGIN(INITIAL);
               compose_add_literal(string_finish());
               return compose_finish();
        }
        line_add(p, strlen(p));
        compose_add_literal(string_finish());
}
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 942 "lex.l"
{
        char *p;

        p = yytext;
        if (char_to_strip)
               for (; char_to_strip (*p); p++)
                      ;

        if (strlen(p) >= multiline_delimiter_len
            && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
            && isemptystr(p + multiline_delimiter_len)) {
	       free (multiline_delimiter);
	       multiline_delimiter = NULL;
               multiline_delimiter_len = 0;
	       BEGIN(INITIAL);
               compose_add_literal(string_finish());
               return compose_finish();
        }
        line_add(p, strlen(p));
}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 962 "lex.l"
{
        if (yyleng >= multiline_delimiter_len
            && memcmp(yytext, multiline_delimiter,
                      multiline_delimiter_len) == 0
            && isemptystr(yytext + multiline_delimiter_len)) {
	       free (multiline_delimiter);
	       multiline_delimiter = NULL;
               multiline_delimiter_len = 0;
	       BEGIN(INITIAL);
               compose_add_literal(string_finish());
               return compose_finish();
        }
        line_add(yytext, yyleng);
        BEGIN_X(ML);
}
	YY_BREAK
/* Other tokens */
case 135:
YY_RULE_SETUP
#line 978 "lex.l"
;
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 979 "lex.l"
;
	YY_BREAK
case 137:
YY_RULE_SETUP
#line 980 "lex.l"
return T_EQ;
	YY_BREAK
case 138:
YY_RULE_SETUP
#line 981 "lex.l"
return T_NE;
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 982 "lex.l"
return T_LT;
	YY_BREAK
case 140:
YY_RULE_SETUP
#line 983 "lex.l"
return T_LE;
	YY_BREAK
case 141:
YY_RULE_SETUP
#line 984 "lex.l"
return T_GT;
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 985 "lex.l"
return T_GE;
	YY_BREAK
case 143:
YY_RULE_SETUP
#line 986 "lex.l"
return T_LOGAND;
	YY_BREAK
case 144:
YY_RULE_SETUP
#line 987 "lex.l"
return T_LOGOR;
	YY_BREAK
case 145:
YY_RULE_SETUP
#line 988 "lex.l"
return T_LOGXOR;
	YY_BREAK
case 146:
YY_RULE_SETUP
#line 989 "lex.l"
return T_LOGNOT;
	YY_BREAK
case 147:
YY_RULE_SETUP
#line 990 "lex.l"
return T_SHL;
	YY_BREAK
case 148:
YY_RULE_SETUP
#line 991 "lex.l"
return T_SHR;
	YY_BREAK
case 149:
YY_RULE_SETUP
#line 992 "lex.l"
return T_DOTS;
	YY_BREAK
case 150:
YY_RULE_SETUP
#line 993 "lex.l"
/* If a here-document is not closed and its next line does not
               end with a \n, prevent it from being displayed by ECHO */;
	YY_BREAK
case 151:
YY_RULE_SETUP
#line 995 "lex.l"
return yytext[0];
	YY_BREAK
case 152:
YY_RULE_SETUP
#line 996 "lex.l"
ECHO;
	YY_BREAK
#line 3433 "lex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(STR):
case YY_STATE_EOF(ML):
case YY_STATE_EOF(CML):
case YY_STATE_EOF(QML):
case YY_STATE_EOF(XIDENT):
case YY_STATE_EOF(SHELLMAGIC):
case YY_STATE_EOF(ONBLOCK):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
/* %if-c-only */
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
/* %endif */
/* %if-c++-only */
/* %endif */
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up yy_cp goes here */
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */

/* %ok-for-header */

/* %endif */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int yy_get_next_buffer (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	yy_size_t number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (yy_size_t) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */

    static yy_state_type yy_get_previous_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
/* %% [15.0] code to get the start state into yy_current_state goes here */
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 986 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int yy_is_jam;
    /* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 986 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 985);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT
/* %if-c-only */

/* %endif */
#endif

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

/* %% [19.0] update BOL and yylineno */
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void yyrestart  (FILE * input_file )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/* %if-c++-only */
/* %endif */

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
/* %if-c-only */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

/* %if-c-only */
static void yy_load_buffer_state  (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
/* %if-c-only */
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
/* %endif */
/* %if-c++-only */
/* %endif */
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/* %if-c++-only */
/* %endif */

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
/* %if-c-only */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
/* %if-c-only */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

/* %if-c-only */
	b->yy_input_file = file;
/* %endif */
/* %if-c++-only */
/* %endif */
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

/* %if-c-only */

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
/* %if-c-only */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
/* %if-c-only */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
/* %if-c-only */
void yypop_buffer_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void yyensure_buffer_stack (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1; // After all that talk, this was set to 1 anyways...
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */
/* %endif */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/* %if-reentrant */
/* %endif */

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

/* %endif */

/* %if-reentrant */
/* %if-bison-bridge */
/* %endif */
/* %endif if-c-only */

/* %if-c-only */
static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

/* %if-reentrant */
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "yytables"
/* %endif */

/* %ok-for-header */

#line 996 "lex.l"



int
yylex()
{
        int rc = lexscan();
	if (rc != T_MODBEG && rc != T_MODEND)
		inctx_flags |= INCTX_HADINPUT;
	return rc;
}

void
init_string_space()
{
        mu_opool_create(&string_pool, MU_OPOOL_ENOMEMABRT);
}

void
free_string_space()
{
	mu_opool_destroy(&string_pool);
}

char *
mf_strdup(const char *str)
{
	string_add(str, strlen(str) + 1);
	return mu_opool_finish(string_pool, NULL);
}

struct literal *
string_alloc(const char *str, size_t len)
{
	string_begin();
	string_add(str, len);
	return string_finish();
}

static void
string(const char *str, size_t len)
{
	yylval.literal = string_alloc(str, len);
}

void
string_begin()
{
	/* nothing */
}

struct literal *
string_finish()
{
	char *ptr;
	struct literal *lit;
	mu_opool_append_char(string_pool, 0);
	ptr = mu_opool_finish(string_pool, NULL);
	lit = literal_lookup(ptr);
	if (lit->text != ptr)
		mu_opool_free(string_pool, ptr);
	return lit;
}

static void
line_finish()
{	
	yylval.literal = string_finish();
	if (yy_flex_debug)
		fprintf(stderr, "constructed line: %s\n",
			yylval.literal->text);
}		

void
string_add(const char *str, size_t len)
{
	mu_opool_append(string_pool, str, len);
}

void
string_add_char(unsigned char c)
{
	mu_opool_append_char(string_pool, c);
}

void
parse_warning(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
        mu_diag_voutput (MU_DIAG_WARNING, fmt, ap);
	va_end(ap);
}

void
parse_warning_locus(struct mu_locus_range const *loc, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
        mu_vdiag_at_locus_range(MU_DIAG_WARNING, loc, fmt, ap);
	va_end(ap);
}

void
parse_error(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
        mu_diag_voutput(MU_DIAG_ERROR, fmt, ap);
	va_end(ap);
	error_count++;
}

void
parse_error_locus(struct mu_locus_range const *loc, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
        mu_vdiag_at_locus_range(MU_DIAG_ERROR, loc, fmt, ap);
	va_end(ap);
	error_count++;
}



static int
lex_close_source()
{
	if (!yyin)
		return 1;
	if (ext_pp)
 	        pp_extrn_shutdown(yyin, pp_pid);
	else
		fclose(yyin);
	yyin = NULL;
        mu_linetrack_destroy(&trk);
	
	switch (YYSTATE) {
	case INITIAL:
		/* ok */
		break;

	case COMMENT:
                mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
                                        "%s", _("end of file in comment"));
		break;

	case STR:
	case ML:
	case CML:
	case QML:
                mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
		                        "%s", _("end of file in string"));
                break;

	case SHELLMAGIC:
                mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
				        "%s", _("end of file in shell block"));
		break;
	}
	return inctx_pop();
}

void
lex_drain_input()
{
	while (input() != EOF)
		;
}

void
lex_bye()
{
	lex_drain_input();
	lex_close_source();
}

int
yywrap()
{
	if (yy_flex_debug && top_module)
		fprintf(stderr, "--eof in module %s\n", top_module->name);
	if (inctx_flags & INCTX_MODULE)
		emit_token = T_MODEND;
	return lex_close_source();
}

static int
isemptystr(char *text)
{
	for (; *text && mu_isspace (*text); text++)
		;
	return *text == 0;
}

void
tie_in_onblock(int enable)
{
	if (enable)
		BEGIN(ONBLOCK);
	else
		BEGIN(INITIAL);
}

data_type_t
builtin_const_value(const char *s, size_t len, const char **sval, long *nval)
{
	if (strncmp(s, "__file__", len) == 0) {
		struct literal *lit = literal_lookup(yylloc.beg.mu_file);
		*sval = lit->text;
		return dtype_string;
	} else if (strncmp(s, "__line__", len) == 0) {
		*nval = yylloc.beg.mu_line;
		return dtype_number;
	} else if (strncmp(s, "__function__", len) == 0) {
		*sval = function_name();
		return dtype_string;
	} else if (strncmp(s, "__package__", len) == 0) {
		*sval = PACKAGE_TARNAME;
		return dtype_string;
	} else if (strncmp(s, "__version__", len) == 0) {
		*sval = PACKAGE_VERSION;
		return dtype_string;
	} else if (strncmp(s, "__major__", len) == 0) {
		*nval = MAILFROMD_VERSION_MAJOR;
		return dtype_number;
	} else if (strncmp(s, "__minor__", len) == 0) {
		*nval = MAILFROMD_VERSION_MINOR;
		return dtype_number;
	} else if (strncmp(s, "__patch__", len) == 0) {
		*nval = MAILFROMD_VERSION_PATCH;
		return dtype_number;
	} else if (strncmp(s, "__git__", len) == 0) {
#ifdef GIT_DESCRIBE
		*sval = GIT_DESCRIBE;
#else
		*sval = "";
#endif
		return dtype_string;
	} else if (strncmp(s, "__statedir__", len) == 0) {
                *sval = mailfromd_state_dir;
		return dtype_string;
	} else if (strncmp(s, "__defstatedir__", len) == 0) {
		*sval = DEFAULT_STATE_DIR;
		return dtype_string;
	} else if (strncmp(s, "__preproc__", len) == 0) {
		*sval = ext_pp ? ext_pp : "";
		return dtype_string;
	} else if (strncmp(s, "__defpreproc__", len) == 0) {
		*sval = DEF_EXT_PP ? DEF_EXT_PP : "";
		return dtype_string;
	} else if (strncmp(s, "__module__", len) == 0) {
		*sval = top_module->dclname ? top_module->dclname : top_module->name;
		return dtype_string;
	}
        return dtype_unspecified;  
}

int
builtin_const(const char *s, size_t len)
{
	const char *sval;
	long nval;
	
	switch (builtin_const_value(s, len, &sval, &nval)) {
	case dtype_number:
		yylval.number = nval;
		return T_NUMBER;

	case dtype_string:
		string(sval, strlen(sval));
		return T_STRING;

	default:
		abort();
	}
	return T_BOGUS;
}

const char *
symbit_to_qualifier(unsigned f)
{
        switch (f) {
	case SYM_PRECIOUS:
		return "precious";
	case SYM_STATIC:
		return "static";
	case SYM_PUBLIC:
		return "public";
	}
	return NULL;
}

/* End of lex.l */

