% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adbcsnowflake-package.R
\name{adbcsnowflake}
\alias{adbcsnowflake}
\alias{adbc_database_init.adbcsnowflake_driver_snowflake}
\alias{adbc_connection_init.adbcsnowflake_database}
\alias{adbc_statement_init.adbcsnowflake_connection}
\title{ADBC Snowflake Driver}
\usage{
adbcsnowflake()

\method{adbc_database_init}{adbcsnowflake_driver_snowflake}(driver, ..., uri = NULL)

\method{adbc_connection_init}{adbcsnowflake_database}(database, ..., adbc.connection.autocommit = NULL)

\method{adbc_statement_init}{adbcsnowflake_connection}(
  connection,
  ...,
  adbc.ingest.target_table = NULL,
  adbc.ingest.mode = NULL
)
}
\arguments{
\item{driver}{An \code{\link[adbcdrivermanager:adbc_driver]{adbc_driver()}}.}

\item{...}{Extra key/value options passed to the driver.}

\item{uri}{A URI to a database path (e.g.,
\verb{user[:password]@account/database[?param1=value1]})}

\item{database}{An \link[adbcdrivermanager:adbc_database_init]{adbc_database}.}

\item{adbc.connection.autocommit}{Use FALSE to disable the default
autocommit behaviour.}

\item{connection}{An \link[adbcdrivermanager:adbc_connection_init]{adbc_connection}}

\item{adbc.ingest.target_table}{The name of the target table for a bulk insert.}

\item{adbc.ingest.mode}{Whether to create (the default) or append.}
}
\value{
An \code{\link[adbcdrivermanager:adbc_driver_void]{adbcdrivermanager::adbc_driver()}}
}
\description{
ADBC Snowflake Driver
}
\examples{
adbcsnowflake()

}
