// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

use arrow_schema::ffi::FFI_ArrowSchema;
use arrow_schema::{DataType, Field};
use criterion::*;
use std::sync::Arc;

fn criterion_benchmark(c: &mut Criterion) {
    let fields = vec![
        Arc::new(Field::new("c1", DataType::Utf8, false)),
        Arc::new(Field::new("c2", DataType::Utf8, false)),
        Arc::new(Field::new("c3", DataType::Utf8, false)),
        Arc::new(Field::new("c4", DataType::Utf8, false)),
        Arc::new(Field::new("c5", DataType::Utf8, false)),
    ];
    let data_type = DataType::Struct(fields.into());
    c.bench_function("ffi_arrow_schema_try_from", |b| {
        b.iter(|| FFI_ArrowSchema::try_from(&data_type));
    });
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
